/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.properties;

import de.jabc.cinco.meta.core.ui.properties.dialogs.InputComboBoxDialog;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class AttributeCreator {
    public static String createAttribute(EAttribute attr) {
        String retval = null;
        Dialog dialog = AttributeCreator.getDialog(attr);
        if (dialog.open() == 0) {
            return AttributeCreator.getValue(dialog);
        }
        return retval;
    }

    public static String createAttribute(EAttribute attr, Object selectedObject) {
        String retval = null;
        Dialog dialog = AttributeCreator.getDialog(attr, selectedObject);
        if (dialog.open() == 0) {
            return AttributeCreator.getValue(dialog);
        }
        return retval;
    }

    private static Dialog getDialog(EAttribute attr) {
        if (attr.getEType() instanceof EEnum) {
            EList input = ((EEnum)attr.getEType()).getELiterals();
            InputComboBoxDialog d = new InputComboBoxDialog(Display.getCurrent().getActiveShell(), (List<?>)input);
            return d;
        }
        return new InputDialog(Display.getCurrent().getActiveShell(), "Add new item to " + attr.getName(), "Add a new item to " + attr.getName() + ":", AttributeCreator.getInitialValue(attr), AttributeCreator.getValidator(attr));
    }

    private static Dialog getDialog(EAttribute attr, Object selectedObject) {
        if (attr.getEType() instanceof EEnum) {
            EList input = ((EEnum)attr.getEType()).getELiterals();
            InputComboBoxDialog d = new InputComboBoxDialog(Display.getCurrent().getActiveShell(), (List<?>)input);
            return d;
        }
        return new InputDialog(Display.getCurrent().getActiveShell(), "Edit item from " + attr.getName(), "Edit an item from " + attr.getName() + ":", selectedObject.toString(), AttributeCreator.getValidator(attr));
    }

    private static IInputValidator getValidator(final EAttribute attr) {
        return new IInputValidator(){

            public String isValid(String newText) {
                try {
                    EcoreUtil.createFromString((EDataType)attr.getEAttributeType(), (String)newText);
                }
                catch (Exception e) {
                    return "Input: \"" + newText + "\" is not a valid " + attr.getEAttributeType().getName();
                }
                return null;
            }
        };
    }

    private static String getValue(Dialog dialog) {
        if (dialog instanceof InputDialog) {
            return ((InputDialog)dialog).getValue();
        }
        if (dialog instanceof InputComboBoxDialog) {
            return ((InputComboBoxDialog)dialog).getValue().toString();
        }
        return null;
    }

    private static String getInitialValue(EAttribute attr) {
        EDataType eAttributeType = attr.getEAttributeType();
        switch (eAttributeType.getName()) {
            case "EInt": {
                return "0";
            }
            case "EEnum": {
                return "";
            }
        }
        return null;
    }
}

