/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.listener;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ui.utils.CincoPropertyUtils;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CincoTreeMenuListener
implements IMenuListener2 {
    @Extension
    private TransactionalEditingDomain.Factory _factory = TransactionalEditingDomain.Factory.INSTANCE;
    private StructuredViewer viewer;
    private Map<Class<? extends EObject>, List<EStructuralFeature>> referencesMap;
    private Set<EClass> disableCreate;
    private Set<EClass> disableDelete;

    public CincoTreeMenuListener(StructuredViewer viewer, Map<Class<? extends EObject>, List<EStructuralFeature>> referencesMap, Set<EClass> disableCreate, Set<EClass> disableDelete) {
        this.viewer = viewer;
        this.referencesMap = referencesMap;
        this.disableCreate = disableCreate;
        this.disableDelete = disableDelete;
    }

    public void menuAboutToShow(IMenuManager mainMenu) {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof Type) {
                object = ((Type)object).getInternalElement_();
            }
            if (object instanceof EObject) {
                List features;
                List<EStructuralFeature> _allEStructuralFeatures = CincoPropertyUtils.getAllEStructuralFeatures(((EObject)object).getClass(), this.referencesMap);
                List _sortBy = null;
                if (_allEStructuralFeatures != null) {
                    Functions.Function1<EStructuralFeature, String> _function = new Functions.Function1<EStructuralFeature, String>(){

                        public String apply(EStructuralFeature it) {
                            return it.getName();
                        }
                    };
                    _sortBy = IterableExtensions.sortBy(_allEStructuralFeatures, (Functions.Function1)_function);
                }
                if ((features = _sortBy) != null) {
                    for (EStructuralFeature feature : features) {
                        EClassifier _eType = feature.getEType();
                        final EClass eType = (EClass)_eType;
                        EPackage ePackage = eType.getEPackage();
                        EList _eSubpackages = ePackage.getESubpackages();
                        Iterable subPackages = Iterables.concat((Iterable)_eSubpackages, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EPackage[]{ePackage})));
                        Functions.Function1<EPackage, EList<EClassifier>> _function_1 = new Functions.Function1<EPackage, EList<EClassifier>>(){

                            public EList<EClassifier> apply(EPackage it) {
                                return it.getEClassifiers();
                            }
                        };
                        Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

                            public Boolean apply(EClass it) {
                                return it.isAbstract();
                            }
                        };
                        Functions.Function1<EClass, Boolean> _function_3 = new Functions.Function1<EClass, Boolean>(){

                            public Boolean apply(EClass subType) {
                                return eType.isSuperTypeOf(subType);
                            }
                        };
                        Functions.Function1<EClass, Boolean> _function_4 = new Functions.Function1<EClass, Boolean>(){

                            public Boolean apply(EClass subType) {
                                return CincoTreeMenuListener.this.disableCreate.contains(subType);
                            }
                        };
                        Functions.Function1<EClass, String> _function_5 = new Functions.Function1<EClass, String>(){

                            public String apply(EClass it) {
                                return it.getName();
                            }
                        };
                        List subTypes = IterableExtensions.sortBy((Iterable)IterableExtensions.reject((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.reject((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)subPackages, (Functions.Function1)_function_1), EClass.class), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
                        int subTypesCount = subTypes.size();
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Add ");
                        String _name = feature.getName();
                        _builder.append(_name);
                        String label = _builder.toString();
                        if (subTypesCount == 0) continue;
                        if (subTypesCount == 1) {
                            this.addAddAction(mainMenu, (EObject)object, feature, (EClass)IterableExtensions.head((Iterable)subTypes), label);
                            continue;
                        }
                        boolean _canAdd = this.canAdd((EObject)object, feature);
                        if (_canAdd) {
                            MenuManager subMenu = new MenuManager(label);
                            for (EClass subType : subTypes) {
                                this.addAddAction((IMenuManager)subMenu, (EObject)object, feature, subType, subType.getName());
                            }
                            mainMenu.add((IContributionItem)subMenu);
                            continue;
                        }
                        this.addDisabledAction(mainMenu, label);
                    }
                }
                this.addSeparator(mainMenu);
                this.addRemoveAction(mainMenu, (EObject)object);
            }
        }
    }

    public void menuAboutToHide(IMenuManager manager) {
    }

    private void addAddAction(IMenuManager menu, final EObject eObject, final EStructuralFeature feature, final EClass type, final String label) {
        Action action = new Action(){

            public String getText() {
                return label;
            }

            public boolean isEnabled() {
                return CincoTreeMenuListener.this.canAdd(eObject, feature);
            }

            public void run() {
                final EObject newValue = EcoreUtil.create((EClass)type);
                Procedures.Procedure0 _function = new Procedures.Procedure0(){

                    public void apply() {
                        boolean _equals;
                        int _upperBound = feature.getUpperBound();
                        boolean bl = _equals = _upperBound == 1;
                        if (_equals) {
                            eObject.eSet(feature, (Object)newValue);
                        } else {
                            Object _eGet = eObject.eGet(feature);
                            List result = (List)_eGet;
                            result.add(newValue);
                        }
                    }
                };
                CincoTreeMenuListener.this.transaction(eObject, _function);
                CincoTreeMenuListener.this.viewer.refresh();
            }
        };
        menu.add((IAction)action);
    }

    private void addRemoveAction(IMenuManager menu, final EObject eObject) {
        Action action = new Action(){

            public String getText() {
                return "Remove";
            }

            public boolean isEnabled() {
                boolean _switchResult = false;
                boolean _matched = false;
                if (eObject instanceof ModelElement) {
                    _matched = true;
                    _switchResult = false;
                }
                if (!_matched && eObject instanceof GraphModel) {
                    _matched = true;
                    _switchResult = false;
                }
                if (!_matched && eObject instanceof InternalModelElement) {
                    _matched = true;
                    _switchResult = false;
                }
                if (!_matched && eObject instanceof InternalGraphModel) {
                    _matched = true;
                    _switchResult = false;
                }
                if (!_matched) {
                    boolean _contains = CincoTreeMenuListener.this.disableDelete.contains(eObject.eClass());
                    _switchResult = !_contains;
                }
                return _switchResult;
            }

            public void run() {
                Procedures.Procedure0 _function = new Procedures.Procedure0(){

                    public void apply() {
                        if (eObject instanceof InternalIdentifiableElement) {
                            EcoreUtil.delete((EObject)((InternalIdentifiableElement)eObject).getElement());
                        }
                        EcoreUtil.delete((EObject)eObject);
                    }
                };
                CincoTreeMenuListener.this.transaction(eObject, _function);
                CincoTreeMenuListener.this.viewer.refresh();
            }
        };
        menu.add((IAction)action);
    }

    private void addDisabledAction(IMenuManager menu, final String label) {
        Action action = new Action(){

            public String getText() {
                return label;
            }

            public boolean isEnabled() {
                return false;
            }

            public void run() {
            }
        };
        menu.add((IAction)action);
    }

    private void addSeparator(IMenuManager menu) {
        Separator _separator = new Separator();
        menu.add((IContributionItem)_separator);
    }

    private boolean canAdd(EObject eObject, EStructuralFeature feature) {
        int upperBound = feature.getUpperBound();
        if (upperBound == 1) {
            Object _eGet = eObject.eGet(feature);
            return _eGet == null;
        }
        Object _eGet_1 = eObject.eGet(feature);
        EList list = (EList)_eGet_1;
        return list.size() < upperBound || upperBound == -1;
    }

    private void transaction(EObject eObject, final Procedures.Procedure0 transaction) {
        TransactionalEditingDomain _createEditingDomain;
        TransactionalEditingDomain _elvis = null;
        TransactionalEditingDomain _editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
        _elvis = _editingDomain != null ? _editingDomain : (_createEditingDomain = this._factory.createEditingDomain(eObject.eResource().getResourceSet()));
        TransactionalEditingDomain domain = _elvis;
        RecordingCommand command = new RecordingCommand(domain){

            protected void doExecute() {
                transaction.apply();
            }
        };
        domain.getCommandStack().execute((Command)command);
    }
}

