/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.listener;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class BrowseSelectionListener
implements SelectionListener {
    @Extension
    private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
    @Extension
    private WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    private final Shell shell;
    private final Text text;
    private final List<String> fileExtensions;

    public BrowseSelectionListener(Shell shell, Text text, List<String> fileExtensions) {
        this.shell = shell;
        this.text = text;
        this.fileExtensions = fileExtensions;
    }

    public void widgetSelected(SelectionEvent e) {
        String path;
        boolean _not;
        FileDialog dialog = new FileDialog(this.shell, 4096);
        IProject project = this._workbenchExtension.getProject(this._workbenchExtension.getActiveEditor());
        if (project != null) {
            IPath location = project.getLocation();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Setting browse location via project: ");
            _builder.append((Object)location);
            InputOutput.println((Object)_builder.toString());
            dialog.setFilterPath(location.toString());
        } else {
            IPath location_1 = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Setting browse location via workspace: ");
            _builder_1.append((Object)location_1);
            InputOutput.println((Object)_builder_1.toString());
            dialog.setFilterPath(location_1.toString());
        }
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                return StringExtensions.isNullOrEmpty((String)it);
            }
        };
        Functions.Function1<String, CharSequence> _function_1 = new Functions.Function1<String, CharSequence>(){

            public CharSequence apply(String ext) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("*.");
                _builder.append(ext);
                _builder.append(";");
                return _builder.toString();
            }
        };
        String extensions = IterableExtensions.join((Iterable)IterableExtensions.reject(this.fileExtensions, (Functions.Function1)_function), (CharSequence)"", (Functions.Function1)_function_1);
        boolean _isEmpty = extensions.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            dialog.setFilterExtensions(new String[]{extensions});
        }
        if ((path = dialog.open()) != null) {
            Predicate<IFile> _function_2 = new Predicate<IFile>(){

                @Override
                public boolean test(IFile f) {
                    String _oSString = f.getLocation().toOSString();
                    return Objects.equal((Object)_oSString, (Object)path);
                }
            };
            List files = this._workspaceExtension.getFiles((IContainer)this._workspaceExtension.getWorkspaceRoot(), (Predicate)_function_2);
            IFile _xifexpression = null;
            boolean _isEmpty_1 = files.isEmpty();
            _xifexpression = _isEmpty_1 ? null : (IFile)IterableExtensions.head((Iterable)files);
            IFile iFile = _xifexpression;
            String _elvis = null;
            IPath _projectRelativePath = null;
            if (iFile != null) {
                _projectRelativePath = iFile.getProjectRelativePath();
            }
            String _string = null;
            if (_projectRelativePath != null) {
                _string = _projectRelativePath.toString();
            }
            _elvis = _string != null ? _string : path;
            this.text.setText(_elvis);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

