/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.handlers;

import com.google.common.base.Joiner;
import de.jabc.cinco.meta.core.mgl.MGLEPackageRegistry;
import de.jabc.cinco.meta.core.mgl.generator.MGLGenerator;
import de.jabc.cinco.meta.core.pluginregistry.ICPDMetaPlugin;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry;
import de.jabc.cinco.meta.core.ui.listener.MGLSelectionListener;
import de.jabc.cinco.meta.core.ui.templates.ActivatorTemplate;
import de.jabc.cinco.meta.core.ui.templates.DefaultPerspectiveContent;
import de.jabc.cinco.meta.core.ui.templates.NewProjectWizardGenerator;
import de.jabc.cinco.meta.core.utils.BuildProperties;
import de.jabc.cinco.meta.core.utils.BundleRegistry;
import de.jabc.cinco.meta.core.utils.CincoProperties;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.GeneratorHelper;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.ConcurrentWorkload;
import de.jabc.cinco.meta.core.utils.job.JobFactory;
import de.jabc.cinco.meta.core.utils.job.Workload;
import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import de.jabc.cinco.meta.core.utils.projects.ContentWriter;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.plugin.gratext.build.GratextLanguageBuild;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import de.jabc.cinco.meta.util.DirectedGraph;
import de.jabc.cinco.meta.util.Stopwatch;
import de.jabc.cinco.meta.util.xapi.FileExtension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mgl.MGLModel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.xtext.xbase.lib.Pair;
import org.jooq.lambda.tuple.Tuple2;
import productDefinition.CincoProduct;
import productDefinition.GenModelDescription;
import productDefinition.MGLDescriptor;
import productDefinition.XtextDescription;

public class CincoProductGenerationHandler
extends AbstractHandler {
    private FileExtension fileExtension = new FileExtension();
    private GeneratorUtils generatorUtils = GeneratorUtils.getInstance();
    private ICommandService commandService;
    private ExecutionEvent event;
    private CompoundJob job;
    private IProject cpdProject;
    private IFile cpdFile;
    private CincoProduct cpd;
    private List<MGLFile> allMGLFiles;
    private List<MGLFile> generateMGLFiles;
    private Stopwatch stopwatch;
    private boolean pyroOnly = false;
    private boolean headless = false;
    private long lastGenerationTimestamp = 0L;
    private Boolean autoBuildWasEnabled = null;
    private boolean atLeastOneFileChanged = false;
    private static boolean forceNextGeneration = false;
    private static boolean didGenerateAfterRestart = false;
    private static boolean lastGenerationDidSucceed = false;

    public void pyroOnly() {
        this.pyroOnly = true;
    }

    public void headless() {
        this.headless = true;
    }

    public static void forceNextGeneration() {
        forceNextGeneration = true;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public synchronized Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.setEvent(executionEvent);
        this.job = JobFactory.job((String)"Generate Cinco Product");
        this.stopwatch = new Stopwatch(Stopwatch.TimeUnit.MILLISECOND);
        this.stopwatch.start("Preparing");
        this.readCPDFile();
        this.readCincoProperties();
        this.deleteFolders();
        this.readGenerationTimestamp();
        this.calculateMGLSets();
        this.generatorUtils.clearCaches();
        this.stopwatch.stop();
        if (!forceNextGeneration && didGenerateAfterRestart && lastGenerationDidSucceed && !this.atLeastOneFileChanged) {
            boolean answer = CincoMessageHandler.showQuestion((String)"No model changes!\n\nGenerate anyways? :-$", (String)"Cinco Product Generator", (boolean)this.headless);
            if (answer) {
                this.stopwatch.start("Recalculating MGL sets");
                CincoProductGenerationHandler.forceNextGeneration();
                this.calculateMGLSets();
                this.stopwatch.stop();
            } else {
                return null;
            }
        }
        this.workload(1, "Initializing").task("Disabling auto-build", () -> this.disableAutoBuild());
        this.workload(1, "CPD processing").task("Executing CPD meta plugins", () -> this.generateCPDMetaPlugins()).task("Recalculating MGL sets", () -> this.calculateMGLSets()).task("Adding CPD Project to Modules", () -> {
            boolean bl = BundleRegistry.INSTANCE.addBundle(this.getCpdProject().getName(), false, true);
        }).task("Adding Preparing used Plugins", () -> this.prepareUsedPlugins()).task("Generating Imported Xtext Languages", () -> this.generateImportedXtextLanguages()).task("Generating Needed Ecore Models,", () -> this.generateNeededGenModels());
        if (!this.pyroOnly) {
            this.workload(20, "MGL pre-processing").task("Deleting previously generated resources", () -> this.deleteGeneratedResources()).taskForEach(() -> this.getGenerateMGLFiles().stream(), mglFile -> this.deleteGeneratedMGLResources(mglFile.mgl), mglFile -> "Deleting generated MGL resources: " + mglFile.file.getName()).task("Generate Ecore Models", () -> this.generateEcoreModels());
            this.workload(10 * this.getGenerateMGLFiles().size(), "MGL processing").taskForEach(() -> this.getGenerateMGLFiles().stream(), mglFile -> {
                IFile file = mglFile.file;
                this.generateCincoSIBs(file);
                this.generateGratextModel(file);
            }, mglFile -> mglFile.file.getName());
            this.workload(5, "MGL post-processing").task("Generating Graphiti editor", () -> this.generateGraphitiEditor()).task("Preparing Build Properties for CPD Project", () -> this.prepareBuildProperties()).task("Generating Feature Project", () -> this.generateFeatureProject(null)).task("Generating product project", () -> this.generateProductProject());
            if (!this.headless) {
                this.workload(15, "Building Cinco project").task("Building project", () -> this.buildProject());
            }
            this.concurrentWorkload((int)(50L + 10L * this.getGenerateMGLFiles().stream().flatMap(mglFile -> mglFile.mgl.getGraphModels().stream()).count()), "Building Gratext").taskForEach(() -> this.getGenerateMGLFiles().stream().flatMap(mglFile -> mglFile.mgl.getGraphModels().stream()), graphModel -> this.buildGratext(), graphModel -> graphModel.getName());
            this.workload(1, "Global processing").task("Generating Activator", () -> this.generateActivator()).task("Generating project wizard", () -> this.generateProjectWizard());
        }
        this.job.consume(0).task(() -> this.stopwatch.stop()).onFinished(() -> {
            this.writeGenerationTimestamp();
            forceNextGeneration = false;
            didGenerateAfterRestart = true;
            lastGenerationDidSucceed = true;
            this.stopwatch.printTable();
            this.restoreAutoBuild();
            System.out.println("Generation successful!");
        }).onCanceled(() -> {
            forceNextGeneration = false;
            lastGenerationDidSucceed = false;
            this.stopwatch.printTable();
            this.restoreAutoBuild();
            System.out.println("Generation canceled!");
        }).onFailed(() -> {
            forceNextGeneration = false;
            lastGenerationDidSucceed = false;
            this.stopwatch.printTable();
            this.restoreAutoBuild();
            System.out.println("Generation failed!");
        }).onFinishedShowMessage("Cinco Product generation finished successfully.").onCanceledShowMessage("Cinco Product generation has been canceled.").onFailedShowMessage("Cinco Product generation failed.");
        if (!this.headless) {
            this.job.schedule();
        }
        this.pyroOnly = false;
        return this.job;
    }

    private void prepareUsedPlugins() {
        for (String pluginName : this.cpd.getPlugins()) {
            BundleRegistry.INSTANCE.addBundle(ContentWriter.stripOffQuotes((String)pluginName), false, true);
        }
    }

    public CompoundJob getJob() {
        return this.job;
    }

    private Workload workload(int quota, String label) {
        Workload workload = this.job.consume(quota, label);
        workload.task(() -> this.stopwatch.start(label));
        workload.task(() -> System.out.println("Starting workload: " + label));
        return workload;
    }

    private ConcurrentWorkload concurrentWorkload(int quota, String label) {
        ConcurrentWorkload workload = this.job.consumeConcurrent(quota, label);
        workload.task(() -> this.stopwatch.start(label));
        workload.task(() -> System.out.println("Starting concurrent workload: " + label));
        workload.setMaxThreads(CincoProperties.getMaxThreads().intValue());
        return workload;
    }

    protected void generateEcoreModels() {
        Set generateMGLsSet;
        ResourceExtension resourceExtension = new ResourceExtension();
        HashMap importedExternalMGLs = new HashMap();
        this.getGenerateMGLFiles().stream().flatMap(mglFile -> mglFile.mgl.getImports().stream()).filter(imprt -> imprt.isExternal()).forEach(imprt -> {
            Resource mglResource = this.fileExtension.getResource(URI.createURI((String)imprt.getImportURI()));
            MGLModel mglModel = (MGLModel)resourceExtension.getContent(mglResource, MGLModel.class);
            String[] uriSegments = imprt.getImportURI().split("/");
            String baseFolder = "";
            int i = 0;
            while (i < uriSegments.length - 2) {
                baseFolder = String.valueOf(baseFolder) + uriSegments[i] + "/";
                ++i;
            }
            String genModelDirUri = URI.createURI((String)(String.valueOf(baseFolder) + "src-gen/model/")).toPlatformString(false);
            String modelDirUri = URI.createURI((String)(String.valueOf(baseFolder) + "model/")).toPlatformString(false);
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IPath rootPath = workspaceRoot.getFullPath();
            IFolder genModelDir = workspaceRoot.getFolder(rootPath.append(genModelDirUri));
            IFolder modelDir = workspaceRoot.getFolder(rootPath.append(modelDirUri));
            Resource ecoreResource = null;
            Resource genModel = null;
            try {
                IResource[] modelDirResources;
                IResource[] genModelDirResources;
                IResource[] iResourceArray = genModelDirResources = genModelDir.members();
                int n = genModelDirResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resourceCandidate = iResourceArray[n2];
                    if (resourceCandidate.getFileExtension().equals("ecore")) {
                        ecoreResource = this.fileExtension.getResource(URI.createURI((String)resourceCandidate.getFullPath().toString()));
                    }
                    if (resourceCandidate.getFileExtension().equals("genmodel")) {
                        genModel = this.fileExtension.getResource(URI.createURI((String)resourceCandidate.getFullPath().toString()));
                    }
                    ++n2;
                }
                IResource[] iResourceArray2 = modelDirResources = modelDir.members();
                int n3 = modelDirResources.length;
                n = 0;
                while (n < n3) {
                    IResource resourceCandidate = iResourceArray2[n];
                    if (resourceCandidate.getFileExtension().equals("cpd")) {
                        MGLUtil.mglModelCpdMap.put(mglModel, (CincoProduct)this.fileExtension.getContent(modelDir.getFile(resourceCandidate.getName()), CincoProduct.class));
                    }
                    ++n;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (ecoreResource == null || genModel == null) {
                throw new RuntimeException("The ecore model of the external import " + imprt.getImportURI() + " cannot be found." + "Please make sure it has already been generated.");
            }
            importedExternalMGLs.put(mglModel, new Pair(ecoreResource, genModel));
        });
        List allMGLsList = this.allMGLFiles.stream().map(mglFile -> mglFile.mgl).collect(Collectors.toList());
        this.generatorUtils.allMGLs = generateMGLsSet = this.getGenerateMGLFiles().stream().map(mglFile -> mglFile.mgl).collect(Collectors.toSet());
        this.generatorUtils.cpd = this.cpd;
        new MGLGenerator().doGenerateEcoreModels(allMGLsList, generateMGLsSet, importedExternalMGLs, this.cpd);
    }

    protected void generateCPDMetaPlugins() {
        List cpdMetaPluginGenerators = PluginRegistry.getInstance().getPluginCPDGenerators().stream().sorted((l, r) -> {
            int priorityDiff = -l.getPlugin().comparePriorityTo(r.getPlugin());
            if (priorityDiff == 0) {
                return l.getAnnotationName().compareToIgnoreCase(r.getAnnotationName());
            }
            return priorityDiff;
        }).map(a -> new Pair((Object)a.getAnnotationName(), (Object)a.getPlugin())).collect(Collectors.toList());
        if (cpdMetaPluginGenerators == null || cpdMetaPluginGenerators.isEmpty()) {
            return;
        }
        EList allAnnotations = this.cpd.getAnnotations();
        if (allAnnotations == null || allAnnotations.isEmpty()) {
            return;
        }
        List allMGLsList = this.allMGLFiles.stream().map(mglFile -> mglFile.mgl).collect(Collectors.toList());
        List generateMGLsList = this.getGenerateMGLFiles().stream().map(mglFile -> mglFile.mgl).collect(Collectors.toList());
        for (Pair entry : cpdMetaPluginGenerators) {
            String cpdMetaPluginName = (String)entry.getKey();
            ICPDMetaPlugin cpdMetaPlugin = (ICPDMetaPlugin)entry.getValue();
            List relatedAnnotations = allAnnotations.stream().filter(annotation -> annotation.getName().equals(cpdMetaPluginName)).collect(Collectors.toList());
            if (relatedAnnotations == null || relatedAnnotations.isEmpty()) continue;
            System.out.println("Executing CPD meta plugin: " + cpdMetaPluginName + " (Priority: " + cpdMetaPlugin.getCPDMetaPluginPriority() + ")");
            cpdMetaPlugin.executeCPDMetaPlugin(relatedAnnotations, generateMGLsList, allMGLsList, this.cpd, this.getCpdProject());
        }
    }

    protected void readCPDFile() {
        if (!this.headless) {
            this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        }
        this.cpdFile = MGLSelectionListener.INSTANCE.getSelectedCPDFile();
        if (!(this.cpdFile instanceof IFile)) {
            throw new RuntimeException("No valid CPD file selected!");
        }
        this.cpdProject = this.cpdFile.getProject();
        this.cpd = (CincoProduct)this.fileExtension.getContent(this.cpdFile, CincoProduct.class, 0);
        MGLSelectionListener.INSTANCE.setCurrentCPD(this.cpd);
    }

    protected void generateGraphitiEditor() {
        this.execute("de.jabc.cinco.meta.core.ge.style.generator.newgraphitigenerator");
    }

    protected void generateCincoSIBs(IFile mglFile) {
        MGLSelectionListener.INSTANCE.putMGLFile(mglFile);
        this.execute("de.jabc.cinco.meta.core.jabcproject.commands.generateCincoSIBsCommand");
    }

    protected void generateProductProject() {
        this.execute("cpd.handler.ui.generate");
    }

    protected void generateFeatureProject(IFile mglFile) {
        this.execute("de.jabc.cinco.meta.core.generatefeature");
    }

    private void resetRegistries() {
        BundleRegistry.resetRegistry();
        MGLEPackageRegistry.resetRegistry();
    }

    private void printDebugOutput(ExecutionEvent event, long startTime) {
        long stopTime = System.nanoTime();
        System.err.println("Stopping at: " + stopTime);
        System.err.println(String.format("Generation took %s of your earth minutes.", (double)(stopTime - startTime) * Math.pow(10.0, -9.0) / 60.0));
    }

    private void publishMglFile(IFile mglFile) {
        MGLSelectionListener.INSTANCE.putMGLFile(mglFile);
    }

    protected void generateGraphitiEditor(IFile mglFile) {
        this.execute("de.jabc.cinco.meta.core.ge.style.generator.newgraphitigenerator");
    }

    protected void generateGratextModel(IFile mglFile) {
        if (this.isGratextEnabled()) {
            MGLSelectionListener.INSTANCE.putMGLFile(mglFile);
            this.execute("de.jabc.cinco.meta.plugin.gratext.generategratext");
        }
    }

    protected void buildProject() {
        try {
            this.getCpdProject().build(10, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void buildGratext() {
        if (this.isGratextEnabled()) {
            this.execute("de.jabc.cinco.meta.plugin.gratext.buildgratext");
        }
    }

    protected boolean isGratextEnabled() {
        return this.cpd.getAnnotations().stream().noneMatch(ann -> "disableGratext".equals(ann.getName()));
    }

    private EObject loadModel(IFile cpdFile, String fileExtension, EPackage ePkg) throws IOException, CoreException {
        URI createPlatformResourceURI = URI.createPlatformResourceURI((String)cpdFile.getFullPath().toPortableString(), (boolean)true);
        Resource res = Resource.Factory.Registry.INSTANCE.getFactory(createPlatformResourceURI, fileExtension).createResource(createPlatformResourceURI);
        res.load(cpdFile.getContents(), null);
        return (EObject)res.getContents().get(0);
    }

    protected void deleteFolders() {
        for (String folder : CincoProperties.getDeleteFolders()) {
            try {
                IResource resource = this.getCpdProject().findMember(folder);
                if (resource == null) continue;
                resource.delete(1, null);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void deleteGeneratedResources() {
        if (this.getGenerateMGLFiles() == null || this.getGenerateMGLFiles().isEmpty()) {
            return;
        }
        try {
            IResource resourcesGen = this.getCpdProject().findMember("resources-gen/");
            if (resourcesGen != null) {
                resourcesGen.delete(1, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void deleteGeneratedMGLResources(MGLModel mgl) {
        try {
            String mglPackagePath = this.toPath(mgl.getPackage());
            IFolder packageFolder = this.getCpdProject().getFolder("src-gen/" + mglPackagePath);
            if (packageFolder.exists()) {
                packageFolder.delete(1, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected void calculateMGLSets() {
        BundleRegistry.resetRegistry();
        MGLEPackageRegistry.resetRegistry();
        List mglFiles = this.cpd.getMgls().stream().map(mglDesc -> new MGLFile((MGLDescriptor)mglDesc)).collect(Collectors.toList());
        for (MGLFile mglFile2 : mglFiles) {
            if (this.isGenerationRequired(mglFile2) || this.pyroOnly) continue;
            MGLEPackageRegistry.INSTANCE.addMGLEPackage(this.getEPackageForMGL(mglFile2.file, this.getCpdProject()));
        }
        DirectedGraph dependencyGraph = new DirectedGraph();
        for (MGLFile mglFile3 : mglFiles) {
            List parents = mglFile3.mgl.getImports().stream().filter(imprt -> !imprt.isStealth() && !imprt.isExternal()).map(imprt -> {
                String path = PathValidator.getRelativePath((String)imprt.getImportURI(), (IProject)this.getCpdProject());
                return mglFiles.stream().filter(mgl -> mgl.path.equals(path)).findFirst().orElse(null);
            }).filter(mgl -> mgl != null).collect(Collectors.toList());
            dependencyGraph.addNode((Object)mglFile3).addParents(parents);
        }
        this.allMGLFiles = dependencyGraph.getTopSortedContents();
        this.generateMGLFiles = new ArrayList<MGLFile>();
        LinkedList independentSubgraphs = dependencyGraph.getSubgraphs();
        for (DirectedGraph subgraph : independentSubgraphs) {
            List subgraphMGLFiles = subgraph.getContents();
            boolean subgraphContainsGenerationRequiredMGLFiles = subgraphMGLFiles.stream().anyMatch(mglFile -> mglFile.generationRequired);
            if (!subgraphContainsGenerationRequiredMGLFiles) continue;
            this.getGenerateMGLFiles().addAll(subgraphMGLFiles);
        }
    }

    private EPackage getEPackageForMGL(IFile mglFile, IProject project) {
        String ecoreName = String.valueOf(this.cpd.getName()) + ".ecore";
        URI uri = URI.createPlatformResourceURI((String)(String.valueOf(ProjectCreator.getProjectSymbolicName((IProject)project)) + "/src-gen/model/" + ecoreName), (boolean)true);
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        try {
            resource.load(null);
            return (EPackage)resource.getContents().get(0);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load ecore model: " + ecoreName, e);
        }
    }

    private String toPath(String e) {
        return e.replace('.', '/');
    }

    private void execute(String commandId) {
        try {
            this.commandService.getCommand(commandId).executeWithChecks(this.event);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            IFile mglFile = MGLSelectionListener.INSTANCE.getCurrentMGLFile();
            String fileName = mglFile == null ? this.cpdFile.getName() : mglFile.getName();
            throw new RuntimeException("Generation of " + fileName + " failed", e);
        }
    }

    private boolean isAutoBuild() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        return desc.isAutoBuilding();
    }

    private void setAutoBuild(boolean enable) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(enable);
        workspace.setDescription(desc);
    }

    protected void disableAutoBuild() {
        block3: {
            if (this.autoBuildWasEnabled == null) {
                this.autoBuildWasEnabled = this.isAutoBuild();
            }
            try {
                this.setAutoBuild(false);
            }
            catch (CoreException e) {
                if (!this.isAutoBuild()) break block3;
                System.out.println("Failed to deactivate \"Build Automatically\".");
                e.printStackTrace();
            }
        }
    }

    protected void restoreAutoBuild() {
        block3: {
            if (this.autoBuildWasEnabled == null) {
                return;
            }
            try {
                this.setAutoBuild(this.autoBuildWasEnabled);
            }
            catch (CoreException e) {
                if (this.autoBuildWasEnabled.booleanValue() == this.isAutoBuild()) break block3;
                System.err.println("Failed to restore state for \"Build Automatically\". Should be: " + this.autoBuildWasEnabled);
                e.printStackTrace();
            }
        }
        this.autoBuildWasEnabled = null;
    }

    protected void generateProjectWizard() {
        if (this.getGenerateMGLFiles() == null || this.getGenerateMGLFiles().isEmpty()) {
            return;
        }
        System.out.println("Generating Project Wizard");
        IFile pluginXMLFile = this.getCpdProject().getFile("plugin.xml");
        String projectName = this.getCpdProject().getName();
        String cpdName = this.cpd.getName();
        String cpdNameUpper = cpdName.toUpperCase();
        String wizardExtensionCommentID = "<!--@CincoGen PROJECT_WIZARD_" + cpdNameUpper + "_WIZ -->";
        String navigatorExtensionCommentID = "<!--@CincoGen PROJECT_WIZARD_" + cpdNameUpper + "_NAV -->";
        String perspectiveExtensionCommentID = "<!--@CincoGen PROJECT_PERSPECTIVE_" + cpdNameUpper + "_PER -->";
        CharSequence wizardJavaCode = NewProjectWizardGenerator.generateWizardJavaCode(this.cpd, projectName);
        CharSequence newWizardXML = NewProjectWizardGenerator.generateNewWizardXML(this.cpd, projectName, wizardExtensionCommentID);
        CharSequence navigatorXML = NewProjectWizardGenerator.generateNavigatorXML(this.cpd, projectName, navigatorExtensionCommentID);
        CharSequence perspectiveXML = DefaultPerspectiveContent.generateXMLPerspective(this.cpd, projectName);
        WorkspaceExtension workspaceExtension = new WorkspaceExtension();
        String wizardPath = "src-gen/" + projectName.replace(".", "/") + "/";
        IFile wizardFile = this.getCpdProject().getFile(String.valueOf(wizardPath) + cpdName + "ProjectWizard.java");
        workspaceExtension.createFolders((IContainer)this.getCpdProject(), (IPath)workspaceExtension.toPath(wizardPath));
        try {
            workspaceExtension.create((IResource)wizardFile);
            this.fileExtension.writeContent(wizardFile, wizardJavaCode.toString());
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        String pluginXMLLocation = pluginXMLFile.getLocation().toString();
        CincoUtil.addExtension((String)pluginXMLLocation, (String)newWizardXML.toString(), (String)wizardExtensionCommentID, (String)projectName);
        CincoUtil.addExtension((String)pluginXMLLocation, (String)navigatorXML.toString(), (String)navigatorExtensionCommentID, (String)projectName);
        CincoUtil.addExtension((String)pluginXMLLocation, (String)perspectiveXML.toString(), (String)perspectiveExtensionCommentID, (String)projectName);
    }

    protected void readCincoProperties() {
        CincoProperties.newInstance().load(this.getCpdProject());
    }

    protected void readGenerationTimestamp() {
        File file = this.getGenerationTimestampFile();
        if (!file.exists()) {
            this.lastGenerationTimestamp = 0L;
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            List lines = reader.lines().collect(Collectors.toList());
            reader.close();
            String contents = Joiner.on((String)"\n").join(lines);
            this.lastGenerationTimestamp = Long.parseLong(contents);
        }
        catch (IOException | UncheckedIOException | NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void writeGenerationTimestamp() {
        this.lastGenerationTimestamp = System.currentTimeMillis();
        File file = this.getGenerationTimestampFile();
        file.delete();
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            FileWriter writer = new FileWriter(file);
            writer.write(Long.toString(this.lastGenerationTimestamp));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getGenerationTimestampFile() {
        return this.cpdFile.getProject().getLocation().append("src-gen").append("model").append(String.valueOf(this.cpdFile.getName()) + ".generation-timestamp").toFile();
    }

    private boolean hasChanged(IFile file) {
        long lastModifiedTimestamp = file.getLocation().toFile().lastModified();
        return lastModifiedTimestamp > this.lastGenerationTimestamp;
    }

    private boolean isGenerationRequired(MGLFile mglFile) {
        if (forceNextGeneration) {
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (Force generation)");
            mglFile.generationRequired = true;
            return true;
        }
        if (!didGenerateAfterRestart) {
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (First generation after restart)");
            mglFile.generationRequired = true;
            return true;
        }
        if (!lastGenerationDidSucceed) {
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (Last generation did fail)");
            mglFile.generationRequired = true;
            return true;
        }
        if (this.lastGenerationTimestamp <= 0L) {
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (Missing generation timestamp file)");
            mglFile.generationRequired = true;
            return true;
        }
        if (mglFile.descriptor.isForceGenerate()) {
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (MGL '" + mglFile.file.getName() + "' is set to 'forceGenerate')");
            mglFile.generationRequired = true;
            return true;
        }
        if (mglFile.descriptor.isDontGenerate()) {
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation not required (MGL '" + mglFile.file.getName() + "' is set to 'generateNOT')");
            mglFile.generationRequired = false;
            return false;
        }
        if (this.hasChanged(this.cpdFile)) {
            this.atLeastOneFileChanged = true;
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (CPD '" + this.cpdFile.getName() + "' changed)");
            mglFile.generationRequired = true;
            return true;
        }
        if (this.hasChanged(mglFile.file)) {
            this.atLeastOneFileChanged = true;
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (MGL '" + mglFile.file.getName() + "' changed)");
            mglFile.generationRequired = true;
            return true;
        }
        String stylePath = PathValidator.getRelativePath((String)mglFile.mgl.getStylePath(), (IProject)this.getCpdProject());
        IFile styleFile = this.getCpdProject().getFile(stylePath);
        if (styleFile.exists() && this.hasChanged(styleFile)) {
            this.atLeastOneFileChanged = true;
            System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation required (MSL '" + styleFile.getName() + "' changed)");
            mglFile.generationRequired = true;
            return true;
        }
        System.out.println(String.valueOf(mglFile.file.getName()) + ": Generation not required (Nothing changed)");
        mglFile.generationRequired = false;
        return false;
    }

    protected void generateActivator() {
        WorkspaceExtension workspaceExtension = new WorkspaceExtension();
        String activatorName = "Activator";
        String activatorPackage = this.getCpdProject().getName();
        String activatorFQN = String.valueOf(activatorPackage) + "." + activatorName;
        String activatorContents = ActivatorTemplate.contents(activatorPackage).toString();
        String activatorPackagePath = "src-gen/" + activatorPackage.replace(".", "/") + "/";
        String activatorFilePath = String.valueOf(activatorPackagePath) + activatorName + ".java";
        IFile activatorFile = this.getCpdProject().getFile(activatorFilePath);
        try {
            workspaceExtension.createFolders((IContainer)this.getCpdProject(), (IPath)workspaceExtension.toPath(activatorPackagePath));
            workspaceExtension.create((IResource)activatorFile);
            this.fileExtension.writeContent(activatorFile, activatorContents);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ProjectCreator.addAttribute((IProject)this.getCpdProject(), null, (Tuple2[])new Tuple2[]{new Tuple2((Object)"Bundle-Activator", (Object)activatorFQN), new Tuple2((Object)"Bundle-ActivationPolicy", (Object)"lazy")});
    }

    protected void prepareBuildProperties() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        BuildProperties properties = BuildProperties.loadBuildProperties((IProject)this.getCpdProject(), (IProgressMonitor)monitor);
        IResource srcFolder = this.getCpdProject().findMember("src/");
        if (srcFolder != null && srcFolder.exists() && !properties.hasSourceValue("src/")) {
            properties.appendSource("src/");
        }
        if (!properties.hasSourceValue("src-gen/")) {
            properties.appendSource("src-gen/");
        }
        if (!properties.hasSourceValue("xtend-gen/")) {
            properties.appendSource("xtend-gen/");
        }
        if (!properties.hasBinIncludesValue("model/")) {
            properties.appendBinIncludes("model/");
        }
        try {
            properties.store(this.getCpdProject(), (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not prepare Build Properties", e);
        }
    }

    protected void generateNeededGenModels() {
        WorkspaceExtension wse = new WorkspaceExtension();
        FileExtension fse = new FileExtension();
        for (GenModelDescription description : this.cpd.getGenModelDescriptions()) {
            URI uri = URI.createURI((String)description.getGenModelPath(), (boolean)true);
            IFile genModelFile = wse.getFile(uri);
            GenModel genModel = (GenModel)fse.getContent(genModelFile, GenModel.class);
            GeneratorHelper.generateGenModelCode((GenModel)genModel);
            if (description.isEditCode()) {
                GeneratorHelper.generateEditCode((GenModel)genModel);
            }
            if (description.isEditorCode()) {
                GeneratorHelper.generateEditorCode((GenModel)genModel);
            }
            if (!description.isTestCode()) continue;
            GeneratorHelper.generateTestCode((GenModel)genModel);
        }
    }

    protected void generateImportedXtextLanguages() {
        for (XtextDescription description : this.cpd.getXtextDescriptions()) {
            WorkspaceExtension wse = new WorkspaceExtension();
            IProject xtextProject = wse.getWorkspaceRoot().getProject(description.getProjectName());
            GratextLanguageBuild build = new GratextLanguageBuild(xtextProject, false);
            build.schedule();
        }
    }

    public IProject getCpdProject() {
        return this.cpdProject;
    }

    public void setEvent(ExecutionEvent event) {
        this.event = event;
    }

    public List<MGLFile> getGenerateMGLFiles() {
        return this.generateMGLFiles;
    }

    protected class MGLFile {
        public final MGLDescriptor descriptor;
        public final String path;
        public final IFile file;
        public final MGLModel mgl;
        public boolean generationRequired;

        public MGLFile(MGLDescriptor mglDesc) {
            this.descriptor = mglDesc;
            this.path = PathValidator.getRelativePath((String)this.descriptor.getMglPath(), (IProject)CincoProductGenerationHandler.this.getCpdProject());
            this.file = CincoProductGenerationHandler.this.getCpdProject().getFile(this.path);
            this.mgl = (MGLModel)CincoProductGenerationHandler.this.fileExtension.getContent(this.file, MGLModel.class);
            this.generationRequired = false;
        }
    }
}

