/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.editor;

import de.jabc.cinco.meta.core.ui.editor.PageAwareEditor;
import de.jabc.cinco.meta.core.ui.editor.PageAwareEditorInput;
import java.util.function.Function;
import org.eclipse.ui.IEditorInput;

public class PageAwareEditorDescriptor {
    private String name;
    private Class<? extends PageAwareEditor> editorClass;
    private Function<IEditorInput, PageAwareEditorInput> inputMapper;
    private PageAwareEditor editor;

    public PageAwareEditorDescriptor(PageAwareEditor editor) {
        this.editor = editor;
        this.editorClass = editor.getClass();
    }

    public PageAwareEditorDescriptor(Class<? extends PageAwareEditor> editorClass) {
        this.editorClass = editorClass;
    }

    public PageAwareEditorDescriptor(String name, Class<? extends PageAwareEditor> editorClass, Function<IEditorInput, PageAwareEditorInput> inputMapper) {
        this.editorClass = editorClass;
        this.inputMapper = inputMapper;
        this.name = name;
    }

    public PageAwareEditor getEditor() {
        if (this.editor == null) {
            this.editor = this.newEditor();
        }
        return this.editor;
    }

    public String getPageName() {
        if (this.name == null) {
            this.name = this.getEditor().getPageName();
        }
        return this.name;
    }

    public Class<? extends PageAwareEditor> getEditorClass() {
        return this.editorClass;
    }

    public Function<IEditorInput, PageAwareEditorInput> getInputMapper() {
        if (this.inputMapper == null) {
            this.inputMapper = input -> this.getEditor().mapEditorInput((IEditorInput)input);
        }
        return this.inputMapper;
    }

    public PageAwareEditor newEditor() {
        try {
            return this.editorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

