/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.converter;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class StringToFloatConverter
implements IConverter<String, Float> {
    public Object getFromType() {
        return String.class;
    }

    public Object getToType() {
        return Float.class;
    }

    public Float convert(String fromString) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)fromString);
        if (_isNullOrEmpty) {
            return Float.valueOf(0.0f);
        }
        try {
            float l = Float.parseFloat(fromString);
            return Float.valueOf(l);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return Float.valueOf(0.0f);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

