/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.converter;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ui.validator.ColorValidator;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ColorToStringConverter
implements IConverter<Color, String> {
    private final String colorFormat;

    public ColorToStringConverter(String colorFormat) {
        boolean _not;
        boolean _isColorFormat = ColorValidator.isColorFormat(colorFormat);
        boolean bl = _not = !_isColorFormat;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unknown color format \"");
            _builder.append(colorFormat);
            _builder.append("\". Must be \"");
            _builder.append("hex");
            _builder.append("\", \"");
            _builder.append("rgb");
            _builder.append("\", or \"");
            _builder.append("rgba");
            _builder.append("\".\"");
            throw new IllegalArgumentException(_builder.toString());
        }
        this.colorFormat = colorFormat;
    }

    public Object getFromType() {
        return Color.class;
    }

    public Object getToType() {
        return String.class;
    }

    public String convert(Color it) {
        String _xifexpression = null;
        if (it == null) {
            String _switchResult = null;
            String colorFormat = this.colorFormat;
            boolean _matched = false;
            if (Objects.equal((Object)colorFormat, (Object)"rgba")) {
                _matched = true;
                _switchResult = "0,0,0,0";
            }
            if (!_matched && Objects.equal((Object)colorFormat, (Object)"rgb")) {
                _matched = true;
                _switchResult = "0,0,0";
            }
            if (!_matched && Objects.equal((Object)colorFormat, (Object)"hex")) {
                _matched = true;
                _switchResult = "#000000";
            }
            _xifexpression = _switchResult;
        } else {
            String _switchResult_1 = null;
            String colorFormat_1 = this.colorFormat;
            boolean _matched_1 = false;
            if (Objects.equal((Object)colorFormat_1, (Object)"rgba")) {
                _matched_1 = true;
                _switchResult_1 = String.format("%d,%d,%d,%d", it.getRed(), it.getGreen(), it.getBlue(), it.getAlpha());
            }
            if (!_matched_1 && Objects.equal((Object)colorFormat_1, (Object)"rgb")) {
                _matched_1 = true;
                _switchResult_1 = String.format("%d,%d,%d", it.getRed(), it.getGreen(), it.getBlue());
            }
            if (!_matched_1 && Objects.equal((Object)colorFormat_1, (Object)"hex")) {
                _matched_1 = true;
                _switchResult_1 = String.format("#%02X%02X%02X", it.getRed(), it.getGreen(), it.getBlue());
            }
            _xifexpression = _switchResult_1;
        }
        return _xifexpression;
    }
}

