/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ui.action;

import de.jabc.cinco.meta.core.ui.properties.AttributeCreator;
import de.jabc.cinco.meta.core.ui.properties.CincoPropertyView;
import de.jabc.cinco.meta.core.ui.properties.PossibleValuesLabelProvider;
import de.jabc.cinco.meta.core.ui.properties.dialogs.InputComboBoxDialog;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class ListFeatureAction
extends Action
implements SelectionListener,
ISelectionChangedListener,
IDoubleClickListener {
    private final TableViewer tableViewer;
    private final EObject bo;
    private final EStructuralFeature feature;
    private List<Button> buttons;
    private TransactionalEditingDomain _domain;

    public ListFeatureAction(String text, TableViewer tableViewer, EObject bo, EStructuralFeature feature) {
        super(text);
        boolean _equals;
        int _upperBound = feature.getUpperBound();
        boolean bl = _equals = _upperBound == 1;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The feature \"");
            String _name = feature.getName();
            _builder.append(_name);
            _builder.append("\" is not a list (upper bound is ");
            int _upperBound_1 = feature.getUpperBound();
            _builder.append((Object)_upperBound_1);
            _builder.append(")");
            throw new IllegalArgumentException(_builder.toString());
        }
        this.tableViewer = tableViewer;
        this.bo = bo;
        this.feature = feature;
        this.buttons = CollectionLiterals.newArrayList();
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
    }

    public abstract boolean canExecuteAction();

    public abstract void executeAction();

    public Button createButton(Composite parent, int style) {
        Button button = new Button(parent, style);
        button.setText(this.getText());
        button.addSelectionListener((SelectionListener)this);
        this.buttons.add(button);
        this.update();
        return button;
    }

    protected List<Object> getList() {
        Object _eGet = this.bo.eGet(this.feature);
        return (List)_eGet;
    }

    protected int getUpperBound() {
        return this.feature.getUpperBound();
    }

    protected Object getSelection() {
        ISelection _selection = this.tableViewer.getSelection();
        return ((IStructuredSelection)_selection).getFirstElement();
    }

    protected Object showDialog() {
        return this.showDialog(null);
    }

    protected Object showDialog(Object defaultValue) {
        EStructuralFeature feature = this.feature;
        boolean _matched = false;
        if (feature instanceof EAttribute) {
            _matched = true;
            String _xifexpression = null;
            _xifexpression = defaultValue == null ? AttributeCreator.createAttribute((EAttribute)this.feature) : AttributeCreator.createAttribute((EAttribute)this.feature, defaultValue);
            String stringValue = _xifexpression;
            if (stringValue != null) {
                return EcoreUtil.createFromString((EDataType)((EAttribute)this.feature).getEAttributeType(), (String)stringValue);
            }
        }
        if (!_matched && feature instanceof EReference) {
            boolean _tripleEquals;
            _matched = true;
            Shell shell = Display.getCurrent().getActiveShell();
            PossibleValuesLabelProvider possibleValuesLabelProvider = CincoPropertyView.getPossibleValuesLabelProvider(this.bo, this.feature);
            Map<? extends Object, String> possibleValues = CincoPropertyView.getPossibleValues(this.feature);
            List<Object> _xifexpression = null;
            _xifexpression = possibleValues == null ? CincoPropertyView.getInput(this.bo, ((EReference)this.feature).getEReferenceType().getInstanceClass()) : IterableExtensions.toList(possibleValues.keySet());
            List<Object> input = _xifexpression;
            InputComboBoxDialog _xifexpression_1 = null;
            _xifexpression_1 = defaultValue == null ? new InputComboBoxDialog(shell, null, (ILabelProvider)possibleValuesLabelProvider, input) : new InputComboBoxDialog(shell, null, (ILabelProvider)possibleValuesLabelProvider, input, defaultValue);
            InputComboBoxDialog dialog = _xifexpression_1;
            int _open = dialog.open();
            boolean bl = _tripleEquals = _open == 0;
            if (_tripleEquals) {
                return dialog.getValue();
            }
        }
        return null;
    }

    private void update() {
        this.setEnabled(this.canExecuteAction());
        for (Button button : this.buttons) {
            button.setEnabled(this.isEnabled());
        }
        this.tableViewer.refresh();
    }

    private TransactionalEditingDomain getDomain() {
        if (this._domain == null) {
            this._domain = new ResourceExtension().getEditingDomain(this.bo.eResource());
        }
        return this._domain;
    }

    public void run() {
        TransactionalEditingDomain _domain = this.getDomain();
        StringConcatenation _builder = new StringConcatenation();
        String _text = this.getText();
        _builder.append(_text);
        _builder.append(" (");
        String _name = this.feature.getName();
        _builder.append(_name);
        _builder.append(")");
        RecordingCommand command = new RecordingCommand(_domain, _builder.toString()){

            protected void doExecute() {
                ListFeatureAction.this.executeAction();
            }
        };
        this.getDomain().getCommandStack().execute((Command)command);
        this.update();
    }

    public void widgetSelected(SelectionEvent e) {
        this.update();
        boolean _isEnabled = this.isEnabled();
        if (_isEnabled) {
            this.run();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent e) {
        this.update();
    }

    public void doubleClick(DoubleClickEvent e) {
        this.update();
        boolean _isEnabled = this.isEnabled();
        if (_isEnabled) {
            this.run();
        }
    }
}

