/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.utils;

import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class CincoLayoutUtils {
    public static final String KEY_HORIZONTAL = "horizontal";
    public static final String KEY_VERTICAL = "vertical";
    public static final String KEY_HORIZONTAL_UNDEFINED = "undef";
    public static final String KEY_HORIZONTAL_LEFT = "h_layout_left";
    public static final String KEY_HORIZONTAL_CENTER = "h_layout_center";
    public static final String KEY_HORIZONTAL_RIGHT = "h_layout_right";
    public static final String KEY_VERTICAL_UNDEFINED = "undef";
    public static final String KEY_VERTICAL_TOP = "v_layout_top";
    public static final String KEY_VERTICAL_MIDDLE = "v_layout_middle";
    public static final String KEY_VERTICAL_BOTTOM = "v_layout_bottom";
    public static final String KEY_MARGIN_HORIZONTAL = "margin_horizontal";
    public static final String KEY_MARGIN_VERTICAL = "margin_vertical";
    public static final String KEY_INITIAL_POINTS = "initial_points";
    public static final String KEY_INITIAL_PARENT_SIZE = "initial_parent_size";
    public static final String KEY_GA_NAME = "ga_name";

    public static void layout(GraphicsAlgorithm parent, GraphicsAlgorithm ga) {
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        String horizontal = peService.getPropertyValue((PropertyContainer)ga, KEY_HORIZONTAL);
        String vertical = peService.getPropertyValue((PropertyContainer)ga, KEY_VERTICAL);
        int xMargin = 0;
        int yMargin = 0;
        if (peService.getPropertyValue((PropertyContainer)ga, KEY_MARGIN_HORIZONTAL) != null) {
            xMargin = Integer.parseInt(peService.getPropertyValue((PropertyContainer)ga, KEY_MARGIN_HORIZONTAL));
        }
        if (peService.getPropertyValue((PropertyContainer)ga, KEY_MARGIN_VERTICAL) != null) {
            yMargin = Integer.parseInt(peService.getPropertyValue((PropertyContainer)ga, KEY_MARGIN_VERTICAL));
        }
        if (parent == null || ga == null) {
            return;
        }
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int gaWidth = ga.getWidth();
        int gaHeight = ga.getHeight();
        if (ga instanceof Text) {
            IDimension dim = CincoLayoutUtils.getTextDimension((AbstractText)((Text)ga));
            gaService.setWidth(ga, dim.getWidth());
            gaService.setHeight(ga, dim.getHeight());
            gaWidth = dim.getWidth();
            gaHeight = dim.getHeight();
        }
        if (ga instanceof MultiText) {
            MultiText mt = (MultiText)ga;
            String content = mt.getValue().trim();
            String[] lines = content.split("\n");
            int linesCount = lines.length + 1;
            int maxLineWidth = -1;
            int lineHeight = -1;
            IDimension dim = null;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                dim = CincoLayoutUtils.getTextDimension(s, mt.getFont() != null ? mt.getFont() : mt.getStyle().getFont());
                maxLineWidth = Math.max(maxLineWidth, dim.getWidth());
                ++n2;
            }
            if (dim != null) {
                lineHeight = dim.getHeight();
            }
            gaWidth = maxLineWidth + 5;
            gaHeight = lineHeight * linesCount;
            mt.setWidth(gaWidth);
            mt.setHeight(gaHeight);
            if (parent.getWidth() < gaWidth + mt.getX()) {
                parent.setWidth(gaWidth + mt.getX());
            }
            if (parent.getHeight() < gaHeight + mt.getY()) {
                parent.setHeight(gaHeight + mt.getY());
            }
            parentWidth = parent.getWidth();
            parentHeight = parent.getHeight();
        }
        if ("undef".equals(horizontal) || "undef".equals(vertical)) {
            return;
        }
        int x = 0;
        int y = 0;
        switch (horizontal) {
            case "h_layout_left": {
                x = 0;
                break;
            }
            case "h_layout_center": {
                x = parentWidth / 2 - gaWidth / 2;
                break;
            }
            case "h_layout_right": {
                x = parentWidth - gaWidth;
                break;
            }
        }
        switch (vertical) {
            case "v_layout_top": {
                y = 0;
                break;
            }
            case "v_layout_middle": {
                y = parentHeight / 2 - gaHeight / 2;
                break;
            }
            case "v_layout_bottom": {
                y = parentHeight - gaHeight;
                break;
            }
        }
        gaService.setLocation(ga, x + xMargin, y + yMargin);
    }

    public static IDimension getTextDimension(AbstractText t) {
        String value = t.getValue();
        Font font = t.getFont() != null ? t.getFont() : t.getStyle().getFont();
        IDimension dim = GraphitiUi.getUiLayoutService().calculateTextSize(value, font);
        return dim;
    }

    private static IDimension getTextDimension(String value, Font font) {
        IDimension dim = GraphitiUi.getUiLayoutService().calculateTextSize(value, font);
        return dim;
    }

    public static void createCIRCLE(GraphicsAlgorithmContainer gaContainer, int lineWidth) {
        IGaService gaService = Graphiti.getGaService();
        Ellipse tmp = gaService.createEllipse(gaContainer);
        int size = 12 + lineWidth * 2;
        gaService.setSize((GraphicsAlgorithm)tmp, size, size);
        gaService.setLocation((GraphicsAlgorithm)tmp, tmp.getX() - 2, tmp.getY());
        tmp.setFilled(Boolean.valueOf(true));
    }

    public static void createTRIANGLE(GraphicsAlgorithmContainer gaContainer, int lineWidth) {
        IGaService gaService = Graphiti.getGaService();
        int dX = 10 + lineWidth * 2;
        int dY = (int)(5.0 + (double)lineWidth * 1.5);
        int[] nArray = new int[6];
        nArray[0] = -dX;
        nArray[1] = -dY;
        nArray[4] = -dX;
        nArray[5] = dY;
        Polygon tmp = gaService.createPolygon(gaContainer, nArray);
        CincoLayoutUtils.mirrorXAxis((ConnectionDecorator)gaContainer, (Polyline)tmp);
        gaService.setLocation((GraphicsAlgorithm)tmp, tmp.getX() + 2, tmp.getY());
        tmp.setFilled(Boolean.valueOf(true));
    }

    public static void createARROW(GraphicsAlgorithmContainer gaContainer, int lineWidth) {
        IGaService gaService = Graphiti.getGaService();
        int dX = 7 + lineWidth * 2;
        int dY = 1 + lineWidth * 2;
        int[] nArray = new int[6];
        nArray[0] = -dX;
        nArray[1] = -dY;
        nArray[4] = -dX;
        nArray[5] = dY;
        Polyline tmp = gaService.createPolyline(gaContainer, nArray);
        CincoLayoutUtils.mirrorXAxis((ConnectionDecorator)gaContainer, tmp);
        gaService.setLocation((GraphicsAlgorithm)tmp, tmp.getX() + 2, tmp.getY());
    }

    public static void createDIAMOND(GraphicsAlgorithmContainer gaContainer, int lineWidth) {
        IGaService gaService = Graphiti.getGaService();
        int dX = 8 + lineWidth;
        int dY = 5 + lineWidth;
        int[] nArray = new int[8];
        nArray[0] = -dX;
        nArray[1] = -dY;
        nArray[4] = -dX;
        nArray[5] = dY;
        nArray[6] = -dX * 2;
        Polygon tmp = gaService.createPolygon(gaContainer, nArray);
        CincoLayoutUtils.mirrorXAxis((ConnectionDecorator)gaContainer, (Polyline)tmp);
        gaService.setLocation((GraphicsAlgorithm)tmp, tmp.getX() + 2, tmp.getY());
        tmp.setFilled(Boolean.valueOf(true));
    }

    public static void mirrorXAxis(ConnectionDecorator cd, Polyline line) {
        if (cd.getLocation() != 1.0) {
            line.getPoints().forEach(p -> p.setX(-p.getX()));
        }
    }
}

