/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.layout;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayoutUtils;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayouter;
import graphmodel.Edge;

public class Layouter_Z_HORIZONTAL
extends EdgeLayouter {
    private EdgeLayoutUtils.Location sourceLoc;
    private EdgeLayoutUtils.Location targetLoc;

    @Override
    public void apply(Edge it) {
        this.sourceLoc = this._edgeLayoutUtils.getAbsoluteLocation(it.getSourceElement());
        this.targetLoc = this._edgeLayoutUtils.getAbsoluteLocation(it.getTargetElement());
        if (this.sourceLoc.x <= this.targetLoc.x) {
            this.applyLeftToRight(it);
        } else {
            this.applyRightToLeft(it);
        }
    }

    public void applyLeftToRight(Edge it) {
        if (this.sourceLoc.y <= this.targetLoc.y) {
            this.applyLeftToRightAndTopToBottom(it);
        } else {
            this.applyLeftToRightAndBottomToTop(it);
        }
    }

    public void applyLeftToRightAndTopToBottom(Edge it) {
        EdgeLayoutUtils.Location source = this._edgeLayoutUtils.getBottomCenter(it.getSourceElement());
        EdgeLayoutUtils.Location target = this._edgeLayoutUtils.getTopCenter(it.getTargetElement());
        int _abs = Math.abs(source.y - target.y);
        int _divide = _abs / 2;
        int dY = Math.max(_divide, 15);
        this._edgeLayoutUtils.replaceBendpoints(it, source.toBottom(dY), target.toTop(dY));
    }

    public void applyLeftToRightAndBottomToTop(Edge it) {
        EdgeLayoutUtils.Location source = this._edgeLayoutUtils.getTopCenter(it.getSourceElement());
        EdgeLayoutUtils.Location target = this._edgeLayoutUtils.getBottomCenter(it.getTargetElement());
        int _abs = Math.abs(source.y - target.y);
        int _divide = _abs / 2;
        int dY = Math.max(_divide, 15);
        this._edgeLayoutUtils.replaceBendpoints(it, source.toTop(dY), target.toBottom(dY));
    }

    public void applyRightToLeft(Edge it) {
        if (this.sourceLoc.y <= this.targetLoc.y) {
            this.applyRightToLeftAndTopToBottom(it);
        } else {
            this.applyRightToLeftAndBottomToTop(it);
        }
    }

    public void applyRightToLeftAndTopToBottom(Edge it) {
        EdgeLayoutUtils.Location source = this._edgeLayoutUtils.getBottomCenter(it.getSourceElement());
        EdgeLayoutUtils.Location target = this._edgeLayoutUtils.getTopCenter(it.getTargetElement());
        int _abs = Math.abs(source.y - target.y);
        int _divide = _abs / 2;
        int dY = Math.max(_divide, 15);
        this._edgeLayoutUtils.replaceBendpoints(it, source.toBottom(dY), target.toTop(dY));
    }

    public void applyRightToLeftAndBottomToTop(Edge it) {
        EdgeLayoutUtils.Location source = this._edgeLayoutUtils.getTopCenter(it.getSourceElement());
        EdgeLayoutUtils.Location target = this._edgeLayoutUtils.getBottomCenter(it.getTargetElement());
        int _abs = Math.abs(source.y - target.y);
        int _divide = _abs / 2;
        int dY = Math.max(_divide, 15);
        this._edgeLayoutUtils.replaceBendpoints(it, source.toTop(dY), target.toBottom(dY));
    }
}

