/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.layout;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.Edge;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalFactory;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal._Point;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.AddBendpointContext;
import org.eclipse.graphiti.features.context.impl.MoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.RemoveBendpointContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class EdgeLayoutUtils {
    @Extension
    private final WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
    protected static final int GRID_DISTANCE = 10;

    public GraphicsAlgorithm getGraphicsAlgorithm(ModelElement it) {
        PictogramElement _pictogramElement = this._workbenchExtension.getPictogramElement((IdentifiableElement)it);
        GraphicsAlgorithm _graphicsAlgorithm = null;
        if (_pictogramElement != null) {
            _graphicsAlgorithm = _pictogramElement.getGraphicsAlgorithm();
        }
        return _graphicsAlgorithm;
    }

    public Location getAbsoluteLocation(Node node) {
        int _x = node.getX();
        int _y = node.getY();
        Location loc = new Location(_x, _y);
        ModelElementContainer container = node.getContainer();
        while (container instanceof Node) {
            int _x_1 = loc.x;
            int _x_2 = ((Node)container).getX();
            loc.x = _x_1 + _x_2;
            int _y_1 = loc.y;
            int _y_2 = ((Node)container).getY();
            loc.y = _y_1 + _y_2;
            container = ((Node)container).getContainer();
        }
        return loc;
    }

    public Iterable<Location> alignTop(Iterable<Location> locs, final int margin) {
        Iterable _xblockexpression = null;
        Functions.Function1<Location, Integer> _function = new Functions.Function1<Location, Integer>(){

            public Integer apply(Location it) {
                return it.y;
            }
        };
        final Integer top = (Integer)IterableExtensions.head((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(locs, (Functions.Function1)_function)));
        Functions.Function1<Location, Location> _function_1 = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.y = top - margin;
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        _xblockexpression = IterableExtensions.map(locs, (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public Iterable<Location> alignBottom(Iterable<Location> locs, final int margin) {
        Iterable _xblockexpression = null;
        Functions.Function1<Location, Integer> _function = new Functions.Function1<Location, Integer>(){

            public Integer apply(Location it) {
                return it.y;
            }
        };
        final Integer bottom = (Integer)IterableExtensions.last((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(locs, (Functions.Function1)_function)));
        Functions.Function1<Location, Location> _function_1 = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.y = bottom + margin;
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        _xblockexpression = IterableExtensions.map(locs, (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public Iterable<Location> alignLeft(Iterable<Location> locs, final int margin) {
        Iterable _xblockexpression = null;
        Functions.Function1<Location, Integer> _function = new Functions.Function1<Location, Integer>(){

            public Integer apply(Location it) {
                return it.x;
            }
        };
        final Integer left = (Integer)IterableExtensions.head((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(locs, (Functions.Function1)_function)));
        Functions.Function1<Location, Location> _function_1 = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.x = left - margin;
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        _xblockexpression = IterableExtensions.map(locs, (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public Iterable<Location> alignRight(Iterable<Location> locs, final int margin) {
        Iterable _xblockexpression = null;
        Functions.Function1<Location, Integer> _function = new Functions.Function1<Location, Integer>(){

            public Integer apply(Location it) {
                return it.x;
            }
        };
        final Integer right = (Integer)IterableExtensions.last((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map(locs, (Functions.Function1)_function)));
        Functions.Function1<Location, Location> _function_1 = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.x = right + margin;
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        _xblockexpression = IterableExtensions.map(locs, (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public int snapToGrid(int value) {
        long _round = Math.round((double)value / 10.0);
        return 10 * (int)_round;
    }

    public int snapToGrid(int value, int offset) {
        int _xblockexpression = 0;
        int snap = this.snapToGrid(value);
        int _xifexpression = 0;
        _xifexpression = offset * (snap - value) <= 0 ? snap + offset : snap;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Iterable<Location> snapToGrid(Iterable<Location> locs) {
        Functions.Function1<Location, Location> _function = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.x = EdgeLayoutUtils.this.snapToGrid(it.x);
                        it.y = EdgeLayoutUtils.this.snapToGrid(it.y);
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        return IterableExtensions.map(locs, (Functions.Function1)_function);
    }

    public Iterable<Location> snapXToGrid(Iterable<Location> locs) {
        Functions.Function1<Location, Location> _function = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.x = EdgeLayoutUtils.this.snapToGrid(it.x);
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        return IterableExtensions.map(locs, (Functions.Function1)_function);
    }

    public Iterable<Location> snapYToGrid(Iterable<Location> locs) {
        Functions.Function1<Location, Location> _function = new Functions.Function1<Location, Location>(){

            public Location apply(Location it) {
                Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                    public void apply(Location it) {
                        it.y = EdgeLayoutUtils.this.snapToGrid(it.y);
                    }
                };
                return (Location)ObjectExtensions.operator_doubleArrow((Object)it, (Procedures.Procedure1)_function);
            }
        };
        return IterableExtensions.map(locs, (Functions.Function1)_function);
    }

    public List<Location> getBendpoints(Edge edge) {
        Functions.Function1<_Point, Location> _function = new Functions.Function1<_Point, Location>(){

            public Location apply(_Point it) {
                int _x = it.getX();
                int _y = it.getY();
                return new Location(_x, _y);
            }
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map(this.getInternalBendpointsList(edge), (Functions.Function1)_function));
    }

    public FreeFormConnection getConnection(Edge it) {
        PictogramElement _pictogramElement;
        FreeFormConnection _switchResult = null;
        PictogramElement pe = _pictogramElement = this._workbenchExtension.getPictogramElement((IdentifiableElement)it);
        boolean _matched = false;
        if (pe instanceof FreeFormConnection) {
            _matched = true;
            _switchResult = (FreeFormConnection)pe;
        }
        return _switchResult;
    }

    public void replaceBendpoints(final Edge it, final Location ... locs) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        final IFeatureProvider fp = _featureProvider;
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                EdgeLayoutUtils.this.removeBendpoints(it, fp);
                Consumer<Location> _function = new Consumer<Location>(){

                    @Override
                    public void accept(Location loc) {
                        EdgeLayoutUtils.this.addBendpoint(it, loc.x, loc.y, fp);
                    }
                };
                ((List)Conversions.doWrapArray((Object)locs)).forEach(_function);
            }
        };
        it.transact("Bendpoint editing", _function);
    }

    public void addBendpoints(final Edge it, final Location ... locs) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        final IFeatureProvider fp = _featureProvider;
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                Consumer<Location> _function = new Consumer<Location>(){

                    @Override
                    public void accept(Location loc) {
                        EdgeLayoutUtils.this.addBendpoint(it, loc.x, loc.y, fp);
                    }
                };
                ((List)Conversions.doWrapArray((Object)locs)).forEach(_function);
            }
        };
        it.transact("Add bendpoints", _function);
    }

    public Object addBendpoint(Edge it, int x, int y) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        return this.addBendpoint(it, x, y, _featureProvider);
    }

    private Object addBendpoint(Edge it, final int x, final int y, IFeatureProvider fp) {
        Object _xifexpression = null;
        if (fp != null) {
            Object _xblockexpression = null;
            FreeFormConnection _connection = this.getConnection(it);
            int _size = this.getBendpoints(it).size();
            AddBendpointContext ctx = new AddBendpointContext(_connection, x, y, _size);
            _xifexpression = _xblockexpression = this.executeWithContext((IFeature)fp.getAddBendpointFeature((IAddBendpointContext)ctx), (IContext)ctx);
        } else {
            EList<_Point> _internalBendpointsList = this.getInternalBendpointsList(it);
            _Point _create_Point = InternalFactory.eINSTANCE.create_Point();
            Procedures.Procedure1<_Point> _function = new Procedures.Procedure1<_Point>(){

                public void apply(_Point it) {
                    it.setX(x);
                    it.setY(y);
                }
            };
            _Point _doubleArrow = (_Point)ObjectExtensions.operator_doubleArrow((Object)_create_Point, (Procedures.Procedure1)_function);
            _xifexpression = _internalBendpointsList.add((Object)_doubleArrow);
        }
        return _xifexpression;
    }

    public void removeBendpoints(Edge it) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        this.removeBendpoints(it, _featureProvider);
    }

    public void removeBendpoints(final Edge it, final IFeatureProvider fp) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                int _size = EdgeLayoutUtils.this.getBendpoints(it).size();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                for (Integer i : _doubleDotLessThan) {
                    EdgeLayoutUtils.this.removeBendpoint(it, 0, fp);
                }
            }
        };
        it.transact("Delete bendpoints", _function);
    }

    public Object removeBendpoint(Edge it, int index) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        return this.removeBendpoint(it, index, _featureProvider);
    }

    private Object removeBendpoint(Edge it, final int index, IFeatureProvider fp) {
        Object _xifexpression = null;
        if (fp != null) {
            Object _xblockexpression = null;
            FreeFormConnection _connection = this.getConnection(it);
            RemoveBendpointContext _removeBendpointContext = new RemoveBendpointContext(_connection, null);
            Procedures.Procedure1<RemoveBendpointContext> _function = new Procedures.Procedure1<RemoveBendpointContext>(){

                public void apply(RemoveBendpointContext it) {
                    it.setBendpointIndex(index);
                }
            };
            RemoveBendpointContext ctx = (RemoveBendpointContext)ObjectExtensions.operator_doubleArrow((Object)_removeBendpointContext, (Procedures.Procedure1)_function);
            _xifexpression = _xblockexpression = this.executeWithContext((IFeature)fp.getRemoveBendpointFeature((IRemoveBendpointContext)ctx), (IContext)ctx);
        } else {
            _xifexpression = this.getInternalBendpointsList(it).remove(index);
        }
        return _xifexpression;
    }

    public void moveBendpoints(final Edge it, final Functions.Function1<? super Location, ? extends Location> move) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        final IFeatureProvider fp = _featureProvider;
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                int _size = EdgeLayoutUtils.this.getBendpoints(it).size();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                for (Integer i : _doubleDotLessThan) {
                    EdgeLayoutUtils.this.moveBendpoint(it, i, (Functions.Function1<? super Location, ? extends Location>)move, fp);
                }
            }
        };
        it.transact("Move bendpoints", _function);
    }

    public Object moveBendpoint(Edge it, int index, Functions.Function1<? super Location, ? extends Location> move) {
        Diagram _diagram = this._workbenchExtension.getDiagram((IdentifiableElement)it);
        IFeatureProvider _featureProvider = null;
        if (_diagram != null) {
            _featureProvider = this._workbenchExtension.getFeatureProvider(_diagram);
        }
        return this.moveBendpoint(it, index, move, _featureProvider);
    }

    public Object moveBendpoint(final Edge edge, final int index, Functions.Function1<? super Location, ? extends Location> move, IFeatureProvider fp) {
        Object _xblockexpression = null;
        final Location loc = (Location)move.apply((Object)this.getBendpoints(edge).get(index));
        Object _xifexpression = null;
        if (fp != null) {
            Object _xblockexpression_1 = null;
            MoveBendpointContext _moveBendpointContext = new MoveBendpointContext(null);
            Procedures.Procedure1<MoveBendpointContext> _function = new Procedures.Procedure1<MoveBendpointContext>(){

                public void apply(MoveBendpointContext it) {
                    it.setConnection(EdgeLayoutUtils.this.getConnection(edge));
                    it.setBendpointIndex(index);
                    it.setLocation(loc.x, loc.y);
                }
            };
            MoveBendpointContext ctx = (MoveBendpointContext)ObjectExtensions.operator_doubleArrow((Object)_moveBendpointContext, (Procedures.Procedure1)_function);
            _xifexpression = _xblockexpression_1 = this.executeWithContext((IFeature)fp.getMoveBendpointFeature((IMoveBendpointContext)ctx), (IContext)ctx);
        } else {
            _Point _get = (_Point)this.getInternalBendpointsList(edge).get(index);
            Procedures.Procedure1<_Point> _function = new Procedures.Procedure1<_Point>(){

                public void apply(_Point it) {
                    it.setX(loc.x);
                    it.setY(loc.y);
                }
            };
            _xifexpression = ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Object executeWithContext(IFeature it, IContext ctx) {
        Object _xblockexpression = null;
        IDiagramBehavior db = it.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior();
        _xblockexpression = db.executeFeature(it, ctx);
        return _xblockexpression;
    }

    private EList<_Point> getInternalBendpointsList(Edge it) {
        InternalModelElement _internalElement_ = it.getInternalElement_();
        return ((InternalEdge)_internalElement_).getBendpoints();
    }

    public Location getTopLeft(Node node) {
        return this.getAbsoluteLocation(node);
    }

    public Location getTopCenter(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _x = it.x;
                int _width = node.getWidth();
                int _divide = _width / 2;
                it.x = _x + _divide;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getTopRight(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _x = it.x;
                int _width = node.getWidth();
                it.x = _x + _width;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getMiddleLeft(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _y = it.y;
                int _height = node.getHeight();
                int _divide = _height / 2;
                it.y = _y + _divide;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getMiddleCenter(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _x = it.x;
                int _width = node.getWidth();
                int _divide = _width / 2;
                it.x = _x + _divide;
                int _y = it.y;
                int _height = node.getHeight();
                int _divide_1 = _height / 2;
                it.y = _y + _divide_1;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getMiddleRight(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _x = it.x;
                int _width = node.getWidth();
                it.x = _x + _width;
                int _y = it.y;
                int _height = node.getHeight();
                int _divide = _height / 2;
                it.y = _y + _divide;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getBottomLeft(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _y = it.y;
                int _height = node.getHeight();
                it.y = _y + _height;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getBottomCenter(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _x = it.x;
                int _width = node.getWidth();
                int _divide = _width / 2;
                it.x = _x + _divide;
                int _y = it.y;
                int _height = node.getHeight();
                it.y = _y + _height;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public Location getBottomRight(final Node node) {
        Location _absoluteLocation = this.getAbsoluteLocation(node);
        Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

            public void apply(Location it) {
                int _x = it.x;
                int _width = node.getWidth();
                it.x = _x + _width;
                int _y = it.y;
                int _height = node.getHeight();
                it.y = _y + _height;
            }
        };
        return (Location)ObjectExtensions.operator_doubleArrow((Object)_absoluteLocation, (Procedures.Procedure1)_function);
    }

    public static class Location {
        public int x = 0;
        public int y = 0;

        public static Location toLocation(Point point) {
            int _x = point.getX();
            int _y = point.getY();
            return new Location(_x, _y);
        }

        public static Iterable<Location> toLocation(Iterable<Point> points) {
            Iterable _xifexpression = null;
            if (points == null) {
                _xifexpression = CollectionLiterals.newArrayList();
            } else {
                Functions.Function1<Point, Location> _function = new Functions.Function1<Point, Location>(){

                    public Location apply(Point it) {
                        return Location.toLocation(it);
                    }
                };
                _xifexpression = IterableExtensions.map(points, (Functions.Function1)_function);
            }
            return _xifexpression;
        }

        public Location(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Location toLeft(final int dx) {
            Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                public void apply(Location it) {
                    int _x = it.x;
                    it.x = _x - dx;
                }
            };
            return (Location)ObjectExtensions.operator_doubleArrow((Object)this, (Procedures.Procedure1)_function);
        }

        public Location toRight(final int dx) {
            Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                public void apply(Location it) {
                    int _x = it.x;
                    it.x = _x + dx;
                }
            };
            return (Location)ObjectExtensions.operator_doubleArrow((Object)this, (Procedures.Procedure1)_function);
        }

        public Location toTop(final int dy) {
            Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                public void apply(Location it) {
                    int _y = it.y;
                    it.y = _y - dy;
                }
            };
            return (Location)ObjectExtensions.operator_doubleArrow((Object)this, (Procedures.Procedure1)_function);
        }

        public Location toBottom(final int dy) {
            Procedures.Procedure1<Location> _function = new Procedures.Procedure1<Location>(){

                public void apply(Location it) {
                    int _y = it.y;
                    it.y = _y + dy;
                }
            };
            return (Location)ObjectExtensions.operator_doubleArrow((Object)this, (Procedures.Procedure1)_function);
        }

        public String toString() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(");
            _builder.append((Object)this.x);
            _builder.append(",");
            _builder.append((Object)this.y);
            _builder.append(")");
            return _builder.toString();
        }
    }
}

