/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.layout;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayoutAction;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayoutRetargetAction;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.EdgeLayouter;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_C_BOTTOM;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_C_LEFT;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_C_RIGHT;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_C_TOP;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_TO_BOTTOM;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_TO_LEFT;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_TO_RIGHT;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_TO_TOP;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_Z_HORIZONTAL;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.layout.Layouter_Z_VERTICAL;
import graphmodel.Edge;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class EdgeLayout {
    public static EdgeLayout C_LEFT = new EdgeLayout("C_LEFT", "C-Layout Left", "c_left.gif", new Layouter_C_LEFT());
    public static EdgeLayout C_TOP = new EdgeLayout("C_TOP", "C-Layout Top", "c_top.gif", new Layouter_C_TOP());
    public static EdgeLayout C_RIGHT = new EdgeLayout("C_RIGHT", "C-Layout Right", "c_right.gif", new Layouter_C_RIGHT());
    public static EdgeLayout C_BOTTOM = new EdgeLayout("C_BOTTOM", "C-Layout Bottom", "c_bottom.gif", new Layouter_C_BOTTOM());
    public static EdgeLayout Z_HORIZONTAL = new EdgeLayout("Z_HORIZONTAL", "Z-Layout Horizontal", "z_horizontal.gif", new Layouter_Z_HORIZONTAL());
    public static EdgeLayout Z_VERTICAL = new EdgeLayout("Z_VERTICAL", "Z-Layout Vertical", "z_vertical.gif", new Layouter_Z_VERTICAL());
    public static EdgeLayout TO_LEFT = new EdgeLayout("TO_LEFT", "Move left", "to_left.gif", new Layouter_TO_LEFT());
    public static EdgeLayout TO_TOP = new EdgeLayout("TO_TOP", "Move up", "to_top.gif", new Layouter_TO_TOP());
    public static EdgeLayout TO_RIGHT = new EdgeLayout("TO_RIGHT", "Move right", "to_right.gif", new Layouter_TO_RIGHT());
    public static EdgeLayout TO_BOTTOM = new EdgeLayout("TO_BOTTOM", "Move down", "to_bottom.gif", new Layouter_TO_BOTTOM());
    public final String id;
    public final String text;
    public final ImageDescriptor imageDescriptor;
    public final ImageDescriptor disabledImageDescriptor;
    public final EdgeLayouter layouter;

    public static EdgeLayout[] values() {
        return new EdgeLayout[]{C_LEFT, C_TOP, C_RIGHT, C_BOTTOM, Z_HORIZONTAL, Z_VERTICAL, TO_LEFT, TO_TOP, TO_RIGHT, TO_BOTTOM};
    }

    private EdgeLayout(String id, String text, String image, EdgeLayouter layouter) {
        this.id = "de.jabc.cinco.meta.ui.action.layout." + id;
        this.text = text;
        this.imageDescriptor = EdgeLayout.createDescriptor("icon/" + image);
        int dot = image.lastIndexOf(".");
        this.disabledImageDescriptor = EdgeLayout.createDescriptor("icon/" + image.substring(0, dot) + "_disabled" + image.substring(dot));
        this.layouter = layouter;
    }

    private static ImageDescriptor createDescriptor(String filename) {
        return ImageDescriptor.createFromFile(EdgeLayout.class, (String)filename);
    }

    public void apply(Edge edge) {
        this.layouter.apply(edge);
    }

    public EdgeLayoutAction createAction(IWorkbenchPart part) {
        return new EdgeLayoutAction(part, this);
    }

    public EdgeLayoutRetargetAction createRetargetAction() {
        return new EdgeLayoutRetargetAction(this);
    }
}

