/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.animation;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.ColorProvider;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.DecoratorRegistry;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlight;
import de.jabc.cinco.meta.core.utils.job.ReiteratingThread;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IColorDecorator;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.util.IColorConstant;

public abstract class HighlightAnimation
extends ReiteratingThread {
    static final Set<HighlightAnimation> ANIMATIONS = new HashSet<HighlightAnimation>();
    static final int EffectIntervalInMs = 30;
    private Highlight hl;
    private int step = 0;
    private int steps = 30;

    public static void quitAll() {
        for (HighlightAnimation anim : ANIMATIONS) {
            anim.quit();
        }
    }

    public HighlightAnimation(Highlight hl, double effectTimeInSeconds) {
        super(30);
        ANIMATIONS.add(this);
        this.onDone(() -> {
            boolean bl = ANIMATIONS.remove((Object)this);
        });
        this.steps = (int)(effectTimeInSeconds * 1000.0 / 30.0);
        this.hl = hl;
    }

    protected void prepare() {
        this.mixColors((double)this.step / (double)this.steps);
        this.hl.on();
    }

    protected void work() {
        this.mixColors((double)this.step / (double)this.steps);
        this.step = this.nextStep(this.step, this.steps);
    }

    abstract int nextStep(int var1, int var2);

    public void cleanup() {
        this.hl.off();
    }

    public Highlight getHighlight() {
        return this.hl;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    void mixColors(double ratio) {
        boolean refresh = this.hl.isRefresh();
        this.hl.setRefresh(false);
        for (PictogramElement pe : this.hl.getPictogramElements()) {
            this.mixColors(pe, this.hl, ratio);
        }
        this.hl.setRefresh(refresh);
        this.hl.refreshAll();
    }

    void mixColors(PictogramElement pe, Highlight hl, double ratio) {
        IColorConstant peBgColor = this.getBackgroundColor(pe);
        IColorConstant peFgColor = this.getForegroundColor(pe);
        if (peFgColor != null) {
            peFgColor = ColorProvider.mix(peFgColor, hl.getForegroundColor(), ratio);
        }
        if (peBgColor != null) {
            peBgColor = ColorProvider.mix(peBgColor, hl.getBackgroundColor(), ratio);
        }
        if (peFgColor != null && peBgColor != null) {
            hl.setColors(pe, peFgColor, peBgColor);
            return;
        }
        if (peFgColor != null) {
            hl.setForegroundColor(pe, peFgColor);
        }
        if (peBgColor != null) {
            hl.setBackgroundColor(pe, peBgColor);
        }
    }

    IColorConstant getBackgroundColor(PictogramElement pe) {
        IDecorator deco = this.getDecorator(pe);
        if (deco != null && deco instanceof IColorDecorator) {
            return ((IColorDecorator)deco).getBackgroundColor();
        }
        if (pe.getGraphicsAlgorithm() != null) {
            return ColorProvider.toColorConstant(pe.getGraphicsAlgorithm().getBackground());
        }
        return null;
    }

    IColorConstant getForegroundColor(PictogramElement pe) {
        IDecorator deco = this.getDecorator(pe);
        if (deco != null && deco instanceof IColorDecorator) {
            return ((IColorDecorator)deco).getForegroundColor();
        }
        if (pe.getGraphicsAlgorithm() != null) {
            return ColorProvider.toColorConstant(pe.getGraphicsAlgorithm().getForeground());
        }
        return null;
    }

    IDecorator getDecorator(PictogramElement pe) {
        Stack reg = (Stack)((DecoratorRegistry)((Object)DecoratorRegistry.INSTANCE.get())).get(pe);
        if (this.hl.isOn()) {
            if (reg.size() > 1) {
                return (IDecorator)reg.get(reg.size() - 2);
            }
        } else if (!reg.isEmpty()) {
            return (IDecorator)reg.lastElement();
        }
        return null;
    }
}

