/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.DefaultHighlighter;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlight;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.HighlightUtils;
import de.jabc.cinco.meta.core.utils.registry.InstanceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;

public abstract class Highlighter {
    public static InstanceRegistry<Highlighter> INSTANCE = new InstanceRegistry(() -> new DefaultHighlighter());
    private Map<String, Collection<Highlight>> highlightContexts = new HashMap<String, Collection<Highlight>>();

    protected abstract Set<PictogramElement> getHighlightablesOnDrag(PictogramElement var1);

    protected abstract Set<PictogramElement> getHighlightablesOnCreate(ICreateFeature var1);

    protected abstract Set<PictogramElement> getHighlightablesOnConnect(ICreateConnectionFeature var1, ICreateConnectionContext var2);

    protected abstract Collection<PictogramElement> getHighlightablesOnReconnect(IReconnectionFeature var1, IReconnectionContext var2);

    protected abstract Highlight getHighlight(PictogramElement var1);

    protected abstract Highlight getHighlight(Iterable<PictogramElement> var1);

    public Highlighter listenToPaletteDrag(PaletteViewer viewer) {
        viewer.addDragSourceListener((TransferDragSourceListener)new PaletteDragSourceListener(viewer));
        return this;
    }

    public Highlighter listenToDiagramDrag(DiagramEditor editor, Control control) {
        DiagramDragSourceListener listener = new DiagramDragSourceListener(editor);
        editor.getGraphicalViewer().addDragSourceListener((TransferDragSourceListener)listener);
        control.addMouseListener((MouseListener)listener);
        return this;
    }

    public String onCreateStart(ICreateFeature feature) {
        return this.turnOnHighlights(this.getHighlightablesOnCreate(feature));
    }

    public void onCreateEnd(String contextKey) {
        this.turnOffHighlights(contextKey);
    }

    public String onConnectionStart(ICreateConnectionFeature feature, ICreateConnectionContext context) {
        Set<PictogramElement> list = this.getHighlightablesOnConnect(feature, context);
        String contextKey = this.turnOnHighlights(list);
        return contextKey;
    }

    public void onConnectionCancel(String contextKey) {
        this.turnOffHighlights(contextKey);
    }

    public void onConnectionEnd(String contextKey) {
        this.turnOffHighlights(contextKey);
    }

    public String onReconnectionStart(IReconnectionFeature feature, IReconnectionContext context) {
        String contextKey = this.turnOnHighlights(this.getHighlightablesOnReconnect(feature, context));
        return contextKey;
    }

    public void onReconnectionCancel(String contextKey) {
        this.turnOffHighlights(contextKey);
    }

    public void onReconnectionEnd(String contextKey) {
        this.turnOffHighlights(contextKey);
    }

    public String onDragStart(PictogramElement dragged) {
        return this.turnOnHighlights(this.getHighlightablesOnDrag(dragged));
    }

    public void onDragEnd(String contextKey) {
        this.turnOffHighlights(contextKey);
    }

    private String turnOnHighlights(Collection<PictogramElement> pes) {
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        if (pes != null && !pes.isEmpty()) {
            Highlight highlight = this.getHighlight(pes);
            highlights.add(highlight);
            highlight.swell(0.2);
            HighlightUtils.refreshDiagram();
        }
        String contextKey = this.getContextKey();
        this.highlightContexts.put(contextKey, highlights);
        return contextKey;
    }

    private void turnOffHighlights(String transactionKey) {
        Collection<Highlight> highlights = this.highlightContexts.get(transactionKey);
        if (highlights != null && !highlights.isEmpty()) {
            for (Highlight highlight : highlights) {
                try {
                    highlight.fade(0.2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getContextKey() {
        return UUID.randomUUID().toString();
    }

    protected class DiagramDragSourceListener
    extends TemplateTransferDragSourceListener
    implements MouseListener {
        String contextKey;
        DiagramEditor editor;

        public DiagramDragSourceListener(DiagramEditor editor) {
            super((EditPartViewer)editor.getGraphicalViewer());
            this.editor = editor;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = false;
            try {
                EditPart clicked = this.editor.getDiagramBehavior().getDiagramContainer().getGraphicalViewer().findObjectAt(new Point(event.x, event.y));
                if (clicked instanceof ContainerShapeEditPart) {
                    this.contextKey = Highlighter.this.onDragStart(((ContainerShapeEditPart)clicked).getPictogramElement());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void mouseUp(MouseEvent evt) {
            if (this.contextKey != null) {
                Highlighter.this.onDragEnd(this.contextKey);
                this.contextKey = null;
            }
        }

        public Transfer getTransfer() {
            return LocalSelectionTransfer.getTransfer();
        }

        public void dragSetData(DragSourceEvent event) {
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent event) {
        }
    }

    protected class DiagramDropTargetListener
    extends AbstractTransferDropTargetListener {
        public DiagramDropTargetListener(EditPartViewer viewer) {
            super(viewer);
            this.setEnablementDeterminedByCommand(true);
        }

        protected void updateTargetRequest() {
            ((CreateRequest)this.getTargetRequest()).setLocation(this.getDropLocation());
        }

        protected Request createTargetRequest() {
            CreateRequest request = new CreateRequest();
            request.setFactory((CreationFactory)new MyCreationFactory());
            request.setLocation(this.getDropLocation());
            return request;
        }

        protected void handleDragOver() {
            super.handleDragOver();
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.getCurrentEvent().detail = 1;
            }
        }

        public Transfer getTransfer() {
            return new LocalSelectionTransfer(){

                protected int[] getTypeIds() {
                    return super.getTypeIds();
                }

                protected String[] getTypeNames() {
                    return super.getTypeNames();
                }

                public TransferData[] getSupportedTypes() {
                    return super.getSupportedTypes();
                }

                public boolean isSupportedType(TransferData transferData) {
                    return super.isSupportedType(transferData);
                }
            };
        }

        private class MyCreationFactory
        implements CreationFactory {
            public Object getNewObject() {
                return LocalSelectionTransfer.getTransfer().getSelection();
            }

            public Object getObjectType() {
                return ISelection.class;
            }
        }
    }

    protected class PaletteDragSourceListener
    extends TemplateTransferDragSourceListener {
        private String contextKey;

        public PaletteDragSourceListener(PaletteViewer viewer) {
            super((EditPartViewer)viewer);
        }

        public void dragStart(DragSourceEvent event) {
            super.dragStart(event);
            try {
                Object feature;
                CreationFactory template = (CreationFactory)this.getTemplate();
                if (template != null && (feature = template.getNewObject()) instanceof ICreateFeature) {
                    this.contextKey = Highlighter.this.onCreateStart((ICreateFeature)feature);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void dragFinished(DragSourceEvent event) {
            super.dragFinished(event);
            Highlighter.this.onCreateEnd(this.contextKey);
        }
    }
}

