/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight;

import com.google.common.collect.Sets;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.LazyDiagram;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.ColorProvider;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.ConnectionDecoratorLayouter;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.DecoratorRegistry;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.HighlightDecorator;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.animation.HighlightAnimation;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.animation.HighlightBlink;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.animation.HighlightFade;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.animation.HighlightFlash;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.animation.HighlightSwell;
import de.jabc.cinco.meta.core.utils.registry.InstanceRegistry;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.SWTException;

public class Highlight {
    public static InstanceRegistry<Highlight> INSTANCE = new InstanceRegistry(() -> new Highlight());
    private Set<PictogramElement> pes = new HashSet<PictogramElement>();
    private Set<PictogramElement> affected = ConcurrentHashMap.newKeySet();
    private Map<PictogramElement, ConnectionDecoratorLayouter> layouters = new HashMap<PictogramElement, ConnectionDecoratorLayouter>();
    private Map<PictogramElement, HighlightDecorator> decos = new HashMap<PictogramElement, HighlightDecorator>();
    private HighlightDecorator deco;
    private Color diagramHltColor;
    private Color diagramOrgColor;
    private HighlightAnimation animation;
    private boolean on = false;
    private boolean refresh = true;
    private WorkbenchExtension workbenchX = new WorkbenchExtension();

    public Highlight() {
        ColorConstant c = ((ColorProvider)ColorProvider.INSTANCE.get()).next();
        this.deco = new HighlightDecorator((IColorConstant)ColorProvider.amend((IColorConstant)c, 0.7), (IColorConstant)ColorProvider.amend((IColorConstant)c, 1.3));
    }

    public Highlight(IColorConstant fgColor, IColorConstant bgColor) {
        this.deco = new HighlightDecorator(fgColor, bgColor);
    }

    public Highlight(Highlight archetype) {
        this(archetype.deco.getForegroundColor(), archetype.deco.getBackgroundColor());
        this.pes = archetype.pes;
    }

    public Highlight add(PictogramElement pe) {
        if (this.pes.add(pe) && this.isOn()) {
            this.on(pe, true);
        }
        return this;
    }

    public Highlight add(ModelElement me) {
        this.add(this.workbenchX.getPictogramElement((IdentifiableElement)me));
        return this;
    }

    public Highlight remove(PictogramElement pe) {
        if (this.pes.remove(pe) && this.isOn()) {
            this.off(pe, true);
        }
        return this;
    }

    public Highlight remove(ModelElement me) {
        this.remove(this.workbenchX.getPictogramElement((IdentifiableElement)me));
        return this;
    }

    public Highlight clear() {
        if (this.isOn()) {
            this.off();
        }
        this.pes.clear();
        return this;
    }

    public boolean isActive(PictogramElement pe) {
        Stack reg = (Stack)((DecoratorRegistry)((Object)DecoratorRegistry.INSTANCE.get())).get(pe);
        return !reg.isEmpty() && this.getDeco(pe) == reg.lastElement();
    }

    public boolean isOn() {
        return this.on;
    }

    public IColorConstant getForegroundColor() {
        return this.deco.getForegroundColor();
    }

    public IColorConstant getForegroundColor(PictogramElement pe) {
        return this.getDeco(pe).getForegroundColor();
    }

    public IColorConstant getBackgroundColor() {
        return this.deco.getBackgroundColor();
    }

    public IColorConstant getBackgroundColor(PictogramElement pe) {
        return this.getDeco(pe).getBackgroundColor();
    }

    public Highlight setForegroundColor(IColorConstant fgColor) {
        this.deco.setForegroundColor(fgColor);
        this.refreshAll();
        return this;
    }

    public Highlight setForegroundColor(int red, int green, int blue) {
        this.deco.setForegroundColor((IColorConstant)new ColorConstant(red, green, blue));
        this.refreshAll();
        return this;
    }

    public Highlight setForegroundColor(String hexRGBString) {
        this.deco.setForegroundColor((IColorConstant)new ColorConstant(hexRGBString));
        this.refreshAll();
        return this;
    }

    public Highlight setForegroundColor(PictogramElement pe, IColorConstant fgColor) {
        this.getDeco(pe).setForegroundColor(fgColor);
        this.refresh(pe);
        return this;
    }

    public Highlight setForegroundColor(PictogramElement pe, int red, int green, int blue) {
        this.getDeco(pe).setForegroundColor((IColorConstant)new ColorConstant(red, green, blue));
        this.refresh(pe);
        return this;
    }

    public Highlight setForegroundColor(PictogramElement pe, String hexRGBString) {
        this.getDeco(pe).setForegroundColor((IColorConstant)new ColorConstant(hexRGBString));
        this.refresh(pe);
        return this;
    }

    public Highlight setBackgroundColor(IColorConstant bgColor) {
        this.deco.setBackgroundColor(bgColor);
        this.refreshAll();
        return this;
    }

    public Highlight setBackgroundColor(int red, int green, int blue) {
        this.deco.setBackgroundColor((IColorConstant)new ColorConstant(red, green, blue));
        this.refreshAll();
        return this;
    }

    public Highlight setBackgroundColor(String hexRGBString) {
        this.deco.setBackgroundColor((IColorConstant)new ColorConstant(hexRGBString));
        this.refreshAll();
        return this;
    }

    public Highlight setBackgroundColor(PictogramElement pe, IColorConstant bgColor) {
        this.getDeco(pe).setBackgroundColor(bgColor);
        this.refresh(pe);
        return this;
    }

    public Highlight setBackgroundColor(PictogramElement pe, int red, int green, int blue) {
        this.getDeco(pe).setBackgroundColor((IColorConstant)new ColorConstant(red, green, blue));
        this.refresh(pe);
        return this;
    }

    public Highlight setBackgroundColor(PictogramElement pe, String hexRGBString) {
        this.getDeco(pe).setBackgroundColor((IColorConstant)new ColorConstant(hexRGBString));
        this.refresh(pe);
        return this;
    }

    public Highlight setColors(PictogramElement pe, IColorConstant fgColor, IColorConstant bgColor) {
        HighlightDecorator deco = this.getDeco(pe);
        deco.setForegroundColor(fgColor);
        deco.setBackgroundColor(bgColor);
        this.refresh(pe);
        return this;
    }

    public ArrayList<PictogramElement> getPictogramElements() {
        return new ArrayList<PictogramElement>(this.pes);
    }

    public Highlight setPictogramElements(PictogramElement ... pes) {
        return this.setPictogramElements(Arrays.asList(pes));
    }

    public Highlight setPictogramElements(Iterable<PictogramElement> pes) {
        HashSet<PictogramElement> current = new HashSet<PictogramElement>(this.pes);
        HashSet newone = Sets.newHashSet(pes);
        HashSet<PictogramElement> result = new HashSet<PictogramElement>();
        for (PictogramElement pe : current) {
            if (newone.contains(pe)) {
                result.add(pe);
                newone.remove(pe);
                continue;
            }
            if (!this.isOn()) continue;
            this.off(pe, false);
        }
        for (PictogramElement pe : newone) {
            result.add(pe);
            if (!this.isOn()) continue;
            this.on(pe, false);
        }
        this.pes = result;
        this.refreshAll();
        return this;
    }

    public Highlight on() {
        for (PictogramElement pe : this.pes) {
            this.on(pe, false);
        }
        this.on = true;
        this.refreshAll();
        return this;
    }

    protected Highlight on(PictogramElement pe, boolean triggerDiagramRefresh) {
        if (pe instanceof Diagram) {
            this.diagramOn((Diagram)pe);
        } else {
            ((Stack)((DecoratorRegistry)((Object)DecoratorRegistry.INSTANCE.get())).get(pe)).push(this.getDeco(pe));
        }
        this.affected.add(pe);
        this.registerConnectionDecoratorLayouter(pe);
        if (triggerDiagramRefresh) {
            this.refresh(pe);
        }
        return this;
    }

    public Highlight flash() {
        this.flash(1.0);
        return this;
    }

    public Highlight flash(double effectTimeInSeconds) {
        this.startAnimation(new HighlightFlash(this, effectTimeInSeconds));
        return this;
    }

    public Highlight blink() {
        this.blink(1.0);
        return this;
    }

    public Highlight blink(double effectTimeInSeconds) {
        this.startAnimation(new HighlightBlink(this, effectTimeInSeconds));
        return this;
    }

    public Highlight swell() {
        this.swell(0.5);
        return this;
    }

    public Highlight swell(double effectTimeInSeconds) {
        this.startAnimation(new HighlightSwell(this, effectTimeInSeconds));
        return this;
    }

    public Highlight fade() {
        this.fade(0.5);
        return this;
    }

    public Highlight fade(double effectTimeInSeconds) {
        this.startAnimation(new HighlightFade(this, effectTimeInSeconds));
        return this;
    }

    public Highlight setAnimation(HighlightAnimation animation) {
        if (this.animation != null) {
            this.animation.quit();
        }
        this.animation = animation;
        return this;
    }

    protected Highlight startAnimation(HighlightAnimation animation) {
        if (this.animation != null) {
            this.animation.onDone(() -> {
                this.animation = animation;
                animation.start();
            });
            this.animation.quit();
            this.animation = null;
        } else {
            this.animation = animation;
            animation.start();
        }
        return this;
    }

    public Highlight off() {
        if (this.animation != null) {
            this.animation.quit();
        }
        this.removeDecos();
        return this;
    }

    protected Highlight off(PictogramElement pe, boolean triggerDiagramRefresh) {
        if (pe instanceof Diagram) {
            this.diagramOff((Diagram)pe);
        } else {
            ((Stack)((DecoratorRegistry)((Object)DecoratorRegistry.INSTANCE.get())).get(pe)).remove((Object)this.getDeco(pe));
        }
        this.unregisterConnectionDecoratorLayouter(pe);
        if (triggerDiagramRefresh) {
            this.refresh(pe, () -> {
                boolean bl = this.affected.remove(pe);
            });
        }
        return this;
    }

    protected void removeDecos() {
        for (PictogramElement pe : new HashSet<PictogramElement>(this.affected)) {
            this.off(pe, false);
        }
        ArrayList<PictogramElement> orgAffected = new ArrayList<PictogramElement>(this.affected);
        this.affected.clear();
        this.on = false;
        this.refreshAll(orgAffected);
    }

    protected Highlight diagramOn(Diagram diagram) {
        GraphicsAlgorithm ga = diagram.getGraphicsAlgorithm();
        this.assertDiagramHltColor(diagram);
        this.diagramOrgColor = ga.getBackground();
        try {
            diagram.getGraphicsAlgorithm().setBackground(this.diagramHltColor);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return this;
    }

    protected Highlight diagramOff(Diagram diagram) {
        try {
            diagram.getGraphicsAlgorithm().setBackground(this.diagramOrgColor);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return this;
    }

    private void registerConnectionDecoratorLayouter(PictogramElement pe) {
        if (pe instanceof Connection) {
            this.workbenchX.sync(() -> {
                ConnectionDecoratorLayouter connectionDecoratorLayouter = this.layouters.put(pe, ConnectionDecoratorLayouter.applyTo(pe));
            });
        }
    }

    private void unregisterConnectionDecoratorLayouter(PictogramElement pe) {
        ConnectionDecoratorLayouter layouter = this.layouters.remove(pe);
        if (layouter != null) {
            layouter.setUnregisterAfterNextLayout(true);
        }
    }

    private HighlightDecorator getDeco(PictogramElement pe) {
        HighlightDecorator deco = this.decos.get(pe);
        if (deco == null) {
            deco = new HighlightDecorator(this.deco);
            this.decos.put(pe, deco);
        }
        return deco;
    }

    private void refresh(PictogramElement pe) {
        this.refresh(pe, null);
    }

    private void refresh(PictogramElement pe, Runnable onDone) {
        this.workbenchX.async(() -> {
            DiagramBehavior db = this.getDiagramBehavior(pe);
            if (db != null) {
                this.refreshRenderingDecorators(db, pe);
            } else {
                System.err.println("[Highlight] No DiagramBehavior found for pictogram: " + pe);
            }
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    public void refreshAll() {
        this.refreshAll(new ArrayList<PictogramElement>(this.affected));
    }

    public void refreshAll(List<PictogramElement> affected) {
        this.workbenchX.async(() -> {
            if (!affected.isEmpty()) {
                PictogramElement pe = (PictogramElement)affected.iterator().next();
                DiagramBehavior db = this.getDiagramBehavior(pe);
                if (db != null) {
                    for (PictogramElement p : affected) {
                        this.refreshRenderingDecorators(db, p);
                    }
                } else {
                    System.err.println("[Highlight] No DiagramBehavior found for pictogram: " + pe);
                }
            }
        });
    }

    private void refreshRenderingDecorators(DiagramBehavior db, PictogramElement p) {
        try {
            db.refreshRenderingDecorators(p);
        }
        catch (IllegalArgumentException | SWTException throwable) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DiagramBehavior getDiagramBehavior(PictogramElement pe) {
        DiagramBehavior db;
        Diagram diagram = this.workbenchX.getDiagram(pe);
        if (diagram instanceof LazyDiagram && (db = ((LazyDiagram)diagram).getDiagramBehavior()) != null) {
            return db;
        }
        return this.workbenchX.getDiagramBehavior(pe);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    private void assertDiagramHltColor(Diagram diagram) {
        if (this.diagramHltColor == null) {
            IColorConstant clr = this.deco.getBackgroundColor();
            this.diagramHltColor = StylesFactory.eINSTANCE.createColor();
            this.diagramHltColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Red(), (Object)clr.getRed());
            this.diagramHltColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Green(), (Object)clr.getGreen());
            this.diagramHltColor.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getColor_Blue(), (Object)clr.getBlue());
        }
    }
}

