/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CNode;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlight;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.HighlightUtils;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.highlight.Highlighter;
import graphmodel.Node;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultHighlighter
extends Highlighter {
    @Override
    protected Set<PictogramElement> getHighlightablesOnDrag(PictogramElement dragged) {
        return HighlightUtils.getShapes().stream().filter(pe -> pe != dragged && HighlightUtils.testBusinessObjectType((PictogramElement)pe, InternalModelElementContainer.class) && this.canContain((Shape)pe, dragged)).collect(Collectors.toSet());
    }

    @Override
    protected Set<PictogramElement> getHighlightablesOnCreate(ICreateFeature feature) {
        return HighlightUtils.getContainerShapes().stream().filter(pe -> HighlightUtils.testBusinessObjectType((PictogramElement)pe, InternalModelElementContainer.class)).filter(pe -> this.canCreate(feature, (ContainerShape)pe)).collect(Collectors.toSet());
    }

    @Override
    protected Set<PictogramElement> getHighlightablesOnConnect(ICreateConnectionFeature feature, ICreateConnectionContext context) {
        CreateConnectionContext ctx = new CreateConnectionContext();
        ctx.setSourceAnchor(context.getSourceAnchor());
        ctx.setSourcePictogramElement(context.getSourcePictogramElement());
        Set<PictogramElement> shapes = HighlightUtils.getShapes(context.getSourcePictogramElement()).stream().filter(shape -> HighlightUtils.testBusinessObjectType((PictogramElement)shape, Node.class)).filter(shape -> {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)shape);
            if (bo instanceof CNode) {
                ctx.setTargetAnchor(((CNode)bo).getAnchor());
                ctx.setTargetPictogramElement(((CNode)bo).getPictogramElement());
                return feature.canCreate((ICreateConnectionContext)ctx);
            }
            return false;
        }).collect(Collectors.toSet());
        return shapes;
    }

    @Override
    protected Collection<PictogramElement> getHighlightablesOnReconnect(IReconnectionFeature feature, IReconnectionContext context) {
        ReconnectionContext ctx = new ReconnectionContext(context.getConnection(), context.getOldAnchor(), context.getNewAnchor(), context.getTargetLocation());
        ctx.setReconnectType(context.getReconnectType());
        return HighlightUtils.getShapes().stream().filter(shape -> HighlightUtils.testBusinessObjectType((PictogramElement)shape, InternalNode.class)).filter(shape -> {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)shape);
            if (bo instanceof CNode) {
                ctx.setNewAnchor(((CNode)bo).getAnchor());
                ctx.setTargetPictogramElement(((CNode)bo).getPictogramElement());
                return feature.canReconnect((IReconnectionContext)ctx);
            }
            return false;
        }).collect(Collectors.toSet());
    }

    private boolean canCreate(ICreateFeature creater, ContainerShape shape) {
        CreateContext context = new CreateContext();
        context.setTargetContainer(shape);
        return creater.canCreate((ICreateContext)context);
    }

    private boolean canContain(Shape containerShape, PictogramElement pe) {
        try {
            InternalNode node = (InternalNode)HighlightUtils.getBusinessObject(pe);
            InternalModelElementContainer cont = (InternalModelElementContainer)HighlightUtils.getBusinessObject((PictogramElement)containerShape);
            return cont.equals((Object)node.getContainer()) || cont.canContain(((Node)node.getElement()).getClass());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected Highlight getHighlight(PictogramElement pe) {
        return ((Highlight)Highlight.INSTANCE.create()).setForegroundColor(20, 150, 20).setBackgroundColor(240, 255, 240).setPictogramElements(pe);
    }

    @Override
    protected Highlight getHighlight(Iterable<PictogramElement> pes) {
        return ((Highlight)Highlight.INSTANCE.create()).setForegroundColor(20, 150, 20).setBackgroundColor(240, 255, 240).setPictogramElements(pes);
    }
}

