/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.features;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoAbstractResizeFeature;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class CincoResizeFeature
extends CincoAbstractResizeFeature {
    public static final String FIXED = "_fixed";
    public static final String FIXED_WIDTH = "_fixedWidth";
    public static final String FIXED_HEIGHT = "_fixedHeight";
    public static final String KEY_INITIAL_POINTS = "initial_points";
    public static final String KEY_INITIAL_PARENT_SIZE = "initial_parent_size";
    public static final String KEY_HORIZONTAL = "horizontal";
    public static final String KEY_HORIZONTAL_LEFT = "h_layout_left";
    public static final String KEY_HORIZONTAL_RIGHT = "h_layout_right";
    public static final String KEY_VERTICAL = "vertical";
    public static final String KEY_VERTICAL_TOP = "v_layout_top";
    public static final String KEY_VERTICAL_BOTTOM = "v_layout_bottom";
    private static EObject bo;
    private static int oldWidth;
    private static int oldHeight;
    private static int newWidth;
    private static int newHeight;
    private static int deltaWidth;
    private static int deltaHeight;
    private static int deltaX;
    private static int deltaY;

    public CincoResizeFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public void resizeShape(IResizeShapeContext context) {
        CincoResizeFeature.resize(context);
    }

    public static void resize(IResizeShapeContext context) {
        EList businessObjects = context.getPictogramElement().getLink().getBusinessObjects();
        if (businessObjects != null && !businessObjects.isEmpty()) {
            bo = (EObject)businessObjects.get(0);
        }
        Shape shape = context.getShape();
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        oldWidth = ga.getWidth();
        oldHeight = ga.getHeight();
        newWidth = context.getWidth();
        newHeight = context.getHeight();
        deltaWidth = oldWidth - newWidth;
        deltaHeight = oldHeight - newHeight;
        deltaX = context.getX() - ga.getX();
        deltaY = context.getY() - ga.getY();
        CincoResizeFeature.resize(shape);
    }

    private static void resize(Shape shape) {
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        if (ga instanceof Polyline) {
            CincoResizeFeature.resizeByScale((Polyline)ga);
        } else {
            CincoResizeFeature.resizeByDelta(ga);
        }
    }

    private static void resizeByDelta(GraphicsAlgorithm ga) {
        CincoResizeFeature.setNewLocationAndSize(ga);
        CincoResizeFeature.resizeChildren(ga);
    }

    private static void setNewLocationAndSize(GraphicsAlgorithm ga, Rectangle bounds) {
        if (((Shape)ga.getPictogramElement()).getContainer() instanceof Diagram) {
            CincoResizeFeature.setLocationAndSize(ga, deltaX, deltaY, ga.getWidth() - bounds.width, ga.getHeight() - bounds.height);
        } else {
            CincoResizeFeature.setLocationAndSize(ga, bounds.x, bounds.y, ga.getWidth() - bounds.width, ga.getHeight() - bounds.height);
        }
    }

    private static void setNewLocationAndSize(GraphicsAlgorithm ga) {
        boolean fixWth = CincoResizeFeature.checkPropertyValue((PropertyContainer)ga, FIXED_WIDTH, FIXED);
        boolean fixHgt = CincoResizeFeature.checkPropertyValue((PropertyContainer)ga, FIXED_HEIGHT, FIXED);
        CincoResizeFeature.setLocationAndSize(ga, fixWth ? 0 : deltaX, fixHgt ? 0 : deltaY, fixWth ? 0 : deltaWidth, fixHgt ? 0 : deltaHeight);
    }

    private static void resizeByScale(Polyline polyline) {
        EList points = polyline.getPoints();
        PointList initialPoints = CincoResizeFeature.getInitialPoints(polyline);
        Dimension initialParent = CincoResizeFeature.getInitialParentSize(polyline);
        Dimension oldParent = new Dimension(oldWidth, oldHeight);
        Dimension newParent = new Dimension(newWidth, newHeight);
        if (initialParent != null && initialPoints.size() > 0 && points.size() == initialPoints.size()) {
            int i = 0;
            while (i < points.size()) {
                org.eclipse.graphiti.mm.algorithms.styles.Point p = (org.eclipse.graphiti.mm.algorithms.styles.Point)points.get(i);
                p.setX(initialPoints.getPoint((int)i).x);
                p.setY(initialPoints.getPoint((int)i).y);
                ++i;
            }
            oldParent.setSize(initialParent.width, initialParent.height);
        }
        if (CincoResizeFeature.checkPropertyValue((PropertyContainer)polyline, FIXED_WIDTH, FIXED)) {
            newParent.width = oldParent.width;
        }
        if (CincoResizeFeature.checkPropertyValue((PropertyContainer)polyline, FIXED_HEIGHT, FIXED)) {
            newParent.height = oldParent.height;
        }
        CincoResizeFeature.resizeByScale((List<org.eclipse.graphiti.mm.algorithms.styles.Point>)points, oldParent, newParent, true, true, true, true);
        CincoResizeFeature.setNewLocationAndSize((GraphicsAlgorithm)polyline, CincoResizeFeature.calcBounds((List<org.eclipse.graphiti.mm.algorithms.styles.Point>)polyline.getPoints()));
        CincoResizeFeature.resizeChildren((GraphicsAlgorithm)polyline);
    }

    private static void resizeByScale(List<org.eclipse.graphiti.mm.algorithms.styles.Point> polypoints, Dimension oldParent, Dimension newParent, boolean marginLftFix, boolean marginRgtFix, boolean marginTopFix, boolean marginBtmFix) {
        Rectangle bounds = CincoResizeFeature.calcBounds(polypoints);
        double marginLft = bounds.x;
        double marginTop = bounds.y;
        double marginRgt = (double)(oldParent.width - bounds.width) - marginLft;
        double marginBtm = (double)(oldParent.height - bounds.height) - marginTop;
        double scaleX = (double)newParent.width / (double)oldParent.width;
        double scaleY = (double)newParent.height / (double)oldParent.height;
        double newWidth = (double)newParent.width - marginLft * (marginLftFix ? 1.0 : scaleX) - marginRgt * (marginRgtFix ? 1.0 : scaleX);
        double newHeight = (double)newParent.height - marginTop * (marginTopFix ? 1.0 : scaleY) - marginBtm * (marginBtmFix ? 1.0 : scaleY);
        CincoResizeFeature.moveByDelta(polypoints, -marginLft, -marginTop);
        CincoResizeFeature.scalePoints(polypoints, bounds.width > 0 ? newWidth / (double)bounds.width : 1.0, bounds.height > 0 ? newHeight / (double)bounds.height : 1.0);
        CincoResizeFeature.moveByDelta(polypoints, marginLft * (marginLftFix ? 1.0 : scaleX), marginTop * (marginTopFix ? 1.0 : scaleY));
    }

    private static Rectangle calcBounds(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        int minX = CincoResizeFeature.getMinX(points);
        int minY = CincoResizeFeature.getMinY(points);
        return new Rectangle(minX, minY, CincoResizeFeature.getMaxX(points) - minX, CincoResizeFeature.getMaxY(points) - minY);
    }

    private static int getMinX(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        return ((org.eclipse.graphiti.mm.algorithms.styles.Point)points.stream().min((p1, p2) -> Integer.compare(p1.getX(), p2.getX())).get()).getX();
    }

    private static int getMinY(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        return ((org.eclipse.graphiti.mm.algorithms.styles.Point)points.stream().min((p1, p2) -> Integer.compare(p1.getY(), p2.getY())).get()).getY();
    }

    private static int getMaxX(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        return ((org.eclipse.graphiti.mm.algorithms.styles.Point)points.stream().max((p1, p2) -> Integer.compare(p1.getX(), p2.getX())).get()).getX();
    }

    private static int getMaxY(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        return ((org.eclipse.graphiti.mm.algorithms.styles.Point)points.stream().max((p1, p2) -> Integer.compare(p1.getY(), p2.getY())).get()).getY();
    }

    private static void moveByDelta(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points, double deltaX, double deltaY) {
        for (org.eclipse.graphiti.mm.algorithms.styles.Point p : points) {
            p.setX(p.getX() + (int)deltaX);
            p.setY(p.getY() + (int)deltaY);
        }
    }

    private static Dimension getInitialParentSize(Polyline polyline) {
        IPeService peService = Graphiti.getPeService();
        String value = peService.getPropertyValue((PropertyContainer)polyline, KEY_INITIAL_PARENT_SIZE);
        if (value != null) {
            String[] values = value.split(",");
            return new Dimension(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
        }
        return null;
    }

    private static PointList getInitialPoints(Polyline polyline) {
        PointList points = new PointList();
        IPeService peService = Graphiti.getPeService();
        String value = peService.getPropertyValue((PropertyContainer)polyline, KEY_INITIAL_POINTS);
        if (value != null) {
            String[] values = value.split(",");
            int i = 0;
            while (i < values.length) {
                Point p = new Point(Integer.parseInt(values[i]), Integer.parseInt(values[i + 1]));
                points.addPoint(p);
                i += 2;
            }
        }
        return points;
    }

    private static boolean checkPropertyValue(PropertyContainer pc, String key, String value) {
        return value.equals(Graphiti.getPeService().getPropertyValue(pc, key));
    }

    private static void scalePoints(List<org.eclipse.graphiti.mm.algorithms.styles.Point> points, double scaleX, double scaleY) {
        for (org.eclipse.graphiti.mm.algorithms.styles.Point p : points) {
            p.setX((int)(scaleX * (double)p.getX()));
            p.setY((int)(scaleY * (double)p.getY()));
        }
    }

    private static void resizeChildren(GraphicsAlgorithm ga) {
        if (ga.getPictogramElement() instanceof ContainerShape) {
            for (Shape s : ((ContainerShape)ga.getPictogramElement()).getChildren()) {
                if (!CincoResizeFeature.isResizable(s)) continue;
                CincoResizeFeature.resize(s);
            }
        }
    }

    private static void setLocationAndSize(GraphicsAlgorithm ga, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        EObject boparent;
        EObject boGa = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(ga.getPictogramElement());
        if (!boGa.equals(boparent = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ga.getPictogramElement().eContainer()))) {
            Graphiti.getGaService().setLocationAndSize(ga, ga.getX() + deltaX, ga.getY() + deltaY, ga.getWidth() - deltaWidth, ga.getHeight() - deltaHeight);
        } else {
            Graphiti.getGaService().setLocationAndSize(ga, ga.getX(), ga.getY(), ga.getWidth() - deltaWidth, ga.getHeight() - deltaHeight);
        }
    }

    private static boolean isResizable(Shape s) {
        EList bos = s.getLink() != null ? s.getLink().getBusinessObjects() : null;
        Object currentBo = null;
        if (bos != null && !bos.isEmpty()) {
            currentBo = (EObject)bos.get(0);
        }
        return (currentBo == null || currentBo.equals(bo)) && !(s.getGraphicsAlgorithm() instanceof AbstractText);
    }
}

