/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.api.CNode;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.LazyDiagram;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.features.CincoAddFeature;
import de.jabc.cinco.meta.runtime.xapi.CodingExtension;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.util.xapi.CodingExtension;
import graphmodel.Edge;
import graphmodel.GraphModel;
import graphmodel.Node;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal._Decoration;
import graphmodel.internal._Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddBendpointContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.AreaContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.SWTException;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class DiagramBuilder {
    @Extension
    private final CodingExtension _codingExtension = new CodingExtension();
    @Extension
    private final ResourceExtension _resourceExtension = new ResourceExtension();
    private Map<InternalIdentifiableElement, PictogramElement> pes = new HashMap<InternalIdentifiableElement, PictogramElement>();
    private GraphModel model;
    private LazyDiagram diagram;
    private IDiagramTypeProvider dtp;
    private IFeatureProvider fp;

    public DiagramBuilder(LazyDiagram diagram, GraphModel model) {
        this.diagram = diagram;
        this.model = model;
    }

    public LazyDiagram build(final Resource resource) {
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                DiagramBuilder.this.linkTo((PictogramElement)DiagramBuilder.this.diagram, (EObject)DiagramBuilder.this.model.getInternalElement_());
                Functions.Function1<Node, InternalModelElement> _function = new Functions.Function1<Node, InternalModelElement>(){

                    public InternalModelElement apply(Node it) {
                        return it.getInternalElement_();
                    }
                };
                Consumer<InternalModelElement> _function_1 = new Consumer<InternalModelElement>(){

                    @Override
                    public void accept(InternalModelElement it) {
                        DiagramBuilder.this.add(it);
                    }
                };
                IterableExtensions.map(DiagramBuilder.this.getNodes(), (Functions.Function1)_function).forEach(_function_1);
                Functions.Function1<Edge, InternalModelElement> _function_2 = new Functions.Function1<Edge, InternalModelElement>(){

                    public InternalModelElement apply(Edge it) {
                        return it.getInternalElement_();
                    }
                };
                Consumer<InternalModelElement> _function_3 = new Consumer<InternalModelElement>(){

                    @Override
                    public void accept(InternalModelElement it) {
                        DiagramBuilder.this.add(it);
                    }
                };
                IterableExtensions.map(DiagramBuilder.this.getEdges(), (Functions.Function1)_function_2).forEach(_function_3);
                DiagramBuilder.this.update(DiagramBuilder.this.diagram);
            }
        };
        this.diagram.setInitialization(_function);
        this.diagram.setAvoidInitialization(true);
        Runnable _function_1 = new Runnable(){

            @Override
            public void run() {
                resource.getContents().add(0, (Object)DiagramBuilder.this.diagram);
            }
        };
        this._resourceExtension.transact(resource, _function_1);
        this.diagram.setAvoidInitialization(false);
        return this.diagram;
    }

    public void add(InternalModelElement it) {
        boolean _matched = false;
        if (it instanceof InternalEdge) {
            _matched = true;
            this.add(it, (AddContext)this.getAddContext((InternalEdge)it));
        }
        if (!_matched && it instanceof InternalNode) {
            _matched = true;
            this.add(it, this.getAddContext((InternalNode)it, (ContainerShape)this.diagram));
        }
    }

    public void add(final InternalModelElement bo, final AddContext ctx) {
        if (ctx != null) {
            Procedures.Procedure1<CodingExtension.FunctionArgumentsNotSupported> _function = new Procedures.Procedure1<CodingExtension.FunctionArgumentsNotSupported>(){

                public void apply(CodingExtension.FunctionArgumentsNotSupported it) {
                    DiagramBuilder.this.cache((InternalIdentifiableElement)bo, DiagramBuilder.this.addIfPossible(ctx));
                    DiagramBuilder.this.postprocess(bo);
                }
            };
            Procedures.Procedure1<Exception> _function_1 = new Procedures.Procedure1<Exception>(){

                public void apply(Exception it) {
                    boolean _equals;
                    boolean _matched = false;
                    if (it instanceof SWTException && (_equals = "Invalid thread access".equals(((SWTException)((Object)it)).getMessage()))) {
                        _matched = true;
                        DiagramBuilder.this.cache((InternalIdentifiableElement)bo, DiagramBuilder.this.getFeatureProvider().getPictogramElementForBusinessObject((Object)bo));
                        DiagramBuilder.this.postprocess(bo);
                    }
                    if (!_matched) {
                        it.printStackTrace();
                    }
                }
            };
            this._codingExtension.onException((Procedures.Procedure1)_function, (Procedures.Procedure1)_function_1);
        }
    }

    public void postprocess(InternalModelElement bo) {
        final PictogramElement pe = this.getPe((InternalIdentifiableElement)bo);
        if (pe == null) {
            this.warn("Pictogram null. Failed to add " + bo);
        } else {
            boolean _matched = false;
            if (bo instanceof InternalEdge) {
                _matched = true;
                this.addBendpoints((InternalEdge)bo, pe);
                this.updateDecorators((InternalEdge)bo, pe);
            }
            if (!_matched && bo instanceof InternalModelElementContainer) {
                _matched = true;
                Consumer<InternalNode> _function = new Consumer<InternalNode>(){

                    @Override
                    public void accept(InternalNode it) {
                        DiagramBuilder.this.add((InternalModelElement)it, DiagramBuilder.this.getAddContext(it, (ContainerShape)pe));
                    }
                };
                Iterables.filter((Iterable)((InternalModelElementContainer)bo).getModelElements(), InternalNode.class).forEach(_function);
            }
        }
    }

    public void addBendpoints(InternalEdge edge, final PictogramElement pe) {
        EList _bendpoints = edge.getBendpoints();
        Procedures.Procedure2<_Point, Integer> _function = new Procedures.Procedure2<_Point, Integer>(){

            public void apply(_Point point, Integer i) {
                DiagramBuilder.this.add(point, (FreeFormConnection)pe, i);
            }
        };
        IterableExtensions.forEach(new ArrayList(_bendpoints), (Procedures.Procedure2)_function);
    }

    public Object add(_Point p, FreeFormConnection connection, int index) {
        Object _xblockexpression = null;
        int _x = p.getX();
        int _y = p.getY();
        AddBendpointContext ctx = new AddBendpointContext(connection, _x, _y, index);
        _xblockexpression = this.getDiagramTypeProvider().getDiagramBehavior().executeFeature((IFeature)this.getFeatureProvider().getAddBendpointFeature((IAddBendpointContext)ctx), (IContext)ctx);
        return _xblockexpression;
    }

    public void updateDecorators(InternalEdge edge, final PictogramElement pe) {
        Procedures.Procedure2<_Decoration, Integer> _function = new Procedures.Procedure2<_Decoration, Integer>(){

            public void apply(_Decoration dec, Integer i) {
                _Point _locationShift = dec.getLocationShift();
                int _x = 0;
                if (_locationShift != null) {
                    _x = _locationShift.getX();
                }
                _Point _locationShift_1 = dec.getLocationShift();
                int _y = 0;
                if (_locationShift_1 != null) {
                    _y = _locationShift_1.getY();
                }
                Pair _mappedTo = Pair.of((Object)_x, (Object)_y);
                DiagramBuilder.this.updateDecorator((Connection)((FreeFormConnection)pe), i, (Pair<Integer, Integer>)_mappedTo);
            }
        };
        IterableExtensions.forEach((Iterable)edge.getDecorators(), (Procedures.Procedure2)_function);
    }

    public void updateDecorator(final Connection con, final int index, Pair<Integer, Integer> location) {
        Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, GraphicsAlgorithm> _function = new Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, GraphicsAlgorithm>(){

            public GraphicsAlgorithm apply(CodingExtension.FunctionArgumentsNotSupported it) {
                EList _connectionDecorators = con.getConnectionDecorators();
                ConnectionDecorator _get = null;
                if (_connectionDecorators != null) {
                    _get = (ConnectionDecorator)_connectionDecorators.get(index);
                }
                GraphicsAlgorithm _graphicsAlgorithm = null;
                if (_get != null) {
                    _graphicsAlgorithm = _get.getGraphicsAlgorithm();
                }
                return _graphicsAlgorithm;
            }
        };
        GraphicsAlgorithm ga = (GraphicsAlgorithm)this._codingExtension.printException((Functions.Function1)_function);
        if (ga != null && location != null) {
            ga.setX(((Integer)location.getKey()).intValue());
            ga.setY(((Integer)location.getValue()).intValue());
        } else {
            this.warn("Failed to retrieve decorator shape (index=" + Integer.valueOf(index) + ") of " + con);
        }
    }

    public PictogramElement addIfPossible(AddContext ctx) {
        PictogramElement _xblockexpression = null;
        IAddFeature _addFeature = this.getFeatureProvider().getAddFeature((IAddContext)ctx);
        CincoAddFeature ftr = (CincoAddFeature)_addFeature;
        PictogramElement _xifexpression = null;
        if (ftr != null) {
            PictogramElement _xblockexpression_1 = null;
            ftr.setHook(false);
            PictogramElement _xifexpression_1 = null;
            boolean _canAdd = false;
            if (ftr != null) {
                _canAdd = ftr.canAdd((IAddContext)ctx);
            }
            if (_canAdd) {
                Object _executeFeature = this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().executeFeature((IFeature)ftr, (IContext)ctx);
                _xifexpression_1 = (PictogramElement)_executeFeature;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        } else {
            this.warn("Failed to retrieve AddFeature for " + ctx);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public AddContext getAddContext(final InternalNode bo, final ContainerShape target) {
        AreaContext _areaContext = new AreaContext();
        AddContext _addContext = new AddContext((IAreaContext)_areaContext, (Object)bo);
        Procedures.Procedure1<AddContext> _function = new Procedures.Procedure1<AddContext>(){

            public void apply(AddContext it) {
                it.setTargetContainer(target);
                it.setX(bo.getX());
                it.setY(bo.getY());
                it.setWidth(bo.getWidth());
                it.setHeight(bo.getHeight());
            }
        };
        return (AddContext)ObjectExtensions.operator_doubleArrow((Object)_addContext, (Procedures.Procedure1)_function);
    }

    public AddConnectionContext getAddContext(final InternalEdge edge) {
        AddConnectionContext _xblockexpression = null;
        Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Anchor> _function = new Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Anchor>(){

            public Anchor apply(CodingExtension.FunctionArgumentsNotSupported it) {
                Node _sourceElement = edge.getSourceElement();
                return ((CNode)_sourceElement).getAnchor();
            }
        };
        Procedures.Procedure1<Exception> _function_1 = new Procedures.Procedure1<Exception>(){

            public void apply(Exception it) {
                String _name = edge.eClass().getName();
                String _plus = "Failed to retrieve source of edge: " + _name;
                String _plus_1 = String.valueOf(_plus) + " ";
                String _id = edge.getId();
                String _plus_2 = String.valueOf(_plus_1) + _id;
                DiagramBuilder.this.warn(_plus_2);
            }
        };
        Anchor srcAnchor = (Anchor)this._codingExtension.onException((Functions.Function1)_function, (Procedures.Procedure1)_function_1);
        Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Anchor> _function_2 = new Functions.Function1<CodingExtension.FunctionArgumentsNotSupported, Anchor>(){

            public Anchor apply(CodingExtension.FunctionArgumentsNotSupported it) {
                Node _targetElement = edge.getTargetElement();
                return ((CNode)_targetElement).getAnchor();
            }
        };
        Procedures.Procedure1<Exception> _function_3 = new Procedures.Procedure1<Exception>(){

            public void apply(Exception it) {
                it.printStackTrace();
                String _name = edge.eClass().getName();
                String _plus = "Failed to retrieve target of edge: " + _name;
                String _plus_1 = String.valueOf(_plus) + " ";
                String _id = edge.getId();
                String _plus_2 = String.valueOf(_plus_1) + _id;
                DiagramBuilder.this.warn(_plus_2);
            }
        };
        Anchor tgtAnchor = (Anchor)this._codingExtension.onException((Functions.Function1)_function_2, (Procedures.Procedure1)_function_3);
        AddConnectionContext _xifexpression = null;
        if (srcAnchor != null && tgtAnchor != null) {
            AddConnectionContext _addConnectionContext = new AddConnectionContext(srcAnchor, tgtAnchor);
            Procedures.Procedure1<AddConnectionContext> _function_4 = new Procedures.Procedure1<AddConnectionContext>(){

                public void apply(AddConnectionContext it) {
                    it.setNewObject((Object)edge);
                }
            };
            _xifexpression = (AddConnectionContext)ObjectExtensions.operator_doubleArrow((Object)_addConnectionContext, (Procedures.Procedure1)_function_4);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public PictogramElement getPe(InternalIdentifiableElement elm) {
        return this.pes.get(elm);
    }

    public Iterable<Node> getNodes() {
        return Iterables.filter((Iterable)this.model.getModelElements(), Node.class);
    }

    public Iterable<Edge> getEdges() {
        return Iterables.filter((Iterable)this.model.getModelElements(), Edge.class);
    }

    public void linkTo(PictogramElement pe, EObject bo) {
        this.getFeatureProvider().link(pe, (Object)bo);
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider _elvis = null;
        _elvis = this.fp != null ? this.fp : (this.fp = this.getDiagramTypeProvider().getFeatureProvider());
        return _elvis;
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        IDiagramTypeProvider _elvis = null;
        _elvis = this.dtp != null ? this.dtp : (this.dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider((Diagram)this.diagram, this.diagram.getDiagramTypeProviderId()));
        return _elvis;
    }

    public PictogramElement cache(InternalIdentifiableElement bo, PictogramElement pe) {
        return this.pes.put(bo, pe);
    }

    public void clearCache() {
        this.pes.clear();
    }

    public void update(LazyDiagram diagram) {
        UpdateContext ctx = new UpdateContext((PictogramElement)diagram);
        IUpdateFeature feature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)ctx);
        boolean _canUpdate = feature.canUpdate((IUpdateContext)ctx);
        if (_canUpdate) {
            feature.update((IUpdateContext)ctx);
        }
        this.model.updateModelElements();
    }

    public void warn(String msg) {
        String _simpleName = this.getClass().getSimpleName();
        String _plus = "[" + _simpleName;
        String _plus_1 = String.valueOf(_plus) + "] ";
        String _plus_2 = String.valueOf(_plus_1) + msg;
        System.err.println(_plus_2);
    }
}

