/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoCornerHandle;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoDragEditPartsTracker;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoSelectEditPartTracker;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoSurroundingHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.policy.GFResizableEditPolicy;

class CincoResizableEditPolicy
extends GFResizableEditPolicy {
    private IResizeShapeContext context;

    public CincoResizableEditPolicy(IConfigurationProviderInternal cfgProvider) {
        super(cfgProvider);
    }

    public CincoResizableEditPolicy(IConfigurationProviderInternal configurationProvider, IResizeShapeContext resizeShapeContext) {
        super(configurationProvider, resizeShapeContext);
        this.context = resizeShapeContext;
    }

    protected SelectEditPartTracker getSelectTracker() {
        return new CincoSelectEditPartTracker(this.getHost());
    }

    protected DragEditPartsTracker getDragTracker() {
        return new CincoDragEditPartsTracker(this.getHost());
    }

    protected List<?> createSelectionHandles() {
        boolean resizeAllowed = false;
        if (this.context != null) {
            resizeAllowed = this.getResizeShapeFeature() != null && this.getResizeShapeFeature().canResizeShape(this.context);
        }
        GraphicalEditPart owner = (GraphicalEditPart)this.getHost();
        List<AbstractHandle> list = this.createShapeHandles(owner, this.getConfigurationProvider(), this.getResizeDirections(), this.isDragAllowed(), resizeAllowed);
        return list;
    }

    private IResizeShapeFeature getResizeShapeFeature() {
        if (this.context == null) {
            return null;
        }
        return this.getConfigurationProvider().getFeatureProvider().getResizeShapeFeature(this.context);
    }

    private List<AbstractHandle> createShapeHandles(GraphicalEditPart owner, IConfigurationProviderInternal cp, int supportedResizeDirections, boolean movable, boolean resizeAllowed) {
        ArrayList<AbstractHandle> list = new ArrayList<AbstractHandle>();
        IShapeSelectionInfo si = null;
        IToolBehaviorProvider tbp = cp.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        Object model = owner.getModel();
        if (model instanceof Shape) {
            si = tbp.getSelectionInfoForShape((Shape)model);
        } else if (model instanceof Anchor) {
            si = tbp.getSelectionInfoForAnchor((Anchor)model);
        }
        list.add((AbstractHandle)new CincoSurroundingHandle(owner, cp, movable, si));
        if (resizeAllowed) {
            if ((0x11 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 17, supportedResizeDirections, movable, si));
            }
            if ((0x14 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 20, supportedResizeDirections, movable, si));
            }
            if ((0xC & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 12, supportedResizeDirections, movable, si));
            }
            if ((9 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 9, supportedResizeDirections, movable, si));
            }
            if ((1 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 1, supportedResizeDirections, movable, si));
            }
            if ((0x10 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 16, supportedResizeDirections, movable, si));
            }
            if ((4 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 4, supportedResizeDirections, movable, si));
            }
            if ((8 & supportedResizeDirections) != 0) {
                list.add((AbstractHandle)new CincoCornerHandle(owner, cp, 8, supportedResizeDirections, movable, si));
            }
        }
        return list;
    }
}

