/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoBendpointHandle;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoConnectionEndpointHandle;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoShapeContainerAndXYLayoutEditPolicy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Handle;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.tb.IConnectionSelectionInfo;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.policy.ConnectionBendpointEditPolicy;
import org.eclipse.graphiti.ui.internal.policy.ConnectionHighlightEditPolicy;
import org.eclipse.graphiti.ui.internal.policy.DefaultEditPolicyFactory;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFBendpointHandle;

public class CincoEditPolicyFactory
extends DefaultEditPolicyFactory {
    public CincoEditPolicyFactory(IConfigurationProviderInternal configurationProvider) {
        super(configurationProvider);
    }

    public EditPolicy createConnectionBendpointsEditPolicy() {
        return new ConnectionBendpointEditPolicy(this.getConfigurationProvider()){
            private IConnectionSelectionInfo csi;

            public void activate() {
                super.activate();
                Object model = this.getHost().getModel();
                if (model instanceof Connection) {
                    this.csi = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider().getSelectionInfoForConnection((Connection)model);
                }
            }

            protected List<BendpointHandle> createHandlesForAutomaticBendpoints() {
                ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
                ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
                PointList points = this.getConnection().getPoints();
                int i = 0;
                while (i < points.size() - 1) {
                    list.add((BendpointHandle)new GFBendpointHandle(connEP, 0, i, this.getConfigurationProvider(), GFBendpointHandle.Type.CREATE, this.csi));
                    ++i;
                }
                return list;
            }

            protected List<BendpointHandle> createHandlesForUserBendpoints() {
                ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
                ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
                PointList points = this.getConnection().getPoints();
                List bendPoints = this.getConnectionRoutingConstraint();
                int bendPointIndex = 0;
                Point currBendPoint = null;
                if (bendPoints == null) {
                    bendPoints = NULL_CONSTRAINT;
                } else if (!bendPoints.isEmpty()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(0)).getLocation();
                }
                int i = 0;
                while (i < points.size() - 1) {
                    list.add((BendpointHandle)new CincoBendpointHandle(connEP, bendPointIndex, i, this.getConfigurationProvider(), GFBendpointHandle.Type.CREATE, this.csi));
                    if (i < points.size() - 1 && bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                        list.add((BendpointHandle)new CincoBendpointHandle(connEP, bendPointIndex, i + 1, this.getConfigurationProvider(), GFBendpointHandle.Type.MOVE, this.csi));
                        if (++bendPointIndex < bendPoints.size()) {
                            currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                        }
                    }
                    ++i;
                }
                return list;
            }
        };
    }

    public EditPolicy createShapeXYLayoutEditPolicy() {
        return new CincoShapeContainerAndXYLayoutEditPolicy(this.getConfigurationProvider());
    }

    public EditPolicy createConnectionHighlightEditPolicy() {
        return new ConnectionHighlightEditPolicy(this.getConfigurationProvider()){

            protected List<Handle> createSelectionHandles() {
                ArrayList<Handle> list = new ArrayList<Handle>();
                Connection connection = (Connection)this.getHost().getModel();
                ReconnectionContext sourceCtx = new ReconnectionContext(connection, connection.getStart(), null, null);
                ReconnectionContext targetCtx = new ReconnectionContext(connection, connection.getEnd(), null, null);
                IReconnectionFeature sourceReconnectionFeature = this.getConfigurationProvider().getFeatureProvider().getReconnectionFeature((IReconnectionContext)sourceCtx);
                IReconnectionFeature targetReconnectionFeature = this.getConfigurationProvider().getFeatureProvider().getReconnectionFeature((IReconnectionContext)targetCtx);
                if (sourceReconnectionFeature == null || sourceReconnectionFeature.canStartReconnect((IReconnectionContext)sourceCtx)) {
                    list.add((Handle)new CincoConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 2));
                }
                if (targetReconnectionFeature == null || targetReconnectionFeature.canStartReconnect((IReconnectionContext)targetCtx)) {
                    list.add((Handle)new CincoConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 3));
                }
                return list;
            }
        };
    }
}

