/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.editor.GFDragConnectionTool;

public class CincoDragConnectionTool
extends GFDragConnectionTool {
    private DiagramBehavior diagramBehavior;
    private long nextContinue = System.currentTimeMillis();

    public CincoDragConnectionTool(DiagramBehavior diagramBehavior, ContextButtonEntry contextButtonEntry) {
        super(diagramBehavior, contextButtonEntry);
        this.diagramBehavior = diagramBehavior;
    }

    public void continueConnection(EditPart targetEditPart, EditPart targetTargetEditPart) {
        if (System.currentTimeMillis() < this.nextContinue) {
            this.handleDrag();
            return;
        }
        this.setConnectionSource(targetEditPart);
        this.lockTargetEditPart(targetEditPart);
        CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)this.getTargetRequest();
        createConnectionRequest.setSourceEditPart(targetEditPart);
        createConnectionRequest.setTargetEditPart(targetTargetEditPart);
        Command command = this.getCommand();
        if (command != null) {
            this.setCurrentCommand(command);
            if (this.stateTransition(1, 64)) {
                for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
                    ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
                    ccf.startConnecting();
                    ccf.attachedToSource((ICreateConnectionContext)ifac.getContext());
                }
            }
        }
        this.setViewer((EditPartViewer)this.diagramBehavior.getDiagramContainer().getGraphicalViewer());
        this.handleDrag();
        this.unlockTargetEditPart();
        this.nextContinue = System.currentTimeMillis() + 50L;
    }

    private Iterable<IFeatureAndContext> getCreateConnectionFeaturesAndContext() {
        if (this.getTargetRequest() instanceof CreateConnectionRequest) {
            ArrayList<IFeatureAndContext> ret = new ArrayList<IFeatureAndContext>();
            CreateConnectionRequest r = (CreateConnectionRequest)this.getTargetRequest();
            if (r.getStartCommand() instanceof CreateConnectionCommand) {
                CreateConnectionCommand cmd = (CreateConnectionCommand)r.getStartCommand();
                IFeatureAndContext[] iFeatureAndContextArray = cmd.getFeaturesAndContexts();
                int n = iFeatureAndContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeatureAndContext ifac = iFeatureAndContextArray[n2];
                    if (ifac.getFeature() instanceof ICreateConnectionFeature) {
                        ret.add(ifac);
                    }
                    ++n2;
                }
            }
            return ret;
        }
        return Collections.emptyList();
    }
}

