/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoContextButton;
import java.awt.Rectangle;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.internal.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.PositionedContextButton;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonManagerForPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonPad;

public class CincoContextButtonPad
extends ContextButtonPad {
    public CincoContextButtonPad(ContextButtonManagerForPad contextButtonManagerForPad, IContextButtonPadDeclaration declaration, double zoomLevel, DiagramBehavior diagramBehavior, EditPart editPart, IResourceRegistry resourceRegistry) {
        super(contextButtonManagerForPad, declaration, zoomLevel, diagramBehavior, editPart, resourceRegistry);
        this.replaceContextButtons();
    }

    private void replaceContextButtons() {
        this.removeAll();
        List positionedButtons = this.getDeclaration().getPositionedContextButtons();
        String providerId = this.getDiagramBehavior().getDiagramTypeProvider().getProviderId();
        for (PositionedContextButton positionedButton : positionedButtons) {
            org.eclipse.draw2d.geometry.Rectangle position = this.transformGenericRectangle(positionedButton.getPosition(), 0);
            position.translate(-this.getBounds().getTopLeft().x, -this.getBounds().getTopLeft().y);
            CincoContextButton cb = new CincoContextButton(providerId, positionedButton, this);
            this.add((IFigure)cb, position);
        }
    }

    private org.eclipse.draw2d.geometry.Rectangle transformGenericRectangle(Rectangle source, int shrinkLines) {
        if (source == null) {
            return null;
        }
        double zoom = this.getZoomLevel();
        int lw = shrinkLines * (int)((double)this.getDeclaration().getPadLineWidth() * zoom);
        org.eclipse.draw2d.geometry.Rectangle target = new org.eclipse.draw2d.geometry.Rectangle(source.x, source.y, source.width, source.height);
        target.scale(zoom);
        int widthShrink = Math.min(target.width / 2, lw);
        int heightShrink = Math.min(target.height / 2, lw);
        target.shrink(widthShrink, heightShrink);
        return target;
    }
}

