/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.editor.CincoContextButtonPad;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.tools.AbstractConnectionCreationTool;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.internal.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.SpecialContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.StandardContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonManagerForPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonPad;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.swt.SWT;

public class CincoContextButtonManagerForPad
extends ContextButtonManagerForPad {
    private IFigure activeFigure;
    private ContextButtonPad activeContextButtonPad;
    private boolean contextButtonShowing;
    private IResourceRegistry resourceRegistry;
    private Map<IFigure, EditPart> figure2EditPart = new HashMap<IFigure, EditPart>();
    private MouseMotionListener mouseMotionListener = new MouseMotionListener.Stub(){

        public void mouseEntered(MouseEvent me) {
            this.reactOnMouse(me);
        }

        public void mouseMoved(MouseEvent me) {
            this.reactOnMouse(me);
        }

        private void reactOnMouse(MouseEvent me) {
            DiagramBehavior diagramBehavior = CincoContextButtonManagerForPad.this.getDiagramBehavior();
            if (diagramBehavior.isDirectEditingActive()) {
                return;
            }
            Tool activeTool = diagramBehavior.getEditDomain().getActiveTool();
            if (activeTool instanceof CreationTool || activeTool instanceof AbstractConnectionCreationTool) {
                return;
            }
            if ((me.getState() & SWT.MOD1) != 0) {
                CincoContextButtonManagerForPad.this.hideContextButtonsInstantly();
                return;
            }
            if (!CincoContextButtonManagerForPad.this.contextButtonShowing) {
                return;
            }
            Object source = me.getSource();
            CincoContextButtonManagerForPad.this.showContextButtonsInstantly((IFigure)source, me.getLocation());
        }
    };

    public CincoContextButtonManagerForPad(DiagramBehavior diagramBehavior, IResourceRegistry resourceRegistry) {
        super(diagramBehavior, resourceRegistry);
        this.resourceRegistry = resourceRegistry;
        this.contextButtonShowing = true;
    }

    public void register(GraphicalEditPart graphicalEditPart) {
        this.figure2EditPart.put(graphicalEditPart.getFigure(), (EditPart)graphicalEditPart);
        graphicalEditPart.getFigure().addMouseMotionListener(this.mouseMotionListener);
    }

    public void deRegister(GraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart.getFigure().equals(this.activeFigure)) {
            this.hideContextButtonsInstantly();
        }
        this.figure2EditPart.remove(graphicalEditPart.getFigure());
        graphicalEditPart.getFigure().removeMouseMotionListener(this.mouseMotionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showContextButtonsInstantly(IFigure figure, Point mouse) {
        if (!this.replaceContextButtonPad(figure, mouse)) {
            return;
        }
        CincoContextButtonManagerForPad cincoContextButtonManagerForPad = this;
        synchronized (cincoContextButtonManagerForPad) {
            this.hideContextButtonsInstantly();
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getDiagramBehavior().getDiagramContainer().getGraphicalViewer().getRootEditPart();
            double zoom = rootEditPart.getZoomManager().getZoom();
            if (zoom < 0.75) {
                return;
            }
            IPictogramElementEditPart editPart = (IPictogramElementEditPart)this.figure2EditPart.get(figure);
            PictogramElement pe = editPart.getPictogramElement();
            if (pe instanceof Diagram) {
                return;
            }
            if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)pe)) {
                return;
            }
            PictogramElementContext context = new PictogramElementContext(pe);
            IToolBehaviorProvider toolBehaviorProvider = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            IContextButtonPadData contextButtonPadData = toolBehaviorProvider.getContextButtonPad((IPictogramElementContext)context);
            if (contextButtonPadData == null) {
                return;
            }
            if (contextButtonPadData.getDomainSpecificContextButtons().size() == 0 && contextButtonPadData.getGenericContextButtons().size() == 0 && contextButtonPadData.getCollapseContextButton() == null) {
                return;
            }
            if (!contextButtonPadData.getPadLocation().contains(mouse.x, mouse.y)) {
                return;
            }
            int declarationType = GFPreferences.getInstance().getContextButtonPadDeclaration();
            Object declaration = declarationType == 1 ? new SpecialContextButtonPadDeclaration(contextButtonPadData) : new StandardContextButtonPadDeclaration(contextButtonPadData);
            EditPart activeEditPart = this.figure2EditPart.get(figure);
            CincoContextButtonPad contextButtonPad = new CincoContextButtonPad(this, (IContextButtonPadDeclaration)declaration, zoom, this.getDiagramBehavior(), activeEditPart, this.resourceRegistry);
            this.activeFigure = figure;
            this.activeContextButtonPad = contextButtonPad;
            IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
            feedbackLayer.add((IFigure)contextButtonPad);
        }
    }

    private boolean replaceContextButtonPad(IFigure figure, Point mouseLocation) {
        if (this.activeFigure == null) {
            return true;
        }
        if (figure.equals(this.activeFigure)) {
            return false;
        }
        IFigure parent = figure.getParent();
        while (parent != null) {
            if (parent.equals(this.activeFigure)) {
                return true;
            }
            parent = parent.getParent();
        }
        if (this.activeFigure.containsPoint(mouseLocation)) {
            return true;
        }
        return this.activeContextButtonPad == null || !this.activeContextButtonPad.isMouseInOverlappingArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideContextButtonsInstantly() {
        if (this.activeContextButtonPad != null) {
            CincoContextButtonManagerForPad cincoContextButtonManagerForPad = this;
            synchronized (cincoContextButtonManagerForPad) {
                ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getDiagramBehavior().getDiagramContainer().getGraphicalViewer().getRootEditPart();
                IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
                feedbackLayer.remove((IFigure)this.activeContextButtonPad);
                this.activeFigure = null;
                this.activeContextButtonPad = null;
            }
        }
    }

    public void setContextButtonShowing(boolean enable) {
        super.setContextButtonShowing(enable);
        this.contextButtonShowing = enable;
    }
}

