/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.editor;

import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.tools.ConnectionBendpointTracker;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.MoveBendpointContext;
import org.eclipse.graphiti.features.context.impl.RemoveBendpointContext;
import org.eclipse.graphiti.tb.IConnectionSelectionInfo;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFBendpointHandle;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFCornerHandle;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFSurroundingHandle;
import org.eclipse.swt.events.MouseEvent;

class CincoBendpointHandle
extends GFBendpointHandle {
    private String dragTrackerType;
    GFCornerHandle h1;
    GFSurroundingHandle h2;

    public CincoBendpointHandle(ConnectionEditPart owner, int index, int locatorIndex, IConfigurationProviderInternal configurationProvider, GFBendpointHandle.Type type, IConnectionSelectionInfo connectionSelectionInfo) {
        super(owner, index, locatorIndex, configurationProvider, type, connectionSelectionInfo);
        if (GFBendpointHandle.Type.CREATE.equals((Object)type)) {
            this.dragTrackerType = "create bendpoint";
        } else if (GFBendpointHandle.Type.MOVE.equals((Object)type)) {
            this.dragTrackerType = "move bendpoint";
        }
    }

    protected DragTracker createDragTracker() {
        ConnectionBendpointTracker tracker = null;
        if (this.dragTrackerType != null && (this.dragTrackerType.equals("move bendpoint") && this.checkMoveBendpointFeature() || this.dragTrackerType.equals("create bendpoint") && this.checkRemoveBendpointFeature())) {
            tracker = new ConnectionBendpointTracker((ConnectionEditPart)this.getOwner(), this.getIndex()){

                public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
                    if (!this.isViewerImportant(viewer)) {
                        return;
                    }
                    this.setViewer(viewer);
                    boolean wasDragging = this.movedPastThreshold();
                    this.getCurrentInput().setInput(me);
                    this.handleDrag();
                    if (this.movedPastThreshold()) {
                        if (!wasDragging || !this.isInState(36)) {
                            this.handleDragStarted();
                        }
                        this.handleDragInProgress();
                    }
                }
            };
            tracker.setType((Object)this.dragTrackerType);
            tracker.setDefaultCursor(this.getCursor());
        }
        return tracker;
    }

    private boolean checkMoveBendpointFeature() {
        boolean ret = false;
        IFeatureProvider fp = this.getConfigurationProvider().getFeatureProvider();
        ret = fp.getMoveBendpointFeature((IMoveBendpointContext)new MoveBendpointContext(null)) != null;
        return ret;
    }

    private boolean checkRemoveBendpointFeature() {
        boolean ret = false;
        IFeatureProvider fp = this.getConfigurationProvider().getFeatureProvider();
        ret = fp.getRemoveBendpointFeature((IRemoveBendpointContext)new RemoveBendpointContext(null, null)) != null;
        return ret;
    }
}

