/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.ge.style.generator.runtime.addfeature;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.provider.CincoFeatureProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class LibraryComponentAddFeature
extends AbstractAddShapeFeature {
    private IAddFeature selectedFeature;
    Listener selectionListener = new Listener(){

        public void handleEvent(Event event) {
            Object data = event.widget.getData();
            if (data instanceof IAddFeature) {
                LibraryComponentAddFeature.this.selectedFeature = (IAddFeature)data;
            }
        }
    };

    public LibraryComponentAddFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return this.possibleFeatureExists(context);
    }

    public PictogramElement add(IAddContext context) {
        IAddFeature iAddFeature;
        List<IAddFeature> features = this.getPossibleFeatures(context);
        Point pos = Display.getCurrent().getCursorLocation();
        if (features.size() == 1 && (iAddFeature = features.get(0)).canAdd(context)) {
            return iAddFeature.add(context);
        }
        Shell shell = new Shell(Display.getCurrent().getActiveShell());
        Menu menu = new Menu((Decorations)shell, 8);
        MenuItem item = null;
        for (IAddFeature af : features) {
            item = new MenuItem(menu, 8);
            item.setText(this.generateDisplayName(af));
            item.setData((Object)af);
            item.addListener(13, this.selectionListener);
        }
        menu.setLocation(pos.x, pos.y);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        menu.dispose();
        shell.dispose();
        if (this.selectedFeature instanceof IAddFeature && this.selectedFeature.canAdd(context)) {
            return this.selectedFeature.add(context);
        }
        return null;
    }

    private String generateDisplayName(IAddFeature af) {
        String simpleName = af.getClass().getSimpleName();
        simpleName = simpleName.replaceFirst("Add", "").replace("Feature", "").replaceFirst("Prime", "");
        return simpleName;
    }

    private boolean possibleFeatureExists(IAddContext context) {
        IAddFeature[] iAddFeatureArray = ((CincoFeatureProvider)this.getFeatureProvider()).getAllLibComponentAddFeatures();
        int n = iAddFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAddFeature f = iAddFeatureArray[n2];
            if (f.canAdd(context)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<IAddFeature> getPossibleFeatures(IAddContext context) {
        ArrayList<IAddFeature> features = new ArrayList<IAddFeature>();
        IAddFeature[] iAddFeatureArray = ((CincoFeatureProvider)this.getFeatureProvider()).getAllLibComponentAddFeatures();
        int n = iAddFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAddFeature f = iAddFeatureArray[n2];
            if (f.canAdd(context)) {
                features.add(f);
            }
            ++n2;
        }
        return features;
    }
}

