/*
 * Decompiled with CFR 0.152.
 */
package info.scce.dime.gUIPlugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveType implements Enumerator
{
    TEXT(0, "Text", "text"),
    INTEGER(1, "Integer", "integer"),
    REAL(2, "Real", "real"),
    BOOLEAN(3, "Boolean", "boolean"),
    TIMESTAMP(4, "Timestamp", "timestamp");

    public static final int TEXT_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int REAL_VALUE = 2;
    public static final int BOOLEAN_VALUE = 3;
    public static final int TIMESTAMP_VALUE = 4;
    private static final PrimitiveType[] VALUES_ARRAY;
    public static final List<PrimitiveType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveType[]{TEXT, INTEGER, REAL, BOOLEAN, TIMESTAMP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveType get(int value) {
        switch (value) {
            case 0: {
                return TEXT;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return REAL;
            }
            case 3: {
                return BOOLEAN;
            }
            case 4: {
                return TIMESTAMP;
            }
        }
        return null;
    }

    private PrimitiveType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

