/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.xtext;

import de.jabc.cinco.meta.core.utils.xtext.MyWizard;
import de.jabc.cinco.meta.runtime.action.CincoCustomAction;
import de.jabc.cinco.meta.runtime.action.CincoDoubleClickAction;
import de.jabc.cinco.meta.runtime.action.CincoPostAttributeChangeHook;
import de.jabc.cinco.meta.runtime.hook.CincoPostCreateHook;
import de.jabc.cinco.meta.runtime.hook.CincoPostMoveHook;
import de.jabc.cinco.meta.runtime.hook.CincoPostResizeHook;
import de.jabc.cinco.meta.runtime.hook.CincoPostSelectHook;
import de.jabc.cinco.meta.runtime.hook.CincoPreDeleteHook;
import de.jabc.cinco.meta.runtime.provider.CincoValuesProvider;
import mgl.Annotation;
import mgl.ModelElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class PerformWizard {
    private String classPath = "";
    private ModelElement model;

    public PerformWizard(Annotation annot) {
        this.model = (ModelElement)annot.getParent();
        String name = annot.getName();
        String superClassName = this.chooseSuperclass(name);
        String value = (String)annot.getValue().get(0);
        String className = this.getClassName(value);
        String packageName = this.getPackageName(value);
        this.execute(this.model, superClassName, className, packageName);
    }

    public void execute(ModelElement modelElement, String superclass, String className, String packageName) {
        URI uri = modelElement.eResource().getURI();
        String[] segments = uri.segments();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        String path = this.search(segments, projects);
        IJavaProject project = JavaCore.create((IProject)root.getProject(path));
        MyWizard wizard = new MyWizard(project, superclass, className, packageName);
        this.createPath(wizard, path);
    }

    private String search(String[] segments, IProject[] projects) {
        int i = 0;
        while (i < segments.length) {
            int j = 0;
            while (j < projects.length) {
                String seg = segments[i];
                String[] pro = projects[j].toString().split("/");
                if (seg.equals(pro[1])) {
                    return seg;
                }
                ++j;
            }
            ++i;
        }
        return "";
    }

    public String chooseSuperclass(String name) {
        String superclass = "";
        if (name.equals("doubleClickAction")) {
            superclass = CincoDoubleClickAction.class.getName();
        } else if (name.equals("postCreate")) {
            superclass = CincoPostCreateHook.class.getName();
        } else if (name.equals("postMove")) {
            superclass = CincoPostMoveHook.class.getName();
        } else if (name.equals("postResize")) {
            superclass = CincoPostResizeHook.class.getName();
        } else if (name.equals("postSelect")) {
            superclass = CincoPostSelectHook.class.getName();
        } else if (name.equals("postAttributeValueChange")) {
            superclass = CincoPostAttributeChangeHook.class.getName();
        } else if (name.equals("preDelete")) {
            superclass = CincoPreDeleteHook.class.getName();
        } else if (name.equals("possibleValueProvider")) {
            superclass = CincoValuesProvider.class.getName();
        } else if (name.equals("contextMenuAction")) {
            superclass = CincoCustomAction.class.getName();
        }
        return superclass;
    }

    private String getClassName(String name) {
        if (name == null) {
            return "";
        }
        String className = "";
        className = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name;
        return className;
    }

    private String getPackageName(String name) {
        String packageName = "";
        if (name == null) {
            return packageName;
        }
        if (name.contains(".")) {
            String withoutClassName;
            packageName = withoutClassName = name.substring(0, name.lastIndexOf("."));
        }
        return packageName;
    }

    private void createPath(MyWizard wizard, String path) {
        this.classPath = wizard.getPath();
    }

    public String getPath() {
        return this.classPath;
    }
}

