/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.xtext;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class MyWizard
extends Wizard
implements INewWizard {
    private NewClassWizardPage page = new NewClassWizardPage();
    private String path;

    public MyWizard(IJavaProject project, String superClass, String className, String packageName) {
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setOpenEditorOnFinish(false);
        action.setConfiguredWizardPage(this.page);
        this.setPackage(project);
        this.page.setSuperClass(superClass, true);
        this.page.setMethodStubSelection(false, true, true, true);
        this.page.setTypeName(className, true);
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject());
        IPackageFragment packageFragment = root.getPackageFragment(packageName);
        this.page.setPackageFragment(packageFragment, true);
        action.run();
        if (action.getCreatedElement() != null) {
            String name = action.getCreatedElement().getElementName();
            IPath ipath = action.getCreatedElement().getPath();
            this.setPath(ipath, name);
        }
    }

    private void setPackage(IJavaProject project) {
        try {
            IClasspathEntry[] rawEntries = project.getRawClasspath();
            IClasspathEntry entry = this.search(rawEntries, "src");
            if (entry != null) {
                IPackageFragmentRoot currentRoot = project.findPackageFragmentRoot(entry.getPath());
                this.page.setPackageFragmentRoot(currentRoot, true);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private IClasspathEntry search(IClasspathEntry[] entry, String str) {
        int i = 0;
        while (i < entry.length) {
            String en = entry[i].toString();
            String[] split = en.split("/");
            int j = 0;
            while (j < split.length) {
                String s = split[j];
                if (s.contains("[")) {
                    String[] folder = s.split("\\[");
                    int k = 0;
                    while (k < folder.length) {
                        String f = folder[k];
                        if (f.equals(str)) {
                            return entry[i];
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void setPath(IPath ipath, String name) {
        String re = "";
        String p = ipath.toString();
        String[] split = p.split("/");
        re = split[3];
        int i = 4;
        while (i < split.length - 1) {
            re = String.valueOf(re) + "." + split[i];
            ++i;
        }
        this.path = re = String.valueOf(re) + "." + name;
    }

    public String getPath() {
        return this.path;
    }

    public void addPages() {
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        return true;
    }
}

