/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.xtext;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;

public class ChooseFolderApplier
extends ReplacementTextApplier {
    private EObject eObject;
    private boolean onlyWorkspaceFiles;

    public ChooseFolderApplier(EObject eo) {
        this.eObject = eo;
        this.onlyWorkspaceFiles = true;
    }

    public ChooseFolderApplier(EObject eo, boolean onlyWorkspaceFiles) {
        this.eObject = eo;
        this.onlyWorkspaceFiles = onlyWorkspaceFiles;
    }

    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
        String filePath;
        DirectoryDialog dialog = new DirectoryDialog(new Shell());
        Path projectPath = null;
        dialog.setText("Choose a folder...");
        if (this.eObject != null) {
            URI resURI = this.eObject.eResource().getURI();
            IResource iRes = ResourcesPlugin.getWorkspace().getRoot().findMember(resURI.toPlatformString(true));
            IProject p = iRes.getProject();
            projectPath = new Path(p.getName());
            dialog.setFilterPath(p.getLocation().toOSString());
        }
        if ((filePath = dialog.open()) == null) {
            return "";
        }
        Path iFilePath = new Path(filePath);
        if (!this.onlyWorkspaceFiles) {
            return "\"" + filePath + "\"";
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf((IPath)iFilePath)) {
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid file", (String)"Unable to process the selected file", (IStatus)new Status(4, filePath, "The file you selected is not contained in your workspace. Please choose another file..."));
            return "";
        }
        File iconFile = new File(filePath);
        if (iconFile.exists()) {
            Path iRelativePath = new Path(filePath);
            if (projectPath.isPrefixOf((IPath)(iRelativePath = iRelativePath.makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation())))) {
                iRelativePath = iRelativePath.makeRelativeTo((IPath)projectPath);
                filePath = iRelativePath.toOSString();
            } else {
                filePath = "platform:/resource/" + iRelativePath.toOSString();
            }
        }
        return "\"" + filePath + "\"";
    }
}

