/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.xtext;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ReplacementTextApplier;

public class ChooseFileTextApplier
extends ReplacementTextApplier {
    private EObject eObject;
    private String[] fileExtensions;
    private String[] fileNames;
    private boolean onlyWorkspaceFiles;

    public ChooseFileTextApplier(EObject eo) {
        this.eObject = eo;
        this.fileExtensions = null;
        this.fileNames = null;
        this.onlyWorkspaceFiles = true;
    }

    public ChooseFileTextApplier(EObject eo, String[] fileExtensions, String[] fileNames, boolean onlyWorkspaceFiles) {
        this.eObject = eo;
        this.fileExtensions = fileExtensions;
        this.fileNames = fileNames;
        this.onlyWorkspaceFiles = onlyWorkspaceFiles;
    }

    public String getActualReplacementString(ConfigurableCompletionProposal proposal) {
        String filePath;
        FileDialog dialog = new FileDialog(new Shell());
        if (this.fileExtensions != null && this.fileNames != null) {
            dialog.setFilterExtensions(this.fileExtensions);
            dialog.setFilterNames(this.fileNames);
        }
        Path projectPath = null;
        dialog.setText("Choose an image file...");
        if (this.eObject != null) {
            URI resURI = this.eObject.eResource().getURI();
            IResource iRes = ResourcesPlugin.getWorkspace().getRoot().findMember(resURI.toPlatformString(true));
            IProject p = iRes.getProject();
            projectPath = new Path(p.getName());
            dialog.setFilterPath(p.getLocation().toOSString());
        }
        if ((filePath = dialog.open()) == null) {
            return "";
        }
        Path iFilePath = new Path(filePath);
        if (!this.onlyWorkspaceFiles) {
            return "\"" + filePath + "\"";
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf((IPath)iFilePath)) {
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid file", (String)"Unable to process the selected file", (IStatus)new Status(4, filePath, "The file you selected is not contained in your workspace. Please choose another file..."));
            return "";
        }
        File iconFile = new File(filePath);
        if (iconFile.exists()) {
            Path iRelativePath = new Path(filePath);
            if (projectPath.isPrefixOf((IPath)(iRelativePath = iRelativePath.makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation())))) {
                iRelativePath = iRelativePath.makeRelativeTo((IPath)projectPath);
                filePath = iRelativePath.toOSString();
            } else {
                filePath = "platform:/resource/" + iRelativePath.toOSString();
            }
        }
        return "\"" + filePath + "\"";
    }
}

