/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.xapi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.core.utils.registry.NonEmptyRegistry;
import de.jabc.cinco.meta.util.xapi.CollectionExtension;
import de.jabc.cinco.meta.util.xapi.FileExtension;
import de.jabc.cinco.meta.util.xapi.ResourceExtension;
import de.jabc.cinco.meta.util.xapi.WorkspaceExtension;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.ComplexAttribute;
import mgl.ContainingElement;
import mgl.EDataTypeType;
import mgl.Edge;
import mgl.Enumeration;
import mgl.GraphModel;
import mgl.GraphicalElementContainment;
import mgl.GraphicalModelElement;
import mgl.Import;
import mgl.IncomingEdgeElementConnection;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.OutgoingEdgeElementConnection;
import mgl.PrimitiveAttribute;
import mgl.ReferencedEClass;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import mgl.Type;
import mgl.UserDefinedType;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GraphModelExtension {
    @Extension
    private CollectionExtension _collectionExtension = new CollectionExtension();
    @Extension
    private WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    @Extension
    private FileExtension _fileExtension = new FileExtension();
    @Extension
    private ResourceExtension _resourceExtension = new ResourceExtension();
    private GeneratorUtils generatorUtils = GeneratorUtils.getInstance();
    public final GenerationContext generationContext = new GenerationContext();
    private final NonEmptyRegistry<ContainingElement, Iterable<? extends ModelElement>> _containables = new NonEmptyRegistry<ContainingElement, Iterable<? extends ModelElement>>(new Function<ContainingElement, Iterable<? extends ModelElement>>(){

        @Override
        public Iterable<? extends ModelElement> apply(ContainingElement it) {
            Set _xblockexpression = null;
            Set<? extends ModelElement> types = GraphModelExtension.this.getContainmentRestrictions((EObject)it);
            Set _xifexpression = null;
            boolean _isEmpty = types.isEmpty();
            if (_isEmpty) {
                Set _switchResult = null;
                boolean _matched = false;
                if (it instanceof GraphModel) {
                    _matched = true;
                    _switchResult = MGLUtil.getMglModel((ModelElement)it).getNodes();
                }
                if (!_matched && it instanceof NodeContainer) {
                    _matched = true;
                    _switchResult = MGLUtil.getMglModel((ModelElement)it).getNodes();
                }
                _xifexpression = _switchResult;
            } else {
                Functions.Function1<ModelElement, Iterable<ModelElement>> _function = new Functions.Function1<ModelElement, Iterable<ModelElement>>(){

                    public Iterable<ModelElement> apply(ModelElement it) {
                        Set<ModelElement> _subTypes = GraphModelExtension.this.getSubTypes(it);
                        return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{it})), _subTypes);
                    }
                };
                _xifexpression = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(types, (Functions.Function1)_function)));
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
    });
    private final NonEmptyRegistry<ModelElement, Set<ModelElement>> _subTypes = new NonEmptyRegistry<ModelElement, Set<ModelElement>>(new Function<ModelElement, Set<ModelElement>>(){

        @Override
        public Set<ModelElement> apply(final ModelElement elm) {
            Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                public Boolean apply(ModelElement it) {
                    Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                        public Boolean apply(ModelElement it) {
                            return it == elm;
                        }
                    };
                    return IterableExtensions.exists(GraphModelExtension.this.getSuperTypes((Type)it), (Functions.Function1)_function);
                }
            };
            return IterableExtensions.toSet((Iterable)IterableExtensions.filter(MGLUtil.modelElements(GraphModelExtension.this.getGraphModel((Annotatable)elm)), (Functions.Function1)_function));
        }
    });
    private final NonEmptyRegistry<ModelElement, Iterable<ModelElement>> _superTypes = new NonEmptyRegistry<ModelElement, Iterable<ModelElement>>(new Function<ModelElement, Iterable<ModelElement>>(){

        @Override
        public Iterable<ModelElement> apply(ModelElement elm) {
            List<ModelElement> _xblockexpression = null;
            ModelElement superType = GraphModelExtension.this.getSuperType((Type)elm);
            Iterable<Object> _xifexpression = null;
            if (superType == null) {
                _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
            } else {
                Iterable<? extends ModelElement> _superTypes_1 = GraphModelExtension.this.getSuperTypes((Type)superType);
                _xifexpression = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ModelElement[]{superType})), _superTypes_1);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
    });
    private final NonEmptyRegistry<ModelElement, Iterable<Attribute>> _allAttributes = new NonEmptyRegistry<ModelElement, Iterable<Attribute>>(new Function<ModelElement, Iterable<Attribute>>(){

        @Override
        public Iterable<Attribute> apply(ModelElement it) {
            Iterable<Object> _elvis = null;
            ModelElement _superType = GraphModelExtension.this.getSuperType((Type)it);
            Iterable<Attribute> _allAttributes_1 = null;
            if (_superType != null) {
                _allAttributes_1 = GraphModelExtension.this.getAllAttributes(_superType);
            }
            _elvis = _allAttributes_1 != null ? _allAttributes_1 : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            EList _attributes = it.getAttributes();
            return Iterables.concat(_elvis, (Iterable)_attributes);
        }
    });
    private final NonEmptyRegistry<Node, Set<Edge>> _incomingEdges = new NonEmptyRegistry<Node, Set<Edge>>(new Function<Node, Set<Edge>>(){

        @Override
        public Set<Edge> apply(Node node) {
            Functions.Function1<IncomingEdgeElementConnection, EList<Edge>> _function = new Functions.Function1<IncomingEdgeElementConnection, EList<Edge>>(){

                public EList<Edge> apply(IncomingEdgeElementConnection it) {
                    return it.getConnectingEdges();
                }
            };
            Functions.Function1<Edge, Iterable<Edge>> _function_1 = new Functions.Function1<Edge, Iterable<Edge>>(){

                public Iterable<Edge> apply(Edge it) {
                    Set<Edge> _subTypes = GraphModelExtension.this.getSubTypes(it);
                    return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{it})), _subTypes);
                }
            };
            return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)node.getIncomingEdgeConnections(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
    });
    private final NonEmptyRegistry<Node, Set<Edge>> _outgoingEdges = new NonEmptyRegistry<Node, Set<Edge>>(new Function<Node, Set<Edge>>(){

        @Override
        public Set<Edge> apply(Node node) {
            Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>> _function = new Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>>(){

                public EList<Edge> apply(OutgoingEdgeElementConnection it) {
                    return it.getConnectingEdges();
                }
            };
            Functions.Function1<Edge, Iterable<Edge>> _function_1 = new Functions.Function1<Edge, Iterable<Edge>>(){

                public Iterable<Edge> apply(Edge it) {
                    Set<Edge> _subTypes = GraphModelExtension.this.getSubTypes(it);
                    return Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Edge[]{it})), _subTypes);
                }
            };
            return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)node.getOutgoingEdgeConnections(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
    });
    private final NonEmptyRegistry<Edge, Iterable<Node>> _sourceNodes = new NonEmptyRegistry<Edge, Iterable<Node>>(new Function<Edge, Iterable<Node>>(){

        @Override
        public Iterable<Node> apply(final Edge edge) {
            Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                        public Boolean apply(Edge it) {
                            return Objects.equal((Object)it, (Object)edge);
                        }
                    };
                    return IterableExtensions.exists(GraphModelExtension.this.getOutgoingEdges(it), (Functions.Function1)_function);
                }
            };
            return IterableExtensions.filter((Iterable)MGLUtil.getMglModel((ModelElement)edge).getNodes(), (Functions.Function1)_function);
        }
    });
    private final NonEmptyRegistry<Edge, Iterable<Node>> _targetNodes = new NonEmptyRegistry<Edge, Iterable<Node>>(new Function<Edge, Iterable<Node>>(){

        @Override
        public Iterable<Node> apply(final Edge edge) {
            Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                        public Boolean apply(Edge it) {
                            return Objects.equal((Object)it, (Object)edge);
                        }
                    };
                    return IterableExtensions.exists(GraphModelExtension.this.getIncomingEdges(it), (Functions.Function1)_function);
                }
            };
            return IterableExtensions.filter((Iterable)MGLUtil.getMglModel((ModelElement)edge).getNodes(), (Functions.Function1)_function);
        }
    });
    private final NonEmptyRegistry<Object, String> _beanPackage = new NonEmptyRegistry<Object, String>(new Function<Object, String>(){

        @Override
        public String apply(Object it) {
            String _lowerCase;
            String _package;
            StringConcatenation _builder;
            String _switchResult = null;
            boolean _matched = false;
            if (it instanceof GraphModel) {
                _matched = true;
                _builder = new StringConcatenation();
                _package = MGLUtil.getMglModel((ModelElement)it).getPackage();
                _builder.append(_package);
                _builder.append(".");
                _lowerCase = ((GraphModel)it).getName().toLowerCase();
                _builder.append(_lowerCase);
                _switchResult = _builder.toString();
            }
            if (!_matched && it instanceof MGLModel) {
                _matched = true;
                _builder = new StringConcatenation();
                _package = MGLUtil.mglModel(it).getPackage();
                _builder.append(_package);
                _switchResult = _builder.toString();
            }
            if (!_matched) {
                _builder = new StringConcatenation();
                _package = MGLUtil.mglModel(it).getPackage();
                _builder.append(_package);
                _builder.append(".");
                _lowerCase = GraphModelExtension.this._workspaceExtension.getFile((EObject)MGLUtil.mglModel(it)).getName().toLowerCase();
                _builder.append(_lowerCase);
                _switchResult = _builder.toString();
            }
            return _switchResult;
        }
    });
    private final NonEmptyRegistry<Type, String> _internalBeanPackage = new NonEmptyRegistry<Type, String>(new Function<Type, String>(){

        @Override
        public String apply(Type it) {
            String _switchResult = null;
            boolean _matched = false;
            if (it instanceof GraphModel) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                String _package = MGLUtil.getMglModel((ModelElement)it).getPackage();
                _builder.append(_package);
                _builder.append(".");
                String _lowerCase = GraphModelExtension.this.generatorUtils.getFileName(MGLUtil.getMglModel((ModelElement)it)).toLowerCase();
                _builder.append(_lowerCase);
                _builder.append(".internal");
                _switchResult = _builder.toString();
            }
            if (!_matched) {
                _switchResult = GraphModelExtension.this.getInternalBeanPackage((Type)GraphModelExtension.this.getGraphModel((Annotatable)it));
            }
            return _switchResult;
        }
    });

    public String getProjectName(GraphModel it) {
        return this._workspaceExtension.getIResource((EObject)it).getProject().getName();
    }

    public String getProjectName(MGLModel it) {
        return this._workspaceExtension.getIResource((EObject)it).getProject().getName();
    }

    public String getProjectSymbolicName(MGLModel model) {
        block6: {
            BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
            ServiceReference serviceRef = bundleContext.getServiceReference(IBundleProjectService.class.getName());
            Object _service = bundleContext.getService(serviceRef);
            IBundleProjectService service = (IBundleProjectService)_service;
            try {
                String string = service.getDescription(this._workspaceExtension.getIResource((EObject)model).getProject()).getSymbolicName();
                return string;
            }
            catch (Throwable _t) {
                if (_t instanceof CoreException) {
                    CoreException e = (CoreException)_t;
                    e.printStackTrace();
                    break block6;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                bundleContext.ungetService(serviceRef);
            }
        }
        return "";
    }

    public Iterable<GenModel> getImportedGenModels(MGLModel model) {
        Functions.Function1<Import, Boolean> _function = new Functions.Function1<Import, Boolean>(){

            public Boolean apply(Import it) {
                return it.getImportURI().endsWith(".ecore");
            }
        };
        Functions.Function1<Import, GenModel> _function_1 = new Functions.Function1<Import, GenModel>(){

            public GenModel apply(Import it) {
                return GraphModelExtension.this.getGenModel(it);
            }
        };
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)MGLUtil.mglModel(model).getImports(), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public Iterable<GraphModel> getImportedGraphModels(MGLModel model) {
        Functions.Function1<Import, Boolean> _function = new Functions.Function1<Import, Boolean>(){

            public Boolean apply(Import it) {
                return it.getImportURI().endsWith(".mgl");
            }
        };
        Functions.Function1<Import, Set<GraphModel>> _function_1 = new Functions.Function1<Import, Set<GraphModel>>(){

            public Set<GraphModel> apply(Import it) {
                return GraphModelExtension.this.getImportedGraphModelsOfImport(it);
            }
        };
        return Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)MGLUtil.mglModel(model).getImports(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public boolean canContain(ContainingElement elm, final ModelElement element) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                return Objects.equal((Object)it, (Object)element);
            }
        };
        return IterableExtensions.exists(this.getContainables(elm), (Functions.Function1)_function);
    }

    public Iterable<Node> getContainableNodes(ContainingElement cont) {
        return Iterables.filter(this.getContainables(cont), Node.class);
    }

    public Iterable<NodeContainer> getContainableNodeContainers(ContainingElement cont) {
        return Iterables.filter(this.getContainables(cont), NodeContainer.class);
    }

    public Iterable<Node> getContainableNonContainerNodes(ContainingElement cont) {
        return this._collectionExtension.drop(this.getContainableNodes(cont), NodeContainer.class);
    }

    public Iterable<NodeContainer> getContainingContainers(Node cont) {
        return this.getContainingContainers((GraphicalModelElement)cont, MGLUtil.getMglModel((ModelElement)cont));
    }

    public Iterable<NodeContainer> getContainingContainers(final GraphicalModelElement cont, MGLModel it) {
        Functions.Function1<NodeContainer, Boolean> _function = new Functions.Function1<NodeContainer, Boolean>(){

            public Boolean apply(NodeContainer it) {
                return GraphModelExtension.this.canContain((ContainingElement)it, (ModelElement)cont);
            }
        };
        return IterableExtensions.filter(this.getContainers(it), (Functions.Function1)_function);
    }

    public Iterable<? extends ModelElement> getContainables(ContainingElement elm) {
        return this._containables.get(elm);
    }

    protected Set<? extends ModelElement> _getContainmentRestrictions(GraphModel it) {
        Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

            public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                return it.getTypes();
            }
        };
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)it.getContainableElements(), (Functions.Function1)_function)));
    }

    protected Set<ModelElement> _getContainmentRestrictions(NodeContainer it) {
        Node _extends = it.getExtends();
        Functions.Function1<NodeContainer, Set<? extends ModelElement>> _function = new Functions.Function1<NodeContainer, Set<? extends ModelElement>>(){

            public Set<? extends ModelElement> apply(NodeContainer it) {
                return GraphModelExtension.this.getContainmentRestrictions((EObject)it);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Node[]{_extends})), NodeContainer.class), (Functions.Function1)_function));
        Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function_1 = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

            public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                return it.getTypes();
            }
        };
        Iterable _flatten_1 = Iterables.concat((Iterable)ListExtensions.map((List)it.getContainableElements(), (Functions.Function1)_function_1));
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_flatten, (Iterable)_flatten_1));
    }

    public <T extends ModelElement> Set<T> getSubTypes(T elm) {
        Set<ModelElement> _get = this._subTypes.get(elm);
        return _get;
    }

    public ModelElement getSuperType(Type it) {
        GraphModel _switchResult = null;
        boolean _matched = false;
        if (it instanceof GraphModel) {
            _matched = true;
            _switchResult = ((GraphModel)it).getExtends();
        }
        if (!_matched && it instanceof Node) {
            _matched = true;
            _switchResult = ((Node)it).getExtends();
        }
        if (!_matched && it instanceof Edge) {
            _matched = true;
            _switchResult = ((Edge)it).getExtends();
        }
        if (!_matched && it instanceof UserDefinedType) {
            _matched = true;
            _switchResult = ((UserDefinedType)it).getExtends();
        }
        return _switchResult;
    }

    public Iterable<? extends ModelElement> getSuperTypes(Type elm) {
        return this._superTypes.get(elm);
    }

    public ModelElement getModelElement(GraphModel it, final String name) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return (ModelElement)IterableExtensions.findFirst(MGLUtil.modelElements(it), (Functions.Function1)_function);
    }

    public Iterable<ModelElement> getModelElements(MGLModel it) {
        EList _graphModels = it.getGraphModels();
        EList _nodes = it.getNodes();
        Iterable _plus = Iterables.concat((Iterable)_graphModels, (Iterable)_nodes);
        EList _edges = it.getEdges();
        Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_edges);
        Iterable<UserDefinedType> _userDefinedTypes = this.getUserDefinedTypes(it);
        return Iterables.concat((Iterable)_plus_1, _userDefinedTypes);
    }

    public boolean containsModelElement(MGLModel it, final String name) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists(this.getModelElements(it), (Functions.Function1)_function);
    }

    public boolean containsChildModelElement(MGLModel it, final String name) {
        Iterable<ModelElement> _modelElements = this.getModelElements(it);
        Functions.Function1<ModelElement, Iterable<? extends ModelElement>> _function = new Functions.Function1<ModelElement, Iterable<? extends ModelElement>>(){

            public Iterable<? extends ModelElement> apply(ModelElement it) {
                return GraphModelExtension.this.getSuperTypes((Type)it);
            }
        };
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map(this.getModelElements(it), (Functions.Function1)_function));
        Functions.Function1<ModelElement, Boolean> _function_1 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Iterable[]{_modelElements, _flatten}))), (Functions.Function1)_function_1);
    }

    public MGLModel getContainingImportedMglModel(MGLModel it, String name) {
        Functions.Function1<Import, MGLModel> _function = new Functions.Function1<Import, MGLModel>(){

            public MGLModel apply(Import it) {
                return MGLUtil.mglModel(it);
            }
        };
        List _map = ListExtensions.map((List)it.getImports(), (Functions.Function1)_function);
        for (MGLModel mglModel : _map) {
            boolean _containsModelElement = this.containsModelElement(mglModel, name);
            if (!_containsModelElement) continue;
            return mglModel;
        }
        return null;
    }

    public GraphicalModelElement getGraphicalModelElement(GraphModel it, final String name) {
        Functions.Function1<GraphicalModelElement, Boolean> _function = new Functions.Function1<GraphicalModelElement, Boolean>(){

            public Boolean apply(GraphicalModelElement it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return (GraphicalModelElement)IterableExtensions.findFirst(this.getGraphicalModelElements(it), (Functions.Function1)_function);
    }

    public Iterable<GraphicalModelElement> getGraphicalModelElements(GraphModel it) {
        EList _nodes = MGLUtil.getMglModel((ModelElement)it).getNodes();
        EList _edges = MGLUtil.getMglModel((ModelElement)it).getEdges();
        return Iterables.concat((Iterable)_nodes, (Iterable)_edges);
    }

    public boolean containsGraphicalModelElement(GraphModel it, final String name) {
        Functions.Function1<GraphicalModelElement, Boolean> _function = new Functions.Function1<GraphicalModelElement, Boolean>(){

            public Boolean apply(GraphicalModelElement it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists(this.getGraphicalModelElements(it), (Functions.Function1)_function);
    }

    public Iterable<NodeContainer> getContainers(MGLModel it) {
        return Iterables.filter((Iterable)it.getNodes(), NodeContainer.class);
    }

    public Iterable<NodeContainer> getContainers(GraphModel it) {
        return Iterables.filter(MGLUtil.nodes(it), NodeContainer.class);
    }

    public boolean containsContainer(MGLModel it, final String name) {
        Functions.Function1<NodeContainer, Boolean> _function = new Functions.Function1<NodeContainer, Boolean>(){

            public Boolean apply(NodeContainer it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists(this.getContainers(it), (Functions.Function1)_function);
    }

    public Iterable<Node> getNonContainerNodes(MGLModel it) {
        return this._collectionExtension.drop((Iterable)it.getNodes(), NodeContainer.class);
    }

    public Iterable<Node> getNonContainerNodes(GraphModel it) {
        return this._collectionExtension.drop(MGLUtil.nodes(it), NodeContainer.class);
    }

    public Set<Node> getUniqueNodesInContainers(GraphModel it) {
        Set<Node> nodes = MGLUtil.nodesInContainers(it);
        CollectionExtensions.removeAll(nodes, this.getNonContainerNodes(it));
        return nodes;
    }

    public boolean containsNonContainerNode(MGLModel it, final String name) {
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists(this.getNonContainerNodes(it), (Functions.Function1)_function);
    }

    public Iterable<Enumeration> getEnumerations(MGLModel it) {
        return Iterables.filter((Iterable)it.getTypes(), Enumeration.class);
    }

    public Set<Enumeration> getEnumerations(GraphModel it) {
        return IterableExtensions.toSet((Iterable)Iterables.filter(MGLUtil.types(it), Enumeration.class));
    }

    public boolean containsEnumeration(MGLModel it, final String name) {
        Functions.Function1<Enumeration, Boolean> _function = new Functions.Function1<Enumeration, Boolean>(){

            public Boolean apply(Enumeration it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists(this.getEnumerations(it), (Functions.Function1)_function);
    }

    public Iterable<UserDefinedType> getUserDefinedTypes(MGLModel it) {
        return Iterables.filter((Iterable)MGLUtil.mglModel(it).getTypes(), UserDefinedType.class);
    }

    public Iterable<UserDefinedType> getUserDefinedTypes(GraphModel it) {
        return Iterables.filter(MGLUtil.types(it), UserDefinedType.class);
    }

    public boolean containsUserDefinedType(MGLModel it, final String name) {
        Functions.Function1<UserDefinedType, Boolean> _function = new Functions.Function1<UserDefinedType, Boolean>(){

            public Boolean apply(UserDefinedType it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        };
        return IterableExtensions.exists(this.getUserDefinedTypes(it), (Functions.Function1)_function);
    }

    public Iterable<ReferencedType> getPrimeReferences(MGLModel it) {
        Functions.Function1<Node, ReferencedType> _function = new Functions.Function1<Node, ReferencedType>(){

            public ReferencedType apply(Node it) {
                return it.getPrimeReference();
            }
        };
        return IterableExtensions.filterNull((Iterable)ListExtensions.map((List)it.getNodes(), (Functions.Function1)_function));
    }

    public Iterable<Node> getAllNodesWithAnnotation(MGLModel model, final String annName) {
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return GraphModelExtension.this.hasAnnotation((Annotatable)it, annName);
            }
        };
        return IterableExtensions.filter((Iterable)MGLUtil.mglModel(model).getNodes(), (Functions.Function1)_function);
    }

    public Iterable<String> getAllAnnotationValues(MGLModel model, final String annName) {
        Functions.Function1<Node, Iterable<Annotation>> _function = new Functions.Function1<Node, Iterable<Annotation>>(){

            public Iterable<Annotation> apply(Node it) {
                Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)annName);
                    }
                };
                return IterableExtensions.filter((Iterable)it.getAnnotations(), (Functions.Function1)_function);
            }
        };
        Functions.Function1<Annotation, EList<String>> _function_1 = new Functions.Function1<Annotation, EList<String>>(){

            public EList<String> apply(Annotation it) {
                return it.getValue();
            }
        };
        return IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap(this.getAllNodesWithAnnotation(model, annName), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public Iterable<Attribute> getAllAttributes(ModelElement it) {
        return this._allAttributes.get(it);
    }

    public boolean hasAnnotation(Annotatable it, final String annotationName) {
        EList _annotations = it.getAnnotations();
        boolean _exists = false;
        if (_annotations != null) {
            Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)annotationName);
                }
            };
            _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)_function);
        }
        return _exists;
    }

    public Set<Edge> getIncomingEdges(Node node) {
        return this._incomingEdges.get(node);
    }

    public Set<Edge> getOutgoingEdges(Node node) {
        return this._outgoingEdges.get(node);
    }

    public boolean isEdgeSource(Node it) {
        boolean _isEmpty = this.getOutgoingEdges(it).isEmpty();
        return !_isEmpty;
    }

    public ReferencedType getAnyPrimeReference(Node node) {
        ReferencedType _elvis = null;
        ReferencedType _primeReference = node.getPrimeReference();
        if (_primeReference != null) {
            _elvis = _primeReference;
        } else {
            Node _extends = node.getExtends();
            ReferencedType _anyPrimeReference = null;
            if (_extends != null) {
                _anyPrimeReference = this.getAnyPrimeReference(_extends);
            }
            _elvis = _anyPrimeReference;
        }
        return _elvis;
    }

    public boolean hasPrimeReference(Node it) {
        ReferencedType _anyPrimeReference = this.getAnyPrimeReference(it);
        return _anyPrimeReference != null;
    }

    public Iterable<Node> getSourceNodes(Edge edge) {
        return this._sourceNodes.get(edge);
    }

    public Iterable<Node> getTargetNodes(Edge edge) {
        return this._targetNodes.get(edge);
    }

    public Object getType(Attribute attribute) {
        EDataTypeType _switchResult = null;
        Attribute it = attribute;
        boolean _matched = false;
        if (it instanceof PrimitiveAttribute) {
            _matched = true;
            _switchResult = ((PrimitiveAttribute)it).getType();
        }
        if (!_matched && it instanceof ComplexAttribute) {
            _matched = true;
            _switchResult = ((ComplexAttribute)it).getType();
        }
        return _switchResult;
    }

    public boolean isList(Attribute attribute) {
        Integer _upperBound = attribute.getUpperBound();
        return _upperBound != 1;
    }

    public EObject getImportedModel(Import imprt) {
        return (EObject)IterableExtensions.head((Iterable)this._fileExtension.getResource(this._workspaceExtension.getFile(URI.createURI((String)imprt.getImportURI()))).getContents());
    }

    public GenModel getGenModel(Import imprt) {
        GenModel _xblockexpression = null;
        URI uri = URI.createURI((String)FilenameUtils.removeExtension((String)imprt.getImportURI()).concat(".genmodel"));
        _xblockexpression = (GenModel)this._resourceExtension.getContent(this._fileExtension.getResource(uri), GenModel.class, 0);
        return _xblockexpression;
    }

    public Set<GraphModel> getImportedGraphModelsOfImport(final Import imprt) {
        Set _xblockexpression = null;
        IFile file = this._workspaceExtension.getFile(URI.createURI((String)imprt.getImportURI(), (boolean)true));
        if (file == null) {
            URI uri = imprt.eResource().getURI();
            boolean _isFile = uri.isFile();
            if (_isFile) {
                IPath fromOSString = Path.fromOSString((String)uri.toFileString());
                IFile member = this._workspaceExtension.getWorkspaceRoot().getFileForLocation(fromOSString);
                IProject _project = null;
                if (member != null) {
                    _project = member.getProject();
                }
                IFile _file = null;
                if (_project != null) {
                    _file = _project.getFile(imprt.getImportURI());
                }
                file = _file;
            } else {
                IWorkspaceRoot _workspaceRoot = this._workspaceExtension.getWorkspaceRoot();
                String _platformString = uri.toPlatformString(true);
                Path _path = new Path(_platformString);
                IFile _file_1 = _workspaceRoot.getFile((IPath)_path);
                IProject _project_1 = null;
                if (_file_1 != null) {
                    _project_1 = _file_1.getProject();
                }
                IProject project = _project_1;
                IFile _file_2 = null;
                if (project != null) {
                    _file_2 = project.getFile(imprt.getImportURI());
                }
                file = _file_2;
            }
        }
        MGLModel _content = null;
        if (file != null) {
            _content = (MGLModel)this._fileExtension.getContent(file, MGLModel.class, 0);
        }
        Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

            public Boolean apply(final GraphModel it) {
                EObject _eContainer = imprt.eContainer();
                Functions.Function1<GraphModel, Boolean> _function = new Functions.Function1<GraphModel, Boolean>(){

                    public Boolean apply(GraphModel gm) {
                        GraphModel _extends = gm.getExtends();
                        String _name = null;
                        if (_extends != null) {
                            _name = _extends.getName();
                        }
                        String _name_1 = it.getName();
                        return Objects.equal((Object)_name, (Object)_name_1);
                    }
                };
                return IterableExtensions.exists((Iterable)((MGLModel)_eContainer).getGraphModels(), (Functions.Function1)_function);
            }
        };
        _xblockexpression = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)_content.getGraphModels(), (Functions.Function1)_function));
        return _xblockexpression;
    }

    protected GraphModel _getGraphModel(MGLModel model) {
        EList _graphModels = model.getGraphModels();
        GraphModel _get = null;
        if (_graphModels != null) {
            _get = (GraphModel)_graphModels.get(0);
        }
        return _get;
    }

    protected GraphModel _getGraphModel(Type it) {
        EObject _eContainer = it.eContainer();
        if (_eContainer instanceof MGLModel) {
            EObject _eContainer_1 = it.eContainer();
            EList _graphModels = ((MGLModel)_eContainer_1).getGraphModels();
            GraphModel _get = null;
            if (_graphModels != null) {
                _get = (GraphModel)_graphModels.get(0);
            }
            return _get;
        }
        EObject _elvis = null;
        EObject _eContainer_2 = it.eContainer();
        _elvis = _eContainer_2 != null ? _eContainer_2 : this._resourceExtension.getContent(it.eResource(), GraphModel.class, 0);
        return (GraphModel)_elvis;
    }

    public CharSequence getBeanName(Type it) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper((String)it.getName());
        _builder.append(_firstUpper);
        return _builder;
    }

    protected String _getBeanPackage(Type type) {
        return this.generatorUtils.beanPackage(type).toString();
    }

    protected String _getBeanPackage(MGLModel model) {
        return this._beanPackage.get(model);
    }

    public CharSequence getFqBeanName(Type it) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.getBeanPackage((Annotatable)it);
        _builder.append(_beanPackage);
        _builder.append(".");
        CharSequence _beanName = this.getBeanName(it);
        _builder.append((Object)_beanName);
        return _builder;
    }

    public CharSequence getInternalBeanName(Type it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Internal");
        String _firstUpper = StringExtensions.toFirstUpper((String)it.getName());
        _builder.append(_firstUpper);
        return _builder;
    }

    public String getInternalBeanPackage(Type type) {
        return this._internalBeanPackage.get(type);
    }

    public CharSequence getFqInternalBeanName(Type it) {
        StringConcatenation _builder = new StringConcatenation();
        String _internalBeanPackage = this.getInternalBeanPackage(it);
        _builder.append(_internalBeanPackage);
        _builder.append(".");
        CharSequence _internalBeanName = this.getInternalBeanName(it);
        _builder.append((Object)_internalBeanName);
        return _builder;
    }

    public EObject getType(ReferencedType it) {
        ModelElement _switchResult = null;
        boolean _matched = false;
        if (it instanceof ReferencedModelElement) {
            _matched = true;
            _switchResult = ((ReferencedModelElement)it).getType();
        }
        if (!_matched && it instanceof ReferencedEClass) {
            _matched = true;
            _switchResult = ((ReferencedEClass)it).getType();
        }
        return _switchResult;
    }

    public String getTypeName(ReferencedType primeRef) {
        String _switchResult = null;
        ReferencedType it = primeRef;
        boolean _matched = false;
        if (it instanceof ReferencedEClass) {
            _matched = true;
            _switchResult = ((ReferencedEClass)it).getType().getName();
        }
        if (!_matched && it instanceof ReferencedModelElement) {
            _matched = true;
            _switchResult = ((ReferencedModelElement)it).getType().getName();
        }
        return _switchResult;
    }

    public CharSequence getFqBeanName(ReferencedType primeRef) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (primeRef instanceof ReferencedModelElement) {
            _matched = true;
            _switchResult = this.getFqBeanName((Type)((ReferencedModelElement)primeRef).getType());
        }
        if (!_matched && primeRef instanceof ReferencedEClass) {
            _matched = true;
            String _xblockexpression = null;
            final EPackage primeEPackage = ((ReferencedEClass)primeRef).getType().getEPackage();
            Functions.Function1<GenPackage, Boolean> _function = new Functions.Function1<GenPackage, Boolean>(){

                public Boolean apply(GenPackage it) {
                    String _name = GraphModelExtension.this.getName(it);
                    String _name_1 = primeEPackage.getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            GenPackage genPkg = (GenPackage)IterableExtensions.findFirst((Iterable)this.getGenModel((ReferencedEClass)primeRef).getGenPackages(), (Functions.Function1)_function);
            _xblockexpression = this.getFqBeanName(primeRef, genPkg);
            _switchResult = _xblockexpression;
        }
        return _switchResult;
    }

    public String getFqBeanName(ReferencedType primeRef, GenPackage genPkg) {
        String genPkgName;
        boolean _tripleNotEquals;
        String pkg = "";
        String _basePackage = genPkg.getBasePackage();
        boolean bl = _tripleNotEquals = _basePackage != null;
        if (_tripleNotEquals) {
            String _pkg = pkg;
            String _basePackage_1 = genPkg.getBasePackage();
            String _plus = String.valueOf(_basePackage_1) + ".";
            pkg = String.valueOf(_pkg) + _plus;
        }
        if ((genPkgName = this.getName(genPkg)) != null) {
            String _pkg_1 = pkg;
            pkg = String.valueOf(_pkg_1) + genPkgName + ".";
        }
        String _typeName = this.getTypeName(primeRef);
        return String.valueOf(pkg) + _typeName;
    }

    public EObject getImportedModel(ReferencedEClass primeRef) {
        return this.getImportedModel(primeRef.getImprt());
    }

    public GenModel getGenModel(ReferencedEClass primeRef) {
        return this.getGenModel(primeRef.getImprt());
    }

    public String getName(GenPackage genPkg) {
        String _elvis = null;
        EPackage _ecorePackage = genPkg.getEcorePackage();
        String _name = null;
        if (_ecorePackage != null) {
            _name = _ecorePackage.getName();
        }
        if (_name != null) {
            _elvis = _name;
        } else {
            String _prefix = genPkg.getPrefix();
            String _lowerCase = null;
            if (_prefix != null) {
                _lowerCase = _prefix.toLowerCase();
            }
            _elvis = _lowerCase;
        }
        return _elvis;
    }

    public ModelElement getAnnotatedModelElement(Annotation annot) {
        Annotatable _parent;
        ModelElement _switchResult = null;
        Annotatable it = _parent = annot.getParent();
        boolean _matched = false;
        if (it instanceof ModelElement) {
            _matched = true;
            _switchResult = (ModelElement)it;
        }
        return _switchResult;
    }

    public Attribute getAnnotatedAttribute(Annotation annot) {
        Annotatable _parent;
        Attribute _switchResult = null;
        Annotatable it = _parent = annot.getParent();
        boolean _matched = false;
        if (it instanceof Attribute) {
            _matched = true;
            _switchResult = (Attribute)it;
        }
        return _switchResult;
    }

    public Set<? extends ModelElement> getContainmentRestrictions(EObject it) {
        if (it instanceof NodeContainer) {
            return this._getContainmentRestrictions((NodeContainer)it);
        }
        if (it instanceof GraphModel) {
            return this._getContainmentRestrictions((GraphModel)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public GraphModel getGraphModel(Annotatable model) {
        if (model instanceof MGLModel) {
            return this._getGraphModel((MGLModel)model);
        }
        if (model instanceof Type) {
            return this._getGraphModel((Type)model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    public String getBeanPackage(Annotatable model) {
        if (model instanceof MGLModel) {
            return this._getBeanPackage((MGLModel)model);
        }
        if (model instanceof Type) {
            return this._getBeanPackage((Type)model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    public static class GenerationContext {
        private final IdentityHashMap<Object, Object> map = new IdentityHashMap();

        public <T> T get(T key) {
            Object _xblockexpression = null;
            Object value = this.map.get(key);
            Object _xifexpression = null;
            _xifexpression = value != null ? value : null;
            _xblockexpression = _xifexpression;
            return (T)_xblockexpression;
        }

        public <T> T put(T key, T value) {
            Object _xblockexpression = null;
            Object oldVal = this.map.put(key, value);
            Object _xifexpression = null;
            _xifexpression = oldVal != null ? oldVal : null;
            _xblockexpression = _xifexpression;
            return (T)_xblockexpression;
        }
    }
}

