/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.registry;

import de.jabc.cinco.meta.core.utils.registry.IdentityRegistry;
import java.util.Map;
import java.util.function.Function;

public class NonEmptyIdentityRegistry<K, V>
extends IdentityRegistry<K, V> {
    private static final long serialVersionUID = -2956005899058856244L;
    private Function<K, V> valueSupplier;

    public NonEmptyIdentityRegistry(Function<K, V> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    protected NonEmptyIdentityRegistry(Function<K, V> valueSupplier, Map<K, V> map) {
        super(map);
        this.valueSupplier = valueSupplier;
    }

    @Override
    public V get(Object key) {
        Object val = super.get(key);
        if (val != null) {
            return val;
        }
        val = this.valueSupplier.apply(key);
        this.put(key, val);
        return val;
    }

    public Function<K, V> getValueSupplier() {
        return this.valueSupplier;
    }

    public void setValueSupplier(Function<K, V> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }
}

