/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.registry;

import de.jabc.cinco.meta.core.utils.registry.KeygenRegistry;
import java.util.UUID;
import java.util.function.Supplier;

public class InstanceRegistry<V>
extends KeygenRegistry<String, V> {
    private static final long serialVersionUID = 2098354111588724338L;
    private Supplier<V> supplier;
    private V instance;

    public InstanceRegistry() {
        super((V v) -> UUID.randomUUID().toString());
    }

    public InstanceRegistry(Supplier<V> instanceSupplier) {
        this();
        this.supplier = instanceSupplier;
    }

    public boolean canCreate() {
        return this.supplier != null;
    }

    public V create() {
        return this.supplier.get();
    }

    public V get() {
        if (this.instance == null && this.canCreate()) {
            this.instance = this.create();
            this.add(this.instance);
        }
        return this.instance;
    }

    public InstanceRegistry<V> set(V instance) {
        this.instance = instance;
        return this;
    }
}

