/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.projects;

import de.jabc.cinco.meta.core.utils.BundleRegistry;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.ui.PlatformUI;
import org.jooq.lambda.tuple.Tuple2;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProjectCreator {
    private static final List<String> DEFAULT_SOURCE = Arrays.asList("src", "src-gen");
    private static final List<String> DEFAULT_CLEAN = Arrays.asList("src-gen");

    public static IProject createProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor, boolean askIfDel) {
        return ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, progressMonitor, null, askIfDel, false);
    }

    public static IProject createProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor) {
        return ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, progressMonitor, null, true, false);
    }

    public static IProject createProject(String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor, List<String> cleanDirs, boolean askIfDelete) {
        return ProjectCreator.createProject(projectName, srcFolders, referencedProjects, requiredBundles, exportedPackages, additionalNatures, progressMonitor, cleanDirs, askIfDelete, false);
    }

    public static IProject createProject(final String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, List<String> additionalNatures, IProgressMonitor progressMonitor, List<String> cleanDirs, boolean askIfDelete, boolean activator) {
        IProject project;
        IProgressMonitor localProgressMonitor;
        block18: {
            localProgressMonitor = progressMonitor;
            if (localProgressMonitor == null) {
                localProgressMonitor = new NullProgressMonitor();
            }
            project = null;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
            if (!project.exists()) break block18;
            final boolean[] result = new boolean[]{true};
            if (askIfDelete) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = MessageDialog.openQuestion(null, (String)("Do you want to overwrite the project " + projectName), (String)("Note that everything inside the project '" + projectName + "' will be deleted if you confirm this dialog."));
                    }
                });
            }
            if (result[0]) {
                if (cleanDirs == null) {
                    project.delete(true, true, null);
                } else {
                    for (String s : cleanDirs) {
                        IFolder f = project.getFolder(s);
                        if (!f.exists()) continue;
                        f.delete(true, localProgressMonitor);
                    }
                }
                break block18;
            }
            return null;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            projectDescription.setLocation(null);
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            }
            ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
            if (referencedProjects != null && referencedProjects.size() != 0) {
                projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                for (IProject referencedProject : referencedProjects) {
                    IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                    classpathEntries.add(referencedProjectClasspathEntry);
                }
            }
            if (additionalNatures != null) {
                String[] natures = new String[additionalNatures.size() + 2];
                int i = 0;
                while (i < additionalNatures.size()) {
                    natures[i] = additionalNatures.get(i);
                    ++i;
                }
                natures[additionalNatures.size()] = "org.eclipse.jdt.core.javanature";
                natures[additionalNatures.size() + 1] = "org.eclipse.pde.PluginNature";
                projectDescription.setNatureIds(natures);
            } else {
                projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
            }
            ICommand java = projectDescription.newCommand();
            java.setBuilderName("org.eclipse.jdt.core.javabuilder");
            ICommand manifest = projectDescription.newCommand();
            manifest.setBuilderName("org.eclipse.pde.ManifestBuilder");
            ICommand schema = projectDescription.newCommand();
            schema.setBuilderName("org.eclipse.pde.SchemaBuilder");
            projectDescription.setBuildSpec(new ICommand[]{java, manifest, schema});
            project.open((IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            if (srcFolders != null) {
                Collections.reverse(srcFolders);
                for (String src : srcFolders) {
                    IFolder srcContainer = project.getFolder(src);
                    if (!srcContainer.exists()) {
                        srcContainer.create(false, true, (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
                    }
                    IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                    classpathEntries.add(0, srcClasspathEntry);
                }
            }
            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-11")));
            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            javaProject.setOutputLocation((IPath)new Path("/" + projectName + "/bin"), (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            ProjectCreator.createManifest(projectName, requiredBundles, exportedPackages, localProgressMonitor, project, activator);
            ProjectCreator.createBuildProps(localProgressMonitor, project, srcFolders);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BundleRegistry.INSTANCE.addBundle(projectName, false, true);
        return project;
    }

    public static IProject createDefaultPluginProject(String projectName, Set<String> reqBundles) {
        IProject p = ProjectCreator.createProject(projectName, DEFAULT_SOURCE, Collections.emptyList(), reqBundles, Collections.emptyList(), Collections.emptyList(), null, DEFAULT_CLEAN, false, false);
        return p;
    }

    public static IProject createDefaultPluginProject(String projectName, Set<String> reqBundles, List<String> exportPackage) {
        IProject p = ProjectCreator.createProject(projectName, DEFAULT_SOURCE, Collections.emptyList(), reqBundles, exportPackage, Collections.emptyList(), null, DEFAULT_CLEAN, false, false);
        return p;
    }

    public static String makeSymbolicName(String projectName) {
        String symbolicName = projectName.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_");
        if (symbolicName.endsWith(".")) {
            symbolicName = String.valueOf(symbolicName.substring(0, symbolicName.lastIndexOf(46))) + "_";
        }
        if (symbolicName.startsWith(".")) {
            symbolicName = "_" + symbolicName.substring(1);
        }
        return symbolicName;
    }

    public static void addRequiredBundle(IProject p, Set<Bundle> bundles) throws IOException, CoreException {
        IFile file = p.getFolder("META-INF").getFile("MANIFEST.MF");
        if (file.exists()) {
            Manifest manifest = new Manifest(file.getContents());
            String reqBundle = manifest.getMainAttributes().getValue("Require-Bundle");
            if (reqBundle == null) {
                reqBundle = new String();
            }
            for (Bundle b : bundles) {
                if (reqBundle.contains(b.getSymbolicName())) continue;
                reqBundle = String.valueOf(reqBundle) + "," + b.getSymbolicName();
            }
            manifest.getMainAttributes().putValue("Require-Bundle", reqBundle);
            manifest.write(new FileOutputStream(file.getLocation().toFile()));
        }
    }

    public static void addRequiredBundle(IProject p, Bundle b) throws IOException, CoreException {
        IFile file = p.getFolder("META-INF").getFile("MANIFEST.MF");
        if (file.exists()) {
            Manifest manifest = new Manifest(file.getContents());
            String reqBundle = manifest.getMainAttributes().getValue("Require-Bundle");
            String bundleToAdd = "," + b.getSymbolicName();
            if (reqBundle == null) {
                reqBundle = new String();
            }
            if (!reqBundle.contains(String.format("%s,", "," + b.getSymbolicName())) && !reqBundle.contains(String.format("%s\n", "," + b.getSymbolicName()))) {
                reqBundle = String.valueOf(reqBundle) + bundleToAdd;
                manifest.getMainAttributes().putValue("Require-Bundle", reqBundle);
                manifest.write(new FileOutputStream(file.getLocation().toFile()));
            }
        }
    }

    public static void addRequiredBundle(IProject p, String bundleName) throws IOException, CoreException {
        IFile file = p.getFolder("META-INF").getFile("MANIFEST.MF");
        if (file.exists()) {
            Manifest manifest = new Manifest(file.getContents());
            String reqBundle = manifest.getMainAttributes().getValue("Require-Bundle");
            if (reqBundle == null) {
                reqBundle = new String();
            }
            reqBundle = String.valueOf(reqBundle) + "," + bundleName;
            manifest.getMainAttributes().putValue("Require-Bundle", reqBundle);
            manifest.write(new FileOutputStream(file.getLocation().toFile()));
        }
    }

    private static void createManifest(String projectName, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor, IProject project, boolean activator) throws CoreException {
        StringBuilder maniContent = new StringBuilder("Manifest-Version: 1.0\n");
        maniContent.append("Bundle-ManifestVersion: 2\n");
        maniContent.append("Bundle-Name: " + projectName + "\n");
        maniContent.append("Bundle-SymbolicName: " + ProjectCreator.makeSymbolicName(projectName) + "; singleton:=true\n");
        maniContent.append("Bundle-Version: 1.0.0.qualifier\n");
        if (activator) {
            maniContent.append(String.format("Bundle-Activator: %s.Activator\n", projectName));
        }
        if (requiredBundles != null && !requiredBundles.isEmpty()) {
            maniContent.append("Require-Bundle: ");
            Iterator<String> it = requiredBundles.iterator();
            while (it.hasNext()) {
                String entry = it.next();
                maniContent.append(" " + entry);
                if (it.hasNext()) {
                    maniContent.append(",\n");
                    continue;
                }
                maniContent.append("\n");
            }
        }
        if (exportedPackages != null && !exportedPackages.isEmpty()) {
            maniContent.append("Export-Package: " + exportedPackages.get(0));
            int i = 1;
            int x = exportedPackages.size();
            while (i < x) {
                maniContent.append(",\n " + exportedPackages.get(i));
                ++i;
            }
            maniContent.append("\n");
        }
        maniContent.append("Bundle-RequiredExecutionEnvironment: JavaSE-11\r\n");
        IFolder metaInf = project.getFolder("META-INF");
        if (!metaInf.exists()) {
            metaInf.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        ProjectCreator.createFile("MANIFEST.MF", (IContainer)metaInf, maniContent.toString(), progressMonitor);
    }

    private static void createManifest(String projectName, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        ProjectCreator.createManifest(projectName, requiredBundles, exportedPackages, progressMonitor, project, false);
    }

    private static void createBuildProps(IProgressMonitor progressMonitor, IProject project, List<String> srcFolders) {
        StringBuilder bpContent = new StringBuilder("source.. = ");
        Iterator<String> iterator = srcFolders.iterator();
        while (iterator.hasNext()) {
            bpContent.append(iterator.next()).append('/');
            if (!iterator.hasNext()) continue;
            bpContent.append(",");
        }
        bpContent.append("\n");
        bpContent.append("bin.includes = META-INF/,.\n");
        ProjectCreator.createFile("build.properties", (IContainer)project, bpContent.toString(), progressMonitor);
    }

    public static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, progressMonitor);
            } else {
                file.create((InputStream)stream, true, progressMonitor);
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static String getProjectSymbolicName(IProject project) {
        BundleContext bc = InternalPlatform.getDefault().getBundleContext();
        ServiceReference ref = bc.getServiceReference(IBundleProjectService.class.getName());
        IBundleProjectService service = (IBundleProjectService)bc.getService(ref);
        try {
            IBundleProjectDescription bpd = service.getDescription(project);
            String string = bpd.getSymbolicName();
            return string;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        finally {
            bc.ungetService(ref);
        }
        return "";
    }

    public static void createJavaClass(IProject project, String packageName, String className, IFolder sourceFolder, String classContents, IProgressMonitor progressMonitor) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragment pack = javaProject.getPackageFragmentRoot((IResource)sourceFolder).createPackageFragment(packageName, true, progressMonitor);
        pack.createCompilationUnit(String.valueOf(className) + ".java", classContents, false, progressMonitor);
        project.refreshLocal(2, progressMonitor);
    }

    public static IProject getProject(Resource res) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        URI uri = res.getURI();
        if (uri.isPlatformResource()) {
            IFile iFile = workspace.getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            return iFile.getProject();
        }
        return null;
    }

    public static IProject createPlainProject(final String projectName, List<String> additionalNatures, IProgressMonitor progressMonitor, List<String> cleanDirs, boolean askIfDelete) {
        IProject project;
        IProgressMonitor localProgressMonitor;
        block12: {
            localProgressMonitor = progressMonitor;
            if (localProgressMonitor == null) {
                localProgressMonitor = new NullProgressMonitor();
            }
            project = null;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
            if (!project.exists()) break block12;
            final boolean[] result = new boolean[]{true};
            if (askIfDelete) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = MessageDialog.openQuestion(null, (String)("Do you want to overwrite the project " + projectName), (String)("Note that everything inside the project '" + projectName + "' will be deleted if you confirm this dialog."));
                    }
                });
            }
            if (result[0]) {
                if (cleanDirs == null) {
                    project.delete(true, true, null);
                } else {
                    for (String s : cleanDirs) {
                        IFolder f = project.getFolder(s);
                        if (!f.exists()) continue;
                        f.delete(true, localProgressMonitor);
                    }
                }
                break block12;
            }
            return null;
        }
        try {
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            projectDescription.setLocation(null);
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            }
            if (additionalNatures != null) {
                String[] natures = new String[additionalNatures.size()];
                int i = 0;
                while (i < additionalNatures.size()) {
                    natures[i] = additionalNatures.get(i);
                    ++i;
                }
                projectDescription.setNatureIds(natures);
            }
            project.open((IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
            project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return project;
    }

    public static boolean exportPackage(IProject project, String packageName) {
        IFile iManiFile = project.getFolder("META-INF").getFile("MANIFEST.MF");
        try {
            CincoUtil.refreshFiles(null, iManiFile);
            Manifest manifest = new Manifest(iManiFile.getContents());
            String val = manifest.getMainAttributes().getValue("Export-Package");
            if (val == null) {
                val = new String("");
            }
            if (!val.contains(packageName)) {
                val = val.isEmpty() ? val.concat(packageName) : val.concat("," + packageName);
                manifest.getMainAttributes().putValue("Export-Package", val);
                manifest.write(new FileOutputStream(iManiFile.getLocation().toFile()));
                CincoUtil.refreshFiles(null, iManiFile);
                return true;
            }
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void addAdditionalNature(IProject project, IProgressMonitor monitor, String ... additionalNatures) {
        IProgressMonitor localProgressMonitor = monitor;
        if (localProgressMonitor == null) {
            localProgressMonitor = new NullProgressMonitor();
        }
        try {
            IProjectDescription projectDescription = project.getDescription();
            String[] oldNatures = projectDescription.getNatureIds();
            if (additionalNatures != null) {
                int size = additionalNatures.length + oldNatures.length;
                String[] natures = new String[size];
                int i = 0;
                while (i < additionalNatures.length) {
                    natures[i] = additionalNatures[i];
                    ++i;
                }
                i = additionalNatures.length;
                while (i < size) {
                    natures[i] = oldNatures[i - additionalNatures.length];
                    ++i;
                }
                projectDescription.setNatureIds(natures);
            }
            project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(localProgressMonitor, 1));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @SafeVarargs
    public static void addAttribute(IProject project, IProgressMonitor monitor, Tuple2<String, String> ... newAttributes) {
        try {
            IFile file;
            IProgressMonitor localProgressMonitor = monitor;
            if (localProgressMonitor == null) {
                localProgressMonitor = new NullProgressMonitor();
            }
            if ((file = project.getFolder("META-INF").getFile("MANIFEST.MF")).exists()) {
                Manifest manifest = new Manifest(file.getContents());
                Attributes mainAttributes = manifest.getMainAttributes();
                if (mainAttributes == null) {
                    mainAttributes = new Attributes();
                }
                Tuple2<String, String>[] tuple2Array = newAttributes;
                int n = newAttributes.length;
                int n2 = 0;
                while (n2 < n) {
                    Tuple2<String, String> attribute = tuple2Array[n2];
                    if (mainAttributes.getValue((String)attribute.v1) == null || !mainAttributes.getValue((String)attribute.v1).equals(attribute.v2)) {
                        mainAttributes.putValue((String)attribute.v1, (String)attribute.v2);
                    }
                    ++n2;
                }
                manifest.write(new FileOutputStream(file.getLocation().toFile()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add Attribute to Manifest.", e);
        }
    }
}

