/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.projects;

import de.jabc.cinco.meta.core.utils.CincoUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ContentWriter {
    public static void writeJavaFileInSrcGen(IProject p, CharSequence packageName, String fileName, CharSequence content) {
        ContentWriter.writeJavaFile(p, "src-gen", packageName.toString(), fileName, content.toString());
    }

    public static void writeJavaFileInSrcGen(IProject p, String packageName, String fileName, CharSequence content) {
        ContentWriter.writeJavaFile(p, "src-gen", packageName, fileName, content.toString());
    }

    public static void writeJavaFileInSrcGen(IProject p, String packageName, String fileName, String content) {
        ContentWriter.writeJavaFile(p, "src-gen", packageName, fileName, content);
    }

    public static void writeJavaFile(IProject p, String folderName, String packageName, String fileName, String content) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFolder folder = p.getFolder(folderName);
        try {
            boolean _not;
            boolean _exists = folder.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                folder.create(true, true, (IProgressMonitor)monitor);
            }
            IJavaProject javaProject = JavaCore.create((IProject)p);
            IPackageFragmentRoot packageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)folder);
            IPackageFragment pack = packageFragmentRoot.createPackageFragment(packageName, true, (IProgressMonitor)monitor);
            pack.createCompilationUnit(fileName, content.toString(), false, (IProgressMonitor)monitor);
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void writeFile(IProject p, String folderName, CharSequence packageName, String fileName, CharSequence content) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IFolder folder = p.getFolder(folderName);
        IFolder packageFolder = null;
        try {
            String _replaceAll;
            Path _path;
            boolean _exists_1;
            boolean _not_1;
            boolean _not;
            boolean _exists = folder.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                folder.create(true, true, (IProgressMonitor)monitor);
            }
            boolean bl2 = _not_1 = !(_exists_1 = (packageFolder = folder.getFolder((IPath)(_path = new Path(_replaceAll = packageName.toString().replaceAll("\\.", "/"))))).exists());
            if (_not_1) {
                packageFolder.create(true, true, (IProgressMonitor)monitor);
            }
            IFile f = packageFolder.getFile(fileName);
            File file = f.getLocation().toFile();
            FileWriter fw = new FileWriter(file);
            fw.write(content.toString());
            fw.close();
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                e.printStackTrace();
            }
            if (_t instanceof IOException) {
                IOException e_1 = (IOException)_t;
                e_1.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void writePluginXML(IProject project, CharSequence content, String extensionCommentID) {
        String pluginXMLPath = project.getLocation().append("plugin.xml").toString();
        CincoUtil.addExtension(pluginXMLPath, content.toString(), extensionCommentID, project.getName());
    }

    public static void writePluginXML(IProject project, List<CharSequence> extensions, String extensionCommentID) {
        ContentWriter.writePluginXML(project, IterableExtensions.join(extensions, (CharSequence)"\n"), extensionCommentID);
    }

    public static String getFileContents(File pluginXMLFile) throws IOException {
        FileReader _fileReader = new FileReader(pluginXMLFile);
        BufferedReader reader = new BufferedReader(_fileReader);
        String line = null;
        String content = new String();
        while ((line = reader.readLine()) != null) {
            String _content = content;
            content = String.valueOf(_content) + line;
        }
        reader.close();
        return content;
    }

    public static String stripOffQuotes(String string) {
        boolean _lessThan;
        if (string == null) {
            return null;
        }
        int _length = string.length();
        boolean bl = _lessThan = _length < 2;
        if (_lessThan) {
            return string;
        }
        char start = string.charAt(0);
        int _length_1 = string.length();
        int _minus = _length_1 - 1;
        char end = string.charAt(_minus);
        int singleQuote = 39;
        int doubleQuote = 34;
        if (start == '\'' && end == '\'' || start == '\"' && end == '\"') {
            int _length_2 = string.length();
            int _minus_1 = _length_2 - 1;
            return string.substring(1, _minus_1);
        }
        return string;
    }
}

