/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.mwe2;

import com.google.common.base.Objects;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MakeSourceDirectory
implements IWorkflowComponent {
    private static final Logger log = Logger.getLogger(MakeSourceDirectory.class);
    private String srcDir = null;
    private String project = null;
    private boolean addGitIgnore = false;
    private boolean cleanIfExisting = false;
    private boolean createIfMissing = true;

    public String setSrcDir(String str) {
        this.srcDir = str;
        return this.srcDir;
    }

    public String setProject(String str) {
        this.project = str;
        return this.project;
    }

    public boolean setAddGitIgnore(boolean flag) {
        this.addGitIgnore = flag;
        return this.addGitIgnore;
    }

    public boolean setCleanIfExisting(boolean flag) {
        this.cleanIfExisting = flag;
        return this.cleanIfExisting;
    }

    public boolean setCreateIfMissing(boolean flag) {
        this.createIfMissing = flag;
        return this.createIfMissing;
    }

    public void invoke(IWorkflowContext arg0) {
        try {
            boolean _not_1;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.project);
            this.operator_elvis(_isNullOrEmpty, "project property must be set");
            File fProject = Paths.get(this.project, new String[0]).toFile();
            boolean _exists = fProject.exists();
            boolean _not = !_exists;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("project ");
            _builder.append(this.project);
            _builder.append(" does not exist");
            this.operator_elvis(_not, _builder.toString());
            boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)this.srcDir);
            this.operator_elvis(_isNullOrEmpty_1, "srcDir property must be set");
            boolean _contains = this.srcDir.contains("/");
            this.operator_elvis(_contains, "srcDir must not contain /");
            File fSrcDir = Paths.get(this.project, this.srcDir).toFile();
            boolean _exists_1 = fSrcDir.exists();
            boolean bl = _not_1 = !_exists_1;
            if (_not_1) {
                if (this.createIfMissing) {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Creating directory \"");
                    _builder_1.append((Object)fSrcDir);
                    _builder_1.append("\"");
                    log.info((Object)_builder_1);
                    fSrcDir.mkdir();
                }
            } else {
                boolean _isDirectory = fSrcDir.isDirectory();
                boolean _not_2 = !_isDirectory;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("file \"");
                _builder_2.append((Object)fSrcDir);
                _builder_2.append("\" exists, but is no directory");
                this.operator_elvis(_not_2, _builder_2.toString());
                if (this.cleanIfExisting) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Cleaning \"");
                    _builder_3.append((Object)fSrcDir);
                    _builder_3.append("\"");
                    log.info((Object)_builder_3);
                    this.clean(fSrcDir);
                }
            }
            Path fGitIgnore = Paths.get(this.project, this.srcDir, ".gitignore");
            if (this.addGitIgnore && !fGitIgnore.toFile().exists()) {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("Creating file \"");
                _builder_4.append((Object)fGitIgnore);
                _builder_4.append("\"");
                log.info((Object)_builder_4);
                Files.write(fGitIgnore, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new CharSequence[]{"*", "!.gitignore"})), Charset.forName("UTF-8"), new OpenOption[0]);
            }
            this.addToClasspathIfMissing();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void operator_elvis(boolean test, String message) {
        if (test) {
            log.error((Object)message);
            throw new IllegalArgumentException(message);
        }
    }

    private Transformer addToClasspathIfMissing() {
        try {
            boolean _not;
            Transformer _xblockexpression = null;
            File fClasspath = Paths.get(this.project, ".classpath").toFile();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(fClasspath);
            NodeList entries = doc.getElementsByTagName("classpathentry");
            Transformer _xifexpression = null;
            boolean _containsSrcEntry = this.containsSrcEntry(entries);
            boolean bl = _not = !_containsSrcEntry;
            if (_not) {
                Transformer _xblockexpression_1 = null;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Adding \"");
                _builder.append(this.srcDir);
                _builder.append("\" to ");
                _builder.append((Object)fClasspath);
                _builder.append(".");
                log.info((Object)_builder);
                Node root = doc.getElementsByTagName("classpath").item(0);
                Element _createElement = doc.createElement("classpathentry");
                Procedures.Procedure1<Element> _function = new Procedures.Procedure1<Element>(){

                    public void apply(Element it) {
                        it.setAttribute("kind", "src");
                        it.setAttribute("path", MakeSourceDirectory.this.srcDir);
                    }
                };
                Element _doubleArrow = (Element)ObjectExtensions.operator_doubleArrow((Object)_createElement, (Procedures.Procedure1)_function);
                root.appendChild(_doubleArrow);
                _xifexpression = _xblockexpression_1 = this.writeToClasspathFile(doc, fClasspath);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean containsSrcEntry(NodeList entries) {
        int _length = entries.getLength();
        IntegerRange _upTo = new IntegerRange(0, _length);
        for (Integer i : _upTo) {
            Node _item;
            Node entry = _item = entries.item(i);
            boolean _matched = false;
            if (!(entry instanceof Element)) continue;
            _matched = true;
            boolean _isSrcEntry = this.isSrcEntry((Element)entry, this.srcDir);
            if (!_isSrcEntry) continue;
            return true;
        }
        return false;
    }

    private boolean isSrcEntry(Element e, String srcDir) {
        boolean _xblockexpression = false;
        Node _namedItem = e.getAttributes().getNamedItem("kind");
        String _value = null;
        if ((Attr)_namedItem != null) {
            _value = ((Attr)_namedItem).getValue();
        }
        String kind = _value;
        Node _namedItem_1 = e.getAttributes().getNamedItem("path");
        String _value_1 = null;
        if ((Attr)_namedItem_1 != null) {
            _value_1 = ((Attr)_namedItem_1).getValue();
        }
        String path = _value_1;
        _xblockexpression = Objects.equal((Object)kind, (Object)"src") && Objects.equal((Object)path, (Object)srcDir);
        return _xblockexpression;
    }

    private Transformer writeToClasspathFile(final Document doc, final File fClasspath) {
        try {
            Transformer _newTransformer = TransformerFactory.newInstance().newTransformer();
            Procedures.Procedure1<Transformer> _function = new Procedures.Procedure1<Transformer>(){

                public void apply(Transformer it) {
                    try {
                        it.setOutputProperty("encoding", "UTF-8");
                        it.setOutputProperty("indent", "yes");
                        DOMSource _dOMSource = new DOMSource(doc);
                        StreamResult _streamResult = new StreamResult(fClasspath);
                        it.transform(_dOMSource, _streamResult);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            return (Transformer)ObjectExtensions.operator_doubleArrow((Object)_newTransformer, (Procedures.Procedure1)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void clean(File fSrcDir) {
        File[] _listFiles = fSrcDir.listFiles();
        if ((List)Conversions.doWrapArray((Object)_listFiles) != null) {
            Consumer<File> _function = new Consumer<File>(){

                @Override
                public void accept(File it) {
                    boolean _isDirectory = it.isDirectory();
                    if (_isDirectory) {
                        MakeSourceDirectory.this.clean(it);
                    } else {
                        boolean _not;
                        boolean _delete = it.delete();
                        boolean bl = _not = !_delete;
                        if (_not) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Couldn't delete \"");
                            _builder.append((Object)it);
                            _builder.append("\"");
                            log.error((Object)_builder);
                        }
                    }
                }
            };
            ((List)Conversions.doWrapArray((Object)_listFiles)).forEach(_function);
        }
    }

    public void postInvoke() {
    }

    public void preInvoke() {
    }
}

