/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.job;

import de.jabc.cinco.meta.core.utils.job.ComplexStep;
import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.ConcurrentWorkload;
import de.jabc.cinco.meta.core.utils.job.Task;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.xbase.lib.Pair;

public class Workload
implements ComplexStep {
    protected CompoundJob job;
    protected int quota;
    protected double tick;
    protected boolean canceled;
    protected List<Supplier<Stream<Task>>> tasksSuppliers = new ArrayList<Supplier<Stream<Task>>>();
    protected List<Task> tasks;
    protected Task currentTask;
    protected String displayName;

    public Workload(CompoundJob job, int quota) {
        this.job = job;
        this.quota = quota;
    }

    @Override
    public int getQuota() {
        return this.quota;
    }

    public Workload consume(int quota) {
        if (this.tasksSuppliers.isEmpty()) {
            this.quota += quota;
            return this;
        }
        return this.job.consume(quota);
    }

    public Workload consume(int quota, String label) {
        return this.label(label).consume(quota);
    }

    public Workload consumeConcurrent(int quota) {
        if (this.tasksSuppliers.isEmpty()) {
            this.quota += quota;
            return this;
        }
        return this.job.consumeConcurrent(quota);
    }

    public ConcurrentWorkload consumeConcurrent(int quota, String label) {
        return this.label(label).consumeConcurrent(quota);
    }

    public Workload task(Runnable runnable) {
        return this.task(null, runnable);
    }

    public Workload task(Pair<String, Runnable> pair) {
        return this.task((String)pair.getKey(), (Runnable)pair.getValue());
    }

    public Workload task(String name, Runnable runnable) {
        this.addTask(this.createTask(name, runnable));
        return this;
    }

    public Workload task(Job job) {
        return this.task(job.getName(), job);
    }

    public Workload task(String name, Job job) {
        this.addTask(this.createTask(name, () -> {
            job.setUser(false);
            job.schedule();
            try {
                job.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        return this;
    }

    protected Task createTask(String name, Runnable runnable) {
        return new Task(name, runnable, this::taskDone);
    }

    protected void addTask(Task task) {
        this.tasksSuppliers.add(() -> Stream.of(task));
    }

    public <T> Workload taskForEach(Supplier<Stream<T>> supplier, Consumer<T> consumer) {
        this.tasksSuppliers.add(() -> ((Stream)supplier.get()).map(item -> this.createTask(null, () -> consumer.accept(item))));
        return this;
    }

    public <T> Workload taskForEach(Supplier<Stream<T>> supplier, Consumer<T> consumer, Function<T, String> nameProvider) {
        this.tasksSuppliers.add(() -> ((Stream)supplier.get()).map(item -> this.createTask((String)nameProvider.apply(item), () -> consumer.accept(item))));
        return this;
    }

    public <T> Workload taskForEach(Stream<T> stream, Consumer<T> consumer) {
        stream.forEach(item -> {
            Workload workload = this.task(() -> consumer.accept(item));
        });
        return this;
    }

    public <T> Workload taskForEach(Stream<T> stream, List<Pair<String, Consumer<T>>> tasks) {
        Iterator it = tasks.iterator();
        stream.forEach(item -> {
            Pair pair = (Pair)it.next();
            this.task((String)pair.getKey(), () -> ((Consumer)pair.getValue()).accept(item));
        });
        return this;
    }

    public <T> Workload taskForEach(Stream<T> stream, Consumer<T> consumer, Function<T, String> nameProvider) {
        stream.forEach(item -> {
            Workload workload = this.task((String)nameProvider.apply(item), () -> consumer.accept(item));
        });
        return this;
    }

    public <T> Workload taskForEach(Iterable<T> iterables, Consumer<T> consumer) {
        for (Object item : iterables) {
            this.task(() -> consumer.accept(item));
        }
        return this;
    }

    public <T> Workload taskForEach(Iterable<T> iterables, Consumer<T> consumer, Function<T, String> nameProvider) {
        for (Object item : iterables) {
            this.task(nameProvider.apply(item), () -> consumer.accept(item));
        }
        return this;
    }

    public Workload taskForEach(Iterable<Job> jobs) {
        jobs.forEach(this::task);
        return this;
    }

    public Workload cancelIf(Supplier<Boolean> test) {
        this.task("", () -> {
            if (((Boolean)test.get()).booleanValue()) {
                this.cancel();
            }
        });
        return this;
    }

    public Workload cancelIf(Supplier<Boolean> test, String message) {
        this.task("", () -> {
            if (((Boolean)test.get()).booleanValue()) {
                this.cancel();
                this.showMessage(message);
            }
        });
        return this;
    }

    @Override
    public void perform(SubMonitor monitor) {
        this.tasks = this.buildTasks();
        if (this.tasks.isEmpty()) {
            monitor.newChild(this.quota).subTask("");
        } else {
            this.tick = 0.0;
            this.tasks.forEach(task -> {
                if (!monitor.isCanceled() && !this.canceled) {
                    this.currentTask = task;
                    this.displayName = this.toDisplayName((Task)task, this.tasks);
                    this.tick += (double)this.quota / (double)this.tasks.size();
                    monitor.newChild((int)this.tick).subTask(this.displayName);
                    this.tick -= (double)((int)this.tick);
                    task.run();
                }
            });
        }
    }

    protected List<Task> buildTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        this.tasksSuppliers.forEach(sup -> ((Stream)sup.get()).forEach(tasks::add));
        return tasks;
    }

    private String toDisplayName(Task task, List<Task> tasks) {
        return task.name != null ? task.name : "Task " + tasks.indexOf(task) + " / " + tasks.size();
    }

    public CompoundJob label(String label) {
        return this.job.label(label);
    }

    public void schedule() {
        this.job.schedule();
    }

    protected void cancel() {
        if (!this.canceled) {
            this.canceled = true;
            this.job.requestCancel();
        }
    }

    public Workload ifDone(Runnable handler) {
        this.job.ifDone(handler);
        return this;
    }

    public Workload ifCanceled(Runnable handler) {
        this.job.ifCanceled(handler);
        return this;
    }

    public Workload ifFailed(Runnable handler) {
        this.job.ifFailed(handler);
        return this;
    }

    public Workload onDone(Runnable handler) {
        this.job.onDone(handler);
        return this;
    }

    public Workload onFinished(Runnable handler) {
        this.job.onFinished(handler);
        return this;
    }

    public Workload onFinishedShowMessage(String message) {
        this.job.onFinishedShowMessage(message);
        return this;
    }

    public Workload onCanceled(Runnable handler) {
        this.job.onCanceled(handler);
        return this;
    }

    public Workload onCanceledShowMessage(String message) {
        this.job.onCanceledShowMessage(message);
        return this;
    }

    public Workload onFailed(Runnable handler) {
        this.job.onFailed(handler);
        return this;
    }

    public Workload onFailedShowMessage(String message) {
        this.job.onFailedShowMessage(message);
        return this;
    }

    @Override
    public Task currentTask() {
        return this.currentTask;
    }

    protected void taskDone(Task task) {
        if (task.exception != null) {
            this.job.onTaskFailed(this, task);
        }
    }

    @Override
    public void requestCancel() {
        this.canceled = true;
    }

    private void showMessage(String msg) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Display display = d;
        display.asyncExec(() -> MessageDialog.openError((Shell)display.getActiveShell(), (String)this.job.getName(), (String)msg));
    }
}

