/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.job;

import java.util.ArrayList;
import java.util.List;

public abstract class ReiteratingThread
extends Thread {
    private int interval = 1000;
    private int tick = 100;
    private boolean paused = false;
    private boolean failed = false;
    private Thread myself;
    private long next = System.currentTimeMillis();
    private List<Runnable> onDoneCallbacks = new ArrayList<Runnable>();
    private List<Runnable> onFailedCallbacks = new ArrayList<Runnable>();
    private List<Runnable> onFinishedCallbacks = new ArrayList<Runnable>();

    public ReiteratingThread() {
    }

    public ReiteratingThread(int intervalMs) {
        this();
        this.interval = intervalMs;
        this.tick = intervalMs / 10;
    }

    public ReiteratingThread(int intervalMs, int tickMs) {
        this();
        this.interval = intervalMs;
        this.tick = tickMs;
    }

    protected void prepare() {
    }

    protected abstract void work();

    protected void afterwork() {
    }

    protected void cleanup() {
    }

    protected void tick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.prepare();
        while (this.myself == Thread.currentThread()) {
            block16: {
                try {
                    try {
                        ReiteratingThread reiteratingThread;
                        if (this.paused) {
                            reiteratingThread = this;
                            synchronized (reiteratingThread) {
                                while (this.paused) {
                                    this.wait();
                                }
                            }
                        }
                        if (this.next < System.currentTimeMillis()) {
                            this.next = (long)this.interval + System.currentTimeMillis();
                            this.work();
                            break block16;
                        }
                        reiteratingThread = this;
                        synchronized (reiteratingThread) {
                            this.wait(this.tick);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.tick();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.tick();
                    throw throwable;
                }
            }
            this.tick();
        }
        if (this.failed) {
            this.onFailed();
        } else {
            this.afterwork();
            this.onFinished();
        }
        this.cleanup();
        this.onDone();
    }

    @Override
    public synchronized void start() {
        this.myself = new Thread(this);
        this.myself.start();
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized void unpause() {
        this.paused = false;
        this.notify();
    }

    public void quit() {
        this.myself = null;
        if (this.paused) {
            this.unpause();
        }
    }

    protected void fail() {
        this.failed = true;
        this.quit();
    }

    public void waitUntilDone() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Thread is not running!");
        }
        try {
            this.myself.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isStarted() {
        return this.myself != null;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void onFinished(Runnable callback) {
        this.onFinishedCallbacks.add(callback);
    }

    private void onFinished() {
        for (Runnable callback : this.onFinishedCallbacks) {
            callback.run();
        }
    }

    public void onFailed(Runnable callback) {
        this.onFailedCallbacks.add(callback);
    }

    private void onFailed() {
        for (Runnable callback : this.onFailedCallbacks) {
            callback.run();
        }
    }

    public void onDone(Runnable callback) {
        this.onDoneCallbacks.add(callback);
    }

    private void onDone() {
        for (Runnable callback : this.onDoneCallbacks) {
            callback.run();
        }
    }
}

