/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.job;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public abstract class ReiteratingJob
extends Job {
    private int interval = 1000;
    private int tick = 100;
    private boolean paused = false;
    private boolean failed = false;
    private Thread myself;
    private long next = System.currentTimeMillis();
    private SubMonitor monitor;
    private IStatus status = Status.OK_STATUS;

    public ReiteratingJob(String name) {
        super(name);
    }

    public ReiteratingJob(String name, int intervalMs) {
        this(name);
        this.interval = intervalMs;
    }

    public ReiteratingJob(String name, int intervalMs, int tickMs) {
        this(name, intervalMs);
        this.tick = tickMs;
    }

    protected void prepare() {
    }

    protected abstract void repeat();

    protected void afterwork() {
    }

    protected void cleanup() {
        this.getMonitor().done();
    }

    protected void tick() {
        if (this.getMonitor().isCanceled()) {
            this.quit(Status.CANCEL_STATUS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        this.myself = Thread.currentThread();
        this.setMonitor(monitor);
        this.prepare();
        while (this.myself == Thread.currentThread()) {
            block15: {
                try {
                    try {
                        ReiteratingJob reiteratingJob;
                        if (this.paused) {
                            reiteratingJob = this;
                            synchronized (reiteratingJob) {
                                while (this.paused) {
                                    ((Object)((Object)this)).wait();
                                }
                            }
                        }
                        if (this.next < System.currentTimeMillis()) {
                            this.next = (long)this.interval + System.currentTimeMillis();
                            this.repeat();
                            break block15;
                        }
                        reiteratingJob = this;
                        synchronized (reiteratingJob) {
                            ((Object)((Object)this)).wait(this.tick);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.tick();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.tick();
                    throw throwable;
                }
            }
            this.tick();
        }
        if (!this.failed) {
            this.afterwork();
        }
        this.cleanup();
        return this.getStatus();
    }

    public void runAndWait() {
        this.schedule();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized void unpause() {
        this.paused = false;
        ((Object)((Object)this)).notify();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void quit() {
        this.quit(Status.OK_STATUS);
    }

    protected void quit(IStatus status) {
        this.setStatus(status);
        this.myself = null;
    }

    protected void fail(String msg, Exception e) {
        this.failed = true;
        this.quit((IStatus)new Status(4, this.getName(), msg, (Throwable)e));
    }

    public SubMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }
}

