/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.job;

import de.jabc.cinco.meta.core.utils.job.CompoundJob;
import de.jabc.cinco.meta.core.utils.job.ReiteratingThread;
import de.jabc.cinco.meta.core.utils.job.Task;
import de.jabc.cinco.meta.core.utils.job.Workload;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.SubMonitor;

public class ConcurrentWorkload
extends Workload {
    private ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private int tasksDone;
    private int quotaLeft;
    private Map<Task, Future<?>> results = new HashMap();
    private boolean done;
    private SubMonitor monitor;

    public ConcurrentWorkload(CompoundJob job, int percent) {
        super(job, percent);
    }

    @Override
    public void perform(SubMonitor monitor) {
        this.monitor = monitor;
        this.quotaLeft = this.quota;
        this.tasks = this.buildTasks();
        if (this.tasks.isEmpty()) {
            monitor.newChild(this.quota).subTask("");
        } else {
            this.tasks.forEach(this::submit);
            this.pool.shutdown();
            this.startMonitorUpdates();
            try {
                this.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.quotaLeft > 0) {
                monitor.newChild(this.quotaLeft);
                monitor.newChild(0);
            }
            this.done = true;
        }
    }

    private void submit(Task task) {
        this.results.put(task, this.pool.submit(task.runnable));
    }

    @Override
    protected void taskDone(Task task) {
        ++this.tasksDone;
        this.currentTask = task;
        this.displayName = task.name;
        this.tickMonitor();
        super.taskDone(task);
    }

    protected void startMonitorUpdates() {
        new ReiteratingThread(500, 200){

            @Override
            protected void work() {
                if (ConcurrentWorkload.this.done || ConcurrentWorkload.this.canceled) {
                    this.quit();
                }
            }

            @Override
            protected void tick() {
                ConcurrentWorkload.this.updateMonitor();
            }
        }.start();
    }

    protected void updateMonitor() {
        if (this.monitor.isCanceled() || this.canceled) {
            if (!this.canceled) {
                this.cancel();
            }
            this.monitor.subTask("Job canceled, awaiting termination...");
        } else {
            String label = "Completed " + this.tasksDone + "/" + this.tasks.size() + ".";
            if (this.displayName != null) {
                label = String.valueOf(label) + " Recent: " + this.displayName;
            }
            this.monitor.subTask(label);
        }
    }

    protected void tickMonitor() {
        if (!this.monitor.isCanceled() && !this.canceled) {
            this.tick += (double)this.quota / (double)this.tasks.size();
            this.monitor.newChild((int)this.tick);
            this.quotaLeft -= (int)this.tick;
            this.tick -= (double)((int)this.tick);
        }
    }

    @Override
    protected void cancel() {
        this.pool.shutdownNow();
        super.cancel();
    }

    @Override
    public void requestCancel() {
        this.pool.shutdownNow();
        super.requestCancel();
    }

    public ConcurrentWorkload setMaxThreads(int max) {
        if (max < 0) {
            System.err.println("WARN: Value for max number of threads ignored: " + max);
            return this;
        }
        int nThreads = Runtime.getRuntime().availableProcessors();
        if (max > 0) {
            nThreads = Math.min(max, nThreads);
        }
        this.pool = Executors.newFixedThreadPool(nThreads);
        return this;
    }
}

