/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.job;

import de.jabc.cinco.meta.core.utils.job.ComplexStep;
import de.jabc.cinco.meta.core.utils.job.ConcurrentWorkload;
import de.jabc.cinco.meta.core.utils.job.Step;
import de.jabc.cinco.meta.core.utils.job.Task;
import de.jabc.cinco.meta.core.utils.job.Workload;
import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.xtext.xbase.lib.Pair;

public class CompoundJob
extends Job {
    private SubMonitor monitor;
    private IProgressMonitor parentMonitor;
    private boolean canceled;
    private boolean cancelOnFail = true;
    protected List<String> failedTaskNames = new ArrayList<String>();
    private IStatus status;
    private List<Step> steps = new ArrayList<Step>();
    private Runnable onDone;
    private Runnable onFinished;
    private Runnable onFinishedMessage;
    private Runnable onCanceled;
    private Runnable onCanceledMessage;
    private Runnable onFailed;
    private Runnable onFailedMessage;
    private List<Runnable> ifDone = new ArrayList<Runnable>();
    private List<Runnable> ifCanceled = new ArrayList<Runnable>();
    private List<Runnable> ifFailed = new ArrayList<Runnable>();

    public CompoundJob(String name) {
        this(name, true);
    }

    public CompoundJob(String name, boolean user) {
        super(name);
        this.setUser(user);
        this.registerListener();
    }

    public CompoundJob(String name, IProgressMonitor monitor) {
        this(name);
        this.parentMonitor = monitor;
    }

    public CompoundJob(String name, IProgressMonitor monitor, boolean user) {
        this(name, user);
        this.parentMonitor = monitor;
    }

    public CompoundJob label(String label) {
        this.steps.add(monitor -> monitor.setTaskName(label));
        return this;
    }

    public Workload consume(int quota) {
        Workload workload = new Workload(this, quota);
        this.steps.add(workload);
        return workload;
    }

    public Workload consume(int quota, String label) {
        return this.label(label).consume(quota);
    }

    public CompoundJob consume(int quota, List<Pair<String, Runnable>> tasks) {
        Workload workload = new Workload(this, quota);
        tasks.forEach(task -> {
            Workload workload2 = workload.task((String)task.getKey(), (Runnable)task.getValue());
        });
        this.steps.add(workload);
        return this;
    }

    public CompoundJob consume(int quota, String label, List<Pair<String, Runnable>> tasks) {
        return this.label(label).consume(quota, tasks);
    }

    public ConcurrentWorkload consumeConcurrent(int quota) {
        ConcurrentWorkload workload = new ConcurrentWorkload(this, quota);
        this.steps.add(workload);
        return workload;
    }

    public ConcurrentWorkload consumeConcurrent(int quota, String label) {
        return this.label(label).consumeConcurrent(quota);
    }

    public CompoundJob consumeConcurrent(int quota, Iterable<Pair<String, Runnable>> tasks) {
        ConcurrentWorkload workload = new ConcurrentWorkload(this, quota);
        tasks.forEach(task -> {
            Workload workload = workload.task((String)task.getKey(), (Runnable)task.getValue());
        });
        this.steps.add(workload);
        return this;
    }

    public CompoundJob consumeConcurrent(int quota, String label, Iterable<Pair<String, Runnable>> tasks) {
        return this.label(label).consumeConcurrent(quota, tasks);
    }

    public CompoundJob cancelOnFail(boolean flag) {
        this.cancelOnFail = flag;
        return this;
    }

    protected void requestCancel() {
        if (!this.canceled) {
            this.canceled = true;
            this.status = Status.CANCEL_STATUS;
            super.cancel();
        }
    }

    public CompoundJob ifDone(Runnable handler) {
        this.ifDone.add(handler);
        this.steps.add(monitor -> {
            Runnable runnable = this.ifDone.remove(0);
        });
        return this;
    }

    public CompoundJob ifCanceled(Runnable handler) {
        this.ifCanceled.add(handler);
        this.steps.add(monitor -> {
            Runnable runnable = this.ifCanceled.remove(0);
        });
        return this;
    }

    public CompoundJob ifFailed(Runnable handler) {
        this.ifFailed.add(handler);
        this.steps.add(monitor -> {
            Runnable runnable = this.ifFailed.remove(0);
        });
        return this;
    }

    public CompoundJob onDone(Runnable handler) {
        this.onDone = handler;
        return this;
    }

    public CompoundJob onFinished(Runnable handler) {
        this.onFinished = handler;
        return this;
    }

    public CompoundJob onFinishedShowMessage(String message) {
        this.onFinishedMessage = () -> CincoMessageHandler.showMessage(message, this.getName());
        return this;
    }

    public CompoundJob onCanceled(Runnable handler) {
        this.onCanceled = handler;
        return this;
    }

    public CompoundJob onCanceledShowMessage(String message) {
        this.onCanceledMessage = () -> CincoMessageHandler.showMessage(message, this.getName());
        return this;
    }

    public CompoundJob onFailed(Runnable handler) {
        this.onFailed = handler;
        return this;
    }

    public CompoundJob onFailedShowMessage(String message) {
        this.onFailedMessage = () -> CincoMessageHandler.showErrorMessage(message, this.getName());
        return this;
    }

    protected IStatus run(IProgressMonitor pm) {
        this.wrapMonitor(pm);
        this.status = Status.OK_STATUS;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.monitor.newChild(5);
        this.steps.forEach(step -> {
            if (this.monitor.isCanceled()) {
                this.requestCancel();
            }
            if (!this.canceled) {
                this.perform((Step)step);
            }
        });
        return this.status;
    }

    private void perform(Step step) {
        try {
            step.perform(this.monitor);
        }
        catch (Exception e) {
            this.onStepFailed(step, e);
        }
    }

    private void onStepFailed(Step step, Exception e) {
        if (step instanceof ComplexStep) {
            this.onTaskFailed((ComplexStep)step, ((ComplexStep)step).currentTask());
        } else {
            if (this.cancelOnFail) {
                this.requestCancel();
            }
            String msg = "Execution failed: " + step;
            this.status = new Status(4, this.getName(), msg, (Throwable)e);
        }
    }

    protected void onTaskFailed(ComplexStep step, Task task) {
        if (this.cancelOnFail) {
            step.requestCancel();
            this.requestCancel();
        }
        String msg = this.buildErrorMessage(task);
        Exception e = this.buildErrorException(task);
        this.status = e != null ? new Status(4, this.getName(), msg, (Throwable)e) : new Status(4, this.getName(), msg);
    }

    protected String buildErrorMessage(Task task) {
        String msg = this.cancelOnFail ? "The execution has been canceled.\n\n" : "The execution of other tasks has not been canceled.\n\n";
        msg = this.failedTaskNames.isEmpty() ? String.valueOf(msg) + "Task failed:\n" : String.valueOf(msg) + "Tasks failed:\n";
        for (String failed : this.failedTaskNames) {
            msg = String.valueOf(msg) + failed;
        }
        if (task != null) {
            String taskName = task.name != null ? "\t" + task.name + "\n" : "\t<unnamed>\n";
            this.failedTaskNames.add(taskName);
            msg = String.valueOf(msg) + taskName;
        }
        return msg;
    }

    protected Exception buildErrorException(Task task) {
        Exception e = task.exception;
        if (e == null) {
            return null;
        }
        String msg = e.getMessage() != null ? e.getMessage() : "Unexpected exception.";
        Throwable cause = e.getCause();
        while (cause != null) {
            if (cause.getMessage() != null) {
                msg = String.valueOf(msg) + "\n\t" + cause.getMessage();
            }
            cause = cause.getCause();
        }
        StringWriter stacktrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stacktrace));
        msg = String.valueOf(msg) + "\n\n" + stacktrace.toString();
        return new RuntimeException(msg, e);
    }

    private void registerListener() {
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ArrayList<Runnable> handlers = new ArrayList<Runnable>();
                if (event.getResult().isOK()) {
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.ifDone));
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.onFinished, CompoundJob.this.onFinishedMessage, CompoundJob.this.onDone));
                } else if (event.getResult().equals(Status.CANCEL_STATUS)) {
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.ifCanceled));
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.ifDone));
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.onCanceled, CompoundJob.this.onCanceledMessage, CompoundJob.this.onDone));
                } else {
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.ifFailed));
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.ifDone));
                    handlers.addAll(CompoundJob.this.getHandlers(CompoundJob.this.onFailed, CompoundJob.this.onFailedMessage, CompoundJob.this.onDone));
                }
                handlers.forEach(handler -> handler.run());
            }
        });
    }

    private List<Runnable> getHandlers(List<Runnable> list) {
        ArrayList<Runnable> retVal = new ArrayList<Runnable>();
        if (!list.isEmpty()) {
            retVal.add(list.get(0));
        }
        return retVal;
    }

    private List<Runnable> getHandlers(Runnable ... handlers) {
        return Arrays.stream(handlers).filter(handler -> handler != null).collect(Collectors.toList());
    }

    protected void wrapMonitor(IProgressMonitor pm) {
        this.monitor = SubMonitor.convert((IProgressMonitor)(this.parentMonitor != null ? this.parentMonitor : pm), (int)(this.getTotalWorkload() + 5));
    }

    protected int getTotalWorkload() {
        return this.steps.stream().filter(ComplexStep.class::isInstance).map(ComplexStep.class::cast).mapToInt(step -> step.getQuota()).sum();
    }
}

