/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.generator;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.InheritanceUtil;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.generator.ReservedKeyWords;
import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension;
import de.jabc.cinco.meta.plugin.event.api.util.EventEnum;
import de.jabc.cinco.meta.runtime.xapi.GraphModelExtension;
import de.jabc.cinco.meta.util.xapi.CollectionExtension;
import de.jabc.cinco.meta.util.xapi.FileExtension;
import de.jabc.cinco.meta.util.xapi.ResourceExtension;
import de.jabc.cinco.meta.util.xapi.WorkbenchExtension;
import de.jabc.cinco.meta.util.xapi.WorkspaceExtension;
import graphmodel.Container;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.Node;
import graphmodel.internal.InternalIdentifiableElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.ComplexAttribute;
import mgl.ContainingElement;
import mgl.Edge;
import mgl.Enumeration;
import mgl.GraphicalElementContainment;
import mgl.GraphicalModelElement;
import mgl.MGLModel;
import mgl.ModelElement;
import mgl.NodeContainer;
import mgl.ReferencedEClass;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import mgl.Type;
import mgl.UserDefinedType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import productDefinition.CincoProduct;

public class GeneratorUtils
extends InheritanceUtil {
    @Extension
    protected CollectionExtension _collectionExtension = new CollectionExtension();
    @Extension
    protected EventApiExtension _eventApiExtension = new EventApiExtension();
    @Extension
    protected FileExtension _fileExtension = new FileExtension();
    @Extension
    protected GraphModelExtension _graphModelExtension = new GraphModelExtension();
    @Extension
    protected InheritanceUtil _inheritanceUtil = new InheritanceUtil();
    @Extension
    protected ResourceExtension _resourceExtension = new ResourceExtension();
    @Extension
    protected WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    @Extension
    protected WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
    @Extension
    protected static MGLUtil _mGLUtil;
    private static final String ID_NODES = "Nodes";
    public CincoProduct cpd;
    public Set<MGLModel> allMGLs = Collections.unmodifiableSet(CollectionLiterals.newHashSet());
    private final HashMap<ContainingElement, Set<Edge>> usableEdgesCache = new HashMap();
    private final HashMap<ContainingElement, Set<Enumeration>> usableEnumsCache = new HashMap();
    private final HashMap<ContainingElement, Set<mgl.Node>> usableNodesAnyDepthCache = new HashMap();
    private final HashMap<ContainingElement, Set<mgl.Node>> usableNodesFlatCache = new HashMap();
    private final HashMap<ContainingElement, Set<UserDefinedType>> usableUserDefinedTypesCache = new HashMap();
    private static GeneratorUtils INSTANCE;

    private GeneratorUtils() {
    }

    private static synchronized GeneratorUtils newInstance() {
        GeneratorUtils _generatorUtils;
        INSTANCE = _generatorUtils = new GeneratorUtils();
        return INSTANCE;
    }

    public static synchronized GeneratorUtils getInstance() {
        GeneratorUtils _newInstance;
        GeneratorUtils _elvis = null;
        _elvis = INSTANCE != null ? INSTANCE : (_newInstance = GeneratorUtils.newInstance());
        return _elvis;
    }

    public void clearCaches() {
        this.usableEdgesCache.clear();
        this.usableEnumsCache.clear();
        this.usableNodesAnyDepthCache.clear();
        this.usableNodesFlatCache.clear();
        this.usableUserDefinedTypesCache.clear();
    }

    public CharSequence instanceofCheck(ModelElement me, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName);
        _builder.append(" instanceof ");
        CharSequence _fqBeanName = this.fqBeanName((EObject)me);
        _builder.append((Object)_fqBeanName);
        return _builder;
    }

    public CharSequence internalInstanceofCheck(Type t, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName);
        _builder.append(" instanceof ");
        CharSequence _fqInternalBeanName = this.fqInternalBeanName(t);
        _builder.append((Object)_fqInternalBeanName);
        return _builder;
    }

    public CharSequence instanceofCheck(Annotatable a, String varName) {
        if (a instanceof ModelElement) {
            ModelElement me = (ModelElement)a;
            return this.instanceofCheck(me, varName);
        }
        return null;
    }

    public String attributeName(Attribute attr) {
        String _name = attr.getName();
        return "_" + _name;
    }

    public String fuName(Type t) {
        return StringExtensions.toFirstUpper((String)t.getName());
    }

    public String fuName(ModelElement me) {
        return StringExtensions.toFirstUpper((String)me.getName());
    }

    public String fuName(MGLModel mgl) {
        return StringExtensions.toFirstUpper((String)this.getFileName(mgl));
    }

    public String fuName(Attribute attr) {
        return StringExtensions.toFirstUpper((String)attr.getName());
    }

    protected String _fuCName(Type me) {
        String _firstUpper = StringExtensions.toFirstUpper((String)me.getName());
        return "C" + _firstUpper;
    }

    protected String _fuCName(ContainingElement me) {
        String _firstUpper;
        String _switchResult = null;
        boolean _matched = false;
        if (me instanceof NodeContainer) {
            _matched = true;
            _firstUpper = StringExtensions.toFirstUpper((String)((NodeContainer)me).getName());
            _switchResult = "C" + _firstUpper;
        }
        if (!_matched && me instanceof mgl.GraphModel) {
            _matched = true;
            _firstUpper = StringExtensions.toFirstUpper((String)((mgl.GraphModel)me).getName());
            _switchResult = "C" + _firstUpper;
        }
        return _switchResult;
    }

    public String fuCViewName(Type me) {
        String _fuCName = this.fuCName((EObject)me);
        return String.valueOf(_fuCName) + "View";
    }

    public String fuCImplName(Type me) {
        String _firstUpper = StringExtensions.toFirstUpper((String)me.getName());
        String _plus = "C" + _firstUpper;
        return String.valueOf(_plus) + "Impl";
    }

    public String flName(Type me) {
        String _firstLower = StringExtensions.toFirstLower((String)me.getName());
        return "_" + _firstLower;
    }

    public String flCName(Type me) {
        String _fuName = this.fuName(me);
        return "c" + _fuName;
    }

    public String fuInternalName(ModelElement me) {
        String _firstUpper = StringExtensions.toFirstUpper((String)me.getName());
        return "Internal" + _firstUpper;
    }

    protected CharSequence _projectName(mgl.GraphModel gm) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.getMglModel((ModelElement)gm).getPackage();
        _builder.append(_package);
        return _builder;
    }

    protected CharSequence _projectName(MGLModel it) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = it.getPackage();
        _builder.append(_package);
        return _builder;
    }

    public String getPackage(mgl.GraphModel gm) {
        String _package = MGLUtil.getMglModel((ModelElement)gm).getPackage();
        String _plus = String.valueOf(_package) + ".";
        String _lowerCase = gm.getName().toLowerCase();
        return String.valueOf(_plus) + _lowerCase;
    }

    protected CharSequence _packageName(mgl.GraphModel gm) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.getMglModel((ModelElement)gm).getPackage();
        _builder.append(_package);
        _builder.append(".editor.graphiti");
        return _builder;
    }

    protected CharSequence _packageName(MGLModel mgl) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = mgl.getPackage();
        _builder.append(_package);
        _builder.append(".editor.graphiti");
        return _builder;
    }

    public CharSequence packageNameAPI(mgl.GraphModel gm) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)gm);
        _builder.append((Object)_packageName);
        _builder.append(".api");
        return _builder;
    }

    public CharSequence packageNameAPI(MGLModel mgl) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)mgl);
        _builder.append((Object)_packageName);
        _builder.append(".api");
        return _builder;
    }

    protected CharSequence _packageName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.getMglModel(me).getPackage();
        _builder.append(_package);
        _builder.append(".editor.graphiti");
        return _builder;
    }

    public CharSequence packageNameAPI(Type me) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.mglModel(me).getPackage();
        _builder.append(_package);
        _builder.append(".editor.graphiti.api");
        return _builder;
    }

    public CharSequence packageNameEContentAdapter(Type me) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.mglModel(me).getPackage();
        _builder.append(_package);
        _builder.append(".adapter");
        return _builder;
    }

    public CharSequence packageNameExpression(mgl.GraphModel gm) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.getMglModel((ModelElement)gm).getPackage();
        _builder.append(_package);
        _builder.append(".editor.graphiti.expression");
        return _builder;
    }

    public CharSequence packageNameAdd(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.add");
        return _builder;
    }

    public CharSequence packageNameCreate(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.create");
        return _builder;
    }

    public CharSequence packageNameDelete(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.delete");
        return _builder;
    }

    public CharSequence packageNameLayout(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.layout");
        return _builder;
    }

    public CharSequence packageNameResize(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.resize");
        return _builder;
    }

    public CharSequence packageNameMove(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.move");
        return _builder;
    }

    public CharSequence packageNameUpdate(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.update");
        return _builder;
    }

    public CharSequence packageNameReconnect(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)MGLUtil.getMglModel(me));
        _builder.append((Object)_packageName);
        _builder.append(".features.reconnect");
        return _builder;
    }

    public String beanPackage(Type me) {
        if (me instanceof UserDefinedType) {
            EObject _eContainer = ((UserDefinedType)me).eContainer();
            MGLModel m = (MGLModel)_eContainer;
            StringConcatenation _builder = new StringConcatenation();
            String _package = m.getPackage();
            _builder.append(_package);
            _builder.append(".");
            String _lowerCase = this.getFileName(m).toLowerCase();
            _builder.append(_lowerCase);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _package_1 = MGLUtil.mglModel(me).getPackage();
        _builder_1.append(_package_1);
        _builder_1.append(".");
        String _lowerCase_1 = this.getFileName(MGLUtil.mglModel(me)).toLowerCase();
        _builder_1.append(_lowerCase_1);
        return _builder_1.toString();
    }

    protected CharSequence _fqBeanName(Type type) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage(type);
        _builder.append(_beanPackage);
        _builder.append(".");
        String _fuName = this.fuName(type);
        _builder.append(_fuName);
        return _builder;
    }

    protected CharSequence _fqBeanName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".");
        String _fuName = this.fuName(me);
        _builder.append(_fuName);
        return _builder;
    }

    protected CharSequence _fqBeanName(MGLModel mgl) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = mgl.getPackage();
        _builder.append(_package);
        _builder.append(".");
        String _lowerCase = this.getFileName(mgl).toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(".");
        String _fuName = this.fuName(mgl);
        _builder.append(_fuName);
        return _builder;
    }

    public CharSequence fqBeanNameEscaped(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".");
        String _escape = this.escape(this.fuName(me));
        _builder.append(_escape);
        return _builder;
    }

    public String escape(String s) {
        String _xifexpression = null;
        Functions.Function1<ReservedKeyWords, String> _function = new Functions.Function1<ReservedKeyWords, String>(){

            public String apply(ReservedKeyWords it) {
                return it.getKeyword().toLowerCase();
            }
        };
        boolean _contains = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)ReservedKeyWords.values())), (Functions.Function1)_function).contains(s.toLowerCase());
        _xifexpression = _contains ? "^" + s : s;
        return _xifexpression;
    }

    public String paramEscape(String s) {
        String _xifexpression = null;
        Functions.Function1<ReservedKeyWords, String> _function = new Functions.Function1<ReservedKeyWords, String>(){

            public String apply(ReservedKeyWords it) {
                return it.getKeyword();
            }
        };
        boolean _contains = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)ReservedKeyWords.values())), (Functions.Function1)_function).contains(s);
        _xifexpression = _contains ? String.valueOf(s) + "_" : s;
        return _xifexpression;
    }

    public String stringEscape(String str) {
        Character _valueOf = Character.valueOf('\t');
        Pair _mappedTo = Pair.of((Object)_valueOf, (Object)"\\t");
        Character _valueOf_1 = Character.valueOf('\b');
        Pair _mappedTo_1 = Pair.of((Object)_valueOf_1, (Object)"\\b");
        Character _valueOf_2 = Character.valueOf('\n');
        Pair _mappedTo_2 = Pair.of((Object)_valueOf_2, (Object)"\\n");
        Character _valueOf_3 = Character.valueOf('\r');
        Pair _mappedTo_3 = Pair.of((Object)_valueOf_3, (Object)"\\r");
        Character _valueOf_4 = Character.valueOf('\f');
        Pair _mappedTo_4 = Pair.of((Object)_valueOf_4, (Object)"\\f");
        Character _valueOf_5 = Character.valueOf('\'');
        Pair _mappedTo_5 = Pair.of((Object)_valueOf_5, (Object)"\\'");
        Character _valueOf_6 = Character.valueOf('\"');
        Pair _mappedTo_6 = Pair.of((Object)_valueOf_6, (Object)"\\\"");
        Character _valueOf_7 = Character.valueOf('\\');
        Pair _mappedTo_7 = Pair.of((Object)_valueOf_7, (Object)"\\\\");
        final Map escapeSeqences = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4, _mappedTo_5, _mappedTo_6, _mappedTo_7}));
        Functions.Function1<Character, String> _function = new Functions.Function1<Character, String>(){

            public String apply(Character c) {
                return escapeSeqences.getOrDefault(c, c.toString());
            }
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)str.toCharArray())), (Functions.Function1)_function));
    }

    protected CharSequence _fqBeanName(ContainingElement ce) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (ce instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = this.fqBeanName((EObject)((ModelElement)ce));
        }
        if (!_matched && ce instanceof NodeContainer) {
            _matched = true;
            _switchResult = this.fqBeanName((EObject)((ModelElement)ce));
        }
        return _switchResult;
    }

    public CharSequence fqInternalBeanName(Type me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage(me);
        _builder.append(_beanPackage);
        _builder.append(".internal.Internal");
        String _fuName = this.fuName(me);
        _builder.append(_fuName);
        return _builder;
    }

    public CharSequence fqBeanImplName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".impl.");
        String _fuName = this.fuName(me);
        _builder.append(_fuName);
        _builder.append("Impl");
        return _builder;
    }

    public CharSequence fqBeanViewName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".views.impl.");
        String _fuName = this.fuName(me);
        _builder.append(_fuName);
        _builder.append("ViewImpl");
        return _builder;
    }

    public CharSequence fqFactoryName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = MGLUtil.getMglModel(me).getPackage();
        _builder.append(_package);
        _builder.append(".factory.");
        String _fileName = this.getFileName(MGLUtil.getMglModel(me));
        _builder.append(_fileName);
        _builder.append("Factory");
        return _builder;
    }

    public CharSequence fqFactoryName(MGLModel mgl) {
        StringConcatenation _builder = new StringConcatenation();
        String _package = mgl.getPackage();
        _builder.append(_package);
        _builder.append(".factory.");
        String _fileName = this.getFileName(mgl);
        _builder.append(_fileName);
        _builder.append("Factory");
        return _builder;
    }

    public CharSequence fqCreateFeatureName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageNameCreate = this.packageNameCreate(me);
        _builder.append((Object)_packageNameCreate);
        _builder.append(".CreateFeature");
        String _fuName = this.fuName(me);
        _builder.append(_fuName);
        return _builder;
    }

    public CharSequence fqPrimeAddFeatureName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageNameAdd = this.packageNameAdd(me);
        _builder.append((Object)_packageNameAdd);
        _builder.append(".AddFeaturePrime");
        String _fuName = this.fuName(me);
        _builder.append(_fuName);
        return _builder;
    }

    public CharSequence fqPropertyView(mgl.GraphModel me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)me);
        _builder.append((Object)_packageName);
        _builder.append(".property.view.");
        String _fuName = this.fuName((ModelElement)me);
        _builder.append(_fuName);
        _builder.append("PropertyView");
        return _builder;
    }

    public CharSequence fqPropertyView(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)this.getGraphModel((Type)me));
        _builder.append((Object)_packageName);
        _builder.append(".property.view.");
        String _fuName = this.fuName((ModelElement)this.getGraphModel((Type)me));
        _builder.append(_fuName);
        _builder.append("PropertyView");
        return _builder;
    }

    public List<ModelElement> modelElements(MGLModel mm) {
        ArrayList<ModelElement> mes = new ArrayList<ModelElement>();
        mes.addAll((Collection<ModelElement>)mm.getNodes());
        mes.addAll((Collection<ModelElement>)mm.getEdges());
        mes.addAll((Collection<ModelElement>)mm.getGraphModels());
        return mes;
    }

    public CharSequence getDtpId(Type t) {
        return this.getDtpId(this.getGraphModel(t));
    }

    public CharSequence getDtpId(mgl.GraphModel model) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName((Annotatable)model);
        _builder.append((Object)_packageName);
        _builder.append(".");
        String _name = model.getName();
        _builder.append(_name);
        _builder.append("DiagramTypeProvider");
        return _builder;
    }

    public mgl.GraphModel getGraphModel(Type me) {
        EObject _eContainer = me.eContainer();
        return (mgl.GraphModel)IterableExtensions.head((Iterable)((MGLModel)_eContainer).getGraphModels());
    }

    public MGLModel getMGLModel(Type me) {
        EObject _eContainer = me.eContainer();
        return (MGLModel)_eContainer;
    }

    public CharSequence superClass(ModelElement me) {
        String _name;
        StringConcatenation _builder;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (me instanceof NodeContainer) {
            _matched = true;
            _builder = new StringConcatenation();
            _name = Container.class.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched && me instanceof mgl.Node) {
            _matched = true;
            _builder = new StringConcatenation();
            _name = Node.class.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched && me instanceof Edge) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append(graphmodel.Edge.class);
            _switchResult = _builder;
        }
        if (!_matched && me instanceof mgl.GraphModel) {
            _matched = true;
            _builder = new StringConcatenation();
            _name = GraphModel.class.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        return _switchResult;
    }

    public CharSequence firstUpperOnly(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper((String)me.getName().toLowerCase());
        _builder.append(_firstUpper);
        return _builder;
    }

    public CharSequence entryName(Class<Map.Entry> e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("java.util.Map.Entry");
        return _builder;
    }

    public LinkedHashMap<String, List<GraphicalModelElement>> getPaletteGroupsMap(mgl.GraphModel gm) {
        final LinkedHashMap<String, List<GraphicalModelElement>> map = new LinkedHashMap<String, List<GraphicalModelElement>>();
        ArrayList _arrayList = new ArrayList();
        map.put(ID_NODES, _arrayList);
        Set<mgl.Node> usableNodes = this.getUsableNodes((ContainingElement)gm, true);
        Functions.Function1<mgl.Node, Boolean> _function = new Functions.Function1<mgl.Node, Boolean>(){

            public Boolean apply(mgl.Node it) {
                return !it.isIsAbstract() && it.getPrimeReference() == null && !GeneratorUtils.this.isCreateDisabled((ModelElement)it);
            }
        };
        Iterable _filter = IterableExtensions.filter(usableNodes, (Functions.Function1)_function);
        for (final mgl.Node n : _filter) {
            boolean _not;
            boolean _hasPaletteCategory = this.hasPaletteCategory((ModelElement)n);
            boolean bl = _not = !_hasPaletteCategory;
            if (_not) {
                ((List)map.get(ID_NODES)).add(n);
            }
            Functions.Function1<Annotation, Boolean> _function_1 = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    return it.getName().equals("palette");
                }
            };
            Consumer<Annotation> _function_2 = new Consumer<Annotation>(){

                @Override
                public void accept(Annotation it) {
                    Consumer<String> _function = new Consumer<String>(){

                        @Override
                        public void accept(String v) {
                            GeneratorUtils.this.addToMap(map, v, (GraphicalModelElement)n);
                        }
                    };
                    it.getValue().forEach((Consumer)_function);
                }
            };
            IterableExtensions.filter((Iterable)n.getAnnotations(), (Functions.Function1)_function_1).forEach(_function_2);
        }
        Functions.Function1<Edge, Boolean> _function_1 = new Functions.Function1<Edge, Boolean>(){

            public Boolean apply(Edge e) {
                return !e.isIsAbstract() && !GeneratorUtils.this.isCreateDisabled((ModelElement)e);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(this.getUsableEdges((ContainingElement)gm), (Functions.Function1)_function_1);
        for (final Edge e : _filter_1) {
            Functions.Function1<Annotation, Boolean> _function_2 = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    return it.getName().equals("palette");
                }
            };
            Consumer<Annotation> _function_3 = new Consumer<Annotation>(){

                @Override
                public void accept(Annotation it) {
                    Consumer<String> _function = new Consumer<String>(){

                        @Override
                        public void accept(String v) {
                            GeneratorUtils.this.addToMap(map, v, (GraphicalModelElement)e);
                        }
                    };
                    it.getValue().forEach((Consumer)_function);
                }
            };
            IterableExtensions.filter((Iterable)e.getAnnotations(), (Functions.Function1)_function_2).forEach(_function_3);
        }
        map.remove("none");
        map.remove("None");
        map.remove("NONE");
        Functions.Function1<Map.Entry<String, List<GraphicalModelElement>>, String> _function_4 = new Functions.Function1<Map.Entry<String, List<GraphicalModelElement>>, String>(){

            public String apply(Map.Entry<String, List<GraphicalModelElement>> it) {
                return it.getKey();
            }
        };
        IterableExtensions.sortBy(map.entrySet(), (Functions.Function1)_function_4);
        return map;
    }

    public Set<mgl.Node> getUsableNodes(ContainingElement model) {
        return this.getUsableNodes(model, false);
    }

    public Set<mgl.Node> getUsableNodes(ContainingElement model, boolean anyDepth) {
        HashSet<ContainingElement> _hashSet = new HashSet<ContainingElement>();
        Set<mgl.Node> nodes = this._getUsableNodes(model, anyDepth, _hashSet);
        return nodes;
    }

    private Set<mgl.Node> _getUsableNodes(final ContainingElement model, boolean anyDepth, final Set<ContainingElement> alreadyVisited) {
        if (anyDepth) {
            Set cachedResult;
            boolean _isNullOrEmpty;
            boolean _not;
            Functions.Function1<Map.Entry<ContainingElement, Set<mgl.Node>>, Boolean> _function = new Functions.Function1<Map.Entry<ContainingElement, Set<mgl.Node>>, Boolean>(){

                public Boolean apply(Map.Entry<ContainingElement, Set<mgl.Node>> it) {
                    ContainingElement _key = it.getKey();
                    return MGLUtil.equalModelElement((Type)model, (Type)_key);
                }
            };
            Map.Entry _findFirst = (Map.Entry)IterableExtensions.findFirst(this.usableNodesAnyDepthCache.entrySet(), (Functions.Function1)_function);
            Set _value = null;
            if (_findFirst != null) {
                _value = (Set)_findFirst.getValue();
            }
            boolean bl = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(cachedResult = _value)));
            if (_not) {
                return cachedResult;
            }
        } else {
            Set cachedResult_1;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            Functions.Function1<Map.Entry<ContainingElement, Set<mgl.Node>>, Boolean> _function_1 = new Functions.Function1<Map.Entry<ContainingElement, Set<mgl.Node>>, Boolean>(){

                public Boolean apply(Map.Entry<ContainingElement, Set<mgl.Node>> it) {
                    ContainingElement _key = it.getKey();
                    return MGLUtil.equalModelElement((Type)model, (Type)_key);
                }
            };
            Map.Entry _findFirst_1 = (Map.Entry)IterableExtensions.findFirst(this.usableNodesFlatCache.entrySet(), (Functions.Function1)_function_1);
            Set _value_1 = null;
            if (_findFirst_1 != null) {
                _value_1 = (Set)_findFirst_1.getValue();
            }
            boolean bl = _not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)(cachedResult_1 = _value_1)));
            if (_not_1) {
                return cachedResult_1;
            }
        }
        alreadyVisited.add(model);
        EList containableElems = model.getContainableElements();
        Functions.Function1<GraphicalElementContainment, Boolean> _function_2 = new Functions.Function1<GraphicalElementContainment, Boolean>(){

            public Boolean apply(GraphicalElementContainment it) {
                int _upperBound = it.getUpperBound();
                return _upperBound != 0;
            }
        };
        Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function_3 = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

            public EList<GraphicalModelElement> apply(GraphicalElementContainment ce) {
                return ce.getTypes();
            }
        };
        Functions.Function1<GraphicalModelElement, Boolean> _function_4 = new Functions.Function1<GraphicalModelElement, Boolean>(){

            public Boolean apply(GraphicalModelElement i) {
                return i instanceof mgl.Node;
            }
        };
        Functions.Function1<GraphicalModelElement, mgl.Node> _function_5 = new Functions.Function1<GraphicalModelElement, mgl.Node>(){

            public mgl.Node apply(GraphicalModelElement i) {
                return (mgl.Node)i;
            }
        };
        Set nodes = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)containableElems, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        Iterable<? extends mgl.Node> childNodes = this.allNodeSubTypes(nodes);
        Iterables.addAll((Collection)nodes, childNodes);
        if (anyDepth) {
            Functions.Function1<ContainingElement, Boolean> _function_6 = new Functions.Function1<ContainingElement, Boolean>(){

                public Boolean apply(ContainingElement it) {
                    boolean _contains = alreadyVisited.contains(it);
                    return !_contains;
                }
            };
            Set containers = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)nodes, ContainingElement.class), (Functions.Function1)_function_6));
            alreadyVisited.addAll(containers);
            int i = 0;
            while (i < containers.size()) {
                Set<mgl.Node> newNodes = this._getUsableNodes(((ContainingElement[])Conversions.unwrapArray((Object)containers, ContainingElement.class))[i], anyDepth, alreadyVisited);
                nodes.addAll(newNodes);
                Functions.Function1<ContainingElement, Boolean> _function_7 = new Functions.Function1<ContainingElement, Boolean>(){

                    public Boolean apply(ContainingElement it) {
                        boolean _contains = alreadyVisited.contains(it);
                        return !_contains;
                    }
                };
                containers.addAll(IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(newNodes, ContainingElement.class), (Functions.Function1)_function_7)));
                ++i;
            }
        }
        final HashSet<mgl.Node> result = new HashSet<mgl.Node>();
        Consumer<mgl.Node> _function_7 = new Consumer<mgl.Node>(){

            @Override
            public void accept(final mgl.Node node) {
                boolean _not;
                Functions.Function1<mgl.Node, Boolean> _function = new Functions.Function1<mgl.Node, Boolean>(){

                    public Boolean apply(mgl.Node resultNode) {
                        return MGLUtil.equalNodes(resultNode, node);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)result, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    result.add(node);
                }
            }
        };
        nodes.forEach(_function_7);
        if (anyDepth) {
            this.usableNodesAnyDepthCache.put(model, result);
        } else {
            this.usableNodesFlatCache.put(model, result);
        }
        return result;
    }

    public Iterable<? extends mgl.Node> allNodeSubTypes(mgl.Node it) {
        return this.allNodeSubTypes(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new mgl.Node[]{it})));
    }

    public Iterable<? extends mgl.Node> allNodeSubTypes(final Iterable<mgl.Node> it) {
        Iterable<mgl.Node> _allOtherNodes = this.allOtherNodes(it);
        Iterable _filter = null;
        if (_allOtherNodes != null) {
            Functions.Function1<mgl.Node, Boolean> _function = new Functions.Function1<mgl.Node, Boolean>(){

                public Boolean apply(mgl.Node node) {
                    Set<mgl.Node> _allSuperNodes = GeneratorUtils.this.getAllSuperNodes(node);
                    Functions.Function1<mgl.Node, Boolean> _function = new Functions.Function1<mgl.Node, Boolean>(){

                        public Boolean apply(final mgl.Node superNode) {
                            Functions.Function1<mgl.Node, Boolean> _function = new Functions.Function1<mgl.Node, Boolean>(){

                                public Boolean apply(mgl.Node innerNode) {
                                    return MGLUtil.equalNodes(superNode, innerNode);
                                }
                            };
                            return IterableExtensions.exists((Iterable)it, (Functions.Function1)_function);
                        }
                    };
                    return IterableExtensions.exists((Iterable)((Iterable)Pair.of((Object)node, _allSuperNodes).getValue()), (Functions.Function1)_function);
                }
            };
            _filter = IterableExtensions.filter(_allOtherNodes, (Functions.Function1)_function);
        }
        return _filter;
    }

    public Iterable<mgl.Node> allOtherNodes(final Iterable<mgl.Node> nodes) {
        Iterable _flatMap = null;
        if (this.allMGLs != null) {
            Functions.Function1<MGLModel, Iterable<mgl.Node>> _function = new Functions.Function1<MGLModel, Iterable<mgl.Node>>(){

                public Iterable<mgl.Node> apply(MGLModel it) {
                    boolean _not;
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getNodes());
                    boolean bl = _not = !_isNullOrEmpty;
                    if (_not) {
                        Functions.Function1<mgl.Node, Boolean> _function = new Functions.Function1<mgl.Node, Boolean>(){

                            public Boolean apply(mgl.Node node) {
                                return (this).GeneratorUtils.this._collectionExtension.contains(nodes, (Object)node);
                            }
                        };
                        return GeneratorUtils.this._collectionExtension.drop((Iterable)it.getNodes(), (Functions.Function1)_function);
                    }
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
            };
            _flatMap = IterableExtensions.flatMap(this.allMGLs, (Functions.Function1)_function);
        }
        return _flatMap;
    }

    public Set<Edge> getUsableEdges(final ContainingElement model) {
        Set cachedResult;
        boolean _isNullOrEmpty;
        boolean _not;
        Functions.Function1<Map.Entry<ContainingElement, Set<Edge>>, Boolean> _function = new Functions.Function1<Map.Entry<ContainingElement, Set<Edge>>, Boolean>(){

            public Boolean apply(Map.Entry<ContainingElement, Set<Edge>> it) {
                ContainingElement _key = it.getKey();
                return MGLUtil.equalModelElement((Type)model, (Type)_key);
            }
        };
        Map.Entry _findFirst = (Map.Entry)IterableExtensions.findFirst(this.usableEdgesCache.entrySet(), (Functions.Function1)_function);
        Set _value = null;
        if (_findFirst != null) {
            _value = (Set)_findFirst.getValue();
        }
        boolean bl = _not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(cachedResult = _value)));
        if (_not) {
            return cachedResult;
        }
        Set<mgl.Node> nodes = this.getUsableNodes(model, true);
        Functions.Function1<mgl.Node, Iterable<Edge>> _function_1 = new Functions.Function1<mgl.Node, Iterable<Edge>>(){

            public Iterable<Edge> apply(mgl.Node node) {
                Set<Edge> _outgoingConnectingEdges = MGLUtil.getOutgoingConnectingEdges(node);
                Set<Edge> _incomingConnectingEdges = MGLUtil.getIncomingConnectingEdges(node);
                return Iterables.concat(_outgoingConnectingEdges, _incomingConnectingEdges);
            }
        };
        Set edges = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(nodes, (Functions.Function1)_function_1));
        Functions.Function1<Edge, Set<ModelElement>> _function_2 = new Functions.Function1<Edge, Set<ModelElement>>(){

            public Set<ModelElement> apply(Edge it) {
                return MGLUtil.getAllSubclasses((ModelElement)it);
            }
        };
        Set _set = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)edges, (Functions.Function1)_function_2), Edge.class));
        Iterables.addAll((Collection)edges, (Iterable)_set);
        final HashSet<Edge> result = new HashSet<Edge>();
        Consumer<Edge> _function_3 = new Consumer<Edge>(){

            @Override
            public void accept(final Edge edge) {
                boolean _not;
                Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                    public Boolean apply(Edge resultEdge) {
                        return MGLUtil.equalEdges(resultEdge, edge);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)result, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    result.add(edge);
                }
            }
        };
        edges.forEach(_function_3);
        this.usableEdgesCache.put(model, result);
        return result;
    }

    public Set<Enumeration> getUsableEnums(ContainingElement model) {
        boolean _not;
        Set<Enumeration> cachedResult = this.usableEnumsCache.get(model);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(cachedResult);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            return cachedResult;
        }
        Functions.Function1<mgl.Node, ModelElement> _function = new Functions.Function1<mgl.Node, ModelElement>(){

            public ModelElement apply(mgl.Node it) {
                return it;
            }
        };
        Set nodesAndEdges = IterableExtensions.toSet((Iterable)IterableExtensions.map(this.getUsableNodes(model), (Functions.Function1)_function));
        nodesAndEdges.addAll(this.getUsableEdges(model));
        Functions.Function1<ModelElement, EList<Attribute>> _function_1 = new Functions.Function1<ModelElement, EList<Attribute>>(){

            public EList<Attribute> apply(ModelElement it) {
                return it.getAttributes();
            }
        };
        Set result = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)nodesAndEdges, (Functions.Function1)_function_1)), Enumeration.class));
        this.usableEnumsCache.put(model, result);
        return result;
    }

    public Set<UserDefinedType> getUsableUserDefinedTypes(ContainingElement model) {
        boolean _not;
        Set<UserDefinedType> cachedResult = this.usableUserDefinedTypesCache.get(model);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(cachedResult);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            return cachedResult;
        }
        Functions.Function1<mgl.Node, Set<mgl.Node>> _function = new Functions.Function1<mgl.Node, Set<mgl.Node>>(){

            public Set<mgl.Node> apply(mgl.Node it) {
                return GeneratorUtils.this.getAllSuperNodes(it);
            }
        };
        Functions.Function1<mgl.Node, ModelElement> _function_1 = new Functions.Function1<mgl.Node, ModelElement>(){

            public ModelElement apply(mgl.Node it) {
                return it;
            }
        };
        Set nodesAndEdges = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(this.getUsableNodes(model, true), (Functions.Function1)_function), (Functions.Function1)_function_1));
        Functions.Function1<Edge, Iterable<Edge>> _function_2 = new Functions.Function1<Edge, Iterable<Edge>>(){

            public Iterable<Edge> apply(Edge it) {
                return Iterables.filter(GeneratorUtils.this.getAllSuperEdges(it), Edge.class);
            }
        };
        Iterables.addAll((Collection)nodesAndEdges, (Iterable)IterableExtensions.flatMap(this.getUsableEdges(model), (Functions.Function1)_function_2));
        Functions.Function1<ModelElement, EList<Attribute>> _function_3 = new Functions.Function1<ModelElement, EList<Attribute>>(){

            public EList<Attribute> apply(ModelElement it) {
                return it.getAttributes();
            }
        };
        Functions.Function1<ComplexAttribute, Type> _function_4 = new Functions.Function1<ComplexAttribute, Type>(){

            public Type apply(ComplexAttribute it) {
                return it.getType();
            }
        };
        final Set resultCandidates = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)nodesAndEdges, (Functions.Function1)_function_3), ComplexAttribute.class), (Functions.Function1)_function_4), UserDefinedType.class));
        ModelElement currentContainingElement = (ModelElement)model;
        while (currentContainingElement != null) {
            Functions.Function1<ComplexAttribute, Type> _function_5 = new Functions.Function1<ComplexAttribute, Type>(){

                public Type apply(ComplexAttribute it) {
                    return it.getType();
                }
            };
            resultCandidates.addAll(IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)currentContainingElement.getAttributes(), ComplexAttribute.class), (Functions.Function1)_function_5), UserDefinedType.class)));
            currentContainingElement = MGLUtil.extend(currentContainingElement);
        }
        HashSet newlyAddedUserDefinedTypes = new HashSet(resultCandidates);
        while (!IterableExtensions.isNullOrEmpty(newlyAddedUserDefinedTypes)) {
            final HashSet newUserDefinedTypes = new HashSet();
            for (UserDefinedType newlyAddedUserDefinedType : newlyAddedUserDefinedTypes) {
                Functions.Function1<ComplexAttribute, Type> _function_5 = new Functions.Function1<ComplexAttribute, Type>(){

                    public Type apply(ComplexAttribute it) {
                        return it.getType();
                    }
                };
                Consumer<UserDefinedType> _function_6 = new Consumer<UserDefinedType>(){

                    @Override
                    public void accept(final UserDefinedType candidate) {
                        boolean _not;
                        Functions.Function1<UserDefinedType, Boolean> _function = new Functions.Function1<UserDefinedType, Boolean>(){

                            public Boolean apply(UserDefinedType resultCandidate) {
                                return MGLUtil.equalUserDefinedTypes(candidate, resultCandidate);
                            }
                        };
                        boolean _exists = IterableExtensions.exists((Iterable)resultCandidates, (Functions.Function1)_function);
                        boolean bl = _not = !_exists;
                        if (_not) {
                            newUserDefinedTypes.add(candidate);
                            resultCandidates.add(candidate);
                        }
                    }
                };
                Iterables.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)newlyAddedUserDefinedType.getAttributes(), ComplexAttribute.class), (Functions.Function1)_function_5), UserDefinedType.class).forEach(_function_6);
            }
            newlyAddedUserDefinedTypes = newUserDefinedTypes;
        }
        final HashSet<UserDefinedType> result = new HashSet<UserDefinedType>();
        Consumer<UserDefinedType> _function_5 = new Consumer<UserDefinedType>(){

            @Override
            public void accept(final UserDefinedType userDefinedType) {
                boolean _not;
                Functions.Function1<UserDefinedType, Boolean> _function = new Functions.Function1<UserDefinedType, Boolean>(){

                    public Boolean apply(UserDefinedType resultUserDefinedType) {
                        return MGLUtil.equalUserDefinedTypes(resultUserDefinedType, userDefinedType);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)result, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    result.add(userDefinedType);
                }
            }
        };
        resultCandidates.forEach(_function_5);
        this.usableUserDefinedTypesCache.put(model, result);
        return result;
    }

    public Set<UserDefinedType> getUsableUserDefinedTypes(ContainingElement model, boolean includeSuperTypes, boolean includeSubTypes) {
        Set<UserDefinedType> types = this.getUsableUserDefinedTypes(model);
        if (includeSuperTypes) {
            Functions.Function1<UserDefinedType, Iterable<UserDefinedType>> _function = new Functions.Function1<UserDefinedType, Iterable<UserDefinedType>>(){

                public Iterable<UserDefinedType> apply(UserDefinedType it) {
                    return Iterables.filter(MGLUtil.allSuperTypes((ModelElement)it), UserDefinedType.class);
                }
            };
            List superTypes = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(types, (Functions.Function1)_function));
            types.addAll(superTypes);
        }
        if (includeSubTypes) {
            Functions.Function1<UserDefinedType, Set<UserDefinedType>> _function_1 = new Functions.Function1<UserDefinedType, Set<UserDefinedType>>(){

                public Set<UserDefinedType> apply(UserDefinedType it) {
                    return MGLUtil.getAllSubTypes(it);
                }
            };
            List subTypes = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(types, (Functions.Function1)_function_1));
            types.addAll(subTypes);
        }
        final HashSet<UserDefinedType> result = new HashSet<UserDefinedType>();
        Consumer<UserDefinedType> _function_2 = new Consumer<UserDefinedType>(){

            @Override
            public void accept(final UserDefinedType userDefinedType) {
                boolean _not;
                Functions.Function1<UserDefinedType, Boolean> _function = new Functions.Function1<UserDefinedType, Boolean>(){

                    public Boolean apply(UserDefinedType resultUserDefinedType) {
                        return MGLUtil.equalUserDefinedTypes(resultUserDefinedType, userDefinedType);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)result, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    result.add(userDefinedType);
                }
            }
        };
        types.forEach(_function_2);
        return result;
    }

    public boolean addToMap(Map<String, List<GraphicalModelElement>> m, String paletteName, GraphicalModelElement me) {
        boolean _tripleEquals;
        boolean _xblockexpression = false;
        List<GraphicalModelElement> _get = m.get(paletteName);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            ArrayList _arrayList = new ArrayList();
            m.put(paletteName, _arrayList);
        }
        _xblockexpression = m.get(paletteName).add(me);
        return _xblockexpression;
    }

    public boolean hasPaletteCategory(ModelElement me) {
        Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation a) {
                return a.getName().equals("palette");
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)me.getAnnotations(), (Functions.Function1)_function));
        return _size > 0;
    }

    public Iterable<Attribute> allModelAttributes(mgl.GraphModel gm) {
        Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(EObject c) {
                return c instanceof Attribute;
            }
        };
        Functions.Function1<EObject, Attribute> _function_1 = new Functions.Function1<EObject, Attribute>(){

            public Attribute apply(EObject a) {
                return (Attribute)a;
            }
        };
        return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IteratorExtensions.toIterable((Iterator)gm.eResource().getAllContents()), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public String getIconNodeValue(ModelElement n) {
        String icon = "";
        EList annots = n.getAnnotations();
        for (Annotation annot : annots) {
            boolean _equals = annot.getName().equals("icon");
            if (!_equals) continue;
            icon = (String)annot.getValue().get(0);
        }
        if (n instanceof mgl.GraphModel) {
            return ((mgl.GraphModel)n).getIconPath();
        }
        return icon;
    }

    public boolean isPrime(mgl.Node n) {
        return this.isPrime(n, true);
    }

    public boolean isPrime(mgl.Node n, boolean includeParentNodes) {
        boolean _tripleNotEquals;
        if (n == null) {
            return false;
        }
        ReferencedType _retrievePrimeReference = MGLUtil.retrievePrimeReference(n, includeParentNodes);
        boolean bl = _tripleNotEquals = _retrievePrimeReference != null;
        if (_tripleNotEquals) {
            return true;
        }
        if (includeParentNodes && n.getExtends() != null) {
            return this.isPrime(n.getExtends(), includeParentNodes);
        }
        return false;
    }

    public boolean isCreateDisabled(ModelElement me) {
        return CincoUtil.isCreateDisabled(me);
    }

    protected String _primeType(ReferencedModelElement rme) {
        String _name = rme.getType().getName();
        return "Internal" + _name;
    }

    protected String _primeTypeElement(ReferencedModelElement rme) {
        return rme.getType().getName();
    }

    protected String _primeTypeElement(ReferencedEClass rme) {
        return rme.getType().getName();
    }

    protected String _primeType(ReferencedEClass rec) {
        return rec.getType().getName();
    }

    public EClass primeTypeEClass(mgl.Node n) {
        EClass _xblockexpression = null;
        ReferencedType prime = this.retrievePrimeReference(n);
        EClass _switchResult = null;
        boolean _matched = false;
        if (prime instanceof ReferencedEClass) {
            _matched = true;
            _switchResult = ((ReferencedEClass)prime).getType();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public ReferencedType retrievePrimeReference(mgl.Node n) {
        return MGLUtil.retrievePrimeReference(n);
    }

    public String primeName(mgl.Node n) {
        return this.retrievePrimeReference(n).getName();
    }

    public CharSequence primeFqTypeName(mgl.Node n) {
        CharSequence _xblockexpression = null;
        ReferencedType prime = this.retrievePrimeReference(n);
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (prime instanceof ReferencedEClass) {
            _matched = true;
            _switchResult = this.fqBeanName((EObject)((ReferencedEClass)prime).getType());
        }
        if (!_matched && prime instanceof ReferencedModelElement) {
            _matched = true;
            _switchResult = this.fqBeanName((EObject)((ReferencedModelElement)prime).getType());
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String primeTypeName(mgl.Node n) {
        String _xblockexpression = null;
        ReferencedType prime = this.retrievePrimeReference(n);
        String _switchResult = null;
        boolean _matched = false;
        if (prime instanceof ReferencedEClass) {
            _matched = true;
            _switchResult = ((ReferencedEClass)prime).getType().getName();
        }
        if (!_matched && prime instanceof ReferencedModelElement) {
            _matched = true;
            _switchResult = ((ReferencedModelElement)prime).getType().getName();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public String primeTypePackagePrefix(mgl.Node n) {
        String _xblockexpression = null;
        ReferencedType prime = this.retrievePrimeReference(n);
        String _switchResult = null;
        boolean _matched = false;
        if (prime instanceof ReferencedEClass) {
            _matched = true;
            _switchResult = ((ReferencedEClass)prime).getType().getEPackage().getNsPrefix();
        }
        if (!_matched && prime instanceof ReferencedModelElement) {
            _matched = true;
            _switchResult = this.getGraphModel((Type)((ReferencedModelElement)prime).getType()).getName().toLowerCase();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String _nsURI(ReferencedModelElement rem) {
        return MGLUtil.nsURI((Annotatable)MGLUtil.getMglModel(rem.getType()));
    }

    protected String _nsURI(ReferencedEClass refEClass) {
        return refEClass.getType().getEPackage().getNsURI();
    }

    public CharSequence addFeaturePrimeCode(mgl.Node n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new AddFeaturePrime");
        String _fuName = this.fuName((ModelElement)n);
        _builder.append(_fuName);
        _builder.append("(this)");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public boolean booleanWriteMethodCallPostCreate(ModelElement me) {
        Annotation annot = CincoUtil.findAnnotationPostCreate(me);
        return annot != null;
    }

    public String writeMethodCallPostCreate(ModelElement me) {
        Annotation annot = CincoUtil.findAnnotationPostCreate(me);
        if (annot != null) {
            String class_ = (String)annot.getValue().get(0);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("new ");
            _builder.append(class_);
            _builder.append("().postCreate((");
            CharSequence _fqBeanName = this.fqBeanName((EObject)me);
            _builder.append((Object)_fqBeanName);
            _builder.append(") modelCreate);");
            return _builder.toString();
        }
        return null;
    }

    public boolean booleanWriteMethodCallPreSave(ModelElement me) {
        return CincoUtil.findAnnotation(me, "preSave") != null || this._eventApiExtension.isEventEnabled(me) && EventEnum.PRE_SAVE.accepts(me);
    }

    public String writeMethodCallPreSave(ModelElement me, String gmName) {
        Annotation annot = CincoUtil.findAnnotation(me, "preSave");
        StringConcatenation _builder = new StringConcatenation();
        if (annot != null) {
            _builder.append("new ");
            String _head = (String)IterableExtensions.head((Iterable)annot.getValue());
            _builder.append(_head);
            _builder.append("().preSave(");
            _builder.append(gmName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        String _notifyCallJava = EventEnum.PRE_SAVE.getNotifyCallJava(me, new String[]{gmName});
        _builder.append(_notifyCallJava);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public boolean booleanWriteMethodCallPostSave(ModelElement me) {
        return CincoUtil.findAnnotation(me, "postSave") != null || this._eventApiExtension.isEventEnabled(me) && EventEnum.POST_SAVE.accepts(me);
    }

    public String writeMethodCallPostSave(ModelElement me, String gmName) {
        Annotation annot = CincoUtil.findAnnotation(me, "postSave");
        StringConcatenation _builder = new StringConcatenation();
        if (annot != null) {
            _builder.append("new ");
            String _head = (String)IterableExtensions.head((Iterable)annot.getValue());
            _builder.append(_head);
            _builder.append("().postSave(");
            _builder.append(gmName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        String _notifyCallJava = EventEnum.POST_SAVE.getNotifyCallJava(me, new String[]{gmName});
        _builder.append(_notifyCallJava);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public boolean booleanWriteMethodCallPreMove(ModelElement me) {
        return this._eventApiExtension.isEventEnabled(me) && EventEnum.PRE_MOVE.accepts(me);
    }

    public String writeMethodCallPreMove(ModelElement me, String meName, String targetContainerName, String xName, String yName) {
        return EventEnum.PRE_MOVE.getNotifyCallJava(me, new String[]{meName, targetContainerName, xName, yName});
    }

    public boolean booleanWriteMethodCallPostMove(ModelElement me) {
        return CincoUtil.findAnnotationPostMove(me) != null || this._eventApiExtension.isEventEnabled(me) && EventEnum.POST_MOVE.accepts(me);
    }

    public String writeMethodCallPostMove(ModelElement me, String meName, String sourceName, String targetName, String xName, String yName, String deltaXName, String deltaYName) {
        Annotation annot = CincoUtil.findAnnotationPostMove(me);
        StringConcatenation _builder = new StringConcatenation();
        if (annot != null) {
            _builder.append("new ");
            String _head = (String)IterableExtensions.head((Iterable)annot.getValue());
            _builder.append(_head);
            _builder.append("().postMove(");
            _builder.append(meName);
            _builder.append(", ");
            _builder.append(sourceName);
            _builder.append(", ");
            _builder.append(targetName);
            _builder.append(", ");
            _builder.append(xName);
            _builder.append(", ");
            _builder.append(yName);
            _builder.append(", ");
            _builder.append(deltaXName);
            _builder.append(", ");
            _builder.append(deltaYName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(xName);
        _builder_1.append(" - ");
        _builder_1.append(deltaXName);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append(yName);
        _builder_2.append(" - ");
        _builder_2.append(deltaYName);
        String _notifyCallJava = EventEnum.POST_MOVE.getNotifyCallJava(me, new String[]{meName, sourceName, _builder_1.toString(), _builder_2.toString()});
        _builder.append(_notifyCallJava);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public boolean booleanWriteMethodCallPreResize(ModelElement me) {
        return this._eventApiExtension.isEventEnabled(me) && EventEnum.PRE_RESIZE.accepts(me);
    }

    public String writeMethodCallPreResize(ModelElement me, String meName, String widthName, String heightName, String xName, String yName, String directionName) {
        return EventEnum.PRE_RESIZE.getNotifyCallJava(me, new String[]{meName, widthName, heightName, xName, yName, directionName});
    }

    public boolean booleanWriteMethodCallPostResize(ModelElement me) {
        return CincoUtil.findAnnotationPostResize(me) != null || this._eventApiExtension.isEventEnabled(me) && EventEnum.POST_RESIZE.accepts(me);
    }

    public String writeMethodCallPostResize(ModelElement me, String meName, String widthName, String heightName, String xName, String yName, String directionName) {
        Annotation annot = CincoUtil.findAnnotationPostResize(me);
        StringConcatenation _builder = new StringConcatenation();
        if (annot != null) {
            String postResizeClass = (String)IterableExtensions.head((Iterable)annot.getValue());
            _builder.newLineIfNotEmpty();
            _builder.append("new ");
            _builder.append(postResizeClass);
            _builder.append("().postResize(");
            _builder.append(meName);
            _builder.append(", ");
            _builder.append(widthName);
            _builder.append(", ");
            _builder.append(heightName);
            _builder.append(", ");
            _builder.append(xName);
            _builder.append(", ");
            _builder.append(yName);
            _builder.append(", ");
            _builder.append(directionName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        String _notifyCallJava = EventEnum.POST_RESIZE.getNotifyCallJava(me, new String[]{meName, widthName, heightName, xName, yName, directionName});
        _builder.append(_notifyCallJava);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public boolean booleanWriteMethodCallPostSelect(ModelElement me) {
        Annotation annot = CincoUtil.findAnnotationPostSelect(me);
        return annot != null;
    }

    public String writeMethodCallPostSelect(ModelElement me) {
        Annotation annot = CincoUtil.findAnnotationPostSelect(me);
        if (annot != null) {
            String class_ = (String)annot.getValue().get(0);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("new ");
            _builder.append(class_);
            _builder.append("().postSelect((");
            CharSequence _fqBeanName = this.fqBeanName((EObject)me);
            _builder.append((Object)_fqBeanName);
            _builder.append(")modelSelect);");
            return _builder.toString();
        }
        return null;
    }

    public boolean booleanWriteMethodCallDoubleClick(ModelElement me) {
        Annotation annot = CincoUtil.findAnnotationDoubleClick(me);
        return annot != null;
    }

    public String getName(ContainingElement ce) {
        String _switchResult = null;
        boolean _matched = false;
        if (ce instanceof mgl.GraphModel) {
            _matched = true;
            _switchResult = ((mgl.GraphModel)ce).getName();
        }
        if (!_matched && ce instanceof NodeContainer) {
            _matched = true;
            _switchResult = ((NodeContainer)ce).getName();
        }
        return _switchResult;
    }

    public CharSequence fqInternalName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".internal.");
        String _fuInternalName = this.fuInternalName(me);
        _builder.append(_fuInternalName);
        return _builder;
    }

    public CharSequence fqInternalFactoryName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".internal.InternalFactory");
        return _builder;
    }

    public CharSequence fqInternalPackageName(ModelElement me) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)me);
        _builder.append(_beanPackage);
        _builder.append(".internal.InternalPackage");
        return _builder;
    }

    public <T> Iterable<? extends T> iterable(T t) {
        List<T> _xifexpression = null;
        _xifexpression = t != null ? Collections.singletonList(t) : new ArrayList<T>();
        return _xifexpression;
    }

    public CharSequence toInternalElement(String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        _builder.append(varName);
        _builder.append(" instanceof ");
        String _name = IdentifiableElement.class.getName();
        _builder.append(_name);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(varName, "\t");
        _builder.append(" = ((");
        String _name_1 = IdentifiableElement.class.getName();
        _builder.append(_name_1, "\t");
        _builder.append(")");
        _builder.append(varName, "\t");
        _builder.append(").getInternalElement_();");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence toNonInternalElement(String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (");
        _builder.append(varName);
        _builder.append(" instanceof ");
        String _name = InternalIdentifiableElement.class.getName();
        _builder.append(_name);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(varName, "\t");
        _builder.append(" = ((");
        String _name_1 = InternalIdentifiableElement.class.getName();
        _builder.append(_name_1, "\t");
        _builder.append(")");
        _builder.append(varName, "\t");
        _builder.append(").getElement();");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public String getWizardLabel(mgl.GraphModel gm) {
        return this.getAnnotationValue((ModelElement)gm, "wizard", 0);
    }

    public String getWizardClass(mgl.GraphModel gm) {
        return this.getAnnotationValue((ModelElement)gm, "wizard", 1);
    }

    public String getAnnotationValue(ModelElement me, String annotationName, int valueIndex) {
        String _xblockexpression = null;
        Annotation _findAnnotation = CincoUtil.findAnnotation(me, annotationName);
        EList _value = null;
        if (_findAnnotation != null) {
            _value = _findAnnotation.getValue();
        }
        EList value = _value;
        int _xifexpression = 0;
        _xifexpression = value == null ? 0 : value.size();
        int valueSize = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = valueSize > valueIndex ? (String)value.get(valueIndex) : null;
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    public CharSequence ePackageName(mgl.GraphModel it) {
        StringConcatenation _builder = new StringConcatenation();
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getFileName(MGLUtil.getMglModel((ModelElement)it)).toLowerCase());
        _builder.append(_firstUpper);
        _builder.append("Package");
        return _builder;
    }

    public CharSequence fqEPackageName(mgl.GraphModel it) {
        StringConcatenation _builder = new StringConcatenation();
        String _beanPackage = this.beanPackage((Type)this.getGraphModel((Type)it));
        _builder.append(_beanPackage);
        _builder.append(".");
        CharSequence _ePackageName = this.ePackageName(it);
        _builder.append((Object)_ePackageName);
        return _builder;
    }

    public String fqBeanPath(ModelElement it) {
        String _string = this.fqBeanName((EObject)it).toString();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(".");
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/");
        return _string.replace((CharSequence)_builder, (CharSequence)_builder_1);
    }

    public String getFileName(MGLModel model) {
        Pattern pattern = Pattern.compile("[\\w\\-. ]+(?=.mgl$)");
        String uriString = "";
        URI modelResourceURI = model.eResource().getURI();
        String platformString = modelResourceURI.toPlatformString(true);
        uriString = platformString != null ? platformString : modelResourceURI.toFileString();
        Matcher matcher = pattern.matcher(uriString);
        boolean _find = matcher.find();
        if (_find) {
            return matcher.group();
        }
        String _package = model.getPackage();
        String _plus = "The name of the MGL model \"" + _package;
        String _plus_1 = String.valueOf(_plus) + "\" could not be resolved properly.";
        throw new IllegalStateException(_plus_1);
    }

    public String fuCName(EObject me) {
        if (me instanceof Type) {
            return this._fuCName((Type)me);
        }
        if (me instanceof ContainingElement) {
            return this._fuCName((ContainingElement)me);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(me).toString());
    }

    public CharSequence projectName(Annotatable gm) {
        if (gm instanceof mgl.GraphModel) {
            return this._projectName((mgl.GraphModel)gm);
        }
        if (gm instanceof MGLModel) {
            return this._projectName((MGLModel)gm);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(gm).toString());
    }

    public CharSequence packageName(Annotatable gm) {
        if (gm instanceof mgl.GraphModel) {
            return this._packageName((mgl.GraphModel)gm);
        }
        if (gm instanceof ModelElement) {
            return this._packageName((ModelElement)gm);
        }
        if (gm instanceof MGLModel) {
            return this._packageName((MGLModel)gm);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(gm).toString());
    }

    public CharSequence fqBeanName(EObject me) {
        if (me instanceof ModelElement) {
            return this._fqBeanName((ModelElement)me);
        }
        if (me instanceof MGLModel) {
            return this._fqBeanName((MGLModel)me);
        }
        if (me instanceof Type) {
            return this._fqBeanName((Type)me);
        }
        if (me instanceof ContainingElement) {
            return this._fqBeanName((ContainingElement)me);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(me).toString());
    }

    public String primeType(ReferencedType rec) {
        if (rec instanceof ReferencedEClass) {
            return this._primeType((ReferencedEClass)rec);
        }
        if (rec instanceof ReferencedModelElement) {
            return this._primeType((ReferencedModelElement)rec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rec).toString());
    }

    public String primeTypeElement(ReferencedType rme) {
        if (rme instanceof ReferencedEClass) {
            return this._primeTypeElement((ReferencedEClass)rme);
        }
        if (rme instanceof ReferencedModelElement) {
            return this._primeTypeElement((ReferencedModelElement)rme);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(rme).toString());
    }

    public String nsURI(ReferencedType refEClass) {
        if (refEClass instanceof ReferencedEClass) {
            return this._nsURI((ReferencedEClass)refEClass);
        }
        if (refEClass instanceof ReferencedModelElement) {
            return this._nsURI((ReferencedModelElement)refEClass);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(refEClass).toString());
    }
}

