/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.dependency;

import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mgl.MGLModel;

public class DependencyNode<T> {
    private T path;
    private Set<T> dependsOf;
    private GeneratorUtils generatorUtils;

    public Set<T> getDependsOf() {
        return this.dependsOf;
    }

    public DependencyNode(T path) {
        this.path = path;
        this.dependsOf = new HashSet<T>();
        this.generatorUtils = GeneratorUtils.getInstance();
    }

    public boolean dependsOf(T path) {
        return this.dependsOf.add(path);
    }

    public boolean removeDependency(T path) {
        if (path instanceof MGLModel) {
            for (T mglModel : this.dependsOf) {
                if (!(mglModel instanceof MGLModel) || !this.generatorUtils.getFileName((MGLModel)mglModel).contentEquals(this.generatorUtils.getFileName((MGLModel)path)) || !((MGLModel)mglModel).getPackage().contentEquals(((MGLModel)path).getPackage())) continue;
                return this.dependsOf.remove(mglModel);
            }
            return false;
        }
        return this.dependsOf.remove(path);
    }

    public T getPath() {
        return this.path;
    }

    public boolean addDependencies(Collection<T> strings) {
        return this.dependsOf.addAll(strings);
    }

    public String toString() {
        return "DependencyNode [path=" + this.path + "]";
    }
}

