/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils.dependency;

import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.dependency.DependencyNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import mgl.Edge;
import mgl.MGLModel;
import mgl.Node;
import mgl.Type;

public class DependencyGraph<T> {
    HashMap<T, DependencyNode<T>> nodes = new HashMap();

    public void addNode(DependencyNode<T> node) {
        this.nodes.put(node.getPath(), node);
    }

    public DependencyGraph<T> createGraph(Iterable<DependencyNode<T>> nodes) {
        DependencyGraph dpg = new DependencyGraph();
        nodes.forEach(node -> dpg.addNode((DependencyNode)node));
        return dpg;
    }

    public Stack<T> topSort() {
        Stack<Object> stck = new Stack<Object>();
        ArrayList<T> toVisit = new ArrayList<T>();
        for (T key : this.nodes.keySet()) {
            if (this.nodes.get(key).getDependsOf().size() == 0) {
                stck.push(key);
                continue;
            }
            toVisit.add(key);
        }
        while (!toVisit.isEmpty()) {
            ArrayList toRemove = new ArrayList();
            Object lastCurrent = null;
            for (Object current : toVisit) {
                lastCurrent = current;
                DependencyNode dn = this.findDependencyNodeOfObject(current);
                for (Object e : stck) {
                    dn.removeDependency(e);
                }
                if (dn.getDependsOf().size() != 0) continue;
                stck.push(current);
                toRemove.add(current);
            }
            if (!toRemove.isEmpty()) {
                toVisit.removeAll(toRemove);
                continue;
            }
            throw new RuntimeException(String.format("Could not resolve Dependencies, Dependency Graph contains cycles, including '%s'.", lastCurrent));
        }
        return stck;
    }

    private DependencyNode<T> findDependencyNodeOfObject(T obj) {
        if (obj instanceof MGLModel) {
            for (T mglModel : this.nodes.keySet()) {
                if (!(mglModel instanceof MGLModel) || !MGLUtil.equalMGLModels((MGLModel)mglModel, (MGLModel)obj)) continue;
                return this.nodes.get(mglModel);
            }
            return null;
        }
        if (obj instanceof Node) {
            for (T node : this.nodes.keySet()) {
                if (!(node instanceof Node) || !MGLUtil.equalModelElement((Type)((Node)node), (Type)((Node)obj))) continue;
                return this.nodes.get(node);
            }
            return null;
        }
        if (obj instanceof Edge) {
            for (T edge : this.nodes.keySet()) {
                if (!(edge instanceof Edge) || !MGLUtil.equalModelElement((Type)((Edge)edge), (Type)((Edge)obj))) continue;
                return this.nodes.get(edge);
            }
            return null;
        }
        return this.nodes.get(obj);
    }

    public void addNodes(List<DependencyNode<T>> nodes) {
        nodes.forEach(n -> this.addNode((DependencyNode<T>)n));
    }
}

