/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public class URIHandler
extends URIHandlerImpl.PlatformSchemeAware {
    EPackage ePack = null;
    HashMap<String, String> uriMap = null;

    public URIHandler(EPackage ePack) {
        this.ePack = ePack;
        this.uriMap = new HashMap();
        for (EClassifier eClassifier : ePack.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EClass superType : eClass.getESuperTypes()) {
                if (ePack.eContents().contains((Object)superType)) continue;
                String superTypeURIFragment = superType.eResource().getURIFragment((EObject)superType);
                String from = superType.eResource().getURI() + "#" + superTypeURIFragment;
                String to = String.valueOf(superType.getEPackage().getNsURI()) + "#" + superTypeURIFragment;
                this.uriMap.put(from, to);
            }
        }
    }

    public URI deresolve(URI uri) {
        URI nURI = null;
        if (uri.isPlatform()) {
            String uri2 = this.uriMap.get(uri.toString());
            nURI = uri2 != null ? URI.createURI((String)uri2) : super.deresolve(uri);
        }
        if (nURI == null) {
            nURI = super.deresolve(uri);
        }
        return nURI;
    }
}

