/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PluginXMLEditor {
    public static Document openPluginXMLDocument(IProject project) {
        Document _xblockexpression = null;
        IFile pluginXMLFile = project.getFile("plugin.xml");
        _xblockexpression = PluginXMLEditor.openXMLDocument(pluginXMLFile);
        return _xblockexpression;
    }

    public static Document openXMLDocument(IFile pluginXMLFile) {
        try {
            Document _xifexpression = null;
            boolean _exists = pluginXMLFile.exists();
            if (_exists) {
                Document _xblockexpression = null;
                InputStream pluginXMLStream = pluginXMLFile.getContents();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                _xifexpression = _xblockexpression = builder.parse(pluginXMLStream);
            } else {
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                _xifexpression = PluginXMLEditor.createEmptyPluginXML(pluginXMLFile, (IProgressMonitor)_nullProgressMonitor);
            }
            return _xifexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static Document createEmptyPluginXML(IFile pluginXMLFile, IProgressMonitor monitor) {
        try {
            Document _xblockexpression = null;
            String _pluginXMLBody = PluginXMLEditor.getPluginXMLBody();
            StringInputStream _stringInputStream = new StringInputStream(_pluginXMLBody);
            pluginXMLFile.setContents((InputStream)_stringInputStream, true, true, monitor);
            _xblockexpression = PluginXMLEditor.openXMLDocument(pluginXMLFile);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getPluginXMLBody() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<?eclipse version=\"3.0\"?>");
        _builder.newLine();
        _builder.append("<plugin>");
        _builder.newLine();
        _builder.append("</plugin>");
        _builder.newLine();
        return _builder.toString();
    }

    public static Element addExtension(Document pluginXML, String name) {
        Element _xblockexpression = null;
        Element root = pluginXML.getDocumentElement();
        Element _xtrycatchfinallyexpression = null;
        try {
            Element _xblockexpression_1 = null;
            Element element = pluginXML.createElement("extension");
            Attr point = pluginXML.createAttribute("point");
            point.setNodeValue(name);
            element.setAttributeNode(point);
            root.appendChild(element);
            _xtrycatchfinallyexpression = _xblockexpression_1 = element;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                throw new RuntimeException("Could Not add Extension", e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    public static Attr addAttribute(Element element, String name, String value) {
        Attr _xblockexpression = null;
        Attr attribute = element.getOwnerDocument().createAttribute(name);
        attribute.setValue(value);
        _xblockexpression = element.setAttributeNode(attribute);
        return _xblockexpression;
    }

    public static Element addSubElement(Element element, String name) {
        Element _xblockexpression = null;
        Element subElement = element.getOwnerDocument().createElement(name);
        element.appendChild(subElement);
        _xblockexpression = subElement;
        return _xblockexpression;
    }

    public static void save(Document pluginXML, IProject project, IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream _byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(_byteArrayOutputStream);
            Transformer _newTransformer = TransformerFactory.newInstance().newTransformer();
            DOMSource _dOMSource = new DOMSource(pluginXML);
            _newTransformer.transform(_dOMSource, result);
            IFile pluginXMLFile = project.getFile("plugin.xml");
            OutputStream _outputStream = result.getOutputStream();
            String _string = ((ByteArrayOutputStream)_outputStream).toString(StandardCharsets.UTF_8.name());
            StringInputStream stream = new StringInputStream(_string);
            boolean _exists = pluginXMLFile.exists();
            if (_exists) {
                pluginXMLFile.setContents((InputStream)stream, true, true, monitor);
            } else {
                pluginXMLFile.create((InputStream)stream, true, monitor);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

