/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.util.xapi.ResourceExtension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class PathValidator {
    public static boolean isRelativePath(String path) {
        URI uri = URI.createURI((String)path, (boolean)true);
        return uri.isRelative();
    }

    public static String checkPath(EObject object, String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Resource res = object.eResource();
        URI uri = URI.createURI((String)path, (boolean)true);
        if (uri.isPlatformResource()) {
            return PathValidator.checkPlatformResourceURI(uri, root);
        }
        if (uri.isPlatformPlugin()) {
            return PathValidator.checkPlatformPluginURI(uri);
        }
        String fileExists = PathValidator.checkFileExists(PathValidator.getFile(path, root, res));
        if (!fileExists.isEmpty()) {
            String folderExists = PathValidator.checkFolderExists(PathValidator.getFolder(path, root, res));
            if (!folderExists.isEmpty()) {
                return String.valueOf(fileExists) + folderExists;
            }
            return folderExists;
        }
        return fileExists;
    }

    public static URI getURIForString(EObject object, String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Resource res = object.eResource();
        URI uri = URI.createURI((String)path, (boolean)true);
        String retval = null;
        if (uri.isPlatformResource() && ((retval = PathValidator.checkPlatformResourceURI(uri, root)) == null || retval.isEmpty())) {
            return uri;
        }
        if (uri.isPlatformPlugin()) {
            retval = PathValidator.checkPlatformPluginURI(uri);
            if (retval == null || retval.isEmpty()) {
                return uri;
            }
        } else {
            IFile resource = PathValidator.getFile(path, root, res);
            if (!resource.exists()) {
                resource = PathValidator.getFolder(path, root, res);
            }
            if (resource.exists()) {
                return PathValidator.getURI((IResource)resource);
            }
        }
        return null;
    }

    public static URL getURLForString(EObject object, String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Resource res = object.eResource();
        URI uri = URI.createURI((String)path, (boolean)true);
        String retval = null;
        try {
            if (uri.isPlatformResource()) {
                retval = PathValidator.checkPlatformResourceURI(uri, root);
                if (retval == null || retval.isEmpty()) {
                    IResource member = root.findMember(uri.toPlatformString(true));
                    return member.getLocationURI().toURL();
                }
            } else if (uri.isPlatformPlugin()) {
                retval = PathValidator.checkPlatformPluginURI(uri);
                if (retval == null || retval.isEmpty()) {
                    IResource resource = root.findMember(uri.toPlatformString(true));
                    return resource.getLocationURI().toURL();
                }
            } else {
                retval = PathValidator.checkRelativePath(path, root, res);
                if (retval == null || retval.isEmpty()) {
                    return PathValidator.pathToURL(res.getURI(), path, root, res);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getBundleID(URI uri) {
        URI trimmed = null;
        if (uri.isPlatformPlugin() || uri.isPlatformResource()) {
            trimmed = URI.createURI((String)uri.toPlatformString(true));
        }
        if (uri.isRelative()) {
            trimmed = uri;
        }
        if (uri.isPlatform()) {
            trimmed = uri.deresolve(URI.createURI((String)"platform:/"));
        }
        if (trimmed != null) {
            return trimmed.segment(0);
        }
        throw new RuntimeException("The uri: \"" + uri + "\" could not be recognized");
    }

    private static String checkPlatformResourceURI(URI uri, IWorkspaceRoot root) {
        IResource res = root.findMember(uri.toPlatformString(true));
        if (res == null || !(res instanceof IFile)) {
            return "The specified file does not exists.";
        }
        return "";
    }

    private static String checkPlatformPluginURI(URI uri) {
        try {
            URL find = FileLocator.find((URL)new URL(uri.toString()));
            URL fileUrl = FileLocator.toFileURL((URL)find);
            File file = new File(fileUrl.getFile());
            if (!file.exists()) {
                return "The specified plugin files does not exist";
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String checkRelativePath(String path, IWorkspaceRoot root, Resource res) {
        IProject p;
        IFile file;
        IPath fromOSString;
        IFile member;
        if (path != null && path.isEmpty()) {
            return "No path specified";
        }
        URI uri = res.getURI();
        if (uri.isFile() ? (member = root.getFileForLocation(fromOSString = Path.fromOSString((String)uri.toFileString()))) != null && !(file = (p = member.getProject()).getFile(path)).exists() : !(file = PathValidator.handlePlatformUri(path, uri, root)).exists()) {
            return "The specified file: \"" + path + "\" does not exists.";
        }
        return "";
    }

    private static String checkFileExists(IFile file) {
        if (!file.exists()) {
            return "The specified file: \"" + file.getFullPath() + "\" does not exist.";
        }
        return "";
    }

    private static String checkFolderExists(IFolder folder) {
        if (!folder.exists()) {
            return "The specified folder: \"" + folder.getFullPath() + "\" does not exist.";
        }
        return "";
    }

    private static URI getURI(IResource file) {
        if (!file.exists()) {
            return null;
        }
        return URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
    }

    private static URL pathToURL(URI resURI, String path, IWorkspaceRoot root, Resource res) {
        if (path != null && path.isEmpty()) {
            return null;
        }
        IFile file = null;
        URI uri = res.getURI();
        if (uri.isFile()) {
            file = PathValidator.handleFileUri(path, uri, root);
        } else {
            file = PathValidator.handlePlatformUri(path, uri, root);
            if (!file.exists()) {
                return null;
            }
        }
        try {
            return file.getLocationURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IFile handlePlatformUri(String path, URI uri, IWorkspaceRoot root) {
        IProject p = root.getFile((IPath)new Path(uri.toPlatformString(true))).getProject();
        IFile file = p.getFile(path);
        return file;
    }

    private static IFile handleFileUri(String path, URI uri, IWorkspaceRoot root) {
        IProject p;
        IFile file = null;
        IPath fromOSString = Path.fromOSString((String)uri.toFileString());
        IFile member = root.getFileForLocation(fromOSString);
        if (member != null && !(file = (p = member.getProject()).getFile(path)).exists()) {
            return null;
        }
        return file;
    }

    private static IFile getFile(String path, IWorkspaceRoot root, Resource res) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        IFile resFile = null;
        resFile = res.getURI().isPlatform() ? root.getFile((IPath)new Path(res.getURI().toPlatformString(true))) : root.getFileForLocation(Path.fromOSString((String)res.getURI().path()));
        URI uri = URI.createURI((String)path);
        if (uri.isPlatform()) {
            return root.getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return resFile.getProject().getFile(path);
    }

    private static IFolder getFolder(String path, IWorkspaceRoot root, Resource res) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        IFile resFile = null;
        resFile = res.getURI().isPlatform() ? root.getFile((IPath)new Path(res.getURI().toPlatformString(true))) : root.getFileForLocation(Path.fromOSString((String)res.getURI().path()));
        URI uri = URI.createURI((String)path);
        if (uri.isPlatform()) {
            return root.getFolder((IPath)new Path(uri.toPlatformString(true)));
        }
        return resFile.getProject().getFolder(path);
    }

    public static boolean checkSameProjects(EObject eObj, String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Resource res = eObj.eResource();
        ResourceExtension reEx = new ResourceExtension();
        IFile importedFile = PathValidator.getFile(path, root, res);
        IProject importedProject = importedFile.getProject();
        return importedProject != null && importedProject.equals((Object)reEx.getFile(res).getProject());
    }

    public static String getRelativePath(String path, IProject project) {
        String projectSymbolicName = ProjectCreator.getProjectSymbolicName(project).replace(".", "\\.");
        String regex = "\\/" + projectSymbolicName + "\\/(.+\\.mgl)$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        regex = "^platform:\\/resource(\\/[a-zA-Z0-9_\\-\\.]+\\/.+\\.mgl)$";
        pattern = Pattern.compile(regex);
        matcher = pattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return path;
    }
}

