/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String RESOURCE_BUNDLE_SUFFIX = ".messages";
    private static HashMap<?, Messages> cache = new HashMap();
    private ResourceBundle resourceBundle;

    private Messages(String resourceBundle) {
        this.resourceBundle = ResourceBundle.getBundle(resourceBundle);
    }

    public static Messages resp(String resourceBundle) {
        return new Messages(resourceBundle);
    }

    public static Messages resp(Class<?> cls) {
        Messages instance = cache.get(cls);
        return instance != null ? instance : new Messages(String.valueOf(cls.getPackage().getName()) + RESOURCE_BUNDLE_SUFFIX);
    }

    public static Messages resp(Object object) {
        Messages instance = cache.get(object.getClass());
        return instance != null ? instance : new Messages(String.valueOf(object.getClass().getPackage().getName()) + RESOURCE_BUNDLE_SUFFIX);
    }

    public String format(String key, Object[] args) {
        return MessageFormat.format(this.get(key), args);
    }

    public String get(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }
}

