/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.core.utils.dependency.DependencyGraph;
import de.jabc.cinco.meta.core.utils.dependency.DependencyNode;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.plugin.event.api.util.EventApiExtension;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.BoundedConstraint;
import mgl.ComplexAttribute;
import mgl.ContainingElement;
import mgl.DefaultValueOverride;
import mgl.EDataTypeType;
import mgl.Edge;
import mgl.EdgeElementConnection;
import mgl.GraphModel;
import mgl.GraphicalElementContainment;
import mgl.GraphicalModelElement;
import mgl.Import;
import mgl.IncomingEdgeElementConnection;
import mgl.MGLModel;
import mgl.MglFactory;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.OutgoingEdgeElementConnection;
import mgl.PrimitiveAttribute;
import mgl.ReferencedModelElement;
import mgl.ReferencedType;
import mgl.Type;
import mgl.UserDefinedType;
import mgl.Wildcard;
import mgl.impl.MglFactoryImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import productDefinition.CincoProduct;
import style.Image;
import style.Styles;

public class MGLUtil {
    @Extension
    private static GeneratorUtils _generatorUtils = GeneratorUtils.getInstance();
    @Extension
    private static EventApiExtension _eventApiExtension = new EventApiExtension();
    public static Map<MGLModel, CincoProduct> mglModelCpdMap = new HashMap<MGLModel, CincoProduct>();

    public static Set<MGLModel> prepareMglModels(Set<MGLModel> mglModels) {
        for (MGLModel mglModel : mglModels) {
            EList _graphModels = mglModel.getGraphModels();
            for (GraphModel graphModel : _graphModels) {
                MGLUtil.handleWildcardContainments((ContainingElement)graphModel);
            }
            Iterable _filter = Iterables.filter((Iterable)mglModel.getNodes(), NodeContainer.class);
            for (NodeContainer nc : _filter) {
                MGLUtil.handleWildcardContainments((ContainingElement)nc);
            }
        }
        for (MGLModel mglModel_1 : mglModels) {
            EList _nodes = mglModel_1.getNodes();
            for (Node node : _nodes) {
                MGLUtil.handleWildcardConnections(node);
            }
        }
        for (MGLModel mglModel_2 : mglModels) {
            MGLUtil.inheritAllConnectionConstraints(mglModel_2);
            MGLUtil.inheritAllContainmentConstraints(mglModel_2);
        }
        return mglModels;
    }

    public static void handleWildcardConnections(Node node) {
        EList _incomingWildcards = node.getIncomingWildcards();
        for (Wildcard incomingWildcard : _incomingWildcards) {
            int _lowerBound = incomingWildcard.getLowerBound();
            int _upperBound = incomingWildcard.getUpperBound();
            MGLModel _mglModel = MGLUtil.mglModel(incomingWildcard);
            EList _edges = null;
            if (_mglModel != null) {
                _edges = _mglModel.getEdges();
            }
            MGLUtil.addEdgesAsIncomingConnection(node, _lowerBound, _upperBound, (Edge[])Conversions.unwrapArray((Object)_edges, Edge.class));
        }
        EList _outgoingWildcards = node.getOutgoingWildcards();
        for (Wildcard outgoingWildcard : _outgoingWildcards) {
            int _lowerBound_1 = outgoingWildcard.getLowerBound();
            int _upperBound_1 = outgoingWildcard.getUpperBound();
            MGLModel _mglModel_1 = MGLUtil.mglModel(outgoingWildcard);
            EList _edges_1 = null;
            if (_mglModel_1 != null) {
                _edges_1 = _mglModel_1.getEdges();
            }
            MGLUtil.addEdgesAsOutgoingConnection(node, _lowerBound_1, _upperBound_1, (Edge[])Conversions.unwrapArray((Object)_edges_1, Edge.class));
        }
    }

    public static void inheritAllConnectionConstraints(MGLModel mglModel) {
        EList _nodes = mglModel.getNodes();
        for (Node n : _nodes) {
            Map.Entry<List<IncomingEdgeElementConnection>, List<OutgoingEdgeElementConnection>> inheritedConnectionConstraints = MGLUtil.getInheritedConnectionConstraints(n);
            ArrayList copiedIncoming = MGLUtil.copyConnectionConstraints((Iterable)inheritedConnectionConstraints.getKey());
            ArrayList copiedOutgoing = MGLUtil.copyConnectionConstraints((Iterable)inheritedConnectionConstraints.getValue());
            EcoreUtil.deleteAll((Collection)n.getIncomingEdgeConnections(), (boolean)false);
            EList _incomingEdgeConnections = n.getIncomingEdgeConnections();
            Iterable _filter = Iterables.filter(copiedIncoming, IncomingEdgeElementConnection.class);
            Iterables.addAll((Collection)_incomingEdgeConnections, (Iterable)_filter);
            EcoreUtil.deleteAll((Collection)n.getOutgoingEdgeConnections(), (boolean)false);
            EList _outgoingEdgeConnections = n.getOutgoingEdgeConnections();
            Iterable _filter_1 = Iterables.filter(copiedOutgoing, OutgoingEdgeElementConnection.class);
            Iterables.addAll((Collection)_outgoingEdgeConnections, (Iterable)_filter_1);
        }
    }

    public static void inheritAllContainmentConstraints(MGLModel mglModel) {
        Iterable _filter = Iterables.filter((Iterable)mglModel.getNodes(), NodeContainer.class);
        EList _graphModels = mglModel.getGraphModels();
        Iterable _plus = Iterables.concat((Iterable)_filter, (Iterable)_graphModels);
        for (EObject containingElement : _plus) {
            List<GraphicalElementContainment> inheritedConnectionConstraints = MGLUtil.getInheritedContainmentConstraints((ContainingElement)containingElement);
            ArrayList<GraphicalElementContainment> copiedConstraints = MGLUtil.copyContainmentConstraints(inheritedConnectionConstraints);
            EcoreUtil.deleteAll((Collection)((ContainingElement)containingElement).getContainableElements(), (boolean)true);
            EList _containableElements = ((ContainingElement)containingElement).getContainableElements();
            Iterables.addAll((Collection)_containableElements, copiedConstraints);
        }
    }

    public static <T extends EdgeElementConnection> ArrayList<T> copyConnectionConstraints(Iterable<T> elementConnectionsToCopy) {
        ArrayList<Object> result = new ArrayList<Object>();
        MglFactory mglFactory = MglFactoryImpl.init();
        for (EdgeElementConnection elementConnectionToCopy : elementConnectionsToCopy) {
            boolean _tripleEquals;
            EObject _eContainer = elementConnectionToCopy.eContainer();
            boolean bl = _tripleEquals = _eContainer == null;
            if (_tripleEquals) {
                result.add(elementConnectionToCopy);
                continue;
            }
            Object newElementConnection = null;
            newElementConnection = elementConnectionToCopy instanceof IncomingEdgeElementConnection ? mglFactory.createIncomingEdgeElementConnection() : mglFactory.createOutgoingEdgeElementConnection();
            EList _connectingEdges = newElementConnection.getConnectingEdges();
            EList _connectingEdges_1 = elementConnectionToCopy.getConnectingEdges();
            Iterables.addAll((Collection)_connectingEdges, (Iterable)_connectingEdges_1);
            newElementConnection.setUpperBound(elementConnectionToCopy.getUpperBound());
            newElementConnection.setLowerBound(elementConnectionToCopy.getLowerBound());
            result.add(newElementConnection);
        }
        return result;
    }

    public static ArrayList<GraphicalElementContainment> copyContainmentConstraints(Iterable<GraphicalElementContainment> containmentConstraintsToCopy) {
        ArrayList<GraphicalElementContainment> result = new ArrayList<GraphicalElementContainment>();
        MglFactory mglFactory = MglFactoryImpl.init();
        for (GraphicalElementContainment containmentConstraintToCopy : containmentConstraintsToCopy) {
            GraphicalElementContainment newContainmentConstraint = mglFactory.createGraphicalElementContainment();
            EList _types = newContainmentConstraint.getTypes();
            EList _types_1 = containmentConstraintToCopy.getTypes();
            Iterables.addAll((Collection)_types, (Iterable)_types_1);
            newContainmentConstraint.setUpperBound(containmentConstraintToCopy.getUpperBound());
            newContainmentConstraint.setLowerBound(containmentConstraintToCopy.getLowerBound());
            result.add(newContainmentConstraint);
        }
        return result;
    }

    public static Map.Entry<List<IncomingEdgeElementConnection>, List<OutgoingEdgeElementConnection>> getInheritedConnectionConstraints(final Node node) {
        boolean _tripleNotEquals;
        ArrayList _arrayList = new ArrayList();
        ArrayList _arrayList_1 = new ArrayList();
        final AbstractMap.SimpleEntry<List<IncomingEdgeElementConnection>, List<OutgoingEdgeElementConnection>> inheritedConstraints = new AbstractMap.SimpleEntry<List<IncomingEdgeElementConnection>, List<OutgoingEdgeElementConnection>>(_arrayList, _arrayList_1);
        if (node == null) {
            return inheritedConstraints;
        }
        Node _extends = node.getExtends();
        boolean bl = _tripleNotEquals = _extends != null;
        if (_tripleNotEquals) {
            Functions.Function1<MGLModel, EList<Node>> _function = new Functions.Function1<MGLModel, EList<Node>>(){

                public EList<Node> apply(MGLModel it) {
                    return it.getNodes();
                }
            };
            Functions.Function1<Node, Boolean> _function_1 = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    return MGLUtil.equalNodes(it, node.getExtends());
                }
            };
            Map.Entry<List<IncomingEdgeElementConnection>, List<OutgoingEdgeElementConnection>> inheritedParentConstraints = MGLUtil.getInheritedConnectionConstraints((Node)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1));
            inheritedConstraints.getKey().addAll(MGLUtil.copyConnectionConstraints((Iterable)inheritedParentConstraints.getKey()));
            inheritedConstraints.getValue().addAll(MGLUtil.copyConnectionConstraints((Iterable)inheritedParentConstraints.getValue()));
        }
        Consumer<IncomingEdgeElementConnection> _function_2 = new Consumer<IncomingEdgeElementConnection>(){

            @Override
            public void accept(final IncomingEdgeElementConnection incomingConnectionConstraint) {
                Consumer<Edge> _function = new Consumer<Edge>(){

                    @Override
                    public void accept(final Edge edge) {
                        Consumer<IncomingEdgeElementConnection> _function = new Consumer<IncomingEdgeElementConnection>(){

                            @Override
                            public void accept(final IncomingEdgeElementConnection inheritedConstraint) {
                                Predicate<Edge> _function = new Predicate<Edge>(){

                                    @Override
                                    public boolean test(Edge it) {
                                        return MGLUtil.equalEdges(it, edge) && MGLUtil.isUpperBoundMoreRestricting((BoundedConstraint)incomingConnectionConstraint, (BoundedConstraint)inheritedConstraint);
                                    }
                                };
                                inheritedConstraint.getConnectingEdges().removeIf((Predicate)_function);
                            }
                        };
                        ((List)inheritedConstraints.getKey()).forEach(_function);
                    }
                };
                incomingConnectionConstraint.getConnectingEdges().forEach((Consumer)_function);
                ((List)inheritedConstraints.getKey()).add(incomingConnectionConstraint);
            }
        };
        node.getIncomingEdgeConnections().forEach((Consumer)_function_2);
        Consumer<OutgoingEdgeElementConnection> _function_3 = new Consumer<OutgoingEdgeElementConnection>(){

            @Override
            public void accept(final OutgoingEdgeElementConnection outgoingConnectionConstraint) {
                Consumer<Edge> _function = new Consumer<Edge>(){

                    @Override
                    public void accept(final Edge edge) {
                        Consumer<OutgoingEdgeElementConnection> _function = new Consumer<OutgoingEdgeElementConnection>(){

                            @Override
                            public void accept(final OutgoingEdgeElementConnection constraint) {
                                Predicate<Edge> _function = new Predicate<Edge>(){

                                    @Override
                                    public boolean test(Edge it) {
                                        return MGLUtil.equalEdges(it, edge) && MGLUtil.isUpperBoundMoreRestricting((BoundedConstraint)outgoingConnectionConstraint, (BoundedConstraint)constraint);
                                    }
                                };
                                constraint.getConnectingEdges().removeIf((Predicate)_function);
                            }
                        };
                        ((List)inheritedConstraints.getValue()).forEach(_function);
                    }
                };
                outgoingConnectionConstraint.getConnectingEdges().forEach((Consumer)_function);
                ((List)inheritedConstraints.getValue()).add(outgoingConnectionConstraint);
            }
        };
        node.getOutgoingEdgeConnections().forEach((Consumer)_function_3);
        Predicate<IncomingEdgeElementConnection> _function_4 = new Predicate<IncomingEdgeElementConnection>(){

            @Override
            public boolean test(IncomingEdgeElementConnection it) {
                return it.getUpperBound() == 0 && IterableExtensions.isNullOrEmpty((Iterable)it.getConnectingEdges());
            }
        };
        inheritedConstraints.getKey().removeIf(_function_4);
        Predicate<OutgoingEdgeElementConnection> _function_5 = new Predicate<OutgoingEdgeElementConnection>(){

            @Override
            public boolean test(OutgoingEdgeElementConnection it) {
                return it.getUpperBound() == 0 && IterableExtensions.isNullOrEmpty((Iterable)it.getConnectingEdges());
            }
        };
        inheritedConstraints.getValue().removeIf(_function_5);
        return inheritedConstraints;
    }

    public static List<GraphicalElementContainment> getInheritedContainmentConstraints(final ContainingElement containingElement) {
        final ArrayList<GraphicalElementContainment> inheritedConstraints = new ArrayList<GraphicalElementContainment>();
        if (containingElement == null) {
            return inheritedConstraints;
        }
        if (containingElement instanceof GraphModel) {
            boolean _tripleNotEquals;
            GraphModel _extends = ((GraphModel)containingElement).getExtends();
            boolean bl = _tripleNotEquals = _extends != null;
            if (_tripleNotEquals) {
                Functions.Function1<MGLModel, EList<GraphModel>> _function = new Functions.Function1<MGLModel, EList<GraphModel>>(){

                    public EList<GraphModel> apply(MGLModel it) {
                        return it.getGraphModels();
                    }
                };
                Functions.Function1<GraphModel, Boolean> _function_1 = new Functions.Function1<GraphModel, Boolean>(){

                    public Boolean apply(GraphModel it) {
                        return MGLUtil.equalGraphModels(it, ((GraphModel)containingElement).getExtends());
                    }
                };
                inheritedConstraints.addAll(MGLUtil.copyContainmentConstraints(MGLUtil.getInheritedContainmentConstraints((ContainingElement)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1))));
            }
        } else if (containingElement instanceof NodeContainer) {
            Node parentElement = ((NodeContainer)containingElement).getExtends();
            while (parentElement != null) {
                if (parentElement instanceof NodeContainer) {
                    Functions.Function1<MGLModel, EList<Node>> _function_2 = new Functions.Function1<MGLModel, EList<Node>>(){

                        public EList<Node> apply(MGLModel it) {
                            return it.getNodes();
                        }
                    };
                    Functions.Function1<Node, Boolean> _function_3 = new Functions.Function1<Node, Boolean>(){

                        public Boolean apply(Node it) {
                            return MGLUtil.equalNodes(it, ((NodeContainer)containingElement).getExtends());
                        }
                    };
                    Node _findFirst = (Node)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                    inheritedConstraints.addAll(MGLUtil.copyContainmentConstraints(MGLUtil.getInheritedContainmentConstraints((ContainingElement)((NodeContainer)_findFirst))));
                    parentElement = null;
                    continue;
                }
                parentElement = parentElement.getExtends();
            }
        }
        Consumer<GraphicalElementContainment> _function_2 = new Consumer<GraphicalElementContainment>(){

            @Override
            public void accept(final GraphicalElementContainment containmentConstraint) {
                Consumer<GraphicalModelElement> _function = new Consumer<GraphicalModelElement>(){

                    @Override
                    public void accept(final GraphicalModelElement type) {
                        Consumer<GraphicalElementContainment> _function = new Consumer<GraphicalElementContainment>(){

                            @Override
                            public void accept(final GraphicalElementContainment constraint) {
                                Predicate<GraphicalModelElement> _function = new Predicate<GraphicalModelElement>(){

                                    @Override
                                    public boolean test(GraphicalModelElement it) {
                                        return MGLUtil.equalModelElement((Type)it, (Type)type) && MGLUtil.isUpperBoundMoreRestricting((BoundedConstraint)containmentConstraint, (BoundedConstraint)constraint);
                                    }
                                };
                                constraint.getTypes().removeIf((Predicate)_function);
                            }
                        };
                        inheritedConstraints.forEach(_function);
                    }
                };
                containmentConstraint.getTypes().forEach((Consumer)_function);
                inheritedConstraints.add(containmentConstraint);
            }
        };
        containingElement.getContainableElements().forEach((Consumer)_function_2);
        Predicate<GraphicalElementContainment> _function_3 = new Predicate<GraphicalElementContainment>(){

            @Override
            public boolean test(GraphicalElementContainment it) {
                return it.getUpperBound() == 0 && IterableExtensions.isNullOrEmpty((Iterable)it.getTypes());
            }
        };
        inheritedConstraints.removeIf(_function_3);
        return inheritedConstraints;
    }

    public static boolean isUpperBoundMoreRestricting(BoundedConstraint it, BoundedConstraint comparee) {
        return !it.isNegative() && it.getUpperBound() >= 0 && it.getUpperBound() < comparee.getUpperBound();
    }

    public static boolean isUpperBoundLessRestricting(BoundedConstraint it, BoundedConstraint comparee) {
        return it.isNegative() && !comparee.isNegative() || it.getUpperBound() == -1 && comparee.getUpperBound() != -1 || it.getUpperBound() > comparee.getUpperBound();
    }

    public static boolean isLowerBoundMoreRestricting(BoundedConstraint it, BoundedConstraint comparee) {
        int _upperBound;
        int _lowerBound = it.getLowerBound();
        return _lowerBound > (_upperBound = it.getUpperBound());
    }

    public static boolean isLowerBoundLessRestricting(BoundedConstraint it, BoundedConstraint comparee) {
        return false;
    }

    public static boolean addNodesAsContainment(ContainingElement ce, int lower, int upper, Node ... nodes) {
        boolean _xblockexpression = false;
        GraphicalElementContainment gec = MglFactory.eINSTANCE.createGraphicalElementContainment();
        gec.setLowerBound(lower);
        gec.setUpperBound(upper);
        gec.getTypes().addAll(Arrays.asList(nodes));
        _xblockexpression = ce.getContainableElements().add((Object)gec);
        return _xblockexpression;
    }

    public static boolean addEdgesAsIncomingConnection(Node node, int lower, int upper, Edge ... edges) {
        boolean _xblockexpression = false;
        IncomingEdgeElementConnection ieec = MglFactory.eINSTANCE.createIncomingEdgeElementConnection();
        ieec.setLowerBound(lower);
        ieec.setUpperBound(upper);
        ieec.getConnectingEdges().addAll(Arrays.asList(edges));
        _xblockexpression = node.getIncomingEdgeConnections().add((Object)ieec);
        return _xblockexpression;
    }

    public static boolean addEdgesAsOutgoingConnection(Node node, int lower, int upper, Edge ... edges) {
        boolean _xblockexpression = false;
        OutgoingEdgeElementConnection ieec = MglFactory.eINSTANCE.createOutgoingEdgeElementConnection();
        ieec.setLowerBound(lower);
        ieec.setUpperBound(upper);
        ieec.getConnectingEdges().addAll(Arrays.asList(edges));
        _xblockexpression = node.getOutgoingEdgeConnections().add((Object)ieec);
        return _xblockexpression;
    }

    public static void handleWildcardContainments(ContainingElement containingElement) {
        EList _containmentWildcards = containingElement.getContainmentWildcards();
        for (Wildcard containmentWildcard : _containmentWildcards) {
            MGLUtil.addNodesAsContainment(containingElement, containmentWildcard.getLowerBound(), containmentWildcard.getUpperBound(), (Node[])Conversions.unwrapArray((Object)MGLUtil.mglModel(containmentWildcard).getNodes(), Node.class));
        }
    }

    public static Set<ContainingElement> getContainingElements(GraphModel graphModel) {
        Iterable _filter = Iterables.filter((Iterable)MGLUtil.getMglModel((ModelElement)graphModel).getNodes(), ContainingElement.class);
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_filter, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new GraphModel[]{graphModel}))));
    }

    public static Set<Node> getPossibleTargets(final Edge edge) {
        HashSet targets = new HashSet();
        Functions.Function1<MGLModel, EList<Node>> _function = new Functions.Function1<MGLModel, EList<Node>>(){

            public EList<Node> apply(MGLModel it) {
                return it.getNodes();
            }
        };
        Functions.Function1<Node, Boolean> _function_1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                    public Boolean apply(Edge it) {
                        return MGLUtil.equalEdges(it, edge);
                    }
                };
                return IterableExtensions.exists(MGLUtil.getIncomingConnectingEdges(it), (Functions.Function1)_function);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1);
        Iterables.addAll(targets, (Iterable)_filter);
        return IterableExtensions.toSet((Iterable)Iterables.filter(MGLUtil.removeDuplicateModelElements(targets), Node.class));
    }

    public static Set<Node> getAllPossibleTargets(Edge edge) {
        Functions.Function1<ModelElement, Edge> _function = new Functions.Function1<ModelElement, Edge>(){

            public Edge apply(ModelElement it) {
                return (Edge)it;
            }
        };
        Functions.Function1<Edge, Set<Node>> _function_1 = new Functions.Function1<Edge, Set<Node>>(){

            public Set<Node> apply(Edge it) {
                return MGLUtil.getPossibleTargets(it);
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)ListExtensions.map(MGLUtil.allSuperTypes((ModelElement)edge), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Set<Node> _possibleTargets = MGLUtil.getPossibleTargets(edge);
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_flatMap, _possibleTargets));
    }

    public static Set<Node> getPossibleSuccessors(Node node) {
        HashSet<Node> possibleSuccessors = new HashSet<Node>();
        Set<Edge> outgoingEdgess = MGLUtil.getOutgoingConnectingEdges(node);
        for (Edge edge : outgoingEdgess) {
            possibleSuccessors.addAll(MGLUtil.getPossibleTargets(edge));
        }
        return possibleSuccessors;
    }

    public static Set<Node> getPossiblePredecessors(Node node) {
        HashSet<Node> possiblePredecessors = new HashSet<Node>();
        Set<Edge> incomingEdges = MGLUtil.getIncomingConnectingEdges(node);
        for (Edge edge : incomingEdges) {
            possiblePredecessors.addAll(MGLUtil.getPossibleSources(edge));
        }
        return possiblePredecessors;
    }

    public static Set<Node> getPossibleSources(final Edge edge) {
        Functions.Function1<MGLModel, EList<Node>> _function = new Functions.Function1<MGLModel, EList<Node>>(){

            public EList<Node> apply(MGLModel it) {
                return it.getNodes();
            }
        };
        Functions.Function1<Node, Boolean> _function_1 = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                    public Boolean apply(Edge it) {
                        return MGLUtil.equalEdges(it, edge);
                    }
                };
                return IterableExtensions.exists(MGLUtil.getOutgoingConnectingEdges(it), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1), Node.class));
    }

    public static Set<Node> getAllPossibleSources(Edge edge) {
        Functions.Function1<ModelElement, Edge> _function = new Functions.Function1<ModelElement, Edge>(){

            public Edge apply(ModelElement it) {
                return (Edge)it;
            }
        };
        Functions.Function1<Edge, Set<Node>> _function_1 = new Functions.Function1<Edge, Set<Node>>(){

            public Set<Node> apply(Edge it) {
                return MGLUtil.getPossibleSources(it);
            }
        };
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)ListExtensions.map(MGLUtil.allSuperTypes((ModelElement)edge), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Set<Node> _possibleSources = MGLUtil.getPossibleSources(edge);
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_flatMap, _possibleSources));
    }

    public static Set<Edge> getIncomingConnectingEdges(Node node) {
        final HashSet<Edge> result = new HashSet<Edge>();
        EList incomingEdgeConnections = node.getIncomingEdgeConnections();
        if (incomingEdgeConnections.size() == 1 && ((IncomingEdgeElementConnection)incomingEdgeConnections.get(0)).getConnectingEdges().isEmpty()) {
            result.addAll((Collection<Edge>)MGLUtil.getMglModel((ModelElement)node).getEdges());
        } else {
            Consumer<IncomingEdgeElementConnection> _function = new Consumer<IncomingEdgeElementConnection>(){

                @Override
                public void accept(IncomingEdgeElementConnection it) {
                    result.addAll(it.getConnectingEdges());
                }
            };
            incomingEdgeConnections.forEach((Consumer)_function);
        }
        return result;
    }

    public static Set<Edge> getOutgoingConnectingEdges(Node node) {
        return MGLUtil.getOutgoingConnectingEdges(node, true);
    }

    public static Set<Edge> getOutgoingConnectingEdges(Node node, boolean includeNodeSuperTypes) {
        final HashSet<Edge> result = new HashSet<Edge>();
        EList outgoingEdgeConnections = node.getOutgoingEdgeConnections();
        if (outgoingEdgeConnections.size() == 1 && ((OutgoingEdgeElementConnection)outgoingEdgeConnections.get(0)).getConnectingEdges().isEmpty()) {
            result.addAll((Collection<Edge>)MGLUtil.getMglModel((ModelElement)node).getEdges());
        } else {
            Consumer<OutgoingEdgeElementConnection> _function = new Consumer<OutgoingEdgeElementConnection>(){

                @Override
                public void accept(OutgoingEdgeElementConnection it) {
                    result.addAll(it.getConnectingEdges());
                }
            };
            outgoingEdgeConnections.forEach((Consumer)_function);
        }
        if (includeNodeSuperTypes) {
            Functions.Function1<ModelElement, Node> _function_1 = new Functions.Function1<ModelElement, Node>(){

                public Node apply(ModelElement it) {
                    return (Node)it;
                }
            };
            Consumer<Node> _function_2 = new Consumer<Node>(){

                @Override
                public void accept(Node it) {
                    Set<Edge> _outgoingConnectingEdges = MGLUtil.getOutgoingConnectingEdges(it);
                    Iterables.addAll((Collection)result, _outgoingConnectingEdges);
                }
            };
            ListExtensions.map(MGLUtil.allSuperTypes((ModelElement)node), (Functions.Function1)_function_1).forEach(_function_2);
        }
        return result;
    }

    public static Set<Node> getContainableNodes(final ContainingElement containingElement) {
        Functions.Function1<MGLModel, Iterable<Node>> _function = new Functions.Function1<MGLModel, Iterable<Node>>(){

            public Iterable<Node> apply(MGLModel it) {
                Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

                    public Boolean apply(Node node) {
                        return MGLUtil.isContained(containingElement, node);
                    }
                };
                return IterableExtensions.filter((Iterable)it.getNodes(), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function));
    }

    private static MGLModel _getRootElement(ContainingElement containingElement) {
        EObject _eContainer = containingElement.eContainer();
        return (MGLModel)_eContainer;
    }

    public static Set<ContainingElement> getPossibleContainers(final Node node) {
        Functions.Function1<ContainingElement, Boolean> _function = new Functions.Function1<ContainingElement, Boolean>(){

            public Boolean apply(ContainingElement nodeContainer) {
                boolean _and = false;
                boolean _contains = MGLUtil.getContainableNodes(nodeContainer).contains(node);
                if (!_contains) {
                    _and = false;
                } else {
                    boolean _isIsAbstract;
                    boolean _xifexpression = false;
                    _xifexpression = nodeContainer instanceof GraphModel ? !(_isIsAbstract = ((GraphModel)nodeContainer).isIsAbstract()) : true;
                    _and = _xifexpression;
                }
                return _and;
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(MGLUtil.nodeContainers(MGLUtil.getRootElement((EObject)node)), (Functions.Function1)_function));
    }

    private static MGLModel _getRootElement(Type type) {
        EObject _eContainer = type.eContainer();
        return (MGLModel)_eContainer;
    }

    private static boolean isContained(ContainingElement containingElement, final Node node) {
        if (containingElement instanceof GraphModel && containingElement.getContainableElements().isEmpty()) {
            return true;
        }
        Functions.Function1<GraphicalElementContainment, Boolean> _function = new Functions.Function1<GraphicalElementContainment, Boolean>(){

            public Boolean apply(final GraphicalElementContainment ce) {
                return (IterableExtensions.exists((Iterable)ce.getTypes(), (Functions.Function1)new Functions.Function1<GraphicalModelElement, Boolean>(){

                    public Boolean apply(GraphicalModelElement it) {
                        return MGLUtil.equalModelElement((Type)it, (Type)node);
                    }
                }) || IterableExtensions.exists((Iterable)IterableExtensions.toSet(MGLUtil.allSuperTypes((ModelElement)node)), (Functions.Function1)new Functions.Function1<ModelElement, Boolean>(){

                    public Boolean apply(final ModelElement st) {
                        Functions.Function1<GraphicalModelElement, Boolean> _function = new Functions.Function1<GraphicalModelElement, Boolean>(){

                            public Boolean apply(GraphicalModelElement it) {
                                return MGLUtil.equalModelElement((Type)it, (Type)st);
                            }
                        };
                        return IterableExtensions.exists((Iterable)IterableExtensions.toSet((Iterable)ce.getTypes()), (Functions.Function1)_function);
                    }
                })) && ce.getUpperBound() != 0;
            }
        };
        Set containments = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)containingElement.getContainableElements(), (Functions.Function1)_function));
        boolean containedInSuperType = false;
        boolean _matched = false;
        if (containingElement instanceof NodeContainer) {
            _matched = true;
            Functions.Function1<NodeContainer, Boolean> _function_1 = new Functions.Function1<NodeContainer, Boolean>(){

                public Boolean apply(NodeContainer it) {
                    return MGLUtil.isContained((ContainingElement)it, node);
                }
            };
            containedInSuperType = IterableExtensions.exists((Iterable)IterableExtensions.toSet((Iterable)Iterables.filter(MGLUtil.allSuperTypes((ModelElement)containingElement), NodeContainer.class)), (Functions.Function1)_function_1);
        }
        return containments.size() > 0 || containedInSuperType;
    }

    public static HashMap<String, URL> getAllImages(GraphModel gm) {
        HashMap<String, URL> paths = new HashMap<String, URL>();
        URL url = null;
        TreeIterator it = gm.eResource().getAllContents();
        while (it.hasNext()) {
            String iconPath;
            Annotation a;
            boolean _equals;
            EObject o = (EObject)it.next();
            if (o instanceof Annotation && (_equals = "icon".equals((a = (Annotation)o).getName()))) {
                if (a.getValue().size() == 1 && PathValidator.isRelativePath((String)a.getValue().get(0))) {
                    url = PathValidator.getURLForString(o, (String)a.getValue().get(0));
                    paths.put((String)a.getValue().get(0), url);
                } else if (a.getValue().size() > 1 && PathValidator.isRelativePath((String)a.getValue().get(1))) {
                    url = PathValidator.getURLForString(o, (String)a.getValue().get(1));
                    paths.put((String)a.getValue().get(1), url);
                }
            }
            if (!(o instanceof GraphModel) || (iconPath = ((GraphModel)o).getIconPath()) == null || iconPath.isEmpty()) continue;
            paths.put(iconPath, PathValidator.getURLForString((EObject)gm, iconPath));
        }
        EObject _eContainer = gm.eContainer();
        Styles styles = CincoUtil.getStyles((MGLModel)_eContainer);
        TreeIterator it2 = styles.eResource().getAllContents();
        while (it2.hasNext()) {
            Image img;
            String path;
            boolean _isRelativePath;
            EObject o = (EObject)it2.next();
            if (!(o instanceof Image) || !(_isRelativePath = PathValidator.isRelativePath(path = (img = (Image)o).getPath()))) continue;
            url = PathValidator.getURLForString((EObject)img, path);
            paths.put(path, url);
        }
        return paths;
    }

    public static Annotation getAnnotation(ModelElement modelElement, final String annotationName) {
        Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)annotationName);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)modelElement.getAnnotations(), (Functions.Function1)_function);
        Annotation _head = null;
        if (_filter != null) {
            _head = (Annotation)IterableExtensions.head((Iterable)_filter);
        }
        return _head;
    }

    public static MGLModel getMglModel(ModelElement modelElement) {
        EObject _eContainer = modelElement.eContainer();
        return (MGLModel)_eContainer;
    }

    public static List<String> getAllAnnotation(final String annotationName, ModelElement modelElement) {
        Predicate<Annotation> _function = new Predicate<Annotation>(){

            @Override
            public boolean test(Annotation annotation) {
                return annotation.getName().equals(annotationName);
            }
        };
        Function<Annotation, String> _function_1 = new Function<Annotation, String>(){

            @Override
            public String apply(Annotation annotation) {
                return (String)annotation.getValue().get(0);
            }
        };
        List<String> values = modelElement.getAnnotations().stream().filter(_function).map(_function_1).collect(Collectors.toList());
        return values;
    }

    public static String getType(Attribute attribute) {
        boolean _matched = false;
        if (attribute instanceof ComplexAttribute) {
            _matched = true;
            return ((ComplexAttribute)attribute).getType().getName();
        }
        if (!_matched && attribute instanceof PrimitiveAttribute) {
            _matched = true;
            return ((PrimitiveAttribute)attribute).getType().getName();
        }
        return null;
    }

    public static ArrayList<? extends ModelElement> allSuperTypes(ModelElement modelElement) {
        ArrayList<ModelElement> superTypes = new ArrayList<ModelElement>();
        ModelElement current = MGLUtil.extend(modelElement);
        while (MGLUtil.extend(current) != null || !Objects.equal((Object)current, (Object)MGLUtil.extend(current))) {
            superTypes.add(current);
            current = MGLUtil.extend(current);
        }
        return superTypes;
    }

    public static Set<ModelElement> getAllSubclasses(MGLModel mglModel, final Set<ModelElement> modelElements) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                boolean _contains = modelElements.contains(it);
                return !_contains;
            }
        };
        Set elementsToCheck = IterableExtensions.toSet((Iterable)IterableExtensions.filter(_generatorUtils.modelElements(mglModel), (Functions.Function1)_function));
        Set graphModelsToCheck = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)elementsToCheck, GraphModel.class));
        Set nodesToCheck = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)elementsToCheck, Node.class));
        Set edgesToCheck = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)elementsToCheck, Edge.class));
        HashSet<ModelElement> result = new HashSet<ModelElement>();
        Iterator<ModelElement> iterator = modelElements.iterator();
        while (iterator.hasNext()) {
            ModelElement modelElement;
            ModelElement it = modelElement = iterator.next();
            boolean _matched = false;
            if (it instanceof GraphModel) {
                _matched = true;
                for (GraphModel gm : graphModelsToCheck) {
                    boolean _isSuperGraphModelOf = _generatorUtils.isSuperGraphModelOf((GraphModel)modelElement, gm);
                    if (!_isSuperGraphModelOf) continue;
                    result.add((ModelElement)gm);
                }
            }
            if (!_matched && it instanceof Node) {
                _matched = true;
                for (Node node : nodesToCheck) {
                    boolean _isSuperNodeOf = _generatorUtils.isSuperNodeOf((Node)modelElement, node);
                    if (!_isSuperNodeOf) continue;
                    result.add((ModelElement)node);
                }
            }
            if (_matched || !(it instanceof Edge)) continue;
            _matched = true;
            for (Edge edge : edgesToCheck) {
                boolean _isSuperEdgeOf = _generatorUtils.isSuperEdgeOf((Edge)modelElement, edge);
                if (!_isSuperEdgeOf) continue;
                result.add((ModelElement)edge);
            }
        }
        return result;
    }

    public static Set<ModelElement> getAllSubclasses(final ModelElement modelElement) {
        Functions.Function1<MGLModel, Iterable<ModelElement>> _function = new Functions.Function1<MGLModel, Iterable<ModelElement>>(){

            public Iterable<ModelElement> apply(MGLModel it) {
                Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                    public Boolean apply(ModelElement sub) {
                        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                            public Boolean apply(ModelElement subSuper) {
                                return MGLUtil.equalModelElement((Type)subSuper, (Type)modelElement);
                            }
                        };
                        return IterableExtensions.exists(MGLUtil.allSuperTypes(sub), (Functions.Function1)_function);
                    }
                };
                return IterableExtensions.filter(_generatorUtils.modelElements(it), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function));
    }

    public static Set<UserDefinedType> getAllSubTypes(final UserDefinedType t) {
        Functions.Function1<MGLModel, Iterable<UserDefinedType>> _function = new Functions.Function1<MGLModel, Iterable<UserDefinedType>>(){

            public Iterable<UserDefinedType> apply(MGLModel it) {
                return Iterables.filter((Iterable)it.getTypes(), UserDefinedType.class);
            }
        };
        Functions.Function1<UserDefinedType, Boolean> _function_1 = new Functions.Function1<UserDefinedType, Boolean>(){

            public Boolean apply(UserDefinedType it) {
                return MGLUtil.allSuperTypes((ModelElement)it).contains(t);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public static Iterable<Type> getComplexAttributeTypesDeeply(ModelElement elm) {
        return MGLUtil.collectComplexAttributeTypesDeeply(elm, CollectionLiterals.newHashSet());
    }

    public static Iterable<Type> collectComplexAttributeTypesDeeply(ModelElement elm, final Set<ModelElement> unseen) {
        Iterable<Object> _xifexpression = null;
        boolean _add = unseen.add(elm);
        if (_add) {
            Functions.Function1<Attribute, Iterable<Type>> _function = new Functions.Function1<Attribute, Iterable<Type>>(){

                public Iterable<Type> apply(Attribute it) {
                    Iterable<Object> _switchResult = null;
                    boolean _matched = false;
                    if (it instanceof ComplexAttribute) {
                        _matched = true;
                        Type _type = ((ComplexAttribute)it).getType();
                        Iterable<Object> _xifexpression = null;
                        Type _type_1 = ((ComplexAttribute)it).getType();
                        if (_type_1 instanceof ModelElement) {
                            Type _type_2 = ((ComplexAttribute)it).getType();
                            _xifexpression = MGLUtil.collectComplexAttributeTypesDeeply((ModelElement)_type_2, unseen);
                        } else {
                            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
                        }
                        _switchResult = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Type[]{_type})), _xifexpression);
                    }
                    if (!_matched) {
                        _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
                    }
                    return _switchResult;
                }
            };
            _xifexpression = IterableExtensions.flatMap((Iterable)elm.getAttributes(), (Functions.Function1)_function);
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _xifexpression;
    }

    public static String refactorIfPrimeAttribute(Node node, String string) {
        if (_generatorUtils.isPrime(node) && _generatorUtils.retrievePrimeReference(node) instanceof ReferencedModelElement && string.startsWith(_generatorUtils.retrievePrimeReference(node).getName())) {
            String _replaceFirst = StringExtensions.toFirstLower((String)string).replaceFirst("\\.", ".internalElement_.");
            String _plus = "${" + _replaceFirst;
            return String.valueOf(_plus) + "}";
        }
        return "${" + string + "}";
    }

    public static ReferencedType retrievePrimeReference(Node n) {
        return MGLUtil.retrievePrimeReference(n, true);
    }

    public static ReferencedType retrievePrimeReference(Node node, boolean includeParents) {
        boolean _tripleNotEquals;
        ReferencedType _primeReference = node.getPrimeReference();
        boolean bl = _tripleNotEquals = _primeReference != null;
        if (_tripleNotEquals) {
            return node.getPrimeReference();
        }
        if (includeParents) {
            Node _extends = node.getExtends();
            ReferencedType _retrievePrimeReference = null;
            if (_extends != null) {
                _retrievePrimeReference = MGLUtil.retrievePrimeReference(_extends, includeParents);
            }
            return _retrievePrimeReference;
        }
        return null;
    }

    public static String getPostCreateHooks(MGLModel mglModel) {
        return IterableExtensions.join(MGLUtil.getPostCreateHooksRecursive(mglModel, CollectionLiterals.newHashSet((Object[])((MGLModel[])Conversions.unwrapArray(Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new MGLModel[]{mglModel})), MGLModel.class)))));
    }

    private static List<CharSequence> getPostCreateHooksRecursive(MGLModel mglModel, Set<MGLModel> alreadyVisited) {
        LinkedList postCreateHooks = CollectionLiterals.newLinkedList();
        Functions.Function1<ModelElement, CharSequence> _function = new Functions.Function1<ModelElement, CharSequence>(){

            public CharSequence apply(ModelElement it) {
                return MGLUtil.postCreates(it);
            }
        };
        Iterables.addAll((Collection)postCreateHooks, (Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)mglModel.getTypes(), ModelElement.class), (Functions.Function1)_function));
        Functions.Function1<ModelElement, CharSequence> _function_1 = new Functions.Function1<ModelElement, CharSequence>(){

            public CharSequence apply(ModelElement it) {
                return MGLUtil.postCreates(it);
            }
        };
        postCreateHooks.addAll(ListExtensions.map(_generatorUtils.modelElements(mglModel), (Functions.Function1)_function_1));
        Set<MGLModel> _allImportedMGLs = MGLUtil.getAllImportedMGLs(mglModel, true, false);
        for (final MGLModel model : _allImportedMGLs) {
            boolean _not;
            Functions.Function1<MGLModel, Boolean> _function_2 = new Functions.Function1<MGLModel, Boolean>(){

                public Boolean apply(MGLModel it) {
                    return MGLUtil.equalMGLModels(it, model);
                }
            };
            boolean _exists = IterableExtensions.exists(alreadyVisited, (Functions.Function1)_function_2);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            alreadyVisited.add(model);
            postCreateHooks.addAll(MGLUtil.getPostCreateHooksRecursive(model, alreadyVisited));
        }
        return postCreateHooks;
    }

    public static boolean hasPostCreateHook(ModelElement it) {
        return IterableExtensions.exists(MGLUtil.getSuperElements(it), (Functions.Function1)new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement it) {
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getDefaultValueOverrides());
                return !_isNullOrEmpty;
            }
        }) || IterableExtensions.exists((Iterable)it.getAnnotations(), (Functions.Function1)new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"postCreate");
            }
        }) || _eventApiExtension.isEventEnabled(it) && _eventApiExtension.hasCreateEvent(it) && _eventApiExtension.getPostCreateEvent(it).accepts(it);
    }

    private static CharSequence postCreates(ModelElement it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasPostCreateHook = MGLUtil.hasPostCreateHook(it);
        if (_hasPostCreateHook) {
            _builder.append("def postCreates(");
            CharSequence _fqBeanNameEscaped = _generatorUtils.fqBeanNameEscaped(it);
            _builder.append((Object)_fqBeanNameEscaped);
            _builder.append(" me) {");
            _builder.newLineIfNotEmpty();
            Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                public Boolean apply(ModelElement it) {
                    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it.getDefaultValueOverrides());
                    return !_isNullOrEmpty;
                }
            };
            boolean _exists = IterableExtensions.exists(MGLUtil.getSuperElements(it), (Functions.Function1)_function);
            if (_exists) {
                _builder.append("\t");
                _builder.append("me.transact [ // Default value overrides");
                _builder.newLine();
                Collection<DefaultValueOverride> _allDefaultValueOverrides = MGLUtil.getAllDefaultValueOverrides(it);
                for (DefaultValueOverride dvo : _allDefaultValueOverrides) {
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("me.set");
                    String _firstUpper = StringExtensions.toFirstUpper((String)dvo.getAttribute().getName());
                    _builder.append(_firstUpper, "\t\t");
                    _builder.append("(");
                    CharSequence _literal = MGLUtil.getLiteral(dvo);
                    _builder.append((Object)_literal, "\t\t");
                    _builder.append(")");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("]");
                _builder.newLine();
            }
            Functions.Function1<Annotation, Boolean> _function_1 = new Functions.Function1<Annotation, Boolean>(){

                public Boolean apply(Annotation it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)"postCreate");
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)it.getAnnotations(), (Functions.Function1)_function_1);
            for (Annotation annotation : _filter) {
                _builder.append("\t");
                _builder.append("me.transact [ // Post create hook");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("new ");
                String _head = (String)IterableExtensions.head((Iterable)annotation.getValue());
                _builder.append(_head, "\t\t");
                _builder.append("().postCreate(me)");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("]");
                _builder.newLine();
            }
            if (_eventApiExtension.isEventEnabled(it) && _eventApiExtension.hasCreateEvent(it) && _eventApiExtension.getPostCreateEvent(it).accepts(it)) {
                _builder.append("\t");
                _builder.append("me.transact [ // Post create event");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                String _notifyCallXtend = _eventApiExtension.getPostCreateEvent(it).getNotifyCallXtend(it, new String[]{"me"});
                _builder.append(_notifyCallXtend, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("]");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private static LinkedList<ModelElement> getSuperElements(ModelElement element) {
        ModelElement currentElement = element;
        LinkedList list = CollectionLiterals.newLinkedList();
        while (currentElement != null) {
            list.add(currentElement);
            currentElement = MGLUtil.extend(currentElement);
        }
        return list;
    }

    private static Collection<DefaultValueOverride> getAllDefaultValueOverrides(ModelElement it) {
        HashMap map = CollectionLiterals.newHashMap();
        LinkedList<ModelElement> _superElements = MGLUtil.getSuperElements(it);
        for (ModelElement element : _superElements) {
            EList _defaultValueOverrides = element.getDefaultValueOverrides();
            for (DefaultValueOverride dvo : _defaultValueOverrides) {
                map.putIfAbsent(dvo.getAttribute(), dvo);
            }
        }
        return map.values();
    }

    private static CharSequence getLiteral(DefaultValueOverride dvo) {
        try {
            String _xifexpression;
            String _xblockexpression;
            block33: {
                StringConcatenation _switchResult_1;
                StringConcatenation _xblockexpression_1;
                block35: {
                    EDataTypeType type_1;
                    block34: {
                        String v;
                        block30: {
                            String _switchResult;
                            block32: {
                                EDataTypeType type;
                                block31: {
                                    _xblockexpression = null;
                                    v = dvo.getDefaultValue();
                                    _xifexpression = null;
                                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)v);
                                    if (!_isNullOrEmpty) break block30;
                                    _switchResult = null;
                                    EDataTypeType _type = dvo.getAttribute().getType();
                                    type = _type;
                                    if (type == null) break block31;
                                    switch (type) {
                                        case ESTRING: {
                                            String _xifexpression_1 = null;
                                            _xifexpression_1 = v == null ? "null" : "\"\"";
                                            _switchResult = _xifexpression_1;
                                            break block32;
                                        }
                                        case ECHAR: {
                                            _switchResult = "Character.valueOf(\"\u0000\")";
                                            break block32;
                                        }
                                        case EFLOAT: {
                                            _switchResult = "0F";
                                            break block32;
                                        }
                                        case EBOOLEAN: {
                                            _switchResult = "false";
                                            break block32;
                                        }
                                        case EDOUBLE: {
                                            _switchResult = "0D";
                                            break block32;
                                        }
                                        case EINT: {
                                            _switchResult = "0";
                                            break block32;
                                        }
                                        case ELONG: {
                                            _switchResult = "0L";
                                            break block32;
                                        }
                                        case EBIG_INTEGER: {
                                            _switchResult = "null";
                                            break block32;
                                        }
                                        case EBIG_DECIMAL: {
                                            _switchResult = "null";
                                            break block32;
                                        }
                                        case EBYTE: {
                                            _switchResult = "0 as byte";
                                            break block32;
                                        }
                                        case ESHORT: {
                                            _switchResult = "0 as short";
                                            break block32;
                                        }
                                        case EDATE: {
                                            _switchResult = "null";
                                            break block32;
                                        }
                                        default: {
                                            StringConcatenation _builder = new StringConcatenation();
                                            _builder.append("Unknown primitive attribute type: ");
                                            String _name = type.getName();
                                            _builder.append(_name);
                                            throw new Exception(_builder.toString());
                                        }
                                    }
                                }
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("Unknown primitive attribute type: ");
                                String _name = type.getName();
                                _builder.append(_name);
                                throw new Exception(_builder.toString());
                            }
                            _xifexpression = _switchResult;
                            break block33;
                        }
                        _xblockexpression_1 = null;
                        v = _generatorUtils.stringEscape(v);
                        _switchResult_1 = null;
                        EDataTypeType _type_1 = dvo.getAttribute().getType();
                        type_1 = _type_1;
                        if (type_1 == null) break block34;
                        switch (type_1) {
                            case ESTRING: {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append("\"");
                                _builder_1.append(v);
                                _builder_1.append("\"");
                                _switchResult_1 = _builder_1;
                                break block35;
                            }
                            case ECHAR: {
                                StringConcatenation _builder_2 = new StringConcatenation();
                                _builder_2.append("Character.valueOf(\"");
                                _builder_2.append(v);
                                _builder_2.append("\")");
                                _switchResult_1 = _builder_2;
                                break block35;
                            }
                            case EFLOAT: {
                                StringConcatenation _builder_3 = new StringConcatenation();
                                _builder_3.append("Float.valueOf(\"");
                                _builder_3.append(v);
                                _builder_3.append("\")");
                                _switchResult_1 = _builder_3;
                                break block35;
                            }
                            case EBOOLEAN: {
                                StringConcatenation _builder_4 = new StringConcatenation();
                                _builder_4.append("Boolean.valueOf(\"");
                                _builder_4.append(v);
                                _builder_4.append("\")");
                                _switchResult_1 = _builder_4;
                                break block35;
                            }
                            case EDOUBLE: {
                                StringConcatenation _builder_5 = new StringConcatenation();
                                _builder_5.append("Double.valueOf(\"");
                                _builder_5.append(v);
                                _builder_5.append("\")");
                                _switchResult_1 = _builder_5;
                                break block35;
                            }
                            case EINT: {
                                StringConcatenation _builder_6 = new StringConcatenation();
                                _builder_6.append("Integer.valueOf(\"");
                                _builder_6.append(v);
                                _builder_6.append("\")");
                                _switchResult_1 = _builder_6;
                                break block35;
                            }
                            case ELONG: {
                                StringConcatenation _builder_7 = new StringConcatenation();
                                _builder_7.append("Long.valueOf(\"");
                                _builder_7.append(v);
                                _builder_7.append("\")");
                                _switchResult_1 = _builder_7;
                                break block35;
                            }
                            case EBIG_INTEGER: {
                                StringConcatenation _builder_8 = new StringConcatenation();
                                _builder_8.append("new java.math.BigInteger(\"");
                                _builder_8.append(v);
                                _builder_8.append("\")");
                                _switchResult_1 = _builder_8;
                                break block35;
                            }
                            case EBIG_DECIMAL: {
                                StringConcatenation _builder_9 = new StringConcatenation();
                                _builder_9.append("new java.math.BigDecimal(\"");
                                _builder_9.append(v);
                                _builder_9.append("\")");
                                _switchResult_1 = _builder_9;
                                break block35;
                            }
                            case EBYTE: {
                                StringConcatenation _builder_10 = new StringConcatenation();
                                _builder_10.append("Byte.valueOf(\"");
                                _builder_10.append(v);
                                _builder_10.append("\")");
                                _switchResult_1 = _builder_10;
                                break block35;
                            }
                            case ESHORT: {
                                StringConcatenation _builder_11 = new StringConcatenation();
                                _builder_11.append("Short.valueOf(\"");
                                _builder_11.append(v);
                                _builder_11.append("\")");
                                _switchResult_1 = _builder_11;
                                break block35;
                            }
                            case EDATE: {
                                StringConcatenation _builder_12 = new StringConcatenation();
                                _builder_12.append("new java.util.Date(\"");
                                _builder_12.append(v);
                                _builder_12.append("\")");
                                _switchResult_1 = _builder_12;
                                break block35;
                            }
                            default: {
                                StringConcatenation _builder_13 = new StringConcatenation();
                                _builder_13.append("Unknown primitive attribute type: ");
                                String _name_1 = type_1.getName();
                                _builder_13.append(_name_1);
                                throw new Exception(_builder_13.toString());
                            }
                        }
                    }
                    StringConcatenation _builder_13 = new StringConcatenation();
                    _builder_13.append("Unknown primitive attribute type: ");
                    String _name_1 = type_1.getName();
                    _builder_13.append(_name_1);
                    throw new Exception(_builder_13.toString());
                }
                _xblockexpression_1 = _switchResult_1;
                _xifexpression = _xblockexpression_1;
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static CharSequence postCreateHook(ModelElement modelElement) {
        StringConcatenation _xifexpression = null;
        boolean _hasPostCreateHook = MGLUtil.hasPostCreateHook(modelElement);
        if (_hasPostCreateHook) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("if (hook) postCreates");
            _xifexpression = _builder;
        }
        return _xifexpression;
    }

    public static String postAttributeValueChange(ModelElement modelElement, final String varName) {
        Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"postAttributeChange");
            }
        };
        Functions.Function1<Annotation, CharSequence> _function_1 = new Functions.Function1<Annotation, CharSequence>(){

            public CharSequence apply(Annotation it) {
                return MGLUtil.generatePostAttributeValueChange(it, varName);
            }
        };
        return IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)modelElement.getAnnotations(), (Functions.Function1)_function), (Functions.Function1)_function_1), (CharSequence)"\n");
    }

    private static CharSequence generatePostAttributeValueChange(Annotation it, String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (new ");
        String _get = (String)it.getValue().get(0);
        _builder.append(_get);
        _builder.append("().canHandleChange(");
        _builder.append(varName);
        _builder.append(".element as ");
        CharSequence _fqBeanName = _generatorUtils.fqBeanName((EObject)it.getParent());
        _builder.append((Object)_fqBeanName);
        _builder.append(", feature))");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("new ");
        String _get_1 = (String)it.getValue().get(0);
        _builder.append(_get_1, "\t");
        _builder.append("().handleChange(");
        _builder.append(varName, "\t");
        _builder.append(".element as ");
        CharSequence _fqBeanName_1 = _generatorUtils.fqBeanName((EObject)it.getParent());
        _builder.append((Object)_fqBeanName_1, "\t");
        _builder.append(", feature)");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static Iterable<? extends Attribute> allAttributes(ModelElement modelElement) {
        return MGLUtil.allAttributes(modelElement, true);
    }

    public static Iterable<? extends Attribute> allAttributes(ModelElement modelElement, boolean includeParentElements) {
        Collection _xblockexpression = null;
        final HashMap allAttributes = new HashMap();
        Stack<ModelElement> mes = new Stack<ModelElement>();
        if (includeParentElements) {
            Stack<ModelElement> _pSort = MGLUtil.topSort(MGLUtil.allSuperTypes(modelElement));
            Iterables.addAll(mes, _pSort);
        }
        mes.add(modelElement);
        Consumer<ModelElement> _function = new Consumer<ModelElement>(){

            @Override
            public void accept(ModelElement it) {
                Consumer<Attribute> _function = new Consumer<Attribute>(){

                    @Override
                    public void accept(Attribute it) {
                        allAttributes.put(it.getName(), it);
                    }
                };
                it.getAttributes().forEach((Consumer)_function);
            }
        };
        mes.forEach(_function);
        _xblockexpression = allAttributes.values();
        return _xblockexpression;
    }

    public static Iterable<? extends Attribute> nonConflictingAttributes(final ModelElement modelElement) {
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(final Attribute attr) {
                return !(attr instanceof ComplexAttribute) || !IterableExtensions.exists((Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.subTypes(modelElement), (Functions.Function1)new Functions.Function1<ModelElement, Iterable<? extends Attribute>>(){

                    public Iterable<? extends Attribute> apply(ModelElement st) {
                        return MGLUtil.allAttributes(st);
                    }
                })), (Functions.Function1)new Functions.Function1<Attribute, Boolean>(){

                    public Boolean apply(Attribute e) {
                        return Objects.equal((Object)e.getName(), (Object)attr.getName()) && ((ComplexAttribute)e).isOverride();
                    }
                });
            }
        };
        return IterableExtensions.filter(MGLUtil.allAttributes(modelElement, false), (Functions.Function1)_function);
    }

    public static boolean isSubType(ModelElement superTypeCandidate, ModelElement subTypeCandidate) {
        ModelElement currentSubTypeCandidate = subTypeCandidate;
        while (currentSubTypeCandidate != null) {
            boolean _equalModelElement = MGLUtil.equalModelElement((Type)currentSubTypeCandidate, (Type)superTypeCandidate);
            if (_equalModelElement) {
                return true;
            }
            currentSubTypeCandidate = MGLUtil.extend(currentSubTypeCandidate);
        }
        return false;
    }

    public static Iterable<? extends ModelElement> subTypes(final ModelElement modelElement) {
        Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement me) {
                Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                    public Boolean apply(ModelElement e) {
                        return MGLUtil.equalModelElement((Type)e, (Type)modelElement);
                    }
                };
                return IterableExtensions.exists(MGLUtil.allSuperTypes(me), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.filter(_generatorUtils.modelElements(MGLUtil.getMglModel(modelElement)), (Functions.Function1)_function);
    }

    public static Iterable<? extends ModelElement> allSubTypes(final ModelElement modelElement) {
        Functions.Function1<MGLModel, List<ModelElement>> _function = new Functions.Function1<MGLModel, List<ModelElement>>(){

            public List<ModelElement> apply(MGLModel it) {
                return _generatorUtils.modelElements(it);
            }
        };
        Functions.Function1<ModelElement, Boolean> _function_1 = new Functions.Function1<ModelElement, Boolean>(){

            public Boolean apply(ModelElement me) {
                Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                    public Boolean apply(ModelElement e) {
                        return MGLUtil.equalModelElement((Type)e, (Type)modelElement);
                    }
                };
                return IterableExtensions.exists(MGLUtil.allSuperTypes(me), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.filter((Iterable)IterableExtensions.flatMap(MGLUtil._generatorUtils.allMGLs, (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public static Stack<ModelElement> topSort(Iterable<? extends ModelElement> elements) {
        Functions.Function1<ModelElement, DependencyNode<ModelElement>> _function = new Functions.Function1<ModelElement, DependencyNode<ModelElement>>(){

            public DependencyNode<ModelElement> apply(ModelElement it) {
                return MGLUtil.dependencies(it);
            }
        };
        return new DependencyGraph().createGraph(IterableExtensions.map(elements, (Functions.Function1)_function)).topSort();
    }

    private static DependencyNode<ModelElement> dependencies(ModelElement it) {
        DependencyNode<ModelElement> _xblockexpression = null;
        DependencyNode<ModelElement> dNode = new DependencyNode<ModelElement>(it);
        Functions.Function1<ModelElement, ModelElement> _function = new Functions.Function1<ModelElement, ModelElement>(){

            public ModelElement apply(ModelElement t) {
                return t;
            }
        };
        dNode.addDependencies(IterableExtensions.toList((Iterable)ListExtensions.map(MGLUtil.allSuperTypes(it), (Functions.Function1)_function)));
        _xblockexpression = dNode;
        return _xblockexpression;
    }

    public static Stack<MGLModel> topSortMGLModels(Iterable<MGLModel> mglModels) {
        Functions.Function1<MGLModel, DependencyNode<MGLModel>> _function = new Functions.Function1<MGLModel, DependencyNode<MGLModel>>(){

            public DependencyNode<MGLModel> apply(MGLModel it) {
                return MGLUtil.dependenciesMGLModel(it);
            }
        };
        return new DependencyGraph().createGraph(IterableExtensions.map(mglModels, (Functions.Function1)_function)).topSort();
    }

    public static boolean equalModelElement(Type type1, Type type2) {
        if (type1 instanceof Node && type2 instanceof Node) {
            return MGLUtil.equalNodes((Node)type1, (Node)type2);
        }
        if (type1 instanceof Edge && type2 instanceof Edge) {
            return MGLUtil.equalEdges((Edge)type1, (Edge)type2);
        }
        if (type1 instanceof GraphModel && type2 instanceof GraphModel) {
            return MGLUtil.equalGraphModels((GraphModel)type1, (GraphModel)type2);
        }
        if (type1 instanceof MGLModel && type2 instanceof MGLModel) {
            return MGLUtil.equalMGLModels((MGLModel)type1, (MGLModel)type2);
        }
        if (type1 instanceof UserDefinedType && type2 instanceof UserDefinedType) {
            return MGLUtil.equalUserDefinedTypes((UserDefinedType)type1, (UserDefinedType)type2);
        }
        return Objects.equal((Object)type1, (Object)type2);
    }

    public static boolean equalNodes(Node node1, Node node2) {
        if (node1 != null && node2 != null) {
            if (node1.getName() != null && Objects.equal((Object)node1.getName(), (Object)node2.getName())) {
                if (node1.eContainer() instanceof MGLModel && node2.eContainer() instanceof MGLModel) {
                    EObject _eContainer = node1.eContainer();
                    EObject _eContainer_1 = node2.eContainer();
                    return MGLUtil.equalMGLModels((MGLModel)_eContainer, (MGLModel)_eContainer_1);
                }
                EObject _eContainer_2 = node1.eContainer();
                EObject _eContainer_3 = node2.eContainer();
                return Objects.equal((Object)_eContainer_2, (Object)_eContainer_3);
            }
            return false;
        }
        return node1 == node2;
    }

    public static boolean equalTypes(Type type1, Type type2) {
        if (type1 != null && type2 != null) {
            if (type1.getName() != null && Objects.equal((Object)type1.getName(), (Object)type2.getName())) {
                if (type1.eContainer() instanceof MGLModel && type1.eContainer() instanceof MGLModel) {
                    EObject _eContainer = type1.eContainer();
                    EObject _eContainer_1 = type2.eContainer();
                    return MGLUtil.equalMGLModels((MGLModel)_eContainer, (MGLModel)_eContainer_1);
                }
                EObject _eContainer_2 = type1.eContainer();
                EObject _eContainer_3 = type2.eContainer();
                return Objects.equal((Object)_eContainer_2, (Object)_eContainer_3);
            }
            return false;
        }
        return type1 == type2;
    }

    public static boolean equalGraphModels(GraphModel graphModel1, GraphModel graphModel2) {
        if (graphModel1 != null && graphModel2 != null) {
            if (graphModel1.getName() != null && Objects.equal((Object)graphModel1.getName(), (Object)graphModel2.getName())) {
                if (graphModel1.eContainer() instanceof MGLModel && graphModel1.eContainer() instanceof MGLModel) {
                    EObject _eContainer = graphModel1.eContainer();
                    EObject _eContainer_1 = graphModel2.eContainer();
                    return MGLUtil.equalMGLModels((MGLModel)_eContainer, (MGLModel)_eContainer_1);
                }
                EObject _eContainer_2 = graphModel1.eContainer();
                EObject _eContainer_3 = graphModel2.eContainer();
                return Objects.equal((Object)_eContainer_2, (Object)_eContainer_3);
            }
            return false;
        }
        return graphModel1 == graphModel2;
    }

    public static boolean equalEdges(Edge edge1, Edge edge2) {
        if (edge1 != null && edge2 != null) {
            if (edge1.getName() != null && Objects.equal((Object)edge1.getName(), (Object)edge2.getName())) {
                if (edge1.eContainer() instanceof MGLModel && edge2.eContainer() instanceof MGLModel) {
                    EObject _eContainer = edge1.eContainer();
                    EObject _eContainer_1 = edge2.eContainer();
                    return MGLUtil.equalMGLModels((MGLModel)_eContainer, (MGLModel)_eContainer_1);
                }
                EObject _eContainer_2 = edge1.eContainer();
                EObject _eContainer_3 = edge2.eContainer();
                return Objects.equal((Object)_eContainer_2, (Object)_eContainer_3);
            }
            return false;
        }
        return edge1 == edge2;
    }

    public static boolean equalMGLModels(MGLModel mglModel1, MGLModel mglModel2) {
        if (mglModel1 != null && mglModel2 != null) {
            return _generatorUtils.getFileName(mglModel1) != null && Objects.equal((Object)_generatorUtils.getFileName(mglModel1), (Object)_generatorUtils.getFileName(mglModel2)) && mglModel1.getPackage() != null && Objects.equal((Object)mglModel1.getPackage(), (Object)mglModel2.getPackage());
        }
        return mglModel1 == mglModel2;
    }

    public static boolean equalUserDefinedTypes(UserDefinedType userDefinedType1, UserDefinedType userDefinedType2) {
        if (userDefinedType1 != null && userDefinedType2 != null) {
            if (userDefinedType1.getName() != null && Objects.equal((Object)userDefinedType1.getName(), (Object)userDefinedType2.getName())) {
                if (userDefinedType1.eContainer() instanceof MGLModel && userDefinedType2.eContainer() instanceof MGLModel) {
                    EObject _eContainer = userDefinedType1.eContainer();
                    EObject _eContainer_1 = userDefinedType2.eContainer();
                    return MGLUtil.equalMGLModels((MGLModel)_eContainer, (MGLModel)_eContainer_1);
                }
                EObject _eContainer_2 = userDefinedType1.eContainer();
                EObject _eContainer_3 = userDefinedType2.eContainer();
                return Objects.equal((Object)_eContainer_2, (Object)_eContainer_3);
            }
            return false;
        }
        return userDefinedType1 == userDefinedType2;
    }

    private static DependencyNode<MGLModel> dependenciesMGLModel(MGLModel it) {
        return MGLUtil.dependenciesMGLModel(it, true, true);
    }

    private static DependencyNode<MGLModel> dependenciesMGLModel(MGLModel it, boolean ignoreStealthImports, boolean ignoreExternalImports) {
        DependencyNode<MGLModel> _xblockexpression = null;
        DependencyNode<MGLModel> dNode = new DependencyNode<MGLModel>(it);
        dNode.addDependencies(MGLUtil.getAllImportedMGLs(it, ignoreStealthImports, ignoreExternalImports));
        _xblockexpression = dNode;
        return _xblockexpression;
    }

    public static Set<MGLModel> getAllImportedMGLs(MGLModel mglModel) {
        return MGLUtil.getAllImportedMGLs(mglModel, true, true);
    }

    public static Set<MGLModel> getAllImportedMGLs(MGLModel mglModel, boolean ignoreStealthImports, boolean ignoreExternalImports) {
        boolean _tripleNotEquals;
        HashSet<MGLModel> resultList = new HashSet<MGLModel>();
        EList _imports = mglModel.getImports();
        boolean bl = _tripleNotEquals = _imports != null;
        if (_tripleNotEquals) {
            EList _imports_1 = mglModel.getImports();
            for (Import import_ : _imports_1) {
                if (ignoreStealthImports && import_.isStealth() || ignoreExternalImports && import_.isExternal() || MGLUtil.mglModel(import_) == null) continue;
                MGLUtil._getAllImportedMGLs(MGLUtil.mglModel(import_), resultList, mglModel, ignoreStealthImports, ignoreExternalImports);
            }
        }
        return resultList;
    }

    private static Set<MGLModel> _getAllImportedMGLs(final MGLModel it, Set<MGLModel> resultList, MGLModel originalModel, boolean ignoreStealthImports, boolean ignoreExternalImports) {
        if (!IterableExtensions.exists(resultList, (Functions.Function1)new Functions.Function1<MGLModel, Boolean>(){

            public Boolean apply(MGLModel item) {
                return MGLUtil.equalMGLModels(item, it);
            }
        }) && !MGLUtil.equalMGLModels(it, originalModel)) {
            boolean _tripleNotEquals;
            resultList.add(it);
            EList _imports = it.getImports();
            boolean bl = _tripleNotEquals = _imports != null;
            if (_tripleNotEquals) {
                EList _imports_1 = it.getImports();
                for (Import import_ : _imports_1) {
                    if (ignoreStealthImports && import_.isStealth() || ignoreExternalImports && import_.isExternal() || MGLUtil.mglModel(import_) == null || import_.isExternal()) continue;
                    MGLUtil._getAllImportedMGLs(MGLUtil.mglModel(import_), resultList, originalModel, ignoreStealthImports, ignoreExternalImports);
                }
            }
        }
        return resultList;
    }

    public static Set<? extends ModelElement> removeDuplicateModelElements(Iterable<? extends ModelElement> modelElements) {
        final HashSet result = new HashSet();
        Consumer<ModelElement> _function = new Consumer<ModelElement>(){

            @Override
            public void accept(final ModelElement modelElement) {
                boolean _not;
                Functions.Function1<ModelElement, Boolean> _function = new Functions.Function1<ModelElement, Boolean>(){

                    public Boolean apply(ModelElement it) {
                        return MGLUtil.equalModelElement((Type)it, (Type)modelElement);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)result, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    result.add(modelElement);
                }
            }
        };
        modelElements.forEach((Consumer<? extends ModelElement>)_function);
        return result;
    }

    public static Iterable<Node> containableNodeElements(ContainingElement containingElement) {
        Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

            public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                return it.getTypes();
            }
        };
        return Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)containingElement.getContainableElements(), (Functions.Function1)_function)), Node.class);
    }

    public static Iterable<NodeContainer> containableContainerElements(ContainingElement containingElement) {
        Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

            public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                return it.getTypes();
            }
        };
        return Iterables.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)containingElement.getContainableElements(), (Functions.Function1)_function)), NodeContainer.class);
    }

    public static ModelElement extend(ModelElement element) {
        Node _switchResult = null;
        boolean _matched = false;
        if (element instanceof Node) {
            _matched = true;
            _switchResult = ((Node)element).getExtends();
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
            _switchResult = ((Edge)element).getExtends();
        }
        if (!_matched && element instanceof UserDefinedType) {
            _matched = true;
            _switchResult = ((UserDefinedType)element).getExtends();
        }
        if (!_matched && element instanceof GraphModel) {
            _matched = true;
            _switchResult = ((GraphModel)element).getExtends();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    protected static MGLModel _mglModel(MGLModel mglModel) {
        return mglModel;
    }

    protected static MGLModel _mglModel(Import imprt) {
        return CincoUtil.getImportedMGLModel(imprt);
    }

    protected static MGLModel _mglModel(Type type) {
        EObject _eContainer = type.eContainer();
        return (MGLModel)_eContainer;
    }

    protected static MGLModel _mglModel(ContainingElement containingElement) {
        MGLModel _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)containingElement, GraphModel.class)) {
            _matched = true;
            _switchResult = MGLUtil.mglModel(containingElement);
        }
        if (!_matched && Objects.equal((Object)containingElement, NodeContainer.class)) {
            _matched = true;
            _switchResult = MGLUtil.mglModel(containingElement);
        }
        return _switchResult;
    }

    protected static MGLModel _mglModel(Wildcard wildcard) {
        boolean _isSelfWildcard = wildcard.isSelfWildcard();
        if (_isSelfWildcard) {
            return MGLUtil.mglModel(wildcard.eContainer());
        }
        Import _referencedImport = wildcard.getReferencedImport();
        MGLModel _mglModel = null;
        if (_referencedImport != null) {
            _mglModel = MGLUtil.mglModel(_referencedImport);
        }
        return _mglModel;
    }

    protected static MGLModel _mglModel(EObject eObject) {
        List alreadyVisited = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EObject[]{eObject}));
        EObject candidate = eObject;
        while (candidate != null) {
            if (candidate instanceof MGLModel) {
                return (MGLModel)candidate;
            }
            boolean _contains = alreadyVisited.contains(candidate = candidate.eContainer());
            if (!_contains) continue;
            return null;
        }
        return null;
    }

    protected static MGLModel _mglModel(Object o) {
        String _format = String.format("Can not determine MGLModel for Object: %s", o);
        throw new RuntimeException(_format);
    }

    public static String ePackageName(MGLModel mglModel) {
        return _generatorUtils.getFileName(mglModel).toLowerCase();
    }

    protected static String _nsURI(MGLModel model) {
        String[] _split;
        String result = "";
        String prefix = "";
        int cnt = 0;
        String[] stringArray = _split = model.getPackage().split("\\.");
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            String packagePart = stringArray[n2];
            if (cnt == 0) {
                result = prefix = packagePart;
                ++cnt;
            } else if (cnt < 3) {
                result = prefix = String.valueOf(packagePart) + "." + prefix;
                ++cnt;
            } else if (cnt == 4) {
                result = String.valueOf(prefix) + "/" + packagePart;
                ++cnt;
            } else {
                String _result = result;
                result = String.valueOf(_result) + "/" + packagePart;
            }
            ++n2;
        }
        return "http://" + result;
    }

    protected static String _nsURI(GraphModel graphModel) {
        return MGLUtil.nsURI((Annotatable)MGLUtil.getMglModel((ModelElement)graphModel));
    }

    protected static String _nsURI(ModelElement modelElement) {
        return MGLUtil.nsURI((Annotatable)MGLUtil.getMglModel(modelElement));
    }

    /*
     * WARNING - void declaration
     */
    public static HashSet<Type> types(GraphModel graphModel) {
        void var6_9;
        final HashSet<Type> result = new HashSet<Type>();
        LinkedHashSet<Object> modelElementsToCheck = new LinkedHashSet<Object>();
        LinkedHashSet<UserDefinedType> userDefinedTypesToCheck = new LinkedHashSet<UserDefinedType>();
        modelElementsToCheck.add(graphModel);
        modelElementsToCheck.addAll(_generatorUtils.getUsableNodes((ContainingElement)graphModel, true));
        modelElementsToCheck.addAll(_generatorUtils.getUsableEdges((ContainingElement)graphModel));
        Functions.Function1<ModelElement, ArrayList<? extends ModelElement>> _function = new Functions.Function1<ModelElement, ArrayList<? extends ModelElement>>(){

            public ArrayList<? extends ModelElement> apply(ModelElement it) {
                return MGLUtil.allSuperTypes(it);
            }
        };
        Set allSuperTypes = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(modelElementsToCheck, (Functions.Function1)_function)));
        modelElementsToCheck.addAll(allSuperTypes);
        for (ModelElement modelElement : modelElementsToCheck) {
            EList _attributes = modelElement.getAttributes();
            for (Attribute attribute : _attributes) {
                if (!(attribute instanceof ComplexAttribute)) continue;
                result.add(((ComplexAttribute)attribute).getType());
                Type _type = ((ComplexAttribute)attribute).getType();
                if (!(_type instanceof UserDefinedType)) continue;
                Type _type_1 = ((ComplexAttribute)attribute).getType();
                userDefinedTypesToCheck.add((UserDefinedType)_type_1);
            }
        }
        boolean bl = false;
        while (var6_9 < userDefinedTypesToCheck.size()) {
            UserDefinedType userDefinedType = ((UserDefinedType[])Conversions.unwrapArray(userDefinedTypesToCheck, UserDefinedType.class))[var6_9];
            EList _attributes_1 = userDefinedType.getAttributes();
            for (Attribute attribute_1 : _attributes_1) {
                if (!(attribute_1 instanceof ComplexAttribute)) continue;
                result.add(((ComplexAttribute)attribute_1).getType());
                Type _type_2 = ((ComplexAttribute)attribute_1).getType();
                if (!(_type_2 instanceof UserDefinedType)) continue;
                Type _type_3 = ((ComplexAttribute)attribute_1).getType();
                userDefinedTypesToCheck.add((UserDefinedType)_type_3);
            }
            ++var6_9;
        }
        final HashSet hashSet = new HashSet();
        Functions.Function1<Type, Boolean> _function_1 = new Functions.Function1<Type, Boolean>(){

            public Boolean apply(final Type candidate) {
                Functions.Function1<Type, Boolean> _function = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        return it != candidate && MGLUtil.equalTypes(candidate, it);
                    }
                };
                return IterableExtensions.exists((Iterable)result, (Functions.Function1)_function);
            }
        };
        Consumer<Type> _function_2 = new Consumer<Type>(){

            @Override
            public void accept(final Type candidate) {
                boolean _not;
                Functions.Function1<Type, Boolean> _function = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        return MGLUtil.equalTypes(candidate, it);
                    }
                };
                boolean _exists = IterableExtensions.exists((Iterable)hashSet, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    hashSet.add(candidate);
                }
            }
        };
        IterableExtensions.filter(result, (Functions.Function1)_function_1).forEach(_function_2);
        result.removeAll(hashSet);
        return result;
    }

    public static Set<Node> nodes(GraphModel graphModel) {
        Iterable<Node> _containableNodeElements = MGLUtil.containableNodeElements((ContainingElement)graphModel);
        List<Node> _importedNodes = MGLUtil.getImportedNodes(graphModel);
        return IterableExtensions.toSet((Iterable)Iterables.concat(_containableNodeElements, _importedNodes));
    }

    public static Iterable<NodeContainer> containers(GraphModel graphModel) {
        Iterable<NodeContainer> _containableContainerElements = MGLUtil.containableContainerElements((ContainingElement)graphModel);
        List<NodeContainer> _importedContainers = MGLUtil.getImportedContainers(graphModel);
        return Iterables.concat(_containableContainerElements, _importedContainers);
    }

    public static Set<Node> nodesInContainers(final GraphModel graphModel) {
        Functions.Function1<NodeContainer, Iterable<Node>> _function = new Functions.Function1<NodeContainer, Iterable<Node>>(){

            public Iterable<Node> apply(NodeContainer it) {
                return MGLUtil.containableNodeElements((ContainingElement)graphModel);
            }
        };
        return IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.containers(graphModel), (Functions.Function1)_function)));
    }

    public static List<Node> nodeDependencies(MGLModel mglModel) {
        final ArrayList result = new ArrayList();
        Consumer<GraphModel> _function = new Consumer<GraphModel>(){

            @Override
            public void accept(GraphModel gm) {
                Iterables.addAll((Collection)result, MGLUtil.nodeDependencies(gm));
            }
        };
        mglModel.getGraphModels().forEach((Consumer)_function);
        Consumer<Node> _function_1 = new Consumer<Node>(){

            @Override
            public void accept(Node n) {
                result.addAll(MGLUtil.nodeDependencies(n));
            }
        };
        mglModel.getNodes().forEach((Consumer)_function_1);
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull(result));
    }

    public static Iterable<Node> nodeDependencies(GraphModel graphModel) {
        List containableElems = IterableExtensions.toList(MGLUtil.nodes(graphModel));
        Functions.Function1<Node, ArrayList<Node>> _function = new Functions.Function1<Node, ArrayList<Node>>(){

            public ArrayList<Node> apply(Node it) {
                return MGLUtil.nodeDependencies(it);
            }
        };
        Iterables.addAll((Collection)containableElems, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.nodes(graphModel), (Functions.Function1)_function)));
        return IterableExtensions.filterNull((Iterable)containableElems);
    }

    public static ArrayList<Node> nodeDependencies(Node node) {
        Node _extends;
        boolean _tripleNotEquals;
        final ArrayList<Node> result = new ArrayList<Node>();
        if (node instanceof NodeContainer) {
            Iterable<Node> containableElems = MGLUtil.containableNodeElements((ContainingElement)node);
            Consumer<Node> _function = new Consumer<Node>(){

                @Override
                public void accept(Node ce) {
                    MGLUtil._nodeDependencies(ce, result);
                }
            };
            containableElems.forEach(_function);
        }
        boolean bl = _tripleNotEquals = (_extends = node.getExtends()) != null;
        if (_tripleNotEquals) {
            MGLUtil._nodeDependencies(node.getExtends(), result);
        }
        return result;
    }

    private static List<Node> _nodeDependencies(Node it, final List<Node> aggregatedNodes) {
        boolean _not;
        boolean _contains = aggregatedNodes.contains(it);
        boolean bl = _not = !_contains;
        if (_not) {
            Node _extends;
            boolean _tripleNotEquals;
            aggregatedNodes.add(it);
            aggregatedNodes.addAll(MGLUtil.getExtendingNodes(it));
            if (it instanceof NodeContainer) {
                Iterable<Node> containableElems = MGLUtil.containableNodeElements((ContainingElement)it);
                Iterables.addAll(aggregatedNodes, containableElems);
                Consumer<Node> _function = new Consumer<Node>(){

                    @Override
                    public void accept(Node ce) {
                        MGLUtil._nodeDependencies(ce, aggregatedNodes);
                    }
                };
                containableElems.forEach(_function);
            }
            boolean bl2 = _tripleNotEquals = (_extends = it.getExtends()) != null;
            if (_tripleNotEquals) {
                MGLUtil._nodeDependencies(it.getExtends(), aggregatedNodes);
            }
        }
        return aggregatedNodes;
    }

    public static List<Node> getExtendingNodes(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        EList _nodes = MGLUtil.getMglModel((ModelElement)node).getNodes();
        for (Node otherNode : _nodes) {
            boolean _equalNodes = MGLUtil.equalNodes(node, otherNode.getExtends());
            if (!_equalNodes) continue;
            result.add(otherNode);
            result.addAll(MGLUtil.getExtendingNodes(otherNode));
        }
        return result;
    }

    public static Iterable<Edge> edgeDependencies(MGLModel mglModel) {
        final ArrayList result = new ArrayList();
        Consumer<GraphModel> _function = new Consumer<GraphModel>(){

            @Override
            public void accept(GraphModel gm) {
                Iterables.addAll((Collection)result, MGLUtil.edgeDependencies(gm));
            }
        };
        mglModel.getGraphModels().forEach((Consumer)_function);
        return IterableExtensions.filterNull(result);
    }

    public static Iterable<Edge> edgeDependencies(GraphModel graphModel) {
        List containableElems = IterableExtensions.toList(MGLUtil.nodes(graphModel));
        Functions.Function1<Node, ArrayList<Node>> _function = new Functions.Function1<Node, ArrayList<Node>>(){

            public ArrayList<Node> apply(Node it) {
                return MGLUtil.nodeDependencies(it);
            }
        };
        Iterables.addAll((Collection)containableElems, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.nodes(graphModel), (Functions.Function1)_function)));
        HashSet result = new HashSet();
        Functions.Function1<Node, Set<Edge>> _function_1 = new Functions.Function1<Node, Set<Edge>>(){

            public Set<Edge> apply(Node it) {
                return MGLUtil.getIncomingConnectingEdges(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)ListExtensions.map((List)containableElems, (Functions.Function1)_function_1)));
        Functions.Function1<Node, Set<Edge>> _function_2 = new Functions.Function1<Node, Set<Edge>>(){

            public Set<Edge> apply(Node it) {
                return MGLUtil.getOutgoingConnectingEdges(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)ListExtensions.map((List)containableElems, (Functions.Function1)_function_2)));
        HashSet edgesToCheckForInheritance = new HashSet(result);
        Functions.Function1<Edge, ArrayList<Edge>> _function_3 = new Functions.Function1<Edge, ArrayList<Edge>>(){

            public ArrayList<Edge> apply(Edge it) {
                return MGLUtil.edgeDependencies(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(edgesToCheckForInheritance, (Functions.Function1)_function_3)));
        return IterableExtensions.filterNull(result);
    }

    public static ArrayList<Edge> edgeDependencies(Edge edge) {
        boolean _tripleNotEquals;
        ArrayList<Edge> result = new ArrayList<Edge>();
        Edge _extends = edge.getExtends();
        boolean bl = _tripleNotEquals = _extends != null;
        if (_tripleNotEquals) {
            MGLUtil._edgeDependencies(edge.getExtends(), result);
        }
        return result;
    }

    private static List<Edge> _edgeDependencies(Edge it, List<Edge> aggregatedEdges) {
        boolean _not;
        boolean _contains = aggregatedEdges.contains(it);
        boolean bl = _not = !_contains;
        if (_not) {
            boolean _tripleNotEquals;
            aggregatedEdges.add(it);
            Edge _extends = it.getExtends();
            boolean bl2 = _tripleNotEquals = _extends != null;
            if (_tripleNotEquals) {
                MGLUtil._edgeDependencies(it.getExtends(), aggregatedEdges);
            }
        }
        return aggregatedEdges;
    }

    public static HashMap<MGLModel, Set<Node>> nodesWithOrigins(ContainingElement it) {
        return MGLUtil.nodesWithOrigins(it, false);
    }

    public static HashMap<MGLModel, Set<Node>> nodesWithOrigins(ContainingElement containingElement, boolean anyDepth) {
        HashMap<MGLModel, Set<Node>> result = new HashMap<MGLModel, Set<Node>>();
        HashSet<Node> usableNodes = new HashSet<Node>();
        Set<Node> _usableNodes = _generatorUtils.getUsableNodes(containingElement, anyDepth);
        Iterables.addAll(usableNodes, _usableNodes);
        for (MGLModel currentMgl : MGLUtil._generatorUtils.allMGLs) {
            HashSet<Node> currentNodes = new HashSet<Node>();
            EList _nodes = currentMgl.getNodes();
            for (final Node node : _nodes) {
                Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

                    public Boolean apply(Node it) {
                        return MGLUtil.equalNodes(it, node);
                    }
                };
                final Node matchingNode = (Node)IterableExtensions.findFirst(usableNodes, (Functions.Function1)_function);
                if (matchingNode == null) continue;
                Predicate<Node> _function_1 = new Predicate<Node>(){

                    @Override
                    public boolean test(Node it) {
                        return MGLUtil.equalNodes(it, matchingNode);
                    }
                };
                usableNodes.removeIf(_function_1);
                currentNodes.add(matchingNode);
            }
            result.put(currentMgl, currentNodes);
            boolean _isEmpty = usableNodes.isEmpty();
            if (!_isEmpty) continue;
            return result;
        }
        return result;
    }

    public static HashMap<MGLModel, Set<Type>> typesWithOrigins(GraphModel graphModel) {
        HashMap<MGLModel, Set<Type>> result = new HashMap<MGLModel, Set<Type>>();
        HashSet<Type> usableTypes = new HashSet<Type>();
        HashSet<Type> _types = MGLUtil.types(graphModel);
        Iterables.addAll(usableTypes, _types);
        for (MGLModel currentMgl : MGLUtil._generatorUtils.allMGLs) {
            HashSet<Type> currentTypes = new HashSet<Type>();
            EList _types_1 = currentMgl.getTypes();
            for (final Type type : _types_1) {
                Functions.Function1<Type, Boolean> _function = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        return MGLUtil.equalTypes(it, type);
                    }
                };
                final Type matchingType = (Type)IterableExtensions.findFirst(usableTypes, (Functions.Function1)_function);
                if (matchingType == null) continue;
                Predicate<Type> _function_1 = new Predicate<Type>(){

                    @Override
                    public boolean test(Type it) {
                        return MGLUtil.equalTypes(it, matchingType);
                    }
                };
                usableTypes.removeIf(_function_1);
                currentTypes.add(matchingType);
            }
            result.put(currentMgl, currentTypes);
            boolean _isEmpty = usableTypes.isEmpty();
            if (!_isEmpty) continue;
            return result;
        }
        return result;
    }

    public static HashMap<MGLModel, Set<Edge>> edgesWithOrigins(GraphModel graphModel) {
        HashMap<MGLModel, Set<Edge>> result = new HashMap<MGLModel, Set<Edge>>();
        HashSet<Edge> usableEdges = new HashSet<Edge>();
        Set<Edge> _usableEdges = _generatorUtils.getUsableEdges((ContainingElement)graphModel);
        Iterables.addAll(usableEdges, _usableEdges);
        for (MGLModel currentMgl : MGLUtil._generatorUtils.allMGLs) {
            HashSet<Edge> currentEdges = new HashSet<Edge>();
            EList _edges = currentMgl.getEdges();
            for (final Edge edge : _edges) {
                Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                    public Boolean apply(Edge it) {
                        return MGLUtil.equalTypes((Type)it, (Type)edge);
                    }
                };
                final Edge matchingEdge = (Edge)IterableExtensions.findFirst(usableEdges, (Functions.Function1)_function);
                if (matchingEdge == null) continue;
                Predicate<Edge> _function_1 = new Predicate<Edge>(){

                    @Override
                    public boolean test(Edge it) {
                        return MGLUtil.equalTypes((Type)it, (Type)matchingEdge);
                    }
                };
                usableEdges.removeIf(_function_1);
                currentEdges.add(matchingEdge);
            }
            result.put(currentMgl, currentEdges);
            boolean _isEmpty = usableEdges.isEmpty();
            if (!_isEmpty) continue;
            return result;
        }
        return result;
    }

    public static HashMap<MGLModel, Set<UserDefinedType>> userDefinedTypesWithOrigins(GraphModel graphModel) {
        HashMap<MGLModel, Set<UserDefinedType>> result = new HashMap<MGLModel, Set<UserDefinedType>>();
        HashSet<UserDefinedType> usableUserDefinedTypes = new HashSet<UserDefinedType>();
        Set<UserDefinedType> _usableUserDefinedTypes = _generatorUtils.getUsableUserDefinedTypes((ContainingElement)graphModel);
        Iterables.addAll(usableUserDefinedTypes, _usableUserDefinedTypes);
        for (MGLModel currentMgl : MGLUtil._generatorUtils.allMGLs) {
            HashSet<UserDefinedType> currentUserDefinedTypes = new HashSet<UserDefinedType>();
            Iterable _filter = Iterables.filter((Iterable)currentMgl.getTypes(), UserDefinedType.class);
            for (final UserDefinedType userDefinedType : _filter) {
                Functions.Function1<UserDefinedType, Boolean> _function = new Functions.Function1<UserDefinedType, Boolean>(){

                    public Boolean apply(UserDefinedType it) {
                        return MGLUtil.equalTypes((Type)it, (Type)userDefinedType);
                    }
                };
                final UserDefinedType matchingUserDefinedType = (UserDefinedType)IterableExtensions.findFirst(usableUserDefinedTypes, (Functions.Function1)_function);
                if (matchingUserDefinedType == null) continue;
                Predicate<UserDefinedType> _function_1 = new Predicate<UserDefinedType>(){

                    @Override
                    public boolean test(UserDefinedType it) {
                        return MGLUtil.equalTypes((Type)it, (Type)matchingUserDefinedType);
                    }
                };
                usableUserDefinedTypes.removeIf(_function_1);
                currentUserDefinedTypes.add(matchingUserDefinedType);
            }
            result.put(currentMgl, currentUserDefinedTypes);
            boolean _isEmpty = usableUserDefinedTypes.isEmpty();
            if (!_isEmpty) continue;
            return result;
        }
        return result;
    }

    public static Set<Edge> generaliseEdge(Edge edge, GraphModel graphModel) {
        HashSet<Edge> result = new HashSet<Edge>();
        result.add(edge);
        Edge extendedEdge = edge.getExtends();
        while (extendedEdge != null) {
            result.add(extendedEdge);
            extendedEdge = extendedEdge.getExtends();
        }
        HashSet<Edge> moreGeneralEdges = new HashSet<Edge>();
        Iterator moreGeneralEdgesIterator = moreGeneralEdges.iterator();
        Set<Edge> allEdges = _generatorUtils.getUsableEdges((ContainingElement)graphModel);
        for (Edge allEdge : allEdges) {
            boolean _equalEdges = MGLUtil.equalEdges(allEdge.getExtends(), edge);
            if (!_equalEdges) continue;
            result.add(allEdge);
            moreGeneralEdges.add(allEdge);
        }
        while (moreGeneralEdgesIterator.hasNext()) {
            Edge inspectingEdge = (Edge)moreGeneralEdgesIterator.next();
            for (Edge allEdge_1 : allEdges) {
                boolean _equalEdges_1 = MGLUtil.equalEdges(allEdge_1.getExtends(), inspectingEdge);
                if (!_equalEdges_1) continue;
                result.add(inspectingEdge);
                moreGeneralEdges.add(inspectingEdge);
            }
        }
        return result;
    }

    public static Set<GraphModel> getAllExtendedGraphModels(GraphModel graphModel) {
        HashSet<GraphModel> _hashSet = new HashSet<GraphModel>();
        return MGLUtil._getAllExtendedGraphModels(graphModel, _hashSet);
    }

    private static Set<GraphModel> _getAllExtendedGraphModels(GraphModel it, Set<GraphModel> importedGraphModels) {
        GraphModel extendedModel = it.getExtends();
        if (extendedModel != null && !importedGraphModels.contains(extendedModel)) {
            importedGraphModels.add(extendedModel);
            MGLUtil._getAllExtendedGraphModels(extendedModel, importedGraphModels);
        }
        return importedGraphModels;
    }

    public static HashSet<Edge> edges(GraphModel graphModel) {
        HashSet<Edge> result = new HashSet<Edge>();
        Functions.Function1<Node, Set<Edge>> _function = new Functions.Function1<Node, Set<Edge>>(){

            public Set<Edge> apply(Node it) {
                return MGLUtil.getIncomingConnectingEdges(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.containableNodeElements((ContainingElement)graphModel), (Functions.Function1)_function)));
        Functions.Function1<Node, Set<Edge>> _function_1 = new Functions.Function1<Node, Set<Edge>>(){

            public Set<Edge> apply(Node it) {
                return MGLUtil.getOutgoingConnectingEdges(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.containableNodeElements((ContainingElement)graphModel), (Functions.Function1)_function_1)));
        Functions.Function1<Node, Set<Edge>> _function_2 = new Functions.Function1<Node, Set<Edge>>(){

            public Set<Edge> apply(Node it) {
                return MGLUtil.getIncomingConnectingEdges(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.nodesInContainers(graphModel), (Functions.Function1)_function_2)));
        Functions.Function1<Node, Set<Edge>> _function_3 = new Functions.Function1<Node, Set<Edge>>(){

            public Set<Edge> apply(Node it) {
                return MGLUtil.getOutgoingConnectingEdges(it);
            }
        };
        Iterables.addAll(result, (Iterable)Iterables.concat((Iterable)IterableExtensions.map(MGLUtil.nodesInContainers(graphModel), (Functions.Function1)_function_3)));
        result.addAll(MGLUtil.getImportedEdges(graphModel));
        return result;
    }

    public static List<ModelElement> modelElements(final GraphModel graphModel) {
        List<ModelElement> elements = _generatorUtils.modelElements(MGLUtil.getMglModel((ModelElement)graphModel));
        Predicate<ModelElement> _function = new Predicate<ModelElement>(){

            @Override
            public boolean test(ModelElement e) {
                return e instanceof GraphModel && !Objects.equal((Object)e.getName(), (Object)graphModel.getName());
            }
        };
        elements.removeIf(_function);
        return elements;
    }

    public static List<ModelElement> modelElements(MGLModel mgl) {
        return MGLUtil.modelElements(mgl, true);
    }

    public static List<ModelElement> modelElements(MGLModel mgl, boolean containGraphModels) {
        List<ModelElement> elements = _generatorUtils.modelElements(mgl);
        if (!containGraphModels) {
            Predicate<ModelElement> _function = new Predicate<ModelElement>(){

                @Override
                public boolean test(ModelElement e) {
                    return e instanceof GraphModel;
                }
            };
            elements.removeIf(_function);
        }
        return elements;
    }

    public static Iterable<ContainingElement> nodeContainers(MGLModel mglModel) {
        EList _graphModels = mglModel.getGraphModels();
        Iterable _filter = Iterables.filter((Iterable)mglModel.getNodes(), NodeContainer.class);
        return Iterables.concat((Iterable)_graphModels, (Iterable)_filter);
    }

    public static List<Node> getImportedNodes(GraphModel graphModel) {
        GraphModel extendedModel = graphModel.getExtends();
        if (extendedModel != null) {
            List result = IterableExtensions.toList(MGLUtil.nodes(extendedModel));
            result.addAll(MGLUtil.getImportedNodes(extendedModel));
            return result;
        }
        return new BasicEList();
    }

    public static List<NodeContainer> getImportedContainers(GraphModel graphModel) {
        GraphModel extendedModel = graphModel.getExtends();
        if (extendedModel != null) {
            List result = IterableExtensions.toList(MGLUtil.containers(extendedModel));
            result.addAll(MGLUtil.getImportedContainers(extendedModel));
            return result;
        }
        return new BasicEList();
    }

    public static Set<Edge> getImportedEdges(GraphModel graphModel) {
        GraphModel extendedModel = graphModel.getExtends();
        if (extendedModel != null) {
            HashSet<Edge> result = new HashSet<Edge>();
            result.addAll(MGLUtil.edges(extendedModel));
            result.addAll(MGLUtil.getImportedEdges(extendedModel));
            return result;
        }
        return new HashSet<Edge>();
    }

    public static boolean canNodeBeReferencedByEdge(final Node node, Edge edge) {
        return IterableExtensions.exists(MGLUtil.getAllPossibleSources(edge), (Functions.Function1)new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return MGLUtil.equalNodes(it, node);
            }
        }) || IterableExtensions.exists(MGLUtil.getAllPossibleTargets(edge), (Functions.Function1)new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                return MGLUtil.equalNodes(it, node);
            }
        });
    }

    public static Set<Node> getUsableNodes(GraphModel graphModel) {
        return _generatorUtils.getUsableNodes((ContainingElement)graphModel);
    }

    public static Set<Edge> getUsableEdges(GraphModel graphModel) {
        return _generatorUtils.getUsableEdges((ContainingElement)graphModel);
    }

    public static String getFqn(ModelElement modelElement) {
        String _lowerCase = MGLUtil.getMglModel(modelElement).getPackage().toLowerCase();
        String _plus = String.valueOf(_lowerCase) + ".";
        String _lowerCase_1 = _generatorUtils.getFileName(MGLUtil.getMglModel(modelElement)).toLowerCase();
        String _plus_1 = String.valueOf(_plus) + _lowerCase_1;
        String _plus_2 = String.valueOf(_plus_1) + ".";
        String _name = modelElement.getName();
        return String.valueOf(_plus_2) + _name;
    }

    public static boolean isPrime(Node node) {
        boolean _xblockexpression = false;
        Node currentNode = node;
        ArrayList visitedNodes = CollectionLiterals.newArrayList();
        while (currentNode != null && !visitedNodes.contains(currentNode)) {
            boolean _tripleNotEquals;
            ReferencedType _primeReference = currentNode.getPrimeReference();
            boolean bl = _tripleNotEquals = _primeReference != null;
            if (_tripleNotEquals) {
                return true;
            }
            visitedNodes.add(currentNode);
            currentNode = node.getExtends();
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    private static MGLModel getRootElement(EObject type) {
        if (type instanceof Type) {
            return MGLUtil._getRootElement((Type)type);
        }
        if (type instanceof ContainingElement) {
            return MGLUtil._getRootElement((ContainingElement)type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    public static MGLModel mglModel(Object wildcard) {
        if (wildcard instanceof Wildcard) {
            return MGLUtil._mglModel((Wildcard)wildcard);
        }
        if (wildcard instanceof MGLModel) {
            return MGLUtil._mglModel((MGLModel)wildcard);
        }
        if (wildcard instanceof Type) {
            return MGLUtil._mglModel((Type)wildcard);
        }
        if (wildcard instanceof ContainingElement) {
            return MGLUtil._mglModel((ContainingElement)wildcard);
        }
        if (wildcard instanceof Import) {
            return MGLUtil._mglModel((Import)wildcard);
        }
        if (wildcard instanceof EObject) {
            return MGLUtil._mglModel((EObject)wildcard);
        }
        if (wildcard != null) {
            return MGLUtil._mglModel(wildcard);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(wildcard).toString());
    }

    public static String nsURI(Annotatable graphModel) {
        if (graphModel instanceof GraphModel) {
            return MGLUtil._nsURI((GraphModel)graphModel);
        }
        if (graphModel instanceof ModelElement) {
            return MGLUtil._nsURI((ModelElement)graphModel);
        }
        if (graphModel instanceof MGLModel) {
            return MGLUtil._nsURI((MGLModel)graphModel);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(graphModel).toString());
    }
}

