/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.utils;

import java.util.ArrayList;
import java.util.List;
import mgl.Edge;
import mgl.GraphModel;
import mgl.ModelElement;
import mgl.Node;
import mgl.UserDefinedType;

public class Inheritances {
    private List<InheritanceTree<ModelElement>> trees = new ArrayList<InheritanceTree<ModelElement>>();

    public void addElement(ModelElement modelElement) {
        ModelElement parent = this.getParent(modelElement);
        if (parent == null) {
            this.trees.add(new InheritanceTree(this, modelElement));
            return;
        }
        InheritanceTree<ModelElement> containingTree = this.getContainingTree(parent);
        if (containingTree != null) {
            containingTree.get(parent).add(modelElement);
        } else {
            this.trees.add(new InheritanceTree(this, modelElement));
        }
    }

    private InheritanceTree<ModelElement> getContainingTree(ModelElement parent) {
        for (InheritanceTree<ModelElement> t : this.trees) {
            if (!t.contains(parent)) continue;
            return t;
        }
        return null;
    }

    public void printTrees() {
        for (InheritanceTree<ModelElement> t : this.trees) {
            t.print();
        }
    }

    public List<ModelElement> createList() {
        ArrayList<ModelElement> list = new ArrayList<ModelElement>();
        for (InheritanceTree<ModelElement> t : this.trees) {
            t.getPostorder(list);
        }
        return list;
    }

    private ModelElement getParent(ModelElement modelElement) {
        if (modelElement instanceof Node) {
            return ((Node)modelElement).getExtends();
        }
        if (modelElement instanceof Edge) {
            return ((Edge)modelElement).getExtends();
        }
        if (modelElement instanceof UserDefinedType) {
            return ((UserDefinedType)modelElement).getExtends();
        }
        if (modelElement instanceof GraphModel) {
            return ((GraphModel)modelElement).getExtends();
        }
        return null;
    }

    class InheritanceTree<E extends ModelElement> {
        private E root;
        private List<InheritanceTree<E>> children;

        public InheritanceTree() {
            this.children = new ArrayList<InheritanceTree<E>>();
        }

        public InheritanceTree(E element) {
            this.root = element;
            this.children = new ArrayList<InheritanceTree<E>>();
        }

        public void print() {
            System.out.print(String.valueOf(this.getRoot().getName()) + ", ");
            this.children.forEach(c -> System.out.print(String.valueOf(c.getRoot().getName()) + ", "));
            System.err.println("\n------------------------------------------\n\n");
            this.children.forEach(c -> c.print());
        }

        public void getPostorder(List<ModelElement> list) {
            for (InheritanceTree<E> c : this.children) {
                c.getPostorder(list);
            }
            if (!this.isEmpty()) {
                list.add((ModelElement)this.root);
            }
        }

        public void add(E element) {
            InheritanceTree r = new InheritanceTree(Inheritances.this, element);
            this.children.add(r);
        }

        public boolean contains(E element) {
            return this.get(element) != null;
        }

        public InheritanceTree<E> get(E element) {
            if (this.isEmpty()) {
                return null;
            }
            if (this.root.equals(element)) {
                return this;
            }
            for (InheritanceTree<E> child : this.children) {
                InheritanceTree<E> childResult = child.get(element);
                if (childResult == null) continue;
                return childResult;
            }
            return null;
        }

        public boolean isEmpty() {
            return this.root == null;
        }

        public E getRoot() {
            return this.root;
        }

        public List<InheritanceTree<E>> getChildren() {
            return this.children;
        }
    }
}

